/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Scanner;

public class GeoSymAbbreviationProvider {
    private HashMap<Integer, HashMap<Integer, String>> abbreviationTables;

    public GeoSymAbbreviationProvider(String string) {
        this.initialize(string);
    }

    public String getAbbreviation(int n, int n2) {
        HashMap<Integer, String> hashMap = this.abbreviationTables.get(n);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(n2);
    }

    protected void initialize(String string) {
        InputStream inputStream = WWIO.openFileOrResourceStream(string, this.getClass());
        if (inputStream == null) {
            String string2 = Logging.getMessage("generic.ExceptionWhileReading", string);
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        this.readTables(new Scanner(inputStream));
    }

    protected void readTables(Scanner scanner) {
        this.abbreviationTables = new HashMap();
        HashMap<Integer, String> hashMap = null;
        while (!scanner.nextLine().equals(";")) {
        }
        while (scanner.hasNextLine()) {
            Object object;
            String string = scanner.nextLine().trim();
            if (string.length() == 0) continue;
            if (string.endsWith(":")) {
                object = Integer.parseInt(string.split(":")[0]);
                hashMap = new HashMap<Integer, String>();
                this.abbreviationTables.put((Integer)object, hashMap);
                continue;
            }
            object = string.split("[|]");
            Integer n = Integer.parseInt(object[0]);
            hashMap.put(n, object[1]);
        }
    }
}

