/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class TiffIFDEntry
implements Comparable<TiffIFDEntry> {
    private ByteBuffer data = null;
    int tag;
    int type;
    long count;
    long valOffset;

    public TiffIFDEntry(int n, int n2, long l, long l2) throws IllegalArgumentException {
        this(n, n2, l, l2, null);
    }

    public TiffIFDEntry(int n, int n2, long l) throws IllegalArgumentException {
        this(n, n2, 1L, l, null);
    }

    public TiffIFDEntry(int n, int n2, long l, long l2, ByteBuffer byteBuffer) throws IllegalArgumentException {
        this.tag = n;
        this.type = n2;
        this.count = l;
        this.valOffset = l2;
        this.data = byteBuffer;
    }

    public long asLong() throws IllegalStateException {
        if (this.type != 3 && this.type != 4) {
            throw new IllegalStateException("Attempt to access Tiff IFD-entry as int: tag/type=" + Long.toHexString(this.tag) + "/" + this.type);
        }
        if (this.type == 3 && this.count == 1L) {
            return 0xFFFFL & this.valOffset >> 16;
        }
        return this.valOffset;
    }

    public Double getAsDouble() throws IOException {
        Double d = null;
        switch (this.type) {
            case 3: 
            case 8: {
                d = this.asShort();
                break;
            }
            case 4: 
            case 9: {
                d = this.asLong();
                break;
            }
            case 11: {
                float[] fArray = this.getFloats();
                if (null == fArray) break;
                d = fArray[0];
                break;
            }
            case 12: {
                double[] dArray = this.getDoubles();
                if (null == dArray) break;
                d = dArray[0];
            }
        }
        return d;
    }

    public int asShort() throws IllegalStateException {
        Object object;
        if (this.type != 3) {
            String string = Logging.getMessage("GeotiffReader.InvalidType", "short", this.tag, this.type);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.count > 0L) {
            if (this.count == 1L) {
                return 0xFFFF & (int)(this.valOffset >> 16);
            }
            object = this.getShortsAsInts();
            if (null != object && ((int[])object).length > 0) {
                return object[0];
            }
        }
        object = Logging.getMessage("generic.indexOutOfRange", this.count);
        Logging.logger().severe((String)object);
        throw new IllegalArgumentException((String)object);
    }

    public int asShort(int n) throws IllegalStateException {
        Object object;
        if (this.type != 3) {
            String string = Logging.getMessage("GeotiffReader.InvalidType", "short", this.tag, this.type);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.count > (long)n && null != (object = this.getShortsAsInts()) && ((int[])object).length > n) {
            return object[n];
        }
        object = Logging.getMessage("generic.indexOutOfRange", this.count);
        Logging.logger().severe((String)object);
        throw new IllegalArgumentException((String)object);
    }

    public int[] getShortsAsInts() {
        if (this.type != 3) {
            String string = Logging.getMessage("GeotiffReader.InvalidType", "short", this.tag, this.type);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.count == 1L) {
            return new int[]{this.asShort()};
        }
        if (this.count > 0L && null != this.data) {
            int[] nArray = new int[(int)this.count];
            this.data.rewind();
            ShortBuffer shortBuffer = this.data.asShortBuffer();
            int n = 0;
            while (shortBuffer.hasRemaining()) {
                nArray[n++] = 0xFFFF & shortBuffer.get();
            }
            return nArray;
        }
        String string = Logging.getMessage("generic.indexOutOfRange", this.count);
        Logging.logger().severe(string);
        throw new IllegalArgumentException(string);
    }

    public long[] getAsLongs() {
        if (this.type != 3 && this.type != 4) {
            String string = Logging.getMessage("GeotiffReader.InvalidType", "long", this.tag, this.type);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.count == 1L) {
            return new long[]{this.asLong()};
        }
        if (this.count > 1L && null != this.data) {
            long[] lArray = new long[(int)this.count];
            if (this.type == 3) {
                ShortBuffer shortBuffer = ((ByteBuffer)this.data.rewind()).asShortBuffer();
                this.data.rewind();
                int n = 0;
                while (shortBuffer.hasRemaining()) {
                    lArray[n++] = 0xFFFFL & (long)shortBuffer.get();
                }
            } else if (this.type == 4) {
                IntBuffer intBuffer = ((ByteBuffer)this.data.rewind()).asIntBuffer();
                this.data.rewind();
                int n = 0;
                while (intBuffer.hasRemaining()) {
                    lArray[n++] = 0xFFFFFFFFL & (long)intBuffer.get();
                }
            }
            return lArray;
        }
        return null;
    }

    public short[] getShorts() {
        if (this.type != 3) {
            String string = Logging.getMessage("GeotiffReader.InvalidType", "short", this.tag, this.type);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.count == 1L) {
            return new short[]{(short)this.asShort()};
        }
        if (this.count > 0L && null != this.data) {
            ShortBuffer shortBuffer = ((ByteBuffer)this.data.rewind()).asShortBuffer();
            this.data.rewind();
            short[] sArray = new short[(int)this.count];
            int n = 0;
            while (shortBuffer.hasRemaining()) {
                sArray[n++] = shortBuffer.get();
            }
            return sArray;
        }
        return null;
    }

    public double[] getDoubles() throws IOException {
        if (this.type != 12) {
            String string = Logging.getMessage("GeotiffReader.InvalidType", "double", this.tag, this.type);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.count == 0L || null == this.data) {
            return null;
        }
        DoubleBuffer doubleBuffer = ((ByteBuffer)this.data.rewind()).asDoubleBuffer();
        this.data.rewind();
        int n = Math.max(doubleBuffer.limit(), (int)this.count);
        double[] dArray = new double[n];
        int n2 = 0;
        while (doubleBuffer.hasRemaining()) {
            dArray[n2++] = doubleBuffer.get();
        }
        return dArray;
    }

    public float[] getFloats() throws IOException {
        if (this.type != 11) {
            String string = Logging.getMessage("GeotiffReader.InvalidType", "float", this.tag, this.type);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.count == 0L) {
            return null;
        }
        if (this.count == 1L) {
            int n = (int)(0xFFFFFFFFL & this.valOffset);
            return new float[]{Float.intBitsToFloat(n)};
        }
        if (null == this.data) {
            return null;
        }
        FloatBuffer floatBuffer = ((ByteBuffer)this.data.rewind()).asFloatBuffer();
        this.data.rewind();
        int n = Math.max(floatBuffer.limit(), (int)this.count);
        float[] fArray = new float[n];
        int n2 = 0;
        while (floatBuffer.hasRemaining()) {
            fArray[n2++] = floatBuffer.get();
        }
        return fArray;
    }

    public String asString() {
        if (this.type != 2) {
            String string = Logging.getMessage("GeotiffReader.InvalidType", "ascii", this.tag, this.type);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.count != 1L || null == this.data) {
            return null;
        }
        CharBuffer charBuffer = ((ByteBuffer)this.data.rewind()).asCharBuffer();
        return charBuffer.toString();
    }

    public long asOffset() {
        return this.valOffset;
    }

    @Override
    public int compareTo(TiffIFDEntry tiffIFDEntry) {
        if (this == tiffIFDEntry) {
            return 0;
        }
        if (tiffIFDEntry != null) {
            if (this.tag < tiffIFDEntry.tag) {
                return -1;
            }
            if (this.tag > tiffIFDEntry.tag) {
                return 1;
            }
            return 0;
        }
        return 1;
    }
}

