/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordPolyline;
import gov.nasa.worldwind.formats.shapefile.ShapefileUtils;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwind.util.WWMath;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ShapefileRecordPolygon
extends ShapefileRecordPolyline {
    public ShapefileRecordPolygon(Shapefile shapefile, ByteBuffer byteBuffer) {
        super(shapefile, byteBuffer);
    }

    @Override
    public void exportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        Iterable<LatLon> iterable = null;
        ArrayList<Iterable<? extends LatLon>> arrayList = new ArrayList<Iterable<? extends LatLon>>();
        Double d = ShapefileUtils.extractHeightAttribute(this);
        for (int i = 0; i < this.getNumberOfParts(); ++i) {
            VecBuffer vecBuffer = this.getCompoundPointBuffer().subBuffer(i);
            if (WWMath.computeWindingOrderOfLocations(vecBuffer.getLocations()).equals("gov.nasa.worldwind.avkey.ClockWise")) {
                if (iterable == null) {
                    iterable = vecBuffer.getLocations();
                    continue;
                }
                this.exportPolygonAsKML(xMLStreamWriter, iterable, arrayList, d);
                iterable = this.getCompoundPointBuffer().getLocations();
                arrayList.clear();
                continue;
            }
            arrayList.add(vecBuffer.getLocations());
        }
        if (iterable != null && iterable.iterator().hasNext()) {
            this.exportPolygonAsKML(xMLStreamWriter, (Iterable<? extends LatLon>)iterable, arrayList, d);
        }
    }

    protected void exportPolygonAsKML(XMLStreamWriter xMLStreamWriter, Iterable<? extends LatLon> iterable, List<Iterable<? extends LatLon>> list, Double d) throws IOException, XMLStreamException {
        String string;
        xMLStreamWriter.writeStartElement("Placemark");
        xMLStreamWriter.writeStartElement("name");
        xMLStreamWriter.writeCharacters(Integer.toString(this.getRecordNumber()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("Polygon");
        if (d != null) {
            xMLStreamWriter.writeStartElement("extrude");
            xMLStreamWriter.writeCharacters("1");
            xMLStreamWriter.writeEndElement();
            string = "absolute";
        } else {
            string = "clampToGround";
            d = 0.0;
        }
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("outerBoundaryIs");
        KMLExportUtil.exportBoundaryAsLinearRing(xMLStreamWriter, iterable, d);
        xMLStreamWriter.writeEndElement();
        for (Iterable<? extends LatLon> iterable2 : list) {
            xMLStreamWriter.writeStartElement("innerBoundaryIs");
            KMLExportUtil.exportBoundaryAsLinearRing(xMLStreamWriter, iterable2, d);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
    }
}

