/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RPFDataSeries;
import gov.nasa.worldwind.formats.rpf.RPFFrameStructure;
import gov.nasa.worldwind.formats.rpf.RPFFrameTransform;
import gov.nasa.worldwind.formats.rpf.RPFPolarFrameStructure;
import gov.nasa.worldwind.formats.rpf.RPFZone;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;

class RPFPolarFrameTransform
extends RPFFrameTransform {
    private final char zoneCode;
    private final String rpfDataType;
    private final double resolution;
    private final RPFPolarFrameStructure frameStructure;
    private static final PixelTransformer northernPixels = new NorthPixelTransformer();
    private static final PixelTransformer southernPixels = new SouthPixelTransformer();

    private RPFPolarFrameTransform(char c, String string, double d, RPFPolarFrameStructure rPFPolarFrameStructure) {
        this.zoneCode = c;
        this.rpfDataType = string;
        this.resolution = d;
        this.frameStructure = rPFPolarFrameStructure;
    }

    static RPFPolarFrameTransform createPolarFrameTransform(char c, String string, double d) {
        if (!RPFZone.isZoneCode(c)) {
            String string2 = Logging.getMessage("RPFZone.UnknownZoneCode", Character.valueOf(c));
            Logging.logger().fine(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null || !RPFDataSeries.isRPFDataType(string)) {
            String string3 = Logging.getMessage("RPFDataSeries.UnkownDataType", string);
            Logging.logger().fine(string3);
            throw new IllegalArgumentException(string3);
        }
        if (d < 0.0) {
            String string4 = Logging.getMessage("generic.ArgumentOutOfRange", string);
            Logging.logger().fine(string4);
            throw new IllegalArgumentException(string4);
        }
        RPFPolarFrameStructure rPFPolarFrameStructure = RPFPolarFrameStructure.computeStructure(c, string, d);
        return new RPFPolarFrameTransform(c, string, d, rPFPolarFrameStructure);
    }

    public final char getZoneCode() {
        return this.zoneCode;
    }

    public final String getRpfDataType() {
        return this.rpfDataType;
    }

    public final double getResolution() {
        return this.resolution;
    }

    public final RPFFrameStructure getFrameStructure() {
        return this.frameStructure;
    }

    @Override
    public int getFrameNumber(int n, int n2) {
        return RPFPolarFrameTransform.frameNumber(n, n2, this.frameStructure.getPolarFrames());
    }

    @Override
    public int getMaximumFrameNumber() {
        return RPFPolarFrameTransform.maxFrameNumber(this.frameStructure.getPolarFrames(), this.frameStructure.getPolarFrames());
    }

    @Override
    public int getRows() {
        return this.frameStructure.getPolarFrames();
    }

    @Override
    public int getColumns() {
        return this.frameStructure.getPolarFrames();
    }

    @Override
    public LatLon computeFrameOrigin(int n) {
        if (n < 0 || n > this.getMaximumFrameNumber()) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = RPFPolarFrameTransform.pixelColumn(0, n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n3 = RPFPolarFrameTransform.pixelRow(0, n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        PixelTransformer pixelTransformer = this.zoneCode == '9' ? northernPixels : southernPixels;
        double d = pixelTransformer.pixel2Latitude(n2, n3, this.frameStructure.getPolarPixelConstant());
        double d2 = pixelTransformer.pixel2Longitude(n2, n3);
        return LatLon.fromDegrees(d, d2);
    }

    @Override
    public Sector computeFrameCoverage(int n) {
        int n2 = this.getMaximumFrameNumber();
        if (n < 0 || n > n2) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = RPFPolarFrameTransform.pixelColumn(0, n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n4 = RPFPolarFrameTransform.pixelRow(0, n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n5 = RPFPolarFrameTransform.pixelColumn(this.frameStructure.getPixelRowsPerFrame(), n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n6 = RPFPolarFrameTransform.pixelRow(this.frameStructure.getPixelRowsPerFrame(), n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n7 = (n3 + n5) / 2;
        int n8 = (n6 + n4) / 2;
        PixelTransformer pixelTransformer = this.zoneCode == '9' ? northernPixels : southernPixels;
        MinMaxLatLon minMaxLatLon = new MinMaxLatLon();
        double d = pixelTransformer.pixel2Latitude(n3, n6, this.frameStructure.getPolarPixelConstant());
        double d2 = pixelTransformer.pixel2Longitude(n3, n6);
        minMaxLatLon.setMinMax(d, d2);
        d = pixelTransformer.pixel2Latitude(n5, n6, this.frameStructure.getPolarPixelConstant());
        d2 = pixelTransformer.pixel2Longitude(n5, n6);
        minMaxLatLon.setMinMax(d, d2);
        d = pixelTransformer.pixel2Latitude(n3, n4, this.frameStructure.getPolarPixelConstant());
        d2 = pixelTransformer.pixel2Longitude(n3, n4);
        minMaxLatLon.setMinMax(d, d2);
        d = pixelTransformer.pixel2Latitude(n5, n4, this.frameStructure.getPolarPixelConstant());
        d2 = pixelTransformer.pixel2Longitude(n5, n4);
        minMaxLatLon.setMinMax(d, d2);
        d = pixelTransformer.pixel2Latitude(n7, n4, this.frameStructure.getPolarPixelConstant());
        d2 = pixelTransformer.pixel2Longitude(n7, n4);
        minMaxLatLon.setMinMax(d, d2);
        d = pixelTransformer.pixel2Latitude(n5, n8, this.frameStructure.getPolarPixelConstant());
        d2 = pixelTransformer.pixel2Longitude(n5, n8);
        minMaxLatLon.setMinMax(d, d2);
        d = pixelTransformer.pixel2Latitude(n7, n6, this.frameStructure.getPolarPixelConstant());
        d2 = pixelTransformer.pixel2Longitude(n7, n6);
        minMaxLatLon.setMinMax(d, d2);
        d = pixelTransformer.pixel2Latitude(n3, n8, this.frameStructure.getPolarPixelConstant());
        d2 = pixelTransformer.pixel2Longitude(n3, n8);
        minMaxLatLon.setMinMax(d, d2);
        d = pixelTransformer.pixel2Latitude(n7, n8, this.frameStructure.getPolarPixelConstant());
        d2 = pixelTransformer.pixel2Longitude(n7, n8);
        minMaxLatLon.setMinMax(d, d2);
        return Sector.fromDegrees(minMaxLatLon.minLat, minMaxLatLon.maxLat, minMaxLatLon.minLon, minMaxLatLon.maxLon);
    }

    @Override
    public RPFFrameTransform.RPFImage[] deproject(int n, BufferedImage bufferedImage) {
        RPFFrameTransform.RPFImage[] rPFImageArray;
        PixelTransformer pixelTransformer;
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        PixelTransformer pixelTransformer2 = pixelTransformer = this.zoneCode == '9' ? northernPixels : southernPixels;
        if (this.isDatelineSpanningFrame(n, pixelTransformer)) {
            rPFImageArray = pixelTransformer == northernPixels ? this.deprojectNorthernDatelineFrames(n, bufferedImage, pixelTransformer) : this.deprojectSouthernDatelineFrames(n, bufferedImage, pixelTransformer);
        } else {
            Sector sector = this.computeFrameCoverage(n);
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 6);
            this.resampleFrameFile(sector, bufferedImage, bufferedImage2, n, pixelTransformer);
            rPFImageArray = new RPFFrameTransform.RPFImage[]{new RPFFrameTransform.RPFImage(sector, bufferedImage2)};
        }
        return rPFImageArray;
    }

    private RPFFrameTransform.RPFImage[] deprojectNorthernDatelineFrames(int n, BufferedImage bufferedImage, PixelTransformer pixelTransformer) {
        RPFFrameTransform.RPFImage[] rPFImageArray = new RPFFrameTransform.RPFImage[2];
        int n2 = RPFPolarFrameTransform.pixelColumn(0, n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n3 = RPFPolarFrameTransform.pixelColumn(this.frameStructure.getPixelRowsPerFrame(), n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n4 = RPFPolarFrameTransform.pixelRow(0, n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n5 = RPFPolarFrameTransform.pixelRow(this.frameStructure.getPixelRowsPerFrame(), n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n6 = (n2 + n3) / 2;
        int n7 = (n4 + n5) / 2;
        MinMaxLatLon minMaxLatLon = new MinMaxLatLon();
        minMaxLatLon.minLon = -180.0;
        if (this.isCenterFrame(n)) {
            minMaxLatLon.maxLon = 0.0;
            minMaxLatLon.maxLat = pixelTransformer.pixel2Latitude(n6, n7, this.frameStructure.getPolarPixelConstant());
            minMaxLatLon.minLat = pixelTransformer.pixel2Latitude(n2, n4, this.frameStructure.getPolarPixelConstant());
        } else {
            minMaxLatLon.minLat = pixelTransformer.pixel2Latitude(n2, n4, this.frameStructure.getPolarPixelConstant());
            minMaxLatLon.maxLat = pixelTransformer.pixel2Latitude(n6, n5, this.frameStructure.getPolarPixelConstant());
            minMaxLatLon.maxLon = pixelTransformer.pixel2Longitude(n2, n5);
        }
        Sector sector = Sector.fromDegrees(minMaxLatLon.minLat, minMaxLatLon.maxLat, minMaxLatLon.minLon, minMaxLatLon.maxLon);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 6);
        this.resampleFrameFile(sector, bufferedImage, bufferedImage2, n, pixelTransformer);
        rPFImageArray[0] = new RPFFrameTransform.RPFImage(sector, bufferedImage2);
        MinMaxLatLon minMaxLatLon2 = new MinMaxLatLon();
        minMaxLatLon2.minLat = minMaxLatLon.minLat;
        minMaxLatLon2.maxLat = minMaxLatLon.maxLat;
        if (this.isCenterFrame(n)) {
            minMaxLatLon2.minLon = 0.0;
            minMaxLatLon2.maxLon = 180.0;
        } else {
            minMaxLatLon2.minLon = pixelTransformer.pixel2Longitude(n3, n5);
            minMaxLatLon2.maxLon = 180.0;
        }
        sector = Sector.fromDegrees(minMaxLatLon2.minLat, minMaxLatLon2.maxLat, minMaxLatLon2.minLon, minMaxLatLon2.maxLon);
        bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 6);
        this.resampleFrameFile(sector, bufferedImage, bufferedImage2, n, pixelTransformer);
        rPFImageArray[1] = new RPFFrameTransform.RPFImage(sector, bufferedImage2);
        return rPFImageArray;
    }

    private RPFFrameTransform.RPFImage[] deprojectSouthernDatelineFrames(int n, BufferedImage bufferedImage, PixelTransformer pixelTransformer) {
        RPFFrameTransform.RPFImage[] rPFImageArray = new RPFFrameTransform.RPFImage[2];
        int n2 = RPFPolarFrameTransform.pixelColumn(0, n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n3 = RPFPolarFrameTransform.pixelColumn(this.frameStructure.getPixelRowsPerFrame(), n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n4 = RPFPolarFrameTransform.pixelRow(0, n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n5 = RPFPolarFrameTransform.pixelRow(this.frameStructure.getPixelRowsPerFrame(), n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n6 = (n2 + n3) / 2;
        int n7 = (n4 + n5) / 2;
        MinMaxLatLon minMaxLatLon = new MinMaxLatLon();
        minMaxLatLon.minLon = -180.0;
        if (this.isCenterFrame(n)) {
            minMaxLatLon.maxLon = 0.0;
            minMaxLatLon.maxLat = pixelTransformer.pixel2Latitude(n6, n7, this.frameStructure.getPolarPixelConstant());
            minMaxLatLon.minLat = pixelTransformer.pixel2Latitude(n2, n4, this.frameStructure.getPolarPixelConstant());
        } else {
            minMaxLatLon.minLat = pixelTransformer.pixel2Latitude(n2, n5, this.frameStructure.getPolarPixelConstant());
            minMaxLatLon.maxLat = pixelTransformer.pixel2Latitude(n6, n4, this.frameStructure.getPolarPixelConstant());
            minMaxLatLon.maxLon = pixelTransformer.pixel2Longitude(n2, n4);
        }
        Sector sector = Sector.fromDegrees(minMaxLatLon.minLat, minMaxLatLon.maxLat, minMaxLatLon.minLon, minMaxLatLon.maxLon);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 6);
        this.resampleFrameFile(sector, bufferedImage, bufferedImage2, n, pixelTransformer);
        rPFImageArray[0] = new RPFFrameTransform.RPFImage(sector, bufferedImage2);
        MinMaxLatLon minMaxLatLon2 = new MinMaxLatLon();
        minMaxLatLon2.minLat = minMaxLatLon.minLat;
        minMaxLatLon2.maxLat = minMaxLatLon.maxLat;
        if (this.isCenterFrame(n)) {
            minMaxLatLon2.minLon = 0.0;
            minMaxLatLon2.maxLon = 180.0;
        } else {
            minMaxLatLon2.minLon = pixelTransformer.pixel2Longitude(n3, n4);
            minMaxLatLon2.maxLon = 180.0;
        }
        sector = Sector.fromDegrees(minMaxLatLon2.minLat, minMaxLatLon2.maxLat, minMaxLatLon2.minLon, minMaxLatLon2.maxLon);
        bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 6);
        this.resampleFrameFile(sector, bufferedImage, bufferedImage2, n, pixelTransformer);
        rPFImageArray[1] = new RPFFrameTransform.RPFImage(sector, bufferedImage2);
        return rPFImageArray;
    }

    private void resampleFrameFile(Sector sector, BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, PixelTransformer pixelTransformer) {
        int n2 = RPFPolarFrameTransform.pixelColumn(0, n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n3 = RPFPolarFrameTransform.pixelRow(0, n, this.frameStructure.getPixelRowsPerFrame(), this.frameStructure.getPolarFrames());
        int n4 = bufferedImage2.getWidth();
        int n5 = bufferedImage2.getHeight();
        double d = (sector.getMaxLongitude().degrees - sector.getMinLongitude().degrees) / (double)n4;
        double d2 = (sector.getMaxLatitude().degrees - sector.getMinLatitude().degrees) / (double)n5;
        double d3 = sector.getMinLongitude().degrees;
        double d4 = sector.getMinLatitude().degrees;
        double d5 = this.frameStructure.getPolarPixelConstant();
        int n6 = bufferedImage.getWidth();
        int n7 = bufferedImage.getHeight();
        for (int i = 0; i < n5; ++i) {
            double d6 = d4 + (double)i * d2;
            for (int j = 0; j < n4; ++j) {
                double d7 = d3 + (double)j * d;
                int n8 = pixelTransformer.latLon2X(d6, d7, d5);
                int n9 = pixelTransformer.latLon2Y(d6, d7, d5);
                int n10 = n8 - n2;
                int n11 = n3 - n9;
                if (n10 < 0 || n10 >= n6 || n11 < 0 || n11 >= n7) continue;
                int n12 = bufferedImage.getRGB(n10, n11);
                if ((n12 & 0xFFFFFF) == 0) {
                    n12 = 0;
                }
                bufferedImage2.setRGB(j, n5 - 1 - i, n12);
            }
        }
    }

    private boolean isDatelineSpanningFrame(int n, PixelTransformer pixelTransformer) {
        int n2 = n / this.getColumns();
        int n3 = n % this.getColumns();
        if (pixelTransformer == northernPixels) {
            return n2 >= this.getRows() / 2 && n3 == this.getColumns() / 2;
        }
        return n2 <= this.getRows() / 2 && n3 == this.getColumns() / 2;
    }

    private boolean isCenterFrame(int n) {
        int n2 = n / this.getRows();
        int n3 = n % this.getColumns();
        return n2 == this.getRows() / 2 && n3 == this.getColumns() / 2;
    }

    private static int pixelRow(int n, int n2, int n3, int n4) {
        int n5 = RPFPolarFrameTransform.frameRow(n2, n4);
        return (n5 + 1) * n3 - n - n4 * n3 / 2;
    }

    private static int pixelColumn(int n, int n2, int n3, int n4) {
        int n5 = RPFPolarFrameTransform.frameRow(n2, n4);
        int n6 = RPFPolarFrameTransform.frameColumn(n2, n5, n4);
        return n6 * n3 + n - n4 * n3 / 2;
    }

    private class MinMaxLatLon {
        double minLon;
        double minLat = Double.MAX_VALUE;
        double maxLon = -1.7976931348623157E308;
        double maxLat = -1.7976931348623157E308;

        public MinMaxLatLon() {
            this.minLon = Double.MAX_VALUE;
        }

        public void setMinMax(double d, double d2) {
            if (d2 < this.minLon) {
                this.minLon = d2;
            }
            if (d < this.minLat) {
                this.minLat = d;
            }
            if (d2 > this.maxLon) {
                this.maxLon = d2;
            }
            if (d > this.maxLat) {
                this.maxLat = d;
            }
            if (d2 == 180.0) {
                this.setMinMax(d, -d2);
            }
        }
    }

    private static class SouthPixelTransformer
    implements PixelTransformer {
        private SouthPixelTransformer() {
        }

        @Override
        public double pixel2Latitude(int n, int n2, double d) {
            return -90.0 + Math.sqrt(n * n + n2 * n2) / (d / 360.0);
        }

        @Override
        public double pixel2Longitude(int n, int n2) {
            if (n == 0 && n2 > 0) {
                return 0.0;
            }
            if (n == 0 && n2 <= 0) {
                return 180.0;
            }
            double d = Math.acos((double)n2 / Math.sqrt(n * n + n2 * n2)) * 180.0 / Math.PI;
            return n > 0 ? d : -d;
        }

        @Override
        public int latLon2X(double d, double d2, double d3) {
            return (int)(d3 / 360.0 * (90.0 + d) * Math.sin(d2 * Math.PI / 180.0));
        }

        @Override
        public int latLon2Y(double d, double d2, double d3) {
            return (int)(d3 / 360.0 * (90.0 + d) * Math.cos(d2 * Math.PI / 180.0));
        }
    }

    private static class NorthPixelTransformer
    implements PixelTransformer {
        private NorthPixelTransformer() {
        }

        @Override
        public double pixel2Latitude(int n, int n2, double d) {
            return 90.0 - Math.sqrt(n * n + n2 * n2) / (d / 360.0);
        }

        @Override
        public double pixel2Longitude(int n, int n2) {
            if (n == 0 && n2 > 0) {
                return 180.0;
            }
            if (n == 0 && n2 <= 0) {
                return 0.0;
            }
            double d = Math.acos((double)(-n2) / Math.sqrt(n * n + n2 * n2)) * 180.0 / Math.PI;
            return n > 0 ? d : -d;
        }

        @Override
        public int latLon2X(double d, double d2, double d3) {
            return (int)(d3 / 360.0 * (90.0 - d) * Math.sin(d2 * Math.PI / 180.0));
        }

        @Override
        public int latLon2Y(double d, double d2, double d3) {
            return (int)(-d3 / 360.0 * (90.0 - d) * Math.cos(d2 * Math.PI / 180.0));
        }
    }

    private static interface PixelTransformer {
        public double pixel2Latitude(int var1, int var2, double var3);

        public double pixel2Longitude(int var1, int var2);

        public int latLon2X(double var1, double var3, double var5);

        public int latLon2Y(double var1, double var3, double var5);
    }
}

