/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NITFSUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class RPFBoundingRectangleSection {
    private long tableOffset;
    private int numberOfRecords;
    private int recordLength;
    private ArrayList<RPFBoundingRectangleRecord> bndRectRecords = new ArrayList();

    public RPFBoundingRectangleSection(ByteBuffer byteBuffer) {
        this.tableOffset = NITFSUtil.getUInt(byteBuffer);
        this.numberOfRecords = NITFSUtil.getUShort(byteBuffer);
        this.recordLength = NITFSUtil.getUShort(byteBuffer);
        this.parseBoundsRecords(byteBuffer);
    }

    public List<RPFBoundingRectangleRecord> getBoundingRecords() {
        return this.bndRectRecords;
    }

    private void parseBoundsRecords(ByteBuffer byteBuffer) {
        for (int i = 0; i < this.numberOfRecords; ++i) {
            this.bndRectRecords.add(new RPFBoundingRectangleRecord(byteBuffer));
        }
    }

    public class RPFBoundingRectangleRecord {
        private String dataType;
        private String compressionRatio;
        private String scale;
        private String zone;
        private String producer;
        private double ulLat;
        private double ulLon;
        private double llLat;
        private double llLon;
        private double urLat;
        private double urLon;
        private double lrLat;
        private double lrLon;
        private double nsRes;
        private double ewRes;
        private double latInterval;
        private double lonInterval;
        private long numFramesNS;
        private long numFramesEW;

        public double getMinLon() {
            return this.ulLon < this.llLon ? this.ulLon : this.llLon;
        }

        public double getMinLat() {
            return this.llLat < this.lrLat ? this.llLat : this.lrLat;
        }

        public double getMaxLon() {
            return this.urLon > this.lrLon ? this.urLon : this.lrLon;
        }

        public double getMaxLat() {
            return this.ulLat > this.urLat ? this.ulLat : this.urLat;
        }

        public RPFBoundingRectangleRecord(ByteBuffer byteBuffer) {
            this.dataType = NITFSUtil.getString(byteBuffer, 5);
            this.compressionRatio = NITFSUtil.getString(byteBuffer, 5);
            this.scale = NITFSUtil.getString(byteBuffer, 12);
            this.zone = NITFSUtil.getString(byteBuffer, 1);
            this.producer = NITFSUtil.getString(byteBuffer, 5);
            this.ulLat = byteBuffer.getDouble();
            this.ulLon = byteBuffer.getDouble();
            this.llLat = byteBuffer.getDouble();
            this.llLon = byteBuffer.getDouble();
            this.urLat = byteBuffer.getDouble();
            this.urLon = byteBuffer.getDouble();
            this.lrLat = byteBuffer.getDouble();
            this.lrLon = byteBuffer.getDouble();
            this.nsRes = byteBuffer.getDouble();
            this.ewRes = byteBuffer.getDouble();
            this.latInterval = byteBuffer.getDouble();
            this.lonInterval = byteBuffer.getDouble();
            this.numFramesNS = NITFSUtil.getUInt(byteBuffer);
            this.numFramesEW = NITFSUtil.getUInt(byteBuffer);
        }
    }
}

