/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nmea;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.util.Logging;

public class NmeaTrackPoint
implements TrackPoint {
    private double latitude;
    private double longitude;
    private double altitude;
    private double geoidHeight;
    private String time;

    public NmeaTrackPoint(String[] stringArray) {
        if (stringArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (stringArray.length < 1) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", stringArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (stringArray[0].equalsIgnoreCase("GPGGA")) {
            this.doGGA(stringArray);
        } else if (stringArray[0].equalsIgnoreCase("GPRMC")) {
            this.doRMC(stringArray);
        }
    }

    private void doGGA(String[] stringArray) {
        if (stringArray.length < 6) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", stringArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.time = stringArray[1];
        this.latitude = this.parseLatitude(stringArray[2], stringArray[3]);
        this.longitude = this.parseLongitude(stringArray[4], stringArray[5]);
        if (stringArray.length >= 11) {
            this.altitude = this.parseElevation(stringArray[9], stringArray[10]);
        }
        if (stringArray.length >= 13) {
            this.geoidHeight = this.parseElevation(stringArray[11], stringArray[12]);
        }
    }

    private void doRMC(String[] stringArray) {
    }

    private double parseLatitude(String string, String string2) {
        if (string.length() == 0) {
            return 0.0;
        }
        double d = string.length() > 2 ? Double.parseDouble(string.substring(2, string.length())) : 0.0;
        double d2 = Double.parseDouble(string.substring(0, 2)) + d / 60.0;
        return string2.equalsIgnoreCase("S") ? -d2 : d2;
    }

    private double parseLongitude(String string, String string2) {
        if (string.length() == 0) {
            return 0.0;
        }
        double d = string.length() > 3 ? Double.parseDouble(string.substring(3, string.length())) : 0.0;
        double d2 = Double.parseDouble(string.substring(0, 3)) + d / 60.0;
        return string2.equalsIgnoreCase("W") ? -d2 : d2;
    }

    private double parseElevation(String string, String string2) {
        if (string.length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(string) * this.unitsToMeters(string2);
    }

    private double unitsToMeters(String string) {
        double d = string.equals("M") ? 1.0 : (string.equals("f") ? 3.2808399 : (string.equals("F") ? 0.5468066528 : 1.0));
        return d;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public void setLatitude(double d) {
        if (d > 90.0 || d < -90.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = d;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public void setLongitude(double d) {
        if (d > 180.0 || d < -180.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.longitude = d;
    }

    @Override
    public Position getPosition() {
        return Position.fromDegrees(this.latitude, this.longitude, this.altitude);
    }

    @Override
    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = position.getLatitude().getDegrees();
        this.longitude = position.getLongitude().getDegrees();
        this.altitude = position.getElevation();
    }

    @Override
    public double getElevation() {
        return this.altitude + this.geoidHeight;
    }

    @Override
    public void setElevation(double d) {
        this.altitude = d;
        this.geoidHeight = 0.0;
    }

    @Override
    public String getTime() {
        return this.time;
    }

    @Override
    public void setTime(String string) {
        this.time = string;
    }

    public String toString() {
        return String.format("(%10.8f\u00b0, %11.8f\u00b0, %10.4g m, %10.4g m, %s)", this.latitude, this.longitude, this.altitude, this.geoidHeight, this.time);
    }
}

