/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.geojson;

import gov.nasa.worldwind.formats.geojson.GeoJSONFeature;
import gov.nasa.worldwind.formats.geojson.GeoJSONFeatureCollection;
import gov.nasa.worldwind.formats.geojson.GeoJSONGeometryCollection;
import gov.nasa.worldwind.formats.geojson.GeoJSONLineString;
import gov.nasa.worldwind.formats.geojson.GeoJSONMultiLineString;
import gov.nasa.worldwind.formats.geojson.GeoJSONMultiPoint;
import gov.nasa.worldwind.formats.geojson.GeoJSONMultiPolygon;
import gov.nasa.worldwind.formats.geojson.GeoJSONPoint;
import gov.nasa.worldwind.formats.geojson.GeoJSONPolygon;
import gov.nasa.worldwind.formats.json.BasicJSONEventParser;
import gov.nasa.worldwind.formats.json.JSONEvent;
import gov.nasa.worldwind.formats.json.JSONEventParserContext;

public class GeoJSONEventParser
extends BasicJSONEventParser {
    @Override
    protected Object resolveObject(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) {
        if (this.fields == null) {
            return super.resolveObject(jSONEventParserContext, jSONEvent);
        }
        Object object = this.fields.getValue("type");
        if ("Point".equals(object)) {
            return new GeoJSONPoint(this.fields);
        }
        if ("MultiPoint".equals(object)) {
            return new GeoJSONMultiPoint(this.fields);
        }
        if ("LineString".equals(object)) {
            return new GeoJSONLineString(this.fields);
        }
        if ("MultiLineString".equals(object)) {
            return new GeoJSONMultiLineString(this.fields);
        }
        if ("Polygon".equals(object)) {
            return new GeoJSONPolygon(this.fields);
        }
        if ("MultiPolygon".equals(object)) {
            return new GeoJSONMultiPolygon(this.fields);
        }
        if ("GeometryCollection".equals(object)) {
            return new GeoJSONGeometryCollection(this.fields);
        }
        if ("Feature".equals(object)) {
            return new GeoJSONFeature(this.fields);
        }
        if ("FeatureCollection".equals(object)) {
            return new GeoJSONFeatureCollection(this.fields);
        }
        return super.resolveObject(jSONEventParserContext, jSONEvent);
    }

    @Override
    protected Object resolveArray(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) {
        if ("features".equals(jSONEventParserContext.getCurrentFieldName())) {
            return this.array.toArray(new GeoJSONFeature[this.array.size()]);
        }
        if ("geometries".equals(jSONEventParserContext.getCurrentFieldName())) {
            return this.array.toArray(new GeoJSONFeature[this.array.size()]);
        }
        return super.resolveArray(jSONEventParserContext, jSONEvent);
    }
}

