/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

import gov.nasa.worldwind.formats.dds.BlockDXT1;
import gov.nasa.worldwind.formats.dds.Color32;
import gov.nasa.worldwind.formats.dds.ColorBlock4x4;
import gov.nasa.worldwind.formats.dds.DXTCompressionAttributes;
import gov.nasa.worldwind.util.Logging;

public class BlockDXT1Compressor {
    protected final Color32 minColor = new Color32();
    protected final Color32 maxColor = new Color32();
    protected final Color32[] palette = new Color32[4];

    public BlockDXT1Compressor() {
        for (int i = 0; i < 4; ++i) {
            this.palette[i] = new Color32();
        }
    }

    public void compressBlockDXT1(ColorBlock4x4 colorBlock4x4, DXTCompressionAttributes dXTCompressionAttributes, BlockDXT1 blockDXT1) {
        if (colorBlock4x4 == null) {
            String string = Logging.getMessage("nullValue.ColorBlockIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (blockDXT1 == null) {
            String string = Logging.getMessage("nullValue.DXTBlockIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.chooseMinMaxColors(colorBlock4x4, dXTCompressionAttributes, this.minColor, this.maxColor);
        int n = BlockDXT1Compressor.short565FromColor32(this.maxColor);
        int n2 = BlockDXT1Compressor.short565FromColor32(this.minColor);
        if (n < n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        BlockDXT1Compressor.computeColorPalette4(n, n2, this.palette);
        blockDXT1.color0 = n;
        blockDXT1.color1 = n2;
        blockDXT1.colorIndexMask = BlockDXT1Compressor.computePaletteIndices4(colorBlock4x4, this.palette);
    }

    public void compressBlockDXT1a(ColorBlock4x4 colorBlock4x4, DXTCompressionAttributes dXTCompressionAttributes, BlockDXT1 blockDXT1) {
        if (colorBlock4x4 == null) {
            String string = Logging.getMessage("nullValue.ColorBlockIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (blockDXT1 == null) {
            String string = Logging.getMessage("nullValue.DXTBlockIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.chooseMinMaxColors(colorBlock4x4, dXTCompressionAttributes, this.minColor, this.maxColor);
        int n = BlockDXT1Compressor.short565FromColor32(this.maxColor);
        int n2 = BlockDXT1Compressor.short565FromColor32(this.minColor);
        if (n < n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        BlockDXT1Compressor.computeColorPalette3(n2, n, this.palette);
        blockDXT1.color0 = n2;
        blockDXT1.color1 = n;
        blockDXT1.colorIndexMask = BlockDXT1Compressor.computePaletteIndices3(colorBlock4x4, dXTCompressionAttributes, this.palette);
    }

    protected void chooseMinMaxColors(ColorBlock4x4 colorBlock4x4, DXTCompressionAttributes dXTCompressionAttributes, Color32 color32, Color32 color322) {
        if (dXTCompressionAttributes.getColorBlockCompressionType() == "ColorBlockCompressionBBox") {
            BlockDXT1Compressor.findMinMaxColorsBox(colorBlock4x4, color32, color322);
            BlockDXT1Compressor.selectDiagonal(colorBlock4x4, color32, color322);
            BlockDXT1Compressor.insetBox(color32, color322);
        } else if (dXTCompressionAttributes.getColorBlockCompressionType() == "ColorBlockCompressionEuclideanDistance") {
            BlockDXT1Compressor.findMinMaxColorsEuclideanDistance(colorBlock4x4, color32, color322);
        } else if (dXTCompressionAttributes.getColorBlockCompressionType() == "ColorBlockCompressionLuminanceDistance") {
            BlockDXT1Compressor.findMinMaxColorsLuminanceDistance(colorBlock4x4, color32, color322);
        }
    }

    protected static void computeColorPalette3(int n, int n2, Color32[] color32Array) {
        BlockDXT1Compressor.short565ToColor32(n, color32Array[0]);
        BlockDXT1Compressor.short565ToColor32(n2, color32Array[1]);
        color32Array[2].a = 255;
        color32Array[2].r = (color32Array[0].r + color32Array[1].r) / 2;
        color32Array[2].g = (color32Array[0].g + color32Array[1].g) / 2;
        color32Array[2].b = (color32Array[0].b + color32Array[1].b) / 2;
        color32Array[3].a = 0;
        color32Array[3].r = 0;
        color32Array[3].g = 0;
        color32Array[3].b = 0;
    }

    protected static void computeColorPalette4(int n, int n2, Color32[] color32Array) {
        BlockDXT1Compressor.short565ToColor32(n, color32Array[0]);
        BlockDXT1Compressor.short565ToColor32(n2, color32Array[1]);
        color32Array[2].a = 255;
        color32Array[2].r = (2 * color32Array[0].r + color32Array[1].r) / 3;
        color32Array[2].g = (2 * color32Array[0].g + color32Array[1].g) / 3;
        color32Array[2].b = (2 * color32Array[0].b + color32Array[1].b) / 3;
        color32Array[2].a = 255;
        color32Array[3].r = (color32Array[0].r + 2 * color32Array[1].r) / 3;
        color32Array[3].g = (color32Array[0].g + 2 * color32Array[1].g) / 3;
        color32Array[3].b = (color32Array[0].b + 2 * color32Array[1].b) / 3;
    }

    protected static long computePaletteIndices3(ColorBlock4x4 colorBlock4x4, DXTCompressionAttributes dXTCompressionAttributes, Color32[] color32Array) {
        int n = dXTCompressionAttributes.getDXT1AlphaThreshold();
        long l = 0L;
        for (int i = 0; i < 16; ++i) {
            int n2 = BlockDXT1Compressor.colorDistanceSquared(color32Array[0], colorBlock4x4.color[i]);
            int n3 = BlockDXT1Compressor.colorDistanceSquared(color32Array[1], colorBlock4x4.color[i]);
            int n4 = BlockDXT1Compressor.colorDistanceSquared(color32Array[2], colorBlock4x4.color[i]);
            long l2 = colorBlock4x4.color[i].a < n ? 3L : (n2 < n3 && n2 < n4 ? 0L : (n3 < n4 ? 1L : 2L));
            l |= l2 << (i << 1);
        }
        return l;
    }

    protected static long computePaletteIndices4(ColorBlock4x4 colorBlock4x4, Color32[] color32Array) {
        long l = 0L;
        for (int i = 0; i < 16; ++i) {
            int n = BlockDXT1Compressor.colorDistanceSquared(color32Array[0], colorBlock4x4.color[i]);
            int n2 = BlockDXT1Compressor.colorDistanceSquared(color32Array[1], colorBlock4x4.color[i]);
            int n3 = BlockDXT1Compressor.colorDistanceSquared(color32Array[2], colorBlock4x4.color[i]);
            int n4 = BlockDXT1Compressor.colorDistanceSquared(color32Array[3], colorBlock4x4.color[i]);
            int n5 = BlockDXT1Compressor.greaterThan(n, n4);
            int n6 = BlockDXT1Compressor.greaterThan(n2, n3);
            int n7 = BlockDXT1Compressor.greaterThan(n, n3);
            int n8 = BlockDXT1Compressor.greaterThan(n2, n4);
            int n9 = BlockDXT1Compressor.greaterThan(n3, n4);
            int n10 = n6 & n7;
            int n11 = n5 & n8;
            int n12 = n5 & n9;
            long l2 = n12 | (n10 | n11) << 1;
            l |= l2 << (i << 1);
        }
        return l;
    }

    protected static void findMinMaxColorsBox(ColorBlock4x4 colorBlock4x4, Color32 color32, Color32 color322) {
        color32.b = 255;
        color32.g = 255;
        color32.r = 255;
        color322.b = 0;
        color322.g = 0;
        color322.r = 0;
        for (int i = 0; i < 16; ++i) {
            BlockDXT1Compressor.minColorComponents(color32, colorBlock4x4.color[i], color32);
            BlockDXT1Compressor.maxColorComponents(color322, colorBlock4x4.color[i], color322);
        }
    }

    protected static void selectDiagonal(ColorBlock4x4 colorBlock4x4, Color32 color32, Color32 color322) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = (color32.r + color322.r) / 2;
        int n7 = (color32.g + color322.g) / 2;
        int n8 = (color32.b + color322.b) / 2;
        int n9 = 0;
        int n10 = 0;
        for (n5 = 0; n5 < 16; ++n5) {
            n4 = colorBlock4x4.color[n5].r - n6;
            n3 = colorBlock4x4.color[n5].g - n7;
            n2 = colorBlock4x4.color[n5].b - n8;
            n9 += n4 * n2;
            n10 += n3 * n2;
        }
        n5 = color32.r;
        n4 = color32.g;
        n3 = color322.r;
        n2 = color322.g;
        if (n9 < 0) {
            n = n5;
            n5 = n3;
            n3 = n;
        }
        if (n10 < 0) {
            n = n4;
            n4 = n2;
            n2 = n;
        }
        color32.r = n5;
        color32.g = n4;
        color322.r = n3;
        color322.g = n2;
    }

    protected static void insetBox(Color32 color32, Color32 color322) {
        int n = color322.r - color32.r >> 4;
        int n2 = color322.g - color32.g >> 4;
        int n3 = color322.b - color32.b >> 4;
        color32.r = color32.r + n < 255 ? color32.r + n : 255;
        color32.g = color32.g + n2 < 255 ? color32.g + n2 : 255;
        color32.b = color32.b + n3 < 255 ? color32.b + n3 : 255;
        color322.r = color322.r > n ? color322.r - n : 0;
        color322.g = color322.g > n2 ? color322.g - n2 : 0;
        color322.b = color322.b > n3 ? color322.b - n3 : 0;
    }

    protected static void findMinMaxColorsEuclideanDistance(ColorBlock4x4 colorBlock4x4, Color32 color32, Color32 color322) {
        double d = -1.0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 15; ++i) {
            for (int j = i + 1; j < 16; ++j) {
                double d2 = BlockDXT1Compressor.colorDistanceSquared(colorBlock4x4.color[i], colorBlock4x4.color[j]);
                if (!(d2 > d)) continue;
                n = i;
                n2 = j;
                d = d2;
            }
        }
        BlockDXT1Compressor.copyColorComponents(colorBlock4x4.color[n], color32);
        BlockDXT1Compressor.copyColorComponents(colorBlock4x4.color[n2], color322);
    }

    protected static void findMinMaxColorsLuminanceDistance(ColorBlock4x4 colorBlock4x4, Color32 color32, Color32 color322) {
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < 16; ++i) {
            int n5 = BlockDXT1Compressor.colorLuminance(colorBlock4x4.color[i]);
            if (n5 < n) {
                n3 = i;
                n = n5;
            }
            if (n5 <= n2) continue;
            n4 = i;
            n2 = n5;
        }
        BlockDXT1Compressor.copyColorComponents(colorBlock4x4.color[n3], color32);
        BlockDXT1Compressor.copyColorComponents(colorBlock4x4.color[n4], color322);
    }

    protected static int short565FromColor32(Color32 color32) {
        return (BlockDXT1Compressor.mul8bit(color32.r, 31) << 11) + (BlockDXT1Compressor.mul8bit(color32.g, 63) << 5) + BlockDXT1Compressor.mul8bit(color32.b, 31);
    }

    protected static void short565ToColor32(int n, Color32 color32) {
        int n2 = (n & 0xF800) >> 11;
        int n3 = (n & 0x7E0) >> 5;
        int n4 = n & 0x1F;
        color32.a = 255;
        color32.r = n2 << 3 | n2 >> 2;
        color32.g = n3 << 2 | n3 >> 4;
        color32.b = n4 << 3 | n4 >> 2;
    }

    private static int mul8bit(int n, int n2) {
        int n3 = n * n2 + 128;
        return n3 + (n3 >> 8) >> 8;
    }

    protected static int colorLuminance(Color32 color32) {
        return color32.r + color32.g + 2 * color32.b;
    }

    protected static int colorDistanceSquared(Color32 color32, Color32 color322) {
        return (color32.r - color322.r) * (color32.r - color322.r) + (color32.g - color322.g) * (color32.g - color322.g) + (color32.b - color322.b) * (color32.b - color322.b);
    }

    protected static void maxColorComponents(Color32 color32, Color32 color322, Color32 color323) {
        color323.a = color32.a > color322.a ? color32.a : color322.a;
        color323.r = color32.r > color322.r ? color32.r : color322.r;
        color323.g = color32.g > color322.g ? color32.g : color322.g;
        color323.b = color32.b > color322.b ? color32.b : color322.b;
    }

    protected static void minColorComponents(Color32 color32, Color32 color322, Color32 color323) {
        color323.a = color32.a > color322.a ? color322.a : color32.a;
        color323.r = color32.r > color322.r ? color322.r : color32.r;
        color323.g = color32.g > color322.g ? color322.g : color32.g;
        color323.b = color32.b > color322.b ? color322.b : color32.b;
    }

    protected static void copyColorComponents(Color32 color32, Color32 color322) {
        color322.a = color32.a;
        color322.r = color32.r;
        color322.g = color32.g;
        color322.b = color32.b;
    }

    protected static int greaterThan(int n, int n2) {
        return n2 - n >>> 31;
    }
}

