/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.AbstractDataRasterReader;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.formats.nitfs.NITFSImageSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSSegmentType;
import gov.nasa.worldwind.formats.rpf.RPFDataSeries;
import gov.nasa.worldwind.formats.rpf.RPFFile;
import gov.nasa.worldwind.formats.rpf.RPFFrameFileComponents;
import gov.nasa.worldwind.formats.rpf.RPFFrameFilename;
import gov.nasa.worldwind.formats.rpf.RPFFrameTransform;
import gov.nasa.worldwind.formats.rpf.RPFImageFile;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class RPFRasterReader
extends AbstractDataRasterReader {
    public RPFRasterReader() {
        super("RPF Imagery");
    }

    @Override
    public boolean canRead(Object object, AVList aVList) {
        if (object == null) {
            return false;
        }
        return this.doCanRead(object, aVList);
    }

    @Override
    protected boolean doCanRead(Object object, AVList aVList) {
        if (!(object instanceof File)) {
            return false;
        }
        File file = (File)object;
        String string = file.getName().toUpperCase();
        boolean bl = RPFFrameFilename.isFilename(string);
        if (bl && null != aVList && !aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
        }
        return bl;
    }

    @Override
    protected DataRaster[] doRead(Object object, AVList aVList) throws IOException {
        if (!(object instanceof File)) {
            String string = Logging.getMessage("DataRaster.CannotRead", object);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File file = (File)object;
        RPFFrameFilename rPFFrameFilename = RPFFrameFilename.parseFilename(file.getName().toUpperCase());
        if (rPFFrameFilename.getZoneCode() == '9' || rPFFrameFilename.getZoneCode() == 'J') {
            return this.readPolarImage(object, rPFFrameFilename);
        }
        return this.readNonPolarImage(object, aVList);
    }

    @Override
    protected void doReadMetadata(Object object, AVList aVList) throws IOException {
        Object object2;
        if (!(object instanceof File)) {
            String string = Logging.getMessage("DataRaster.CannotRead", object);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File file = (File)object;
        RPFImageFile rPFImageFile = null;
        Object object3 = aVList.getValue("gov.nasa.worldwind.avkey.Width");
        Object object4 = aVList.getValue("gov.nasa.worldwind.avkey.Height");
        if (object3 == null || object4 == null || !(object3 instanceof Integer) || !(object4 instanceof Integer)) {
            rPFImageFile = RPFImageFile.load(file);
            this.readFileSize(rPFImageFile, aVList);
        }
        if ((object2 = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object2 instanceof Sector)) {
            this.readFileSector(file, rPFImageFile, aVList);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
        }
    }

    private DataRaster[] readNonPolarImage(Object object, AVList aVList) throws IOException {
        AVListImpl aVListImpl;
        Object object2;
        File file = (File)object;
        RPFImageFile rPFImageFile = RPFImageFile.load(file);
        BufferedImage bufferedImage = rPFImageFile.getBufferedImage();
        bufferedImage = ImageUtil.toCompatibleImage(bufferedImage);
        Object object3 = object2 = aVList != null ? aVList.getValue("gov.nasa.worldwind.avKey.Sector") : null;
        if (object2 == null || !(object2 instanceof Sector)) {
            aVListImpl = new AVListImpl();
            this.readFileSector(file, rPFImageFile, aVListImpl);
            object2 = aVListImpl.getValue("gov.nasa.worldwind.avKey.Sector");
        }
        aVListImpl = new BufferedImageRaster((Sector)object2, bufferedImage);
        return new DataRaster[]{aVListImpl};
    }

    private DataRaster[] readPolarImage(Object object, RPFFrameFilename rPFFrameFilename) throws IOException {
        File file = (File)object;
        RPFImageFile rPFImageFile = RPFImageFile.load(file);
        BufferedImage bufferedImage = rPFImageFile.getBufferedImage();
        RPFDataSeries rPFDataSeries = RPFDataSeries.dataSeriesFor(rPFFrameFilename.getDataSeriesCode());
        RPFFrameTransform rPFFrameTransform = RPFFrameTransform.createFrameTransform(rPFFrameFilename.getZoneCode(), rPFDataSeries.rpfDataType, rPFDataSeries.scaleOrGSD);
        RPFFrameTransform.RPFImage[] rPFImageArray = rPFFrameTransform.deproject(rPFFrameFilename.getFrameNumber(), bufferedImage);
        DataRaster[] dataRasterArray = new DataRaster[rPFImageArray.length];
        for (int i = 0; i < rPFImageArray.length; ++i) {
            BufferedImage bufferedImage2 = ImageUtil.toCompatibleImage(rPFImageArray[i].getImage());
            dataRasterArray[i] = new BufferedImageRaster(rPFImageArray[i].getSector(), bufferedImage2);
        }
        return dataRasterArray;
    }

    private void readFileSize(RPFImageFile rPFImageFile, AVList aVList) {
        int n = rPFImageFile.getImageSegment().numSignificantCols;
        int n2 = rPFImageFile.getImageSegment().numSignificantRows;
        aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
        aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
    }

    private void readFileSector(File file, RPFImageFile rPFImageFile, AVList aVList) {
        Sector sector = this.sectorFromFilename(file);
        if (sector == null) {
            sector = this.sectorFromHeader(file, rPFImageFile);
        }
        aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
    }

    private Sector sectorFromFilename(File file) {
        Sector sector = null;
        try {
            RPFFrameFilename rPFFrameFilename = RPFFrameFilename.parseFilename(file.getName().toUpperCase());
            RPFDataSeries rPFDataSeries = RPFDataSeries.dataSeriesFor(rPFFrameFilename.getDataSeriesCode());
            if (rPFDataSeries.scaleOrGSD > 0.0) {
                RPFFrameTransform rPFFrameTransform = RPFFrameTransform.createFrameTransform(rPFFrameFilename.getZoneCode(), rPFDataSeries.rpfDataType, rPFDataSeries.scaleOrGSD);
                sector = rPFFrameTransform.computeFrameCoverage(rPFFrameFilename.getFrameNumber());
            }
        }
        catch (Exception exception) {
            String string = String.format("Exception while computing file sector: %s", file);
            Logging.logger().log(Level.SEVERE, string, exception);
            sector = null;
        }
        return sector;
    }

    private Sector sectorFromHeader(File file, RPFFile rPFFile) {
        Sector sector;
        try {
            Angle angle;
            if (rPFFile == null) {
                rPFFile = RPFImageFile.load(file);
            }
            NITFSImageSegment nITFSImageSegment = (NITFSImageSegment)rPFFile.getNITFSSegment(NITFSSegmentType.IMAGE_SEGMENT);
            RPFFrameFileComponents rPFFrameFileComponents = nITFSImageSegment.getUserDefinedImageSubheader().getRPFFrameFileComponents();
            Angle angle2 = rPFFrameFileComponents.swLowerleft.getLatitude();
            Angle angle3 = rPFFrameFileComponents.neUpperRight.getLatitude();
            Angle angle4 = rPFFrameFileComponents.swLowerleft.getLongitude();
            if (Angle.crossesLongitudeBoundary(angle4, angle = rPFFrameFileComponents.neUpperRight.getLongitude()) && angle4.compareTo(angle) > 0) {
                double d = 360.0 + angle.degrees;
                angle = Angle.fromDegrees(d);
            }
            sector = new Sector(angle2, angle3, angle4, angle);
        }
        catch (Exception exception) {
            String string = String.format("Exception while getting file sector: %s", file);
            Logging.logger().log(Level.SEVERE, string, exception);
            sector = null;
        }
        return sector;
    }
}

