/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.animation;

import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.ScheduledInterpolator;

public class SmoothInterpolator
extends ScheduledInterpolator {
    private boolean useMidZoom = true;
    private final int MAX_SMOOTHING = 3;
    private final double START = this.useMidZoom ? 0.0 : 0.6;
    private final double STOP = 1.0;

    public SmoothInterpolator(long l) {
        super(l);
    }

    @Override
    public double nextInterpolant() {
        double d = super.nextInterpolant();
        return SmoothInterpolator.basicInterpolant(d, this.START, this.STOP, this.MAX_SMOOTHING);
    }

    protected static double basicInterpolant(double d, double d2, double d3, int n) {
        double d4 = AnimationSupport.interpolantNormalized(d, d2, d3);
        return AnimationSupport.interpolantSmoothed(d4, n);
    }
}

