/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.animation;

import gov.nasa.worldwind.animation.BasicAnimator;
import gov.nasa.worldwind.animation.Interpolator;
import gov.nasa.worldwind.animation.ScheduledInterpolator;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.PropertyAccessor;

public class PositionAnimator
extends BasicAnimator {
    protected Position begin;
    protected Position end;
    protected final PropertyAccessor.PositionAccessor propertyAccessor;

    public PositionAnimator(Interpolator interpolator, Position position, Position position2, PropertyAccessor.PositionAccessor positionAccessor) {
        super(interpolator);
        if (interpolator == null) {
            this.interpolator = new ScheduledInterpolator(10000L);
        }
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (positionAccessor == null) {
            String string = Logging.getMessage("nullValue.ViewPropertyAccessorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.begin = position;
        this.end = position2;
        this.propertyAccessor = positionAccessor;
    }

    public void setBegin(Position position) {
        this.begin = position;
    }

    public void setEnd(Position position) {
        this.end = position;
    }

    public Position getBegin() {
        return this.begin;
    }

    public Position getEnd() {
        return this.end;
    }

    public PropertyAccessor.PositionAccessor getPropertyAccessor() {
        return this.propertyAccessor;
    }

    @Override
    protected void setImpl(double d) {
        Position position = this.nextPosition(d);
        if (position == null) {
            return;
        }
        boolean bl = this.propertyAccessor.setPosition(position);
        if (!bl) {
            this.flagLastStateInvalid();
        }
        if (d >= 1.0) {
            this.stop();
        }
    }

    protected Position nextPosition(double d) {
        return Position.interpolateGreatCircle(d, this.begin, this.end);
    }
}

