/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.cache.MemoryCacheSet;
import gov.nasa.worldwind.cache.SessionCache;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.tiff.GeotiffImageReaderSpi;
import gov.nasa.worldwind.retrieve.RetrievalService;
import gov.nasa.worldwind.util.BasicScheduledTaskService;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.NetworkStatus;
import gov.nasa.worldwind.util.ScheduledTaskService;
import gov.nasa.worldwind.util.TaskService;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import javax.imageio.spi.IIORegistry;

public final class WorldWind {
    public static final String SHUTDOWN_EVENT = "gov.nasa.worldwind.ShutDown";
    public static final int ABSOLUTE = 0;
    public static final int CLAMP_TO_GROUND = 1;
    public static final int RELATIVE_TO_GROUND = 2;
    public static final int CONSTANT = 3;
    public static final int GREAT_CIRCLE = 0;
    public static final int LINEAR = 1;
    public static final int RHUMB_LINE = 2;
    public static final int ANTIALIAS_DONT_CARE = 4352;
    public static final int ANTIALIAS_FASTEST = 4353;
    public static final int ANTIALIAS_NICEST = 4354;
    private static WorldWind instance = new WorldWind();
    private WWObjectImpl wwo;
    private MemoryCacheSet memoryCacheSet;
    private FileStore dataFileStore;
    private RetrievalService remoteRetrievalService;
    private RetrievalService localRetrievalService;
    private TaskService taskService;
    private ScheduledTaskService scheduledTaskService;
    private NetworkStatus networkStatus;
    private SessionCache sessionCache;

    private WorldWind() {
        this.initialize();
    }

    private void initialize() {
        this.wwo = new WWObjectImpl();
        this.remoteRetrievalService = (RetrievalService)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.RetrievalServiceClassName");
        this.localRetrievalService = (RetrievalService)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.RetrievalServiceClassName");
        this.taskService = (TaskService)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TaskServiceClassName");
        this.dataFileStore = (FileStore)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.DataFileStoreClassName");
        this.memoryCacheSet = (MemoryCacheSet)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.MemoryCacheSetClassName");
        this.networkStatus = (NetworkStatus)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.NetworkStatusClassName");
        this.sessionCache = (SessionCache)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.SessionCacheClassName");
        this.scheduledTaskService = new BasicScheduledTaskService();
        IIORegistry.getDefaultInstance().registerServiceProvider(GeotiffImageReaderSpi.inst());
    }

    private void dispose() {
        if (this.taskService != null) {
            this.taskService.shutdown(true);
        }
        if (this.remoteRetrievalService != null) {
            this.remoteRetrievalService.shutdown(true);
        }
        if (this.localRetrievalService != null) {
            this.localRetrievalService.shutdown(true);
        }
        if (this.memoryCacheSet != null) {
            this.memoryCacheSet.clear();
        }
        if (this.sessionCache != null) {
            this.sessionCache.clear();
        }
        if (this.scheduledTaskService != null) {
            this.scheduledTaskService.shutdown(true);
        }
    }

    public static synchronized void shutDown() {
        WorldWind.instance.wwo.firePropertyChange(SHUTDOWN_EVENT, null, -1);
        instance.dispose();
        instance = new WorldWind();
    }

    public static MemoryCacheSet getMemoryCacheSet() {
        return WorldWind.instance.memoryCacheSet;
    }

    public static synchronized MemoryCache getMemoryCache(String string) {
        return WorldWind.instance.memoryCacheSet.getCache(string);
    }

    public static FileStore getDataFileStore() {
        return WorldWind.instance.dataFileStore;
    }

    public static RetrievalService getRetrievalService() {
        return WorldWind.instance.remoteRetrievalService;
    }

    public static RetrievalService getRemoteRetrievalService() {
        return WorldWind.instance.remoteRetrievalService;
    }

    public static RetrievalService getLocalRetrievalService() {
        return WorldWind.instance.localRetrievalService;
    }

    public static TaskService getTaskService() {
        return WorldWind.instance.taskService;
    }

    public static ScheduledTaskService getScheduledTaskService() {
        return WorldWind.instance.scheduledTaskService;
    }

    public static NetworkStatus getNetworkStatus() {
        return WorldWind.instance.networkStatus;
    }

    public static SessionCache getSessionCache() {
        return WorldWind.instance.sessionCache;
    }

    public static boolean isOfflineMode() {
        return WorldWind.getNetworkStatus().isOfflineMode();
    }

    public static void setOfflineMode(boolean bl) {
        WorldWind.getNetworkStatus().setOfflineMode(bl);
    }

    public static Object createComponent(String string) throws WWRuntimeException {
        if (string == null || string.length() == 0) {
            Logging.logger().severe("nullValue.ClassNameIsNull");
            throw new IllegalArgumentException(Logging.getMessage("nullValue.ClassNameIsNull"));
        }
        try {
            Class<?> clazz = Class.forName(string.trim());
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "WorldWind.ExceptionCreatingComponent", string);
            throw new WWRuntimeException(Logging.getMessage("WorldWind.ExceptionCreatingComponent", string), exception);
        }
        catch (Throwable throwable) {
            Logging.logger().log(Level.SEVERE, "WorldWind.ErrorCreatingComponent", string);
            throw new WWRuntimeException(Logging.getMessage("WorldWind.ErrorCreatingComponent", string), throwable);
        }
    }

    public static Object createConfigurationComponent(String string) throws IllegalStateException, IllegalArgumentException {
        if (string == null || string.length() == 0) {
            Logging.logger().severe("nullValue.ClassNameKeyNullZero");
            throw new IllegalArgumentException(Logging.getMessage("nullValue.ClassNameKeyNullZero"));
        }
        String string2 = Configuration.getStringValue(string);
        if (string2 == null) {
            Logging.logger().log(Level.SEVERE, "WorldWind.NoClassNameInConfigurationForKey", string);
            throw new WWRuntimeException(Logging.getMessage("WorldWind.NoClassNameInConfigurationForKey", string));
        }
        try {
            return WorldWind.createComponent(string2.trim());
        }
        catch (Throwable throwable) {
            Logging.logger().log(Level.SEVERE, "WorldWind.UnableToCreateClassForConfigurationKey", string2);
            throw new IllegalStateException(Logging.getMessage("WorldWind.UnableToCreateClassForConfigurationKey", string2), throwable);
        }
    }

    public static void setValue(String string, Object object) {
        WorldWind.instance.wwo.setValue(string, object);
    }

    public static void setValue(String string, String string2) {
        WorldWind.instance.wwo.setValue(string, string2);
    }

    public static Object getValue(String string) {
        return WorldWind.instance.wwo.getValue(string);
    }

    public static String getStringValue(String string) {
        return WorldWind.instance.wwo.getStringValue(string);
    }

    public static boolean hasKey(String string) {
        return WorldWind.instance.wwo.hasKey(string);
    }

    public static void removeKey(String string) {
        WorldWind.instance.wwo.removeKey(string);
    }

    public static void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        WorldWind.instance.wwo.addPropertyChangeListener(string, propertyChangeListener);
    }

    public static void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        WorldWind.instance.wwo.removePropertyChangeListener(string, propertyChangeListener);
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        WorldWind.instance.wwo.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        WorldWind.instance.wwo.removePropertyChangeListener(propertyChangeListener);
    }
}

