/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.event.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import nl.tudelft.simulation.event.EventProducer;
import nl.tudelft.simulation.event.EventType;
import nl.tudelft.simulation.event.util.EventIterator;

public class EventProducingList
extends EventProducer
implements List {
    public static final EventType OBJECT_ADDED_EVENT = new EventType("OBJECT_ADDED_EVENT");
    public static final EventType OBJECT_REMOVED_EVENT = new EventType("OBJECT_REMOVED_EVENT");
    private List parent = null;

    public EventProducingList(List parent) {
        this.parent = parent;
    }

    public int size() {
        return this.parent.size();
    }

    public boolean isEmpty() {
        return this.parent.isEmpty();
    }

    public void clear() {
        this.parent.clear();
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
    }

    public void add(int index, Object element) {
        this.parent.add(index, element);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
    }

    public boolean add(Object o) {
        boolean result = this.parent.add(o);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
        return result;
    }

    public boolean addAll(Collection c) {
        boolean result = this.parent.addAll(c);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
        return result;
    }

    public boolean addAll(int index, Collection c) {
        boolean result = this.parent.addAll(index, c);
        this.fireEvent(OBJECT_ADDED_EVENT, null);
        return result;
    }

    public boolean contains(Object o) {
        return this.parent.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.parent.containsAll(c);
    }

    public Object get(int index) {
        return this.parent.get(index);
    }

    public int indexOf(Object o) {
        return this.parent.indexOf(o);
    }

    public Iterator iterator() {
        return new EventIterator(this.parent.iterator());
    }

    public int lastIndexOf(Object o) {
        return this.parent.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.parent.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.parent.listIterator(index);
    }

    public Object remove(int index) {
        Object result = this.parent.remove(index);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    public boolean remove(Object o) {
        boolean result = this.parent.remove(o);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    public boolean removeAll(Collection c) {
        boolean result = this.parent.removeAll(c);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    public boolean retainAll(Collection c) {
        boolean result = this.parent.retainAll(c);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    public Object set(int index, Object element) {
        Object result = this.parent.set(index, element);
        this.fireEvent(OBJECT_REMOVED_EVENT, null);
        return result;
    }

    public List subList(int fromIndex, int toIndex) {
        return this.parent.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.parent.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.parent.toArray(a);
    }
}

