/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.gui.input.InputComponent;
import jams.gui.input.ValueChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FloatInput
extends JPanel
implements InputComponent {
    private JTextField text = new JTextField();
    private ValueChangeListener l;
    private String boundaryString = null;
    private Color oldColor;

    public FloatInput() {
        this.setRange(-1.7976931348623157E308, Double.MAX_VALUE);
        this.setLayout(new BorderLayout());
        this.add((Component)this.text, "West");
    }

    @Override
    public String getValue() {
        return this.text.getText();
    }

    @Override
    public void setValue(String value) {
        this.text.setText(value);
    }

    @Override
    public JComponent getComponent() {
        return this.text;
    }

    @Override
    public void setRange(double lower, double upper) {
        this.boundaryString = "[" + lower + "..." + upper + "]";
        this.setInputVerifier(new FloatIntervalVerifier(lower, upper));
    }

    @Override
    public boolean verify() {
        return this.getInputVerifier().verify(this.text);
    }

    @Override
    public int getErrorCode() {
        return ((FloatIntervalVerifier)this.getInputVerifier()).result;
    }

    @Override
    public void setLength(int length) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener l) {
        this.l = l;
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FloatInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FloatInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FloatInput.this.l.valueChanged();
            }
        });
    }

    @Override
    public void setMarked(boolean marked) {
        if (marked) {
            this.oldColor = this.text.getBackground();
            this.text.setBackground(new Color(255, 0, 0));
        } else {
            this.text.setBackground(this.oldColor);
        }
    }

    @Override
    public void setHelpText(String text) {
        if (this.boundaryString != null) {
            text = this.boundaryString + "<br>" + text;
        }
        text = "<html>" + text + "</html>";
        this.getComponent().setToolTipText(text);
    }

    class FloatIntervalVerifier
    extends InputVerifier {
        double lower;
        double upper;
        int result;

        public FloatIntervalVerifier(double lower, double upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean verify(JComponent input) {
            try {
                double value = Double.parseDouble(((JTextField)input).getText());
                if (value >= this.lower && value <= this.upper) {
                    this.result = 0;
                    return true;
                }
                this.result = -2;
                return false;
            }
            catch (NumberFormatException nfe) {
                this.result = -1;
                return false;
            }
        }
    }
}

