/*
 * Decompiled with CFR 0.152.
 */
package jams.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class JAMSSplash {
    private Image img;
    private int width = 0;
    private int height = 0;
    private JDialog dlg;

    public JAMSSplash() {
        this(0, 0);
    }

    public JAMSSplash(int width, int height) {
    }

    public void show(JFrame frame, int timeInMillis) {
        frame.setVisible(true);
    }

    public void show_(JFrame frame, int timeInMillis) {
        if (timeInMillis == 0) {
            frame.setVisible(true);
            return;
        }
        this.dlg = new JDialog(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.drawImage(JAMSSplash.this.img, 0, 0, this);
            }
        };
        this.dlg.setDefaultCloseOperation(0);
        this.dlg.setTitle("JAMS");
        this.dlg.setUndecorated(true);
        this.dlg.setFocusable(false);
        this.dlg.setAlwaysOnTop(true);
        URL imgURL = ClassLoader.getSystemResource("resources/images/JAMSsplash.png");
        if (this.img == null && imgURL != null) {
            this.img = new ImageIcon(imgURL).getImage();
        }
        if (this.width == 0) {
            this.width = this.img.getWidth(null);
            this.height = this.img.getHeight(null);
        } else {
            this.img = this.img.getScaledInstance(this.width, this.height, 4);
        }
        this.dlg.setSize(this.width, this.height);
        Dimension d2 = new Dimension(this.width, this.height);
        this.dlg.setPreferredSize(d2);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.dlg.setLocation(d.width / 2 - this.width / 2, d.height / 2 - this.height / 2);
        this.dlg.setVisible(true);
        new Timer().schedule((TimerTask)new FrameStarter(this.dlg, frame), timeInMillis);
    }

    class FrameStarter
    extends TimerTask {
        private JDialog splash;
        private JFrame frame;

        public FrameStarter(JDialog splash, JFrame frame) {
            this.splash = splash;
            this.frame = frame;
        }

        @Override
        public void run() {
            this.splash.setVisible(false);
            this.splash.dispose();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FrameStarter.this.frame.setVisible(true);
                }
            });
        }
    }
}

