/*
 * Decompiled with CFR 0.152.
 */
package jams.gui;

import jams.JAMS;
import jams.SystemProperties;
import jams.gui.HelpDlg;
import jams.gui.WorkerDlg;
import jams.gui.input.InputComponent;
import jams.gui.input.InputComponentFactory;
import jams.gui.tools.GUIHelper;
import jams.io.ParameterProcessor;
import jams.meta.HelpComponent;
import jams.model.JAMSFullModelState;
import jams.model.Model;
import jams.runtime.JAMSRuntime;
import jams.runtime.StandardRuntime;
import jams.tools.JAMSTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAMSLauncher
extends JFrame {
    protected static final String BASE_TITLE = JAMS.i18n("JAMS_Launcher");
    private static final int BUTTON_SIZE = 20;
    private Map<InputComponent, Element> inputMap;
    private Map<InputComponent, String> attributeNameMap;
    private Map<InputComponent, JScrollPane> groupMap;
    protected Document modelDocument = null;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private SystemProperties properties;
    private JButton runButton;
    private HelpDlg helpDlg;
    protected String initialModelDocString = "";
    protected File loadPath;
    protected JAMSRuntime runtime;
    private Runnable modelLoading;
    private WorkerDlg loadModelDlg;
    private Font titledBorderFont;
    private Action runModelAction;
    private JToolBar toolBar;
    protected JAMSFullModelState state = null;

    public JAMSLauncher(Frame parent, SystemProperties properties) {
        this.properties = properties;
        this.init();
    }

    public JAMSLauncher(Frame parent, SystemProperties properties, Document modelDocument) {
        this(parent, properties);
        this.loadModelDefinition(modelDocument);
    }

    public JAMSLauncher(Frame parent, SystemProperties properties, Document modelDocument, File loadPath) {
        this(parent, properties, modelDocument);
        this.loadPath = loadPath;
    }

    protected void loadModelDefinition(Document modelDocument) {
        this.modelDocument = modelDocument;
        this.fillAttributes(this.getModelDocument());
        this.fillTabbedPane(modelDocument);
    }

    protected void init() throws HeadlessException, DOMException, NumberFormatException {
        this.modelLoading = new Runnable(){

            @Override
            public void run() {
                if (JAMSLauncher.this.state != null) {
                    Model model = JAMSLauncher.this.state.getModel();
                    JAMSLauncher.this.runtime = model.getRuntime();
                    return;
                }
                if (!JAMSLauncher.this.verifyInputs()) {
                    JAMSLauncher.this.runtime = null;
                    return;
                }
                JAMSLauncher.this.updateProperties();
                Document modelDocCopy = (Document)JAMSLauncher.this.getModelDocument().cloneNode(true);
                String defaultWorkspacePath = null;
                if (Boolean.parseBoolean(JAMSLauncher.this.properties.getProperty("defaultworkspace")) && JAMSLauncher.this.loadPath != null) {
                    defaultWorkspacePath = JAMSLauncher.this.loadPath.getParent();
                }
                JAMSLauncher.this.runtime = new StandardRuntime(JAMSLauncher.this.getProperties());
                JAMSLauncher.this.runtime.addInfoLogObserver(new Observer(){

                    @Override
                    public void update(Observable obs, Object obj) {
                        JAMSLauncher.this.processInfoLog(obj.toString());
                    }
                });
                JAMSLauncher.this.runtime.addErrorLogObserver(new Observer(){

                    @Override
                    public void update(Observable obs, Object obj) {
                        JAMSLauncher.this.processErrorLog(obj.toString());
                    }
                });
                JAMSLauncher.this.runtime.loadModel(modelDocCopy, defaultWorkspacePath);
            }
        };
        this.runModelAction = new AbstractAction(JAMS.i18n("Run_Model")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        JAMSLauncher.this.runModel();
                        Runtime.getRuntime().gc();
                    }
                };
                t.start();
            }
        };
        this.loadModelDlg = new WorkerDlg((Window)this, JAMS.i18n("Model_Setup"));
        this.titledBorderFont = (Font)UIManager.getDefaults().get("TitledBorder.font");
        int fontSize = this.titledBorderFont.getSize();
        if (this.titledBorderFont.getStyle() == 1) {
            fontSize += 2;
        }
        this.titledBorderFont = new Font(this.titledBorderFont.getName(), 1, fontSize);
        this.helpDlg = new HelpDlg(this);
        this.setLocationByPlatform(true);
        this.setLayout(new BorderLayout());
        int width = Integer.parseInt(this.getProperties().getProperty("guiconfigwidth", "600"));
        int height = Integer.parseInt(this.getProperties().getProperty("guiconfigheight", "400"));
        this.setPreferredSize(new Dimension(width, height));
        this.setDefaultCloseOperation(0);
        this.setIconImages(JAMSTools.getJAMSIcons());
        this.setTitle(BASE_TITLE);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                JAMSLauncher.this.exit();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.runButton = new JButton(this.runModelAction);
        this.runButton.setText("");
        this.runButton.setToolTipText(JAMS.i18n("Run_Model"));
        this.runButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelRun.png")));
        this.runButton.setEnabled(false);
        this.tabbedPane.setTabPlacement(2);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.toolBar = new JToolBar();
        this.toolBar.setPreferredSize(new Dimension(0, 40));
        this.toolBar.add(this.runButton);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.pack();
    }

    protected void processInfoLog(String logText) {
    }

    protected void processErrorLog(String logText) {
    }

    protected boolean verifyInputs() {
        return this.verifyInputs(true);
    }

    protected boolean verifyInputs(boolean runModel) {
        for (InputComponent ic : this.getInputMap().keySet()) {
            if (ic.verify()) continue;
            this.tabbedPane.setSelectedComponent(this.getGroupMap().get(ic));
            ic.setMarked(true);
            String info = "";
            if (runModel) {
                info = JAMS.i18n("_Stopping_model_execution.");
            }
            if (ic.getErrorCode() == -2) {
                GUIHelper.showErrorDlg(this, JAMS.i18n("Selected_value_out_of_range!") + info, JAMS.i18n("Range_error"));
            } else {
                GUIHelper.showErrorDlg(this, JAMS.i18n("Invalid_value_found!") + info, JAMS.i18n("Format_error"));
            }
            ic.setMarked(false);
            return false;
        }
        return true;
    }

    protected void fillTabbedPane(Document doc) {
        HashMap<String, HashMap<String, Element>> componentHash = ParameterProcessor.getAttributeHash(this.getModelDocument());
        this.tabbedPane.removeAll();
        this.inputMap = new HashMap<InputComponent, Element>();
        this.attributeNameMap = new HashMap<InputComponent, String>();
        this.groupMap = new HashMap<InputComponent, JScrollPane>();
        Element root = doc.getDocumentElement();
        Element config = (Element)root.getElementsByTagName("launcher").item(0);
        if (config != null) {
            NodeList groups = config.getElementsByTagName("group");
            for (int i = 0; i < groups.getLength(); ++i) {
                JPanel contentPanel = new JPanel();
                GridBagLayout gbl = new GridBagLayout();
                contentPanel.setLayout(gbl);
                JPanel scrollPanel = new JPanel();
                scrollPanel.add(contentPanel);
                JScrollPane scrollPane = new JScrollPane(scrollPanel);
                Element groupElement = (Element)groups.item(i);
                int row = 1;
                NodeList groupChildNodes = groupElement.getChildNodes();
                for (int pindex = 0; pindex < groupChildNodes.getLength(); ++pindex) {
                    Node node = groupChildNodes.item(pindex);
                    if (node.getNodeName().equalsIgnoreCase("property")) {
                        Element propertyElement = (Element)node;
                        this.drawProperty(contentPanel, scrollPane, gbl, propertyElement, componentHash, row);
                        ++row;
                    }
                    if (!node.getNodeName().equalsIgnoreCase("subgroup")) continue;
                    Element subgroupElement = (Element)node;
                    String subgroupName = subgroupElement.getAttribute("name");
                    JPanel subgroupPanel = new JPanel(gbl);
                    subgroupPanel.setBorder(BorderFactory.createTitledBorder(null, subgroupName, 0, 0, this.titledBorderFont));
                    GUIHelper.addGBComponent(contentPanel, gbl, subgroupPanel, 0, ++row, 3, 1, 6, 2, 6, 2, 1.0, 1.0);
                    HelpComponent helpComponent = new HelpComponent(subgroupElement);
                    if (!helpComponent.isEmpty()) {
                        JPanel helpPanel = new JPanel();
                        HelpButton helpButton = this.createHelpButton(helpComponent);
                        helpPanel.add(helpButton);
                        GUIHelper.addGBComponent(contentPanel, gbl, helpPanel, 4, row, 1, 1, 1, 1, 1, 1, 1.0, 1.0);
                    }
                    ++row;
                    NodeList propertyNodes = subgroupElement.getElementsByTagName("property");
                    for (int kindex = 0; kindex < propertyNodes.getLength(); ++kindex) {
                        Element propertyElement = (Element)propertyNodes.item(kindex);
                        this.drawProperty(subgroupPanel, scrollPane, gbl, propertyElement, componentHash, row);
                        ++row;
                    }
                    row += 2;
                    ++row;
                }
                this.tabbedPane.addTab(groupElement.getAttribute("name"), scrollPane);
            }
        }
        this.runButton.setEnabled(true);
    }

    private void drawProperty(JPanel contentPanel, JScrollPane scrollPane, GridBagLayout gbl, Element property, HashMap<String, HashMap<String, Element>> componentHash, int row) {
        Element targetElement;
        String elementAttributeName;
        String componentName = property.getAttribute("component");
        String componentAttributeName = property.getAttribute("attribute");
        HashMap<String, Element> attributeMap = componentHash.get(componentName);
        if (attributeMap == null) {
            property.getParentNode().removeChild(property);
            GUIHelper.showInfoDlg(this, JAMS.i18n("Component_with_name_") + componentName + JAMS.i18n("_does_not_exist!") + JAMS.i18n("!_Removing_visual_editor!"), JAMS.i18n("Info"));
            return;
        }
        if (componentAttributeName.equals("%enable%")) {
            elementAttributeName = "enabled";
            targetElement = attributeMap.get(componentName);
        } else {
            elementAttributeName = "value";
            targetElement = attributeMap.get(componentAttributeName);
        }
        if (targetElement == null) {
            property.getParentNode().removeChild(property);
            GUIHelper.showInfoDlg(this, JAMS.i18n("Attribute_") + componentAttributeName + JAMS.i18n("_does_not_exist_in_component_") + componentName + JAMS.i18n("!_Removing_visual_editor!"), JAMS.i18n("Info"));
            return;
        }
        JLabel nameLabel = new JLabel(property.getAttribute("name"));
        nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        GUIHelper.addGBComponent(contentPanel, gbl, nameLabel, 0, row, 1, 1, 0.0, 0.0);
        try {
            String lenStr;
            String typeName = property.getAttribute("type");
            String prefix = typeName.startsWith("JAMS") ? "jams.data." : "jams.data.Attribute$";
            if (!typeName.startsWith(prefix)) {
                typeName = prefix + typeName;
            }
            InputComponent ic = InputComponentFactory.createInputComponent(Class.forName(typeName));
            StringTokenizer tok = new StringTokenizer(property.getAttribute("range"), ";");
            if (tok.countTokens() == 2) {
                String lower = tok.nextToken();
                String upper = tok.nextToken();
                ic.setRange(Double.parseDouble(lower), Double.parseDouble(upper));
            }
            if ((lenStr = property.getAttribute("length")) != null && lenStr.length() > 0) {
                ic.setLength(Integer.parseInt(lenStr));
            }
            ic.setHelpText(property.getAttribute("description"));
            ic.setValue(targetElement.getAttribute(elementAttributeName));
            this.getInputMap().put(ic, targetElement);
            this.getAttributeNameMap().put(ic, elementAttributeName);
            this.getGroupMap().put(ic, scrollPane);
            GUIHelper.addGBComponent(contentPanel, gbl, (Component)((Object)ic), 1, row, 2, 1, 1.0, 1.0);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        HelpComponent helpComponent = new HelpComponent(property);
        if (!helpComponent.isEmpty()) {
            HelpButton helpButton = this.createHelpButton(helpComponent);
            GUIHelper.addGBComponent(contentPanel, gbl, helpButton, 3, row, 1, 1, 1, 1, 1, 1, 1.0, 1.0);
        }
    }

    protected void fillAttributes(Document doc) {
        Element root = doc.getDocumentElement();
        this.setTitle(BASE_TITLE + ": " + root.getAttribute("name"));
        this.setHelpBaseUrl(root.getAttribute("helpbaseurl"));
    }

    protected void updateProperties() {
        for (InputComponent ic : this.getInputMap().keySet()) {
            Element element = this.getInputMap().get(ic);
            String attributeName = this.getAttributeNameMap().get(ic);
            if (!ic.verify()) continue;
            element.setAttribute(attributeName, ic.getValue());
        }
    }

    protected void exit() {
        this.setVisible(false);
        this.dispose();
    }

    protected void runModel() {
        this.loadModelDlg.setTask(this.modelLoading);
        this.loadModelDlg.execute();
        if (this.runtime == null) {
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    if (JAMSLauncher.this.state == null) {
                        JAMSLauncher.this.runtime.runModel();
                    } else {
                        JAMSLauncher.this.runtime.resume(JAMSLauncher.this.state.getSmallModelState());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    JAMSLauncher.this.runtime.handle(t);
                }
                JAMSLauncher.this.runtime = null;
                Runtime.getRuntime().gc();
            }
        };
        t.start();
    }

    protected SystemProperties getProperties() {
        return this.properties;
    }

    public Map<InputComponent, Element> getInputMap() {
        return this.inputMap;
    }

    public Map<InputComponent, String> getAttributeNameMap() {
        return this.attributeNameMap;
    }

    public Map<InputComponent, JScrollPane> getGroupMap() {
        return this.groupMap;
    }

    protected Document getModelDocument() {
        return this.modelDocument;
    }

    protected String getHelpBaseUrl() {
        return this.helpDlg.getBaseUrl();
    }

    protected void setHelpBaseUrl(String helpBaseUrl) {
        this.helpDlg.setBaseUrl(helpBaseUrl);
    }

    protected HelpButton createHelpButton(HelpComponent helpComponent) {
        HelpButton helpButton = new HelpButton(helpComponent);
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpButton button = (HelpButton)e.getSource();
                button.showHelp();
            }
        });
        helpButton.setEnabled(true);
        return helpButton;
    }

    public void help(HelpComponent helpComponent) {
        this.helpDlg.load(helpComponent);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public String getInitialModelDocString() {
        return this.initialModelDocString;
    }

    protected Action getRunModelAction() {
        return this.runModelAction;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    protected class HelpButton
    extends JButton {
        HelpComponent helpComponent;

        public HelpButton(HelpComponent helpComponent) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setPreferredSize(new Dimension(20, 20));
            this.getInsets().set(0, 0, 0, 0);
            this.setText("?");
            this.setFont(JAMSLauncher.this.titledBorderFont);
            this.setToolTipText(JAMS.i18n("Help"));
            this.helpComponent = helpComponent;
        }

        public void showHelp() {
            JAMSLauncher.this.help(this.helpComponent);
        }
    }
}

