/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.fits;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.fits.FitsDataset;
import ncsa.hdf.object.fits.FitsGroup;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.TableHDU;
import nom.tam.util.ArrayDataInput;

public class FitsFile
extends FileFormat {
    private static final long serialVersionUID = -1965689032980605791L;
    private MutableTreeNode rootNode;
    private Fits fitsFile;
    private static boolean isFileOpen;

    public FitsFile() {
        this("");
    }

    public FitsFile(String pathname) {
        super(pathname);
        this.isReadOnly = true;
        isFileOpen = false;
        this.fid = -1;
        try {
            this.fitsFile = new Fits(this.fullFileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isThisType(FileFormat fileformat) {
        return fileformat instanceof FitsFile;
    }

    @Override
    public boolean isThisType(String filename) {
        boolean is_fits = false;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filename, "r");
        }
        catch (Exception ex) {
            raf = null;
        }
        if (raf == null) {
            try {
                raf.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            return false;
        }
        byte[] header = new byte[80];
        try {
            raf.read(header);
        }
        catch (Exception ex) {
            header = null;
        }
        if (header != null) {
            String front = new String(header, 0, 9);
            if (!front.startsWith("SIMPLE  =")) {
                try {
                    raf.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return false;
            }
            String back = new String(header, 9, 70);
            if ((back = back.trim()).length() < 1 || back.charAt(0) != 'T') {
                try {
                    raf.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return false;
            }
            is_fits = true;
        }
        try {
            raf.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return is_fits;
    }

    @Override
    public FileFormat createInstance(String filename, int access) throws Exception {
        return new FitsFile(filename);
    }

    @Override
    public int open() throws Exception {
        if (!isFileOpen) {
            isFileOpen = true;
            this.rootNode = this.loadTree();
        }
        return 0;
    }

    private MutableTreeNode loadTree() {
        long[] oid = new long[]{0L};
        FitsGroup rootGroup = new FitsGroup(this, "/", null, null, oid);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootGroup){
            private static final long serialVersionUID = 5556789624491863365L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        if (this.fitsFile == null) {
            return root;
        }
        BasicHDU[] hdus = null;
        try {
            hdus = this.fitsFile.read();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (hdus == null) {
            return root;
        }
        int n = hdus.length;
        int nImageHDU = 0;
        int nTableHDU = 0;
        String hduName = null;
        BasicHDU hdu = null;
        for (int i = 0; i < n; ++i) {
            hdu = hdus[i];
            hduName = null;
            if (hdu instanceof ImageHDU) {
                hduName = "ImageHDU #" + nImageHDU++;
            } else if (hdu instanceof RandomGroupsHDU) {
                hduName = "RandomGroupsHDU #" + nImageHDU++;
            } else if (hdu instanceof TableHDU) {
                hduName = hdu instanceof AsciiTableHDU ? "AsciiTableHDU #" + nTableHDU++ : (hdu instanceof BinaryTableHDU ? "BinaryTableHDU #" + nTableHDU++ : "TableHDU #" + nTableHDU++);
            }
            if (hduName == null) continue;
            oid[0] = hdu.hashCode();
            FitsDataset d = new FitsDataset((FileFormat)this, hdu, hduName, oid);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(d);
            root.add(node);
            rootGroup.addToMemberList(d);
        }
        return root;
    }

    @Override
    public void close() throws IOException {
        if (this.fitsFile == null) {
            return;
        }
        ArrayDataInput di = this.fitsFile.getStream();
        if (di instanceof InputStream) {
            ((InputStream)di).close();
        }
    }

    @Override
    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public Fits getFitsFile() {
        return this.fitsFile;
    }

    @Override
    public Group createGroup(String name, Group pgroup) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for Fits.");
    }

    @Override
    public Datatype createDatatype(int tclass, int tsize, int torder, int tsign) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for Fits.");
    }

    @Override
    public Datatype createDatatype(int tclass, int tsize, int torder, int tsign, String name) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for Fits.");
    }

    @Override
    public Dataset createScalarDS(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, Object fillValue, Object data) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Dataset createImage(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, int ncomp, int intelace, Object data) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void delete(HObject obj) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public TreeNode copy(HObject srcObj, Group dstGroup, String dstName) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    private TreeNode copyDataset(Dataset srcDataset, FitsGroup pgroup) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    private TreeNode copyGroup(FitsGroup srcGroup, FitsGroup pgroup) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public void copyAttributes(HObject src, HObject dst) {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public void copyAttributes(int src_id, int dst_id) {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void writeAttribute(HObject obj, Attribute attr, boolean attrExisted) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public String getLibversion() {
        String ver = "Fits Java (version 2.4)";
        return ver;
    }

    @Override
    public HObject get(String path) throws Exception {
        throw new UnsupportedOperationException("get() is not supported");
    }
}

