/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.lang.reflect.Array;
import java.util.Vector;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;

public abstract class Dataset
extends HObject {
    private static final long serialVersionUID = -3360885430038261178L;
    protected Object data = null;
    protected int rank = 0;
    protected long[] dims = null;
    protected long[] maxDims = null;
    protected long[] selectedDims = null;
    protected long[] startDims = null;
    protected final int[] selectedIndex = new int[3];
    protected long[] selectedStride = null;
    protected long[] chunkSize = null;
    protected String compression = "NONE";
    protected Datatype datatype;
    protected String[] dimNames = null;
    protected boolean convertByteToString = true;
    protected boolean isDataLoaded = false;
    protected long nPoints = 1L;
    protected Object originalBuf = null;
    protected Object convertedBuf = null;
    protected boolean enumConverted = false;

    public Dataset(FileFormat theFile, String name, String path) {
        this(theFile, name, path, null);
    }

    @Deprecated
    public Dataset(FileFormat theFile, String name, String path, long[] oid) {
        super(theFile, name, path, oid);
        this.selectedIndex[0] = 0;
        this.selectedIndex[1] = 1;
        this.selectedIndex[2] = 2;
    }

    public void clear() {
        if (this.data != null) {
            if (this.data instanceof Vector) {
                ((Vector)this.data).setSize(0);
            }
            this.data = null;
            this.originalBuf = null;
            this.convertedBuf = null;
        }
        this.isDataLoaded = false;
    }

    public abstract void init();

    public final int getRank() {
        if (this.rank < 0) {
            this.init();
        }
        return this.rank;
    }

    public final long[] getDims() {
        if (this.rank < 0) {
            this.init();
        }
        return this.dims;
    }

    public final long[] getMaxDims() {
        if (this.rank < 0) {
            this.init();
        }
        if (this.maxDims == null) {
            return this.dims;
        }
        return this.maxDims;
    }

    public final long[] getSelectedDims() {
        if (this.rank < 0) {
            this.init();
        }
        return this.selectedDims;
    }

    public final long[] getStartDims() {
        if (this.rank < 0) {
            this.init();
        }
        return this.startDims;
    }

    public final long[] getStride() {
        if (this.rank < 0) {
            this.init();
        }
        if (this.rank <= 0) {
            return null;
        }
        if (this.selectedStride == null) {
            this.selectedStride = new long[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                this.selectedStride[i] = 1L;
            }
        }
        return this.selectedStride;
    }

    public final void setConvertByteToString(boolean b) {
        this.convertByteToString = b;
    }

    public final boolean getConvertByteToString() {
        return this.convertByteToString;
    }

    public abstract Object read() throws Exception, OutOfMemoryError;

    public abstract byte[] readBytes() throws Exception;

    public abstract void write(Object var1) throws Exception;

    public final void write() throws Exception {
        if (this.data != null) {
            this.write(this.data);
        }
    }

    public abstract Dataset copy(Group var1, String var2, long[] var3, Object var4) throws Exception;

    public abstract Datatype getDatatype();

    public final Object getData() throws Exception, OutOfMemoryError {
        if (!this.isDataLoaded) {
            this.originalBuf = this.data = this.read();
            this.isDataLoaded = true;
            this.nPoints = 1L;
            for (int j = 0; j < this.selectedDims.length; ++j) {
                this.nPoints *= this.selectedDims[j];
            }
        }
        return this.data;
    }

    @Deprecated
    public final void setData(Object d) {
        this.data = d;
    }

    public void clearData() {
        this.isDataLoaded = false;
    }

    public final int getHeight() {
        if (this.rank < 0) {
            this.init();
        }
        if (this.selectedDims == null || this.selectedIndex == null) {
            return 0;
        }
        return (int)this.selectedDims[this.selectedIndex[0]];
    }

    public final int getWidth() {
        if (this.rank < 0) {
            this.init();
        }
        if (this.selectedDims == null || this.selectedIndex == null) {
            return 0;
        }
        if (this.selectedDims.length < 2 || this.selectedIndex.length < 2) {
            return 1;
        }
        return (int)this.selectedDims[this.selectedIndex[1]];
    }

    public final int[] getSelectedIndex() {
        if (this.rank < 0) {
            this.init();
        }
        return this.selectedIndex;
    }

    public final String getCompression() {
        if (this.rank < 0) {
            this.init();
        }
        return this.compression;
    }

    public final long[] getChunkSize() {
        if (this.rank < 0) {
            this.init();
        }
        return this.chunkSize;
    }

    @Deprecated
    public static Object convertFromUnsignedC(Object data_in) {
        return Dataset.convertFromUnsignedC(data_in, null);
    }

    public static Object convertFromUnsignedC(Object data_in, Object data_out) {
        Class<?> data_class_out;
        if (data_in == null) {
            return null;
        }
        Class<?> data_class = data_in.getClass();
        if (!data_class.isArray()) {
            return null;
        }
        if (!(data_out == null || (data_class_out = data_out.getClass()).isArray() && Array.getLength(data_in) == Array.getLength(data_out))) {
            data_out = null;
        }
        String cname = data_class.getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        int size = Array.getLength(data_in);
        if (dname == 'B') {
            short[] sdata = null;
            sdata = data_out == null ? new short[size] : (short[])data_out;
            byte[] bdata = (byte[])data_in;
            for (int i = 0; i < size; ++i) {
                sdata[i] = (short)(bdata[i] + 256 & 0xFF);
            }
            data_out = sdata;
        } else if (dname == 'S') {
            int[] idata = null;
            idata = data_out == null ? new int[size] : (int[])data_out;
            short[] sdata = (short[])data_in;
            for (int i = 0; i < size; ++i) {
                idata[i] = sdata[i] + 65536 & 0xFFFF;
            }
            data_out = idata;
        } else if (dname == 'I') {
            long[] ldata = null;
            ldata = data_out == null ? new long[size] : (long[])data_out;
            int[] idata = (int[])data_in;
            for (int i = 0; i < size; ++i) {
                ldata[i] = (long)idata[i] + 0x100000000L & 0xFFFFFFFFL;
            }
            data_out = ldata;
        } else {
            data_out = data_in;
        }
        return data_out;
    }

    @Deprecated
    public static Object convertToUnsignedC(Object data_in) {
        return Dataset.convertToUnsignedC(data_in, null);
    }

    public static Object convertToUnsignedC(Object data_in, Object data_out) {
        Class<?> data_class_out;
        if (data_in == null) {
            return null;
        }
        Class<?> data_class = data_in.getClass();
        if (!data_class.isArray()) {
            return null;
        }
        if (!(data_out == null || (data_class_out = data_out.getClass()).isArray() && Array.getLength(data_in) == Array.getLength(data_out))) {
            data_out = null;
        }
        String cname = data_class.getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        int size = Array.getLength(data_in);
        if (dname == 'S') {
            byte[] bdata = null;
            bdata = data_out == null ? new byte[size] : (byte[])data_out;
            short[] sdata = (short[])data_in;
            for (int i = 0; i < size; ++i) {
                bdata[i] = (byte)sdata[i];
            }
            data_out = bdata;
        } else if (dname == 'I') {
            short[] sdata = null;
            sdata = data_out == null ? new short[size] : (short[])data_out;
            int[] idata = (int[])data_in;
            for (int i = 0; i < size; ++i) {
                sdata[i] = (short)idata[i];
            }
            data_out = sdata;
        } else if (dname == 'J') {
            int[] idata = null;
            idata = data_out == null ? new int[size] : (int[])data_out;
            long[] ldata = (long[])data_in;
            for (int i = 0; i < size; ++i) {
                idata[i] = (int)ldata[i];
            }
            data_out = idata;
        } else {
            data_out = data_in;
        }
        return data_out;
    }

    public static final String[] byteToString(byte[] bytes, int length) {
        if (bytes == null) {
            return null;
        }
        int n = bytes.length / length;
        String[] strArray = new String[n];
        String str = null;
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            int end;
            str = new String(bytes, i * length, length);
            idx = str.indexOf(0);
            if (idx > 0) {
                str = str.substring(0, idx);
            }
            for (end = str.length(); end > 0 && str.charAt(end - 1) <= ' '; --end) {
            }
            strArray[i] = end <= 0 ? "" : str.substring(0, end);
        }
        return strArray;
    }

    public static final byte[] stringToByte(String[] strings, int length) {
        if (strings == null) {
            return null;
        }
        int size = strings.length;
        byte[] bytes = new byte[size * length];
        StringBuffer strBuff = new StringBuffer(length);
        for (int i = 0; i < size; ++i) {
            strBuff.replace(0, length, " ");
            if (strings[i] != null) {
                if (strings[i].length() > length) {
                    strings[i] = strings[i].substring(0, length);
                }
                strBuff.replace(0, length, strings[i]);
            }
            strBuff.setLength(length);
            System.arraycopy(strBuff.toString().getBytes(), 0, bytes, length * i, length);
        }
        return bytes;
    }

    public final String[] getDimNames() {
        if (this.rank < 0) {
            this.init();
        }
        return this.dimNames;
    }

    public boolean isString(int tid) {
        return false;
    }

    public int getSize(int tid) {
        return -1;
    }

    public boolean isEnumConverted() {
        return this.enumConverted;
    }

    public void setEnumConverted(boolean b) {
        if (this.enumConverted != b) {
            this.convertedBuf = null;
            this.originalBuf = null;
            this.clearData();
        }
        this.enumConverted = b;
    }

    public final Class getOriginalClass() {
        return this.originalBuf.getClass();
    }
}

