/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.lang.reflect.Array;
import java.math.BigInteger;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.Metadata;

public class Attribute
implements Metadata {
    private static final long serialVersionUID = 2072473407027648309L;
    private final String name;
    private final Datatype type;
    private int rank;
    private long[] dims;
    private Object value;
    private boolean isUnsigned;
    protected boolean isScalar = false;

    public Attribute(String attrName, Datatype attrType, long[] attrDims) {
        this(attrName, attrType, attrDims, null);
    }

    public Attribute(String attrName, Datatype attrType, long[] attrDims, Object attrValue) {
        this.name = attrName;
        this.type = attrType;
        this.dims = attrDims;
        this.value = null;
        this.rank = 0;
        if (this.dims != null) {
            this.rank = this.dims.length;
        } else {
            this.isScalar = true;
            this.rank = 1;
            this.dims = new long[]{1L};
        }
        if (attrValue != null) {
            this.value = attrValue;
        }
        this.isUnsigned = this.type.getDatatypeSign() == 0;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object theValue) {
        this.value = theValue;
    }

    public String getName() {
        return this.name;
    }

    public int getRank() {
        return this.rank;
    }

    public long[] getDataDims() {
        return this.dims;
    }

    public Datatype getType() {
        return this.type;
    }

    public boolean isScalar() {
        return this.isScalar;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public String toString() {
        return this.name;
    }

    public String toString(String delimiter) {
        StringBuffer sb;
        block23: {
            int n;
            block22: {
                boolean is_unsigned;
                if (this.value == null) {
                    return null;
                }
                Class<?> valClass = this.value.getClass();
                if (!valClass.isArray()) {
                    return this.value.toString();
                }
                sb = new StringBuffer();
                n = Array.getLength(this.value);
                boolean bl = is_unsigned = this.getType().getDatatypeSign() == 0;
                if (!is_unsigned) break block22;
                String cname = valClass.getName();
                char dname = cname.charAt(cname.lastIndexOf("[") + 1);
                switch (dname) {
                    case 'B': {
                        byte[] barray = (byte[])this.value;
                        short sValue = barray[0];
                        if (sValue < 0) {
                            sValue = (short)(sValue + 256);
                        }
                        sb.append(sValue);
                        for (int i = 1; i < n; ++i) {
                            sb.append(delimiter);
                            sValue = barray[i];
                            if (sValue < 0) {
                                sValue = (short)(sValue + 256);
                            }
                            sb.append(sValue);
                        }
                        break block23;
                    }
                    case 'S': {
                        short[] sarray = (short[])this.value;
                        int iValue = sarray[0];
                        if (iValue < 0) {
                            iValue += 65536;
                        }
                        sb.append(iValue);
                        for (int i = 1; i < n; ++i) {
                            sb.append(delimiter);
                            iValue = sarray[i];
                            if (iValue < 0) {
                                iValue += 65536;
                            }
                            sb.append(iValue);
                        }
                        break block23;
                    }
                    case 'I': {
                        int[] iarray = (int[])this.value;
                        long lValue = iarray[0];
                        if (lValue < 0L) {
                            lValue += 0x100000000L;
                        }
                        sb.append(lValue);
                        for (int i = 1; i < n; ++i) {
                            sb.append(delimiter);
                            lValue = iarray[i];
                            if (lValue < 0L) {
                                lValue += 0x100000000L;
                            }
                            sb.append(lValue);
                        }
                        break block23;
                    }
                    case 'J': {
                        String theValue = "";
                        long[] larray = (long[])this.value;
                        Long l = larray[0];
                        if (l < 0L) {
                            l = l << 1 >>> 1;
                            BigInteger big1 = new BigInteger("9223372036854775808");
                            BigInteger big2 = new BigInteger(l.toString());
                            BigInteger big = big1.add(big2);
                            theValue = big.toString();
                        }
                        sb.append(theValue);
                        for (int i = 1; i < n; ++i) {
                            sb.append(delimiter);
                            l = larray[i];
                            if (l < 0L) {
                                l = l << 1 >>> 1;
                                BigInteger big1 = new BigInteger("9223372036854775808");
                                BigInteger big2 = new BigInteger(l.toString());
                                BigInteger big = big1.add(big2);
                                theValue = big.toString();
                            }
                            sb.append(theValue);
                        }
                        break block23;
                    }
                    default: {
                        sb.append(Array.get(this.value, 0));
                        for (int i = 1; i < n; ++i) {
                            sb.append(delimiter);
                            sb.append(Array.get(this.value, i));
                        }
                        break block23;
                    }
                }
            }
            sb.append(Array.get(this.value, 0));
            for (int i = 1; i < n; ++i) {
                sb.append(delimiter);
                sb.append(Array.get(this.value, i));
            }
        }
        return sb.toString();
    }
}

