/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree.fs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import org.geotools.index.quadtree.Node;
import org.geotools.index.quadtree.StoreException;

public class FileSystemNode
extends Node {
    private ScrollingBuffer buffer;
    private ByteOrder order;
    private int subNodeStartByte;
    private int subNodesLength;
    private int numSubNodes;

    FileSystemNode(Envelope bounds, int id, Node parent, ScrollingBuffer buffer, int startByte, int subNodesLength) {
        super(bounds, id, parent);
        this.buffer = buffer;
        this.subNodeStartByte = startByte;
        this.subNodesLength = subNodesLength;
    }

    public Node copy() throws IOException {
        FileSystemNode copy = new FileSystemNode(this.getBounds(), this.id, this.getParent(), this.buffer, this.subNodeStartByte, this.subNodesLength);
        copy.numShapesId = this.numShapesId;
        copy.shapesId = new int[this.numShapesId];
        System.arraycopy(this.shapesId, 0, copy.shapesId, 0, this.numShapesId);
        copy.numSubNodes = this.numSubNodes;
        return copy;
    }

    public int getNumSubNodes() {
        return this.numSubNodes;
    }

    public void setNumSubNodes(int numSubNodes) {
        this.numSubNodes = numSubNodes;
    }

    public int getSubNodeStartByte() {
        return this.subNodeStartByte;
    }

    public int getSubNodesLength() {
        return this.subNodesLength;
    }

    public Node getSubNode(int pos) throws StoreException {
        if (this.subNodes.size() > pos) {
            return super.getSubNode(pos);
        }
        try {
            FileSystemNode subNode = null;
            int offset = this.subNodeStartByte;
            if (pos > 0) {
                subNode = (FileSystemNode)this.getSubNode(pos - 1);
                offset = subNode.getSubNodeStartByte() + subNode.getSubNodesLength();
            }
            this.buffer.goTo(offset);
            int ii = this.subNodes.size();
            for (int i = 0; i < pos + 1 - ii; ++i) {
                subNode = FileSystemNode.readNode(pos, this, this.buffer);
                this.addSubNode(subNode);
            }
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
        return super.getSubNode(pos);
    }

    public static FileSystemNode readNode(int id, Node parent, FileChannel channel, ByteOrder order) throws IOException {
        ScrollingBuffer buffer = new ScrollingBuffer(channel, order);
        return FileSystemNode.readNode(id, parent, buffer);
    }

    static FileSystemNode readNode(int id, Node parent, ScrollingBuffer buf) throws IOException {
        int offset = buf.getInt();
        double x1 = buf.getDouble();
        double y1 = buf.getDouble();
        double x2 = buf.getDouble();
        double y2 = buf.getDouble();
        Envelope env = new Envelope(x1, x2, y1, y2);
        int numShapesId = buf.getInt();
        int[] ids = new int[numShapesId];
        buf.getIntArray(ids);
        int numSubNodes = buf.getInt();
        FileSystemNode node = new FileSystemNode(env, id, parent, buf, (int)buf.getPosition(), offset);
        node.setShapesId(ids);
        node.setNumSubNodes(numSubNodes);
        return node;
    }

    private static class ScrollingBuffer {
        FileChannel channel;
        ByteOrder order;
        ByteBuffer buffer;
        long bufferStart;

        public ScrollingBuffer(FileChannel channel, ByteOrder order) throws IOException {
            this.channel = channel;
            this.order = order;
            this.bufferStart = channel.position();
            this.buffer = ByteBuffer.allocateDirect(8192);
            this.buffer.order(order);
            channel.read(this.buffer);
            this.buffer.flip();
        }

        public int getInt() throws IOException {
            if (this.buffer.remaining() < 4) {
                this.refillBuffer(4);
            }
            return this.buffer.getInt();
        }

        public double getDouble() throws IOException {
            if (this.buffer.remaining() < 8) {
                this.refillBuffer(8);
            }
            return this.buffer.getDouble();
        }

        public void getIntArray(int[] array) throws IOException {
            int size = array.length * 4;
            if (this.buffer.remaining() < size) {
                this.refillBuffer(size);
            }
            IntBuffer intView = this.buffer.asIntBuffer();
            intView.limit(array.length);
            intView.get(array);
            this.buffer.position(this.buffer.position() + size);
        }

        void refillBuffer(int requiredSize) throws IOException {
            long currentPosition = this.bufferStart + (long)this.buffer.position();
            if (this.buffer.capacity() < requiredSize) {
                int size;
                for (size = this.buffer.capacity(); size < requiredSize; size *= 2) {
                }
                this.buffer = ByteBuffer.allocateDirect(size);
                this.buffer.order(this.order);
            }
            this.readBuffer(currentPosition);
        }

        private void readBuffer(long currentPosition) throws IOException {
            this.channel.position(currentPosition);
            this.buffer.clear();
            this.channel.read(this.buffer);
            this.buffer.flip();
            this.bufferStart = currentPosition;
        }

        public void goTo(long newPosition) throws IOException {
            if (newPosition >= this.bufferStart && newPosition <= this.bufferStart + (long)this.buffer.limit()) {
                this.buffer.position((int)(newPosition - this.bufferStart));
            } else {
                this.readBuffer(newPosition);
            }
        }

        public long getPosition() {
            return this.bufferStart + (long)this.buffer.position();
        }
    }
}

