/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed.attribute;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.NoSuchElementException;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.indexed.attribute.IndexRecord;

public class AttributeIndexReader {
    private int record_size;
    private String attribute;
    private int numRecords;
    private char attributeType;
    private StreamLogging streamLogger = new StreamLogging("AttributeIndexReader");
    private FileChannel readChannel;
    private ByteBuffer buffer;
    private int foundPos;

    public AttributeIndexReader(String attribute, FileChannel readChannel) throws IOException {
        this.readChannel = readChannel;
        this.attribute = attribute;
        this.streamLogger.open();
        this.readHeader();
        this.allocateBuffers();
    }

    public int getCount() {
        return this.numRecords;
    }

    public void goTo(int recno) throws IOException {
        long newPos = 9 + recno * this.record_size;
        if (newPos > this.readChannel.size()) {
            throw new NoSuchElementException();
        }
        this.readChannel.position(newPos);
        this.buffer.limit(this.buffer.capacity());
        this.buffer.position(this.buffer.limit());
    }

    public IndexRecord next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.getRecord();
    }

    public boolean hasNext() throws IOException {
        if (this.isEOF()) {
            return false;
        }
        if (this.buffer.position() == this.buffer.limit()) {
            this.buffer.position(0);
            this.buffer.limit((int)Math.min((long)this.buffer.limit(), this.remainingInFile()));
            int read = this.readChannel.read(this.buffer);
            if (read != 0) {
                this.buffer.position(0);
            }
        }
        return this.buffer.remaining() != 0;
    }

    public boolean isEOF() throws IOException {
        return this.buffer.position() == this.buffer.limit() && this.readChannel.position() == this.readChannel.size();
    }

    public Collection findFids(Object reqAttribute) throws IOException {
        IndexRecord rec = this.findRecord(reqAttribute);
        if (rec == null) {
            return new ArrayList(0);
        }
        this.goTo(this.foundPos + 1);
        ArrayList<Long> l = new ArrayList<Long>();
        while (rec.getAttribute().equals(reqAttribute)) {
            l.add(new Long(rec.getFeatureID()));
            if (!this.hasNext()) break;
            rec = this.next();
        }
        return l;
    }

    public IndexRecord findRecord(Object reqAttribute) throws IOException {
        this.foundPos = 0;
        return this.search(reqAttribute, 0, this.numRecords, this.numRecords / 2 - 1);
    }

    private void readHeader() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(9);
        this.readChannel.read(buf);
        buf.position(0);
        this.attributeType = (char)buf.get();
        this.record_size = buf.getInt();
        this.numRecords = buf.getInt();
    }

    private void allocateBuffers() throws IOException {
        this.buffer = ByteBuffer.allocateDirect(this.record_size * 1024);
        this.buffer.position(this.buffer.limit());
    }

    private IndexRecord search(Object desired, int minRec, int maxRec, int predictedRec) throws IOException {
        if (maxRec == minRec) {
            this.goTo(minRec);
            this.buffer.limit(this.record_size);
            IndexRecord currentRecord = this.next();
            this.buffer.limit(this.buffer.capacity());
            return currentRecord != null && currentRecord.getAttribute().equals(desired) ? this.firstInstance(minRec, currentRecord) : null;
        }
        this.goTo(predictedRec);
        this.buffer.limit(this.record_size);
        IndexRecord currentRecord = this.next();
        this.buffer.limit(this.buffer.capacity());
        if (currentRecord == null) {
            return null;
        }
        int comparison = currentRecord.compareTo(desired);
        if (comparison == 0) {
            return this.firstInstance(predictedRec, currentRecord);
        }
        if (maxRec - minRec < 2) {
            int llimit = minRec == predictedRec ? minRec + 1 : minRec;
            int ulimit = minRec == predictedRec ? maxRec : maxRec - 1;
            int newPrediction = minRec == predictedRec ? llimit : ulimit;
            return this.search(desired, llimit, ulimit, newPrediction);
        }
        if (comparison < 1) {
            int newPrediction = (maxRec - predictedRec) / 2 + predictedRec;
            return this.search(desired, ++predictedRec, maxRec, newPrediction);
        }
        int newPrediction = (predictedRec - minRec) / 2 + minRec;
        return this.search(desired, minRec, --predictedRec, newPrediction);
    }

    private IndexRecord getRecord() throws IOException {
        Object obj = null;
        switch (this.attributeType) {
            case 'N': {
                if (this.record_size == 12) {
                    obj = new Integer(this.buffer.getInt());
                    break;
                }
                obj = new Long(this.buffer.getLong());
                break;
            }
            case 'F': {
                obj = new Double(this.buffer.getDouble());
                break;
            }
            case 'L': {
                obj = this.buffer.get() == 1 ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 'D': {
                obj = new Date(this.buffer.getLong());
                break;
            }
            default: {
                byte[] b = new byte[this.record_size - 8];
                this.buffer.get(b);
                obj = new String(b, "ISO-8859-1").trim();
            }
        }
        long id = this.buffer.getLong();
        return new IndexRecord((Comparable)obj, id);
    }

    private IndexRecord firstInstance(int position, IndexRecord rec) throws IOException {
        if (rec == null) {
            return null;
        }
        IndexRecord current = rec;
        IndexRecord prev = rec;
        while (rec.compareTo(current) == 0 && position > 0) {
            this.goTo(--position);
            this.buffer.limit(this.record_size);
            prev = current;
            current = this.next();
            this.buffer.limit(this.buffer.capacity());
        }
        boolean b = rec.compareTo(current) == 0;
        this.foundPos = b ? position : position + 1;
        return b ? current : prev;
    }

    private long remainingInFile() throws IOException {
        return this.readChannel.size() - this.readChannel.position();
    }
}

