/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.FIDReader;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StreamLogging;
import org.geotools.data.shapefile.indexed.RecordNumberTracker;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.resources.NIOUtilities;
import org.geotools.util.logging.Logging;

public class IndexedFidReader
implements FIDReader,
FileReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.shapefile");
    private ReadableByteChannel readChannel;
    private ByteBuffer buffer;
    private long count;
    private String typeName;
    private boolean done;
    private int removes;
    private int currentShxIndex = -1;
    private RecordNumberTracker reader;
    private long currentId;
    private long bufferStart = Long.MIN_VALUE;
    StreamLogging streamLogger = new StreamLogging("IndexedFidReader");

    public IndexedFidReader(ShpFiles shpFiles) throws IOException {
        this.init(shpFiles, shpFiles.getReadChannel(ShpFileType.FIX, this));
    }

    public IndexedFidReader(ShpFiles shpFiles, RecordNumberTracker reader) throws IOException {
        this(shpFiles);
        this.reader = reader;
    }

    public IndexedFidReader(ShpFiles shpFiles, ReadableByteChannel in) throws IOException {
        this.init(shpFiles, in);
    }

    private void init(ShpFiles shpFiles, ReadableByteChannel in) throws IOException {
        this.typeName = shpFiles.getTypeName() + ".";
        this.readChannel = in;
        this.streamLogger.open();
        this.getHeader(shpFiles);
        this.buffer = ByteBuffer.allocateDirect(12);
        this.buffer.position(this.buffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHeader(ShpFiles shpFiles) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(13);
        ShapefileReader.fill(buffer, this.readChannel);
        if (buffer.position() == 0) {
            this.done = true;
            this.count = 0L;
            return;
        }
        buffer.position(0);
        byte version = buffer.get();
        if (version != 1) {
            throw new IOException("File is not of a compatible version for this reader or file is corrupt.");
        }
        this.count = buffer.getLong();
        this.removes = buffer.getInt();
        if ((long)this.removes > this.getCount() / 2L) {
            URL url = shpFiles.acquireRead(ShpFileType.FIX, this);
            try {
                DataUtilities.urlToFile(url).deleteOnExit();
            }
            finally {
                shpFiles.unlockRead(url, (FileReader)this);
            }
        }
    }

    public long getCount() {
        return this.count;
    }

    public int getRemoves() {
        return this.removes;
    }

    public long findFid(String fid) throws IOException {
        try {
            long desired = Long.parseLong(fid.substring(fid.lastIndexOf(".") + 1));
            if (desired < 0L) {
                return -1L;
            }
            if (desired < this.count) {
                return this.search(desired, -1L, this.count, desired - 1L);
            }
            return this.search(desired, -1L, this.count, this.count - 1L);
        }
        catch (NumberFormatException e) {
            LOGGER.warning("Fid is not recognized as a fid for this shapefile: " + this.typeName);
            return -1L;
        }
    }

    long search(long desired, long minRec, long maxRec, long predictedRec) throws IOException {
        if (minRec == maxRec) {
            return -1L;
        }
        this.goTo(predictedRec);
        this.buffer.limit(12);
        this.next();
        this.buffer.limit(this.buffer.capacity());
        if (this.currentId == desired) {
            return this.currentShxIndex;
        }
        if (maxRec - minRec < 10L) {
            return this.search(desired, minRec + 1L, maxRec, minRec + 1L);
        }
        long newOffset = desired - this.currentId;
        long newPrediction = predictedRec + newOffset;
        if (newPrediction <= minRec) {
            newPrediction = minRec + (predictedRec - minRec) / 2L;
        }
        if (newPrediction >= maxRec) {
            newPrediction = predictedRec + (maxRec - predictedRec) / 2L;
        }
        if (newPrediction == predictedRec) {
            return -1L;
        }
        if (newPrediction < predictedRec) {
            return this.search(desired, minRec, predictedRec, newPrediction);
        }
        return this.search(desired, predictedRec, maxRec, newPrediction);
    }

    public void goTo(long recno) throws IOException {
        assert (recno < this.count);
        if (this.readChannel instanceof FileChannel) {
            long newPosition = 13L + recno * 12L;
            if (newPosition >= this.bufferStart + (long)this.buffer.limit() || newPosition < this.bufferStart) {
                FileChannel fc = (FileChannel)this.readChannel;
                fc.position(newPosition);
                this.buffer.limit(this.buffer.capacity());
                this.buffer.position(this.buffer.limit());
            } else {
                this.buffer.position((int)(newPosition - this.bufferStart));
            }
        } else {
            throw new IOException("Read Channel is not a File Channel so this is not possible.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.buffer != null && this.buffer instanceof MappedByteBuffer) {
                NIOUtilities.clean((ByteBuffer)this.buffer);
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        finally {
            this.readChannel.close();
            this.streamLogger.close();
        }
    }

    public boolean hasNext() throws IOException {
        if (this.done) {
            return false;
        }
        if (this.buffer.position() == this.buffer.limit()) {
            this.buffer.position(0);
            FileChannel fc = (FileChannel)this.readChannel;
            this.bufferStart = fc.position();
            int read = ShapefileReader.fill(this.buffer, this.readChannel);
            if (read != 0) {
                this.buffer.position(0);
            }
        }
        return this.buffer.remaining() != 0;
    }

    public String next() throws IOException {
        if (this.reader != null) {
            this.goTo(this.reader.getRecordNumber() - 1);
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("Feature could not be read; a the index may be invalid");
        }
        this.currentId = this.buffer.getLong();
        this.currentShxIndex = this.buffer.getInt();
        return this.typeName + this.currentId;
    }

    public int currentSHXIndex() {
        if (this.currentShxIndex == -1) {
            throw new NoSuchElementException("Next must be called before there exists a current element.");
        }
        return this.currentShxIndex;
    }

    public long getCurrentFIDIndex() {
        return this.currentId;
    }

    public String id() {
        return this.getClass().getName();
    }
}

