/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.util.Locale;
import javax.swing.MenuElement;

public final class SwingXUtilities {
    private SwingXUtilities() {
    }

    private static Component[] getChildren(Component c) {
        Component[] children = null;
        if (c instanceof MenuElement) {
            MenuElement[] elements = ((MenuElement)((Object)c)).getSubElements();
            children = new Component[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                children[i] = elements[i].getComponent();
            }
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        return children;
    }

    public void setComponentTreeEnabled(Component c, boolean enabled) {
        c.setEnabled(enabled);
        Component[] children = SwingXUtilities.getChildren(c);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.setComponentTreeEnabled(children[i], enabled);
            }
        }
    }

    public void setComponentTreeLocale(Component c, Locale locale) {
        c.setLocale(locale);
        Component[] children = SwingXUtilities.getChildren(c);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.setComponentTreeLocale(children[i], locale);
            }
        }
    }
}

