/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import ucar.unidata.io.RandomAccessFile;

public final class BufrNumbers {
    private static final long[] missing_value = new long[2049];
    private static final int UNDEFINED = -9999;

    public static boolean isMissing(long raw, int bitWidth) {
        return raw == missing_value[bitWidth];
    }

    static long missingValue(int bitWidth) {
        return missing_value[bitWidth];
    }

    static int int2(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        return BufrNumbers.int2(a, b);
    }

    private static int int2(int a, int b) {
        if (a == 255 && b == 255) {
            return -9999;
        }
        return (1 - ((a & 0x80) >> 6)) * ((a & 0x7F) << 8 | b);
    }

    static int int3(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        int c = raf.read();
        return BufrNumbers.int3(a, b, c);
    }

    private static int int3(int a, int b, int c) {
        return (1 - ((a & 0x80) >> 6)) * ((a & 0x7F) << 16 | b << 8 | c);
    }

    public static int int4(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        int c = raf.read();
        int d = raf.read();
        return BufrNumbers.int4(a, b, c, d);
    }

    private static int int4(int a, int b, int c, int d) {
        if (a == 255 && b == 255 && c == 255 && d == 255) {
            return -9999;
        }
        return (1 - ((a & 0x80) >> 6)) * ((a & 0x7F) << 24 | b << 16 | c << 8 | d);
    }

    static int uint2(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        return BufrNumbers.uint2(a, b);
    }

    private static int uint2(int a, int b) {
        return a << 8 | b;
    }

    public static int uint3(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        int c = raf.read();
        return BufrNumbers.uint3(a, b, c);
    }

    private static int uint3(int a, int b, int c) {
        return a << 16 | b << 8 | c;
    }

    public static float float4(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        int c = raf.read();
        int d = raf.read();
        return BufrNumbers.float4(a, b, c, d);
    }

    private static float float4(int a, int b, int c, int d) {
        int mant = b << 16 | c << 8 | d;
        if (mant == 0) {
            return 0.0f;
        }
        int sgn = -(((a & 0x80) >> 6) - 1);
        int exp = (a & 0x7F) - 64;
        return (float)((double)sgn * Math.pow(16.0, exp - 6) * (double)mant);
    }

    public static long int8(RandomAccessFile raf) throws IOException {
        int a = raf.read();
        int b = raf.read();
        int c = raf.read();
        int d = raf.read();
        int e = raf.read();
        int f = raf.read();
        int g2 = raf.read();
        int h2 = raf.read();
        return (long)(1 - ((a & 0x80) >> 6)) * ((long)(a & 0x7F) << 56 | (long)b << 48 | (long)c << 40 | (long)d << 32 | (long)(e << 24) | (long)(f << 16) | (long)(g2 << 8) | (long)h2);
    }

    static {
        long accum = 0L;
        for (int i = 0; i < 65; ++i) {
            BufrNumbers.missing_value[i] = accum;
            accum = accum * 2L + 1L;
        }
    }
}

