/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib2.table.Grib2Tables;

public class WmoTemplateTables {
    private static final Logger logger = LoggerFactory.getLogger(WmoTemplateTables.class);
    private static final Map<String, String> convertMap = new HashMap<String, String>();
    public static final Version standard;
    private static WmoTemplateTables instance;
    private ImmutableList<TemplateTable> templateTables;
    private ImmutableMap<String, TemplateTable> templateMap;

    public static WmoTemplateTables getInstance() {
        if (instance == null) {
            instance = new WmoTemplateTables();
            try {
                instance.readXml(standard);
            }
            catch (IOException e) {
                logger.error("Cant read WMO Grib2 tables");
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    private void readXml(Version version) throws IOException {
        try (InputStream ios = WmoTemplateTables.class.getResourceAsStream(version.getResourceName());){
            Document doc;
            if (ios == null) {
                throw new IOException("cant open TemplateTable %s " + version.getResourceName());
            }
            try {
                SAXBuilder builder = new SAXBuilder();
                builder.setExpandEntities(false);
                doc = builder.build(ios);
            }
            catch (JDOMException e) {
                throw new IOException(e.getMessage());
            }
            HashMap<String, TemplateTable> map = new HashMap<String, TemplateTable>();
            String[] elems = version.getElemNames();
            assert (elems != null);
            assert (elems.length > 3);
            Element root = doc.getRootElement();
            List<Element> featList = root.getChildren(elems[0]);
            for (Element element : featList) {
                String desc = element.getChildTextNormalize(elems[1]);
                String octet = element.getChildTextNormalize("OctetNo");
                String content = element.getChildTextNormalize(elems[3]);
                String status = element.getChildTextNormalize("Status");
                String note = element.getChildTextNormalize(elems[2]);
                TemplateTable template = map.computeIfAbsent(desc, name -> new TemplateTable((String)name));
                template.add(octet, content, status, note);
            }
            ios.close();
            ArrayList tlist = new ArrayList(map.values());
            for (TemplateTable t2 : tlist) {
                if (t2.m1 == 3) {
                    t2.add(1, 4, "GDS length");
                    t2.add(5, 1, "Section");
                    t2.add(6, 1, "Source of Grid Definition (see code table 3.0)");
                    t2.add(7, 4, "Number of data points");
                    t2.add(11, 1, "Number of octects for optional list of numbers");
                    t2.add(12, 1, "Interpretation of list of numbers");
                    t2.add(13, 2, "Grid Definition Template Number");
                } else if (t2.m1 == 4) {
                    t2.add(1, 4, "PDS length");
                    t2.add(5, 1, "Section");
                    t2.add(6, 2, "Number of coordinates values after Template");
                    t2.add(8, 2, "Product Definition Template Number");
                }
                Collections.sort(t2.flds);
            }
            this.templateTables = map.values().stream().sorted().collect(ImmutableList.toImmutableList());
            ImmutableMap.Builder builder = ImmutableMap.builder();
            map.values().forEach(t -> builder.put(t.getId(), t));
            this.templateMap = builder.build();
        }
    }

    public ImmutableList<TemplateTable> getTemplateTables() {
        return this.templateTables;
    }

    @Nullable
    public TemplateTable getTemplateTable(String key) {
        return this.templateMap.get(key);
    }

    static {
        convertMap.put("Source of Grid Definition (see code table 3.0)", "3.0");
        convertMap.put("Shape of the Earth", "3.2");
        convertMap.put("Interpretation of list of numbers", "3.11");
        convertMap.put("Type of generating process", "4.3");
        convertMap.put("Indicator of unit of time range", "4.4");
        convertMap.put("Indicator of unit of time for time range over which statistical processing is done", "4.4");
        convertMap.put("Indicator of unit of time for the increment between the successive fields used", "4.4");
        convertMap.put("Type of first fixed surface", "4.5");
        convertMap.put("Type of second fixed surface", "4.5");
        convertMap.put("Type of ensemble forecast", "4.6");
        convertMap.put("Derived forecast", "4.7");
        convertMap.put("Probability type", "4.9");
        convertMap.put("Statistical process used to calculate the processed field from the field at each time increment during the time range", "4.10");
        convertMap.put("Type of time increment between successive fields used in the statistical processing", "4.11");
        convertMap.put("Analysis or forecast generating process identifier (defined by originating centre)", "ProcessId");
        convertMap.put("Background generating process identifier (defined by originating centre)", "ProcessId");
        convertMap.put("Forecast generating process identifier (defined by originating centre)", "ProcessId");
        standard = Version.GRIB2_22_0_0;
    }

    public static class Field
    implements Comparable<Field> {
        private final String octet;
        private final String content;
        private String status;
        private String note;
        private int start;
        private int nbytes;

        private Field(String octet, String content, String status, String note) {
            this.octet = octet;
            this.content = content;
            this.status = status;
            this.note = note;
            try {
                int pos = octet.indexOf(45);
                if (pos > 0) {
                    this.start = Integer.parseInt(octet.substring(0, pos));
                    String stops = octet.substring(pos + 1);
                    try {
                        int stop = Integer.parseInt(stops);
                        this.nbytes = stop - this.start + 1;
                    }
                    catch (Exception e) {
                        logger.debug("Error parsing wmo template line=" + content, e);
                    }
                } else {
                    this.start = Integer.parseInt(octet);
                    this.nbytes = 1;
                }
            }
            catch (Exception e) {
                this.start = -1;
                this.nbytes = 0;
            }
        }

        private Field(int start, int nbytes, String content) {
            this.start = start;
            this.nbytes = nbytes;
            this.content = content;
            this.octet = start + "-" + (start + nbytes - 1);
        }

        public String getOctet() {
            return this.octet;
        }

        public String getContent() {
            return this.content;
        }

        public String getStatus() {
            return this.status;
        }

        public String getNote() {
            return this.note;
        }

        public int getStart() {
            return this.start;
        }

        public int getNbytes() {
            return this.nbytes;
        }

        @Override
        public int compareTo(@Nonnull Field o) {
            return this.start - o.start;
        }

        private int value(byte[] pds) {
            switch (this.nbytes) {
                case 1: {
                    return this.get(pds, this.start);
                }
                case 2: {
                    return GribNumbers.int2(this.get(pds, this.start), this.get(pds, this.start + 1));
                }
                case 4: {
                    return GribNumbers.int4(this.get(pds, this.start), this.get(pds, this.start + 1), this.get(pds, this.start + 2), this.get(pds, this.start + 3));
                }
            }
            return -9999;
        }

        private int get(byte[] pds, int offset) {
            return pds[offset - 1] & 0xFF;
        }
    }

    public class TemplateTable
    implements Comparable<TemplateTable> {
        private String name;
        private String desc;
        private int m1;
        private int m2;
        private final List<Field> flds = new ArrayList<Field>();

        private TemplateTable(String desc) {
            this.desc = desc;
            String[] slist = desc.split(" ");
            for (int i = 0; i < slist.length; ++i) {
                if (!slist[i].equalsIgnoreCase("template")) continue;
                this.name = slist[i + 1];
                String[] slist2 = this.name.split("\\.");
                if (slist2.length == 2) {
                    this.m1 = Integer.parseInt(slist2[0]);
                    this.m2 = Integer.parseInt(slist2[1]);
                    break;
                }
                logger.warn("TemplateTable bad= {}", (Object)this.name);
                break;
            }
        }

        private void add(String octet, String content, String status, String note) {
            this.flds.add(new Field(octet, content, status, note));
        }

        private void add(int start, int nbytes, String content) {
            this.flds.add(new Field(start, nbytes, content));
        }

        public String getId() {
            return this.m1 + "." + this.m2;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getM1() {
            return this.m1;
        }

        public int getM2() {
            return this.m2;
        }

        public ImmutableList<Field> getFlds() {
            return ImmutableList.copyOf(this.flds);
        }

        @Override
        public int compareTo(@Nonnull TemplateTable o) {
            if (this.m1 == o.m1) {
                return this.m2 - o.m2;
            }
            return this.m1 - o.m1;
        }

        public void showInfo(Grib2Tables tables, byte[] raw, Formatter f) {
            f.format("%n(%s) %s %n", this.name, this.desc);
            for (Field fld : this.flds) {
                if (fld.start < 0) continue;
                String info = (String)convertMap.get(fld.content);
                if (info == null) {
                    f.format("%3d: %90s == %d %n", fld.start, fld.content, fld.value(raw));
                    continue;
                }
                String desc = this.convert(tables, info, fld.value(raw));
                if (desc == null) {
                    f.format("%3d: %90s == %d (%s) %n", fld.start, fld.content, fld.value(raw), this.convert(tables, info, fld.value(raw)));
                    continue;
                }
                f.format("%3d: %90s == %d (table %s: %s) %n", fld.start, fld.content, fld.value(raw), info, desc);
            }
        }

        private String convert(Grib2Tables tables, String table, int value) {
            String result = tables.getCodeTableValue(table, value);
            return result != null ? result : "Table " + table + " code " + value + " not found";
        }
    }

    public static enum Version {
        GRIB2_22_0_0;


        String getResourceName() {
            return "/resources/grib2/wmo/" + this.name() + "_Template_en.xml";
        }

        @Nullable
        String[] getElemNames() {
            if (this == GRIB2_22_0_0) {
                return new String[]{"GRIB2_22_0_0_Template_en", "Title_en", "Note_en", "Contents_en"};
            }
            return null;
        }
    }
}

