/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.tree;

import com.jogamp.opengl.util.awt.TextRenderer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FrameFactory;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.util.HotSpot;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLRenderToTextureSupport;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.tree.Animation;
import gov.nasa.worldwind.util.tree.BasicFrameAttributes;
import gov.nasa.worldwind.util.tree.DragControl;
import gov.nasa.worldwind.util.tree.FrameAttributes;
import gov.nasa.worldwind.util.tree.FrameResizeControl;
import gov.nasa.worldwind.util.tree.ScrollBar;
import gov.nasa.worldwind.util.tree.Scrollable;
import gov.nasa.worldwind.util.tree.TreeHotSpot;
import gov.nasa.worldwind.util.tree.TreeUtil;
import gov.nasa.worldwind.util.tree.WindowShadeAnimation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class ScrollFrame
extends DragControl
implements PreRenderable,
Renderable {
    protected static final int DEFAULT_TEXTURE_TILE_DIMENSION = 512;
    protected static final int DEFAULT_TITLE_BAR_HEIGHT = 25;
    protected static final int DEFAULT_BUTTON_SIZE = 18;
    protected static final int DEFAULT_SCROLL_BAR_SIZE = 15;
    protected static final int DEFAULT_FRAME_BORDER_WIDTH = 3;
    protected static final int DEFAULT_FRAME_BORDER_PICK_WIDTH = 10;
    protected static final int DEFAULT_LINE_WIDTH = 1;
    protected static final int DEFAULT_ANIMATION_DELAY = 5;
    protected static final Size DEFAULT_MAXIMIZED_SIZE = Size.fromPixels(265, 300);
    protected FrameAttributes normalAttributes;
    protected FrameAttributes highlightAttributes;
    protected FrameAttributes activeAttributes = new BasicFrameAttributes();
    protected String frameTitle;
    protected Scrollable contents;
    protected Offset screenLocation;
    protected boolean drawTitleBar = true;
    protected boolean enableResize = true;
    protected boolean enableMove = true;
    protected int titleBarHeight = 25;
    protected int buttonSize = 18;
    protected int scrollBarSize = 15;
    protected int frameBorder = 3;
    protected int frameLineWidth = 1;
    protected OGLStackHandler BEogsh = new OGLStackHandler();
    protected PickSupport pickSupport = new PickSupport();
    protected ScrollBar verticalScrollBar;
    protected ScrollBar horizontalScrollBar;
    protected boolean minimized = false;
    protected Size maximizedSize = DEFAULT_MAXIMIZED_SIZE;
    protected Size minimizedSize;
    protected Size activeSize;
    protected Size maxSize;
    protected Object iconImageSource;
    protected BasicWWTexture texture;
    protected Animation minimizeAnimation;
    protected Animation animation;
    protected int animationDelay = 5;
    protected HotSpot minimizeButton;
    protected FrameResizeControl frameResizeControl;
    protected int borderPickWidth = 10;
    protected DoubleBuffer vertexBuffer;
    protected OGLRenderToTextureSupport rttSupport = new OGLRenderToTextureSupport();
    protected List<ContentTile> tiles = new ArrayList<ContentTile>();
    protected boolean renderToTexture;
    protected final Object textureCacheKey = new Object();
    protected Map<ContentTile, TextureTile> textureTileMap = new HashMap<ContentTile, TextureTile>();
    protected List<TextureTile> textureTiles = new ArrayList<TextureTile>();
    protected int textureDimension;
    protected int textureTileDimension = 512;
    protected String shortTitle;
    protected int frameTitleWidth;
    protected Font shortFrameTitleFont;
    protected Rectangle2D shortTitleBounds;
    protected long frameNumber = -1L;
    protected boolean mustRecomputeFrameGeometry = true;
    protected Point2D awtScreenPoint;
    protected Rectangle frameBounds;
    protected Rectangle innerBounds;
    protected Rectangle contentBounds;
    protected Rectangle scrollContentBounds;
    protected Rectangle pickBounds;
    protected Dimension contentSize;
    protected Dimension frameSize;
    protected boolean highlighted;
    protected boolean showVerticalScrollbar;
    protected boolean showHorizontalScrollbar;
    protected static final FrameAttributes defaultAttributes = new BasicFrameAttributes();

    public ScrollFrame() {
        super(null);
        this.initializeUIControls();
    }

    public ScrollFrame(int n, int n2) {
        this(new Offset(Double.valueOf(n), Double.valueOf(n2), "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.InsetPixels"));
    }

    public ScrollFrame(Offset offset) {
        super(null);
        this.setScreenLocation(offset);
        this.initializeUIControls();
    }

    public Scrollable getContents() {
        return this.contents;
    }

    public void setContents(Scrollable scrollable) {
        this.contents = scrollable;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean bl) {
        if (bl != this.isMinimized()) {
            this.minimized = bl;
            if (this.minimizeAnimation != null) {
                this.animation = this.minimizeAnimation;
                this.animation.reset();
            }
        }
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean bl) {
        if (this.highlighted != bl) {
            this.highlighted = bl;
            this.contents.setHighlighted(bl);
        }
    }

    public String getFrameTitle() {
        return this.frameTitle;
    }

    public void setFrameTitle(String string) {
        this.frameTitle = string;
        this.shortTitle = null;
    }

    public Size getSize() {
        return this.maximizedSize;
    }

    public void setSize(Size size) {
        if (size == null) {
            String string = Logging.getMessage("nullValue.SizeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.maximizedSize = size;
        this.mustRecomputeFrameGeometry = true;
        if (!this.isAnimating()) {
            this.forceTileUpdate();
        }
    }

    public Size getMinimizedSize() {
        return this.minimizedSize;
    }

    public void setMinimizedSize(Size size) {
        this.minimizedSize = size;
        this.mustRecomputeFrameGeometry = true;
        if (!this.isAnimating()) {
            this.forceTileUpdate();
        }
    }

    public Size getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Size size) {
        this.maxSize = size;
        this.mustRecomputeFrameGeometry = true;
        if (!this.isAnimating()) {
            this.forceTileUpdate();
        }
    }

    public Dimension getCurrentSize() {
        return this.frameSize;
    }

    public int getTitleBarHeight() {
        return this.titleBarHeight;
    }

    public void setTitleBarHeight(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.InvalidHeight", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.titleBarHeight = n;
    }

    public boolean isDrawTitleBar() {
        return this.drawTitleBar;
    }

    public void setDrawTitleBar(boolean bl) {
        this.drawTitleBar = bl;
    }

    public boolean isEnableResizeControl() {
        return this.enableResize;
    }

    public void setEnableResizeControl(boolean bl) {
        this.enableResize = bl;
    }

    public boolean isEnableMove() {
        return this.enableMove;
    }

    public void setEnableMove(boolean bl) {
        this.enableMove = bl;
    }

    public Animation getMinimizeAnimation() {
        return this.minimizeAnimation;
    }

    public void setMinimizeAnimation(Animation animation) {
        this.minimizeAnimation = animation;
    }

    public Object getIconImageSource() {
        return this.iconImageSource;
    }

    public void setIconImageSource(Object object) {
        this.iconImageSource = object;
    }

    public Rectangle getBounds(DrawContext drawContext) {
        this.updateBounds(drawContext);
        return new Rectangle((int)this.awtScreenPoint.getX(), (int)this.awtScreenPoint.getY(), this.frameSize.width, this.frameSize.height);
    }

    public Offset getScreenLocation() {
        return this.screenLocation;
    }

    public void setScreenLocation(Offset offset) {
        this.screenLocation = offset;
    }

    protected Point2D getScreenPoint() {
        return this.awtScreenPoint;
    }

    public FrameAttributes getAttributes() {
        return this.normalAttributes;
    }

    public void setAttributes(FrameAttributes frameAttributes) {
        if (frameAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.normalAttributes = frameAttributes;
    }

    public FrameAttributes getHighlightAttributes() {
        return this.highlightAttributes;
    }

    public void setHighlightAttributes(FrameAttributes frameAttributes) {
        if (frameAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.highlightAttributes = frameAttributes;
    }

    protected void assembleTiles(int n, int n2) {
        this.tiles.clear();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                ContentTile contentTile = new ContentTile(i, j);
                this.tiles.add(contentTile);
            }
        }
    }

    protected boolean mustUpdateTiles(DrawContext drawContext) {
        if (this.isMinimized()) {
            return false;
        }
        if (drawContext.getTextureCache().getTexture(this.textureCacheKey) == null) {
            return true;
        }
        if (this.tiles.isEmpty()) {
            return true;
        }
        long l = this.contents.getUpdateTime();
        for (ContentTile contentTile : this.tiles) {
            if (!this.mustUpdateTile(contentTile, l)) continue;
            return true;
        }
        return false;
    }

    protected boolean mustUpdateTile(ContentTile contentTile, long l) {
        Rectangle rectangle = this.getContentTileBounds(contentTile.row, contentTile.column);
        if (this.contentBounds.intersects(rectangle)) {
            if (contentTile.updateTime != l) {
                return true;
            }
            TextureTile textureTile = this.getTextureTile(contentTile);
            if (textureTile == null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTiles(DrawContext drawContext) {
        int n;
        int n2;
        this.rttSupport.setEnableFramebufferObject(true);
        Texture texture = drawContext.getTextureCache().getTexture(this.textureCacheKey);
        int n3 = this.computeTileTextureDimension(this.contentBounds.getSize(), this.contentSize);
        int n4 = drawContext.getGLRuntimeCapabilities().getMaxTextureSize();
        boolean bl = this.renderToTexture = n3 <= n4;
        if (!this.renderToTexture) {
            return;
        }
        if (texture == null || this.textureDimension != n3) {
            texture = this.createTileTexture(drawContext, n3, n3);
            drawContext.getTextureCache().put(this.textureCacheKey, texture);
            this.textureDimension = n3;
            n2 = n3 / this.textureTileDimension;
            this.textureTiles.clear();
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n2; ++i) {
                    this.textureTiles.add(new TextureTile(n, i));
                }
            }
            this.textureTileMap.clear();
        }
        if (texture == null) {
            Logging.logger().warning(Logging.getMessage("nullValue.TextureIsNull"));
            return;
        }
        n2 = (int)Math.ceil((double)this.contentSize.height / (double)this.textureTileDimension);
        n = (int)Math.ceil((double)this.contentSize.width / (double)this.textureTileDimension);
        if (this.tiles.size() != n2 * n) {
            this.assembleTiles(n2, n);
        }
        long l = this.contents.getUpdateTime();
        for (ContentTile contentTile : this.tiles) {
            if (!this.mustUpdateTile(contentTile, l)) continue;
            TextureTile textureTile = this.getTextureTile(contentTile);
            if (textureTile == null) {
                textureTile = this.allocateTextureTile(contentTile);
            }
            int n5 = textureTile.column * this.textureTileDimension;
            int n6 = textureTile.row * this.textureTileDimension;
            Rectangle rectangle = new Rectangle(n5, n6, this.textureTileDimension, this.textureTileDimension);
            this.rttSupport.beginRendering(drawContext, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            try {
                this.updateTile(drawContext, contentTile, rectangle);
                contentTile.updateTime = l;
                textureTile.lastUsed = drawContext.getFrameTimeStamp();
            }
            finally {
                this.rttSupport.endRendering(drawContext);
            }
        }
    }

    protected TextureTile getTextureTile(ContentTile contentTile) {
        TextureTile textureTile = this.textureTileMap.get(contentTile);
        if (textureTile != null && textureTile.currentTile.equals(contentTile)) {
            return textureTile;
        }
        return null;
    }

    protected TextureTile allocateTextureTile(ContentTile contentTile) {
        TextureTile[] textureTileArray = new TextureTile[this.textureTiles.size()];
        Arrays.sort(this.textureTiles.toArray(textureTileArray));
        TextureTile textureTile = textureTileArray[0];
        textureTile.currentTile = contentTile;
        this.textureTileMap.put(contentTile, textureTile);
        return textureTile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTile(DrawContext drawContext, ContentTile contentTile, Rectangle rectangle) {
        int n = rectangle.x - contentTile.column * this.textureTileDimension;
        int n2 = rectangle.y - this.contentSize.height + this.textureTileDimension * (contentTile.row + 1);
        Rectangle rectangle2 = new Rectangle(n, n2, this.contentBounds.width, this.textureTileDimension);
        try {
            Texture texture = drawContext.getTextureCache().getTexture(this.textureCacheKey);
            this.rttSupport.setColorTarget(drawContext, texture);
            this.rttSupport.clear(drawContext, new Color(0, 0, 0, 0));
            this.contents.renderScrollable(drawContext, rectangle2.getLocation(), rectangle2.getSize(), rectangle);
        }
        finally {
            this.rttSupport.setColorTarget(drawContext, null);
        }
    }

    protected void forceTileUpdate() {
        for (ContentTile contentTile : this.tiles) {
            contentTile.updateTime = -1L;
        }
    }

    protected Texture createTileTexture(DrawContext drawContext, int n, int n2) {
        GL gL = drawContext.getGL();
        TextureData textureData = new TextureData(gL.getGLProfile(), 32856, n, n2, 0, 6408, 5121, false, false, false, null, null){

            @Override
            public int getEstimatedMemorySize() {
                int n = OGLUtil.estimateTextureMemorySize(this.getInternalFormat(), this.getWidth(), this.getHeight(), this.getMipmap());
                if (n > 0) {
                    return n;
                }
                return super.getEstimatedMemorySize();
            }
        };
        Texture texture = TextureIO.newTexture(textureData);
        texture.bind(gL);
        return texture;
    }

    protected int computeTileTextureDimension(Dimension dimension, Dimension dimension2) {
        int n = Math.min(dimension.width, dimension2.width);
        int n2 = Math.min(dimension.height, dimension2.height);
        int n3 = n * n2;
        return WWMath.powerOfTwoCeiling((int)Math.sqrt(n3) + this.textureTileDimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preRender(DrawContext drawContext) {
        Offset offset = this.getScreenLocation();
        if (offset == null) {
            return;
        }
        this.stepAnimation(drawContext);
        this.updateBounds(drawContext);
        Point point = drawContext.getPickPoint();
        if (point != null) {
            int n = drawContext.getView().getViewport().height - point.y;
            this.setHighlighted(this.pickBounds.contains(new Point(point.x, n)));
        }
        this.determineActiveAttributes();
        if (this.intersectsFrustum(drawContext) && this.mustUpdateTiles(drawContext)) {
            try {
                this.beginDrawing(drawContext);
                this.updateTiles(drawContext);
            }
            finally {
                this.endDrawing(drawContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(DrawContext drawContext) {
        Offset offset = this.getScreenLocation();
        if (offset == null || this.frameBounds == null) {
            return;
        }
        if (this.mustRecomputeFrameGeometry) {
            this.computeFrameGeometry();
            this.mustRecomputeFrameGeometry = false;
        }
        if (this.intersectsFrustum(drawContext)) {
            try {
                this.beginDrawing(drawContext);
                if (this.isDrawMinimized()) {
                    this.drawMinimized(drawContext);
                } else {
                    this.drawMaximized(drawContext);
                }
            }
            finally {
                this.endDrawing(drawContext);
            }
        }
    }

    protected void initializeUIControls() {
        this.minimizeAnimation = new WindowShadeAnimation(this);
        this.frameResizeControl = new FrameResizeControl(this);
        this.minimizeButton = new TreeHotSpot(this){

            @Override
            public void selected(SelectEvent selectEvent) {
                if (selectEvent == null || this.isConsumed(selectEvent)) {
                    return;
                }
                if (selectEvent.isLeftClick()) {
                    ScrollFrame.this.setMinimized(!ScrollFrame.this.isMinimized());
                    selectEvent.consume();
                } else {
                    super.selected(selectEvent);
                }
            }
        };
        this.verticalScrollBar = new ScrollBar(this, "gov.nasa.worldwind.avkey.Vertical");
        this.horizontalScrollBar = new ScrollBar(this, "gov.nasa.worldwind.avkey.Horizontal");
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(this.pickBounds);
        }
        return drawContext.getView().getViewport().intersects(this.frameBounds);
    }

    protected void stepAnimation(DrawContext drawContext) {
        if (this.isAnimating()) {
            this.animation.step();
            if (this.animation.hasNext()) {
                drawContext.setRedrawRequested(this.animationDelay);
            } else {
                this.animation = null;
            }
        }
    }

    protected Rectangle getContentTileBounds(int n, int n2) {
        int n3 = this.horizontalScrollBar.getValue();
        int n4 = this.verticalScrollBar.getValue();
        int n5 = (int)this.contentBounds.getMinX() + this.textureTileDimension * n2 - n3;
        int n6 = (int)this.contentBounds.getMaxY() - this.textureTileDimension * (n + 1) + n4;
        return new Rectangle(n5, n6, this.textureTileDimension, this.textureTileDimension);
    }

    public void updateBounds(DrawContext drawContext) {
        boolean bl;
        Cloneable cloneable;
        if (drawContext.getFrameTimeStamp() == this.frameNumber) {
            return;
        }
        this.determineSize();
        Rectangle rectangle = drawContext.getView().getViewport();
        Dimension dimension = null;
        Dimension dimension2 = this.frameSize;
        Size size = this.getActiveSize();
        if (this.isRelativeSize(size)) {
            dimension = this.contents.getSize(drawContext, null);
            cloneable = this.computeFrameRectForContentRect(dimension);
            this.frameSize = size.compute(((Dimension)cloneable).width, ((Dimension)cloneable).height, rectangle.width, rectangle.height);
        } else {
            this.frameSize = size.compute(0, 0, rectangle.width, rectangle.height);
        }
        if (this.getMaxSize() != null) {
            cloneable = this.getMaxSize().compute(this.frameSize.width, this.frameSize.height, rectangle.width, rectangle.height);
            this.frameSize.width = Math.min(this.frameSize.width, ((Dimension)cloneable).width);
            this.frameSize.height = Math.min(this.frameSize.height, ((Dimension)cloneable).height);
        }
        if (!this.frameSize.equals(dimension2)) {
            this.mustRecomputeFrameGeometry = true;
        }
        cloneable = this.screenLocation.computeOffset(rectangle.width, rectangle.height, 1.0, 1.0);
        this.awtScreenPoint = new Point((int)((Point2D)cloneable).getX(), (int)((double)rectangle.height - ((Point2D)cloneable).getY()));
        this.frameBounds = new Rectangle((int)((Point2D)cloneable).getX(), (int)((Point2D)cloneable).getY() - this.frameSize.height, this.frameSize.width, this.frameSize.height);
        this.pickBounds = new Rectangle(this.frameBounds.x - this.borderPickWidth / 2, this.frameBounds.y - this.borderPickWidth / 2, this.frameBounds.width + this.borderPickWidth, this.frameBounds.height + this.borderPickWidth);
        this.innerBounds = new Rectangle((int)((Point2D)cloneable).getX() + this.frameBorder, (int)((Point2D)cloneable).getY() - this.frameSize.height + this.frameBorder, this.frameSize.width - this.frameBorder * 2, this.frameSize.height - this.frameBorder * 2);
        if (dimension == null) {
            dimension = this.contents.getSize(drawContext, this.computeBounds(true, true).getSize());
        }
        this.contentBounds = this.computeBounds(false, false);
        boolean bl2 = this.mustShowVerticalScrollbar(dimension);
        if (bl2) {
            this.contentBounds = this.computeBounds(true, false);
        }
        if ((bl = this.mustShowHorizontalScrollbar(dimension)) && !bl2) {
            this.contentBounds = this.computeBounds(bl2, bl);
            bl2 = this.mustShowVerticalScrollbar(dimension);
        }
        this.contentBounds = this.computeBounds(bl2, bl);
        if (this.showVerticalScrollbar && !bl2) {
            this.verticalScrollBar.setValue(0);
        }
        if (this.showHorizontalScrollbar && !bl) {
            this.horizontalScrollBar.setValue(0);
        }
        this.showVerticalScrollbar = bl2;
        this.showHorizontalScrollbar = bl;
        this.verticalScrollBar.setMaxValue(dimension.height);
        this.verticalScrollBar.setExtent(this.contentBounds.height);
        this.horizontalScrollBar.setMaxValue(dimension.width);
        this.horizontalScrollBar.setExtent(this.contentBounds.width);
        this.scrollContentBounds = new Rectangle(this.contentBounds);
        this.scrollContentBounds.x -= this.horizontalScrollBar.getValue();
        this.scrollContentBounds.y += this.verticalScrollBar.getValue();
        this.scrollContentBounds.y -= dimension.height - this.contentBounds.height;
        this.contentSize = dimension;
        this.frameNumber = drawContext.getFrameTimeStamp();
    }

    protected Dimension computeFrameRectForContentRect(Dimension dimension) {
        int n = dimension.width + this.frameBorder * 2 + 4 * this.frameLineWidth + this.scrollBarSize;
        int n2 = dimension.height + this.frameBorder * 2 + this.getTitleBarHeight() + 2 * this.frameLineWidth;
        return new Dimension(n, n2);
    }

    protected boolean isRelativeSize(Size size) {
        String string = size.getHeightMode();
        String string2 = size.getWidthMode();
        return "gov.nasa.worldwind.render.Size.NativeDimension".equals(string) || "gov.nasa.worldwind.render.Size.MaintainAspectRatio".equals(string) || "gov.nasa.worldwind.render.Size.NativeDimension".equals(string2) || "gov.nasa.worldwind.render.Size.MaintainAspectRatio".equals(string2);
    }

    protected boolean mustShowVerticalScrollbar(Dimension dimension) {
        if (!this.isMinimized() && !this.isAnimating()) {
            return dimension.height > this.contentBounds.height;
        }
        return this.showVerticalScrollbar;
    }

    protected boolean mustShowHorizontalScrollbar(Dimension dimension) {
        return dimension.width > this.contentBounds.width && this.innerBounds.height > this.titleBarHeight + this.scrollBarSize;
    }

    protected boolean isAnimating() {
        return this.animation != null;
    }

    protected Rectangle computeBounds(boolean bl, boolean bl2) {
        int n = bl2 ? this.scrollBarSize : 0;
        int n2 = bl ? this.scrollBarSize : 0;
        int n3 = this.isDrawTitleBar() ? this.titleBarHeight : 0;
        int n4 = 2 * this.frameLineWidth;
        return new Rectangle(this.innerBounds.x + n4, this.innerBounds.y + n + n4, this.innerBounds.width - n2 - n4 * 2, this.innerBounds.height - n3 - n - n4);
    }

    protected void computeFrameGeometry() {
        if (this.frameBounds == null) {
            return;
        }
        FrameAttributes frameAttributes = this.getActiveAttributes();
        this.vertexBuffer = FrameFactory.createShapeBuffer("gov.nasa.worldwind.avkey.ShapeRectangle", this.frameBounds.width, this.frameBounds.height, frameAttributes.getCornerRadius(), this.vertexBuffer);
    }

    protected Dimension getMinimumSize() {
        int n = this.frameBorder * 2 + this.scrollBarSize * 3;
        int n2 = this.frameBorder * 2 + this.scrollBarSize * 3 + this.titleBarHeight;
        return new Dimension(n, n2);
    }

    protected boolean isDrawMinimized() {
        return this.isMinimized() && !this.isAnimating();
    }

    protected void drawMaximized(DrawContext drawContext) {
        this.drawFrame(drawContext);
        if (this.renderToTexture && !drawContext.isPickingMode()) {
            this.drawContentTiles(drawContext);
        } else {
            this.drawContentDirect(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawContentDirect(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        try {
            gL.glEnable(3089);
            gL.glScissor(this.contentBounds.x, this.contentBounds.y - 1, this.contentBounds.width + 1, this.contentBounds.height);
            this.contents.renderScrollable(drawContext, this.scrollContentBounds.getLocation(), this.scrollContentBounds.getSize(), this.contentBounds);
        }
        finally {
            gL.glDisable(3089);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawContentTiles(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        try {
            gL2.glPolygonMode(1028, 6914);
            gL2.glEnable(3553);
            OGLUtil.applyBlending(gL2, true);
            Texture texture = drawContext.getTextureCache().getTexture(this.textureCacheKey);
            if (texture == null) {
                return;
            }
            texture.bind(gL2);
            for (ContentTile contentTile : this.tiles) {
                TextureTile textureTile = this.getTextureTile(contentTile);
                if (textureTile == null) continue;
                int n = textureTile.column * this.textureTileDimension;
                int n2 = textureTile.row * this.textureTileDimension;
                Rectangle rectangle = this.getContentTileBounds(contentTile.row, contentTile.column);
                Rectangle rectangle2 = rectangle.intersection(this.contentBounds);
                if (rectangle2.isEmpty()) continue;
                Rectangle rectangle3 = new Rectangle(n + rectangle2.x - rectangle.x, n2 + rectangle2.y - rectangle.y, rectangle2.width, rectangle2.height);
                gL2.glPushMatrix();
                try {
                    gL2.glTranslated(rectangle2.x, rectangle2.y, 0.0);
                    gL2.glColor4f(1.0f, 1.0f, 1.0f, (float)this.getActiveAttributes().getForegroundOpacity());
                    TextureCoords textureCoords = texture.getSubImageTexCoords((int)rectangle3.getMinX(), (int)rectangle3.getMinY(), (int)rectangle3.getMaxX(), (int)rectangle3.getMaxY());
                    gL2.glScaled(rectangle3.width, rectangle3.height, 1.0);
                    drawContext.drawUnitQuad(textureCoords);
                }
                finally {
                    gL2.glPopMatrix();
                }
            }
        }
        finally {
            gL2.glDisable(3553);
            gL2.glBindTexture(3553, 0);
        }
    }

    protected void drawMinimized(DrawContext drawContext) {
        this.drawFrame(drawContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawFrame(DrawContext drawContext) {
        block18: {
            GL2 gL2 = drawContext.getGL().getGL2();
            OGLStackHandler oGLStackHandler = new OGLStackHandler();
            try {
                int n;
                int n2;
                oGLStackHandler.pushModelviewIdentity(gL2);
                FrameAttributes frameAttributes = this.getActiveAttributes();
                gL2.glTranslated(this.frameBounds.x, this.frameBounds.y, 0.0);
                boolean bl = this.showHorizontalScrollbar;
                boolean bl2 = this.showVerticalScrollbar;
                if (!drawContext.isPickingMode()) {
                    Color[] colorArray = frameAttributes.getBackgroundColor();
                    try {
                        gL2.glEnable(2848);
                        OGLUtil.applyColor(gL2, colorArray[0], 1.0, false);
                        gL2.glLineWidth(this.frameLineWidth);
                        FrameFactory.drawBuffer(drawContext, 3, this.vertexBuffer);
                    }
                    finally {
                        gL2.glDisable(2848);
                    }
                    gL2.glLoadIdentity();
                    gL2.glTranslated(this.innerBounds.x, this.innerBounds.y, 0.0);
                    TreeUtil.drawRectWithGradient(gL2, new Rectangle(0, 0, this.innerBounds.width, this.innerBounds.height), colorArray[0], colorArray[1], frameAttributes.getBackgroundOpacity(), "gov.nasa.worldwind.avkey.Vertical");
                } else {
                    int n3 = this.frameBounds.height;
                    n2 = this.frameBounds.width;
                    TreeUtil.drawPickableRect(drawContext, this.pickSupport, this, new Rectangle(0, 0, n2, n3));
                    if (this.isEnableResizeControl() && !this.isDrawMinimized()) {
                        Color color = drawContext.getUniquePickColor();
                        n = color.getRGB();
                        this.pickSupport.addPickableObject(n, this.frameResizeControl);
                        gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                        gL2.glLineWidth(this.borderPickWidth);
                        FrameFactory.drawBuffer(drawContext, 3, this.vertexBuffer);
                    }
                    gL2.glLoadIdentity();
                    gL2.glTranslated(this.innerBounds.x, this.innerBounds.y, 0.0);
                    if (bl2 && bl && !this.isDrawMinimized()) {
                        gL2.glRecti(this.innerBounds.width - this.scrollBarSize, 0, this.innerBounds.width, this.scrollBarSize);
                    }
                }
                if (!this.isDrawMinimized()) {
                    this.drawScrollBars(drawContext);
                }
                if (this.isDrawTitleBar()) {
                    gL2.glTranslated(0.0, this.innerBounds.height - this.titleBarHeight, 0.0);
                    this.drawTitleBar(drawContext);
                }
                if (drawContext.isPickingMode()) break block18;
                gL2.glLoadIdentity();
                int n4 = (int)this.innerBounds.getMinX();
                n2 = (int)this.innerBounds.getMinY();
                int n5 = (int)this.innerBounds.getMaxX();
                n = (int)this.innerBounds.getMaxY();
                OGLUtil.applyColor(gL2, frameAttributes.getForegroundColor(), false);
                gL2.glBegin(3);
                try {
                    if (!bl2) {
                        gL2.glVertex2f(n5, (float)n2 + 0.5f);
                    }
                    gL2.glVertex2f(n5, n);
                    gL2.glVertex2f((float)n4 + 0.5f, n);
                    gL2.glVertex2f((float)n4 + 0.5f, (float)n2 + 0.5f);
                    if (!bl) {
                        gL2.glVertex2f(n5, (float)n2 + 0.5f);
                    }
                }
                finally {
                    gL2.glEnd();
                }
            }
            finally {
                oGLStackHandler.pop(gL2);
            }
        }
    }

    protected void drawScrollBars(DrawContext drawContext) {
        int n;
        int n2;
        if (this.showVerticalScrollbar) {
            n2 = this.innerBounds.width - this.scrollBarSize;
            n = 1;
            if (this.showHorizontalScrollbar) {
                n += this.scrollBarSize;
            }
            Rectangle rectangle = new Rectangle(n2, n, this.scrollBarSize, this.contentBounds.height + 1);
            this.verticalScrollBar.setBounds(rectangle);
            this.verticalScrollBar.render(drawContext);
        }
        if (this.showHorizontalScrollbar) {
            n2 = 1;
            n = 1;
            int n3 = this.innerBounds.width - 1;
            if (this.showVerticalScrollbar) {
                n3 -= this.scrollBarSize;
            }
            Rectangle rectangle = new Rectangle(n2, n, n3, this.scrollBarSize);
            this.horizontalScrollBar.setBounds(rectangle);
            this.horizontalScrollBar.render(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawTitleBar(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        FrameAttributes frameAttributes = this.getActiveAttributes();
        if (!drawContext.isPickingMode()) {
            Color[] colorArray = frameAttributes.getTitleBarColor();
            TreeUtil.drawRectWithGradient(gL2, new Rectangle(0, 0, this.innerBounds.width, this.getTitleBarHeight()), colorArray[0], colorArray[1], frameAttributes.getBackgroundOpacity(), "gov.nasa.worldwind.avkey.Vertical");
            OGLUtil.applyColor(gL2, frameAttributes.getForegroundColor(), 1.0, false);
            if (!this.isDrawMinimized()) {
                gL2.glBegin(1);
                try {
                    gL2.glVertex2f(0.0f, 0.0f);
                    gL2.glVertex2f(this.innerBounds.width, 0.0f);
                }
                finally {
                    gL2.glEnd();
                }
            }
            Point point = new Point(0, 0);
            this.drawIcon(drawContext, point);
            this.drawTitleText(drawContext, point);
        }
        this.drawMinimizeButton(drawContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawIcon(DrawContext drawContext, Point point) {
        GL2 gL2 = drawContext.getGL().getGL2();
        FrameAttributes frameAttributes = this.getActiveAttributes();
        int n = frameAttributes.getIconSpace();
        BasicWWTexture basicWWTexture = this.getTexture();
        if (basicWWTexture == null) {
            point.x += n;
            return;
        }
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            if (basicWWTexture.bind(drawContext)) {
                gL2.glEnable(3553);
                Dimension dimension = frameAttributes.getIconSize();
                oGLStackHandler.pushModelview(gL2);
                gL2.glColor4d(1.0, 1.0, 1.0, 1.0);
                double d = (this.titleBarHeight - dimension.height) / 2;
                TextureCoords textureCoords = basicWWTexture.getTexCoords();
                gL2.glTranslated(point.x + n, (double)point.y + d + 1.0, 1.0);
                gL2.glScaled(dimension.width, dimension.height, 1.0);
                drawContext.drawUnitQuad(textureCoords);
                point.x = (int)((double)point.x + (dimension.getWidth() + (double)(n * 2)));
            }
        }
        finally {
            gL2.glDisable(3553);
            gL2.glBindTexture(3553, 0);
            oGLStackHandler.pop(gL2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawTitleText(DrawContext drawContext, Point point) {
        GL2 gL2 = drawContext.getGL().getGL2();
        FrameAttributes frameAttributes = this.getActiveAttributes();
        String string = this.getFrameTitle();
        if (string == null) {
            return;
        }
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), frameAttributes.getFont());
        int n = this.innerBounds.width - this.buttonSize - point.x - frameAttributes.getIconSpace();
        if (this.mustGenerateShortTitle(frameAttributes.getFont(), n)) {
            this.generateShortTitle(drawContext, string, n, "...");
        }
        if (this.shortTitle == null) {
            return;
        }
        try {
            textRenderer.begin3DRendering();
            OGLUtil.applyColor(gL2, frameAttributes.getTextColor(), 1.0, false);
            double d = ((double)this.titleBarHeight - Math.abs(this.shortTitleBounds.getY())) / 2.0;
            textRenderer.draw(this.shortTitle, point.x, (int)((double)point.y + d) + 1);
        }
        finally {
            textRenderer.end3DRendering();
        }
    }

    protected boolean mustGenerateShortTitle(Font font, int n) {
        return this.shortTitle == null || !font.equals(this.shortFrameTitleFont) || n != this.frameTitleWidth;
    }

    protected void generateShortTitle(DrawContext drawContext, String string, int n, String string2) {
        Font font;
        this.shortFrameTitleFont = font = this.getActiveAttributes().getFont();
        this.frameTitleWidth = n;
        if (string == null) {
            this.shortTitle = null;
            return;
        }
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
        Rectangle2D rectangle2D = textRenderer.getBounds(string);
        if (rectangle2D.getWidth() < (double)n) {
            this.shortTitle = string;
            this.shortTitleBounds = rectangle2D;
            return;
        }
        Rectangle2D rectangle2D2 = textRenderer.getBounds(string2);
        if ((double)n < rectangle2D2.getWidth()) {
            this.shortTitle = null;
            this.shortTitleBounds = null;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(string.charAt(i));
            Rectangle2D rectangle2D3 = textRenderer.getBounds(stringBuilder);
            if (!(rectangle2D3.getWidth() + rectangle2D2.getWidth() > (double)n)) continue;
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append("...");
            break;
        }
        if (stringBuilder.length() > string2.length()) {
            this.shortTitle = stringBuilder.toString();
            this.shortTitleBounds = textRenderer.getBounds(stringBuilder);
        } else {
            this.shortTitle = null;
            this.shortTitleBounds = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawMinimizeButton(DrawContext drawContext) {
        block12: {
            GL2 gL2 = drawContext.getGL().getGL2();
            OGLStackHandler oGLStackHandler = new OGLStackHandler();
            try {
                oGLStackHandler.pushModelviewIdentity(gL2);
                int n = (int)this.innerBounds.getMaxX() - this.getActiveAttributes().getIconSpace() - this.buttonSize;
                int n2 = (int)this.innerBounds.getMaxY() - (this.titleBarHeight - this.buttonSize) / 2 - this.buttonSize;
                gL2.glTranslated(n, n2, 0.0);
                if (!drawContext.isPickingMode()) {
                    Color color = this.getActiveAttributes().getMinimizeButtonColor();
                    FrameAttributes frameAttributes = this.getActiveAttributes();
                    OGLUtil.applyColor(gL2, color, frameAttributes.getForegroundOpacity(), false);
                    gL2.glRectf(0.0f, 0.0f, this.buttonSize, this.buttonSize);
                    OGLUtil.applyColor(gL2, frameAttributes.getForegroundColor(), false);
                    gL2.glBegin(2);
                    try {
                        gL2.glVertex2f(0.0f, 0.0f);
                        gL2.glVertex2f(0.5f, (float)this.buttonSize + 0.5f);
                        gL2.glVertex2f(this.buttonSize, (float)this.buttonSize + 0.5f);
                        gL2.glVertex2f(this.buttonSize, 0.0f);
                    }
                    finally {
                        gL2.glEnd();
                    }
                    gL2.glBegin(1);
                    try {
                        gL2.glVertex2f((float)this.buttonSize / 4.0f, (float)this.buttonSize / 2.0f);
                        gL2.glVertex2f((float)this.buttonSize - (float)this.buttonSize / 4.0f, (float)this.buttonSize / 2.0f);
                        if (this.isMinimized()) {
                            gL2.glVertex2f((float)this.buttonSize / 2.0f, (float)this.buttonSize / 4.0f);
                            gL2.glVertex2f((float)this.buttonSize / 2.0f, (float)this.buttonSize - (float)this.buttonSize / 4.0f);
                        }
                        break block12;
                    }
                    finally {
                        gL2.glEnd();
                    }
                }
                Color color = drawContext.getUniquePickColor();
                int n3 = color.getRGB();
                this.pickSupport.addPickableObject(n3, this.minimizeButton, null, false);
                gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                gL2.glScaled(this.buttonSize, this.buttonSize, 1.0);
                drawContext.drawUnitQuad();
            }
            finally {
                oGLStackHandler.pop(gL2);
            }
        }
    }

    protected void beginDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        GLU gLU = drawContext.getGLU();
        this.BEogsh.pushAttrib(gL2, 553229);
        gL2.glEnable(3042);
        gL2.glBlendFunc(770, 771);
        gL2.glDisable(2929);
        this.BEogsh.pushProjectionIdentity(gL2);
        Rectangle rectangle = drawContext.getView().getViewport();
        gLU.gluOrtho2D(0.0, (double)rectangle.width, 0.0, (double)rectangle.height);
        this.BEogsh.pushModelviewIdentity(gL2);
        if (drawContext.isPickingMode()) {
            this.pickSupport.clearPickList();
            this.pickSupport.beginPicking(drawContext);
        }
    }

    protected void endDrawing(DrawContext drawContext) {
        if (drawContext.isPickingMode()) {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, drawContext.getPickPoint(), drawContext.getCurrentLayer());
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        this.BEogsh.pop(gL2);
    }

    protected FrameAttributes getActiveAttributes() {
        return this.activeAttributes;
    }

    protected void determineActiveAttributes() {
        if (this.isHighlighted()) {
            if (this.getHighlightAttributes() != null) {
                this.activeAttributes.copy(this.getHighlightAttributes());
            } else if (this.getAttributes() != null) {
                this.activeAttributes.copy(this.getAttributes());
            } else {
                this.activeAttributes.copy(defaultAttributes);
            }
        } else if (this.getAttributes() != null) {
            this.activeAttributes.copy(this.getAttributes());
        } else {
            this.activeAttributes.copy(defaultAttributes);
        }
        this.determineScrollbarAttributes();
    }

    protected void determineScrollbarAttributes() {
        this.verticalScrollBar.setLineColor(this.activeAttributes.getForegroundColor());
        this.verticalScrollBar.setOpacity(this.activeAttributes.getBackgroundOpacity());
        this.horizontalScrollBar.setLineColor(this.activeAttributes.getForegroundColor());
        this.horizontalScrollBar.setOpacity(this.activeAttributes.getBackgroundOpacity());
        Color[] colorArray = this.activeAttributes.getScrollBarColor();
        this.horizontalScrollBar.setKnobColor(colorArray[0], colorArray[1]);
        this.verticalScrollBar.setKnobColor(colorArray[0], colorArray[1]);
    }

    protected Size getActiveSize() {
        return this.activeSize;
    }

    protected void determineSize() {
        this.activeSize = (this.isMinimized() || this.isAnimating()) && this.minimizedSize != null ? this.minimizedSize : this.maximizedSize;
    }

    protected BasicWWTexture getTexture() {
        if (this.texture != null) {
            return this.texture;
        }
        return this.initializeTexture();
    }

    protected BasicWWTexture initializeTexture() {
        Object object = this.getIconImageSource();
        if (object instanceof String || object instanceof URL) {
            URL uRL = WorldWind.getDataFileStore().requestFile(object.toString());
            if (uRL != null) {
                this.texture = new BasicWWTexture(uRL, true);
            }
        } else if (object != null) {
            this.texture = new BasicWWTexture(object, true);
            return this.texture;
        }
        return null;
    }

    public ScrollBar getScrollBar(String string) {
        if ("gov.nasa.worldwind.avkey.Vertical".equals(string)) {
            return this.verticalScrollBar;
        }
        return this.horizontalScrollBar;
    }

    @Override
    protected void beginDrag(Point point) {
        if (this.isEnableMove()) {
            Point2D point2D = this.awtScreenPoint;
            this.dragRefPoint = new Point((int)point2D.getX() - point.x, (int)point2D.getY() - point.y);
        }
    }

    @Override
    public void drag(Point point) {
        if (this.isEnableMove()) {
            double d = point.x + this.dragRefPoint.x;
            double d2 = point.y + this.dragRefPoint.y;
            this.setScreenLocation(new Offset(d, d2, "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.InsetPixels"));
        }
    }

    @Override
    public void selected(SelectEvent selectEvent) {
        Point point;
        if (selectEvent == null || this.isConsumed(selectEvent)) {
            return;
        }
        super.selected(selectEvent);
        Rectangle rectangle = new Rectangle((int)this.awtScreenPoint.getX() + this.frameBorder, (int)this.awtScreenPoint.getY() + this.frameBorder * 2, this.innerBounds.width, this.titleBarHeight);
        if (selectEvent.isLeftDoubleClick() && (point = selectEvent.getPickPoint()) != null && rectangle.contains(selectEvent.getPickPoint())) {
            this.setMinimized(!this.isMinimized());
            selectEvent.consume();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent == null || mouseWheelEvent.isConsumed()) {
            return;
        }
        if (Configuration.isMacOS()) {
            this.doScrollMacOS(mouseWheelEvent);
        } else {
            this.doScroll(mouseWheelEvent);
        }
        mouseWheelEvent.consume();
        this.firePropertyChange("gov.nasa.worldwind.avkey.Repaint", null, this);
    }

    protected void doScroll(MouseWheelEvent mouseWheelEvent) {
        if (this.showVerticalScrollbar) {
            this.verticalScrollBar.scroll(mouseWheelEvent.getUnitsToScroll() * this.getMouseWheelScrollUnit("gov.nasa.worldwind.avkey.Vertical"));
        } else if (this.showHorizontalScrollbar) {
            this.horizontalScrollBar.scroll(mouseWheelEvent.getUnitsToScroll() * this.getMouseWheelScrollUnit("gov.nasa.worldwind.avkey.Horizontal"));
        }
    }

    protected void doScrollMacOS(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.isShiftDown()) {
            this.horizontalScrollBar.scroll(mouseWheelEvent.getUnitsToScroll() * this.getMouseWheelScrollUnit("gov.nasa.worldwind.avkey.Horizontal"));
        } else {
            this.doScroll(mouseWheelEvent);
        }
    }

    protected int getMouseWheelScrollUnit(String string) {
        return (int)((double)this.getScrollBar(string).getBlockIncrement() * 0.25);
    }

    class TextureTile
    implements Comparable<TextureTile> {
        int row;
        int column;
        ContentTile currentTile;
        long lastUsed;

        TextureTile(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        @Override
        public int compareTo(TextureTile textureTile) {
            if (textureTile == null) {
                String string = Logging.getMessage("nullValue.CacheEntryIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.lastUsed < textureTile.lastUsed ? -1 : (this.lastUsed == textureTile.lastUsed ? 0 : 1);
        }
    }

    class ContentTile {
        int row;
        int column;
        long updateTime;

        ContentTile(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ContentTile contentTile = (ContentTile)object;
            if (this.row != contentTile.row) {
                return false;
            }
            return this.column == contentTile.column;
        }

        public int hashCode() {
            int n = this.row;
            n = 31 * n + this.column;
            return n;
        }
    }
}

