/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf;

import com.jogamp.opengl.util.texture.TextureData;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.formats.dds.DDSCompressor;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.layers.TiledImageLayer;
import gov.nasa.worldwind.layers.rpf.RPFFileIndex;
import gov.nasa.worldwind.layers.rpf.RPFGenerator;
import gov.nasa.worldwind.layers.rpf.RPFRetriever;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.retrieve.AbstractRetrievalPostProcessor;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.logging.Level;

public class RPFTiledImageLayer
extends TiledImageLayer {
    private AVList creationParams;
    private final RPFGenerator rpfGenerator;
    private final Object fileLock = new Object();
    public static final String RPF_ROOT_PATH = "rpf.RootPath";
    public static final String RPF_DATA_SERIES_ID = "rpf.DataSeriesId";

    static Collection<Tile> createTopLevelTiles(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.LayerConfigParams");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LevelSet levelSet = new LevelSet(RPFTiledImageLayer.initParams(aVList));
        Sector sector = levelSet.getSector();
        gov.nasa.worldwind.util.Level level = levelSet.getFirstLevel();
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = levelSet.getTileOrigin().getLatitude();
        Angle angle4 = levelSet.getTileOrigin().getLongitude();
        int n = Tile.computeRow(angle, sector.getMinLatitude(), angle3);
        int n2 = Tile.computeColumn(angle2, sector.getMinLongitude(), angle4);
        int n3 = Tile.computeRow(angle, sector.getMaxLatitude(), angle3);
        int n4 = Tile.computeColumn(angle2, sector.getMaxLongitude(), angle4);
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        ArrayList<Tile> arrayList = new ArrayList<Tile>(n5 * n6);
        Angle angle5 = Tile.computeRowLatitude(n, angle, angle3);
        for (int i = n; i <= n3; ++i) {
            Angle angle6 = angle5.add(angle);
            Angle angle7 = Tile.computeColumnLongitude(n2, angle2, angle4);
            for (int j = n2; j <= n4; ++j) {
                Angle angle8 = angle7.add(angle2);
                arrayList.add(new Tile(new Sector(angle5, angle6, angle7, angle8), level, i, j));
                angle7 = angle8;
            }
            angle5 = angle6;
        }
        return arrayList;
    }

    static String getFileIndexCachePath(String string, String string2) {
        String string3 = null;
        if (string != null && string2 != null) {
            string3 = WWIO.formPath(string, string2, "rpf_file_index.idx");
        }
        return string3;
    }

    public static RPFTiledImageLayer fromRestorableState(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return new RPFTiledImageLayer(string);
    }

    public RPFTiledImageLayer(String string) {
        this(RPFTiledImageLayer.xmlStateToParams(string));
        RestorableSupport.StateObject[] stateObjectArray;
        RestorableSupport.StateObject stateObject;
        String string2;
        Double d;
        RestorableSupport restorableSupport;
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        Boolean bl = restorableSupport.getStateValueAsBoolean("rpf.LayerEnabled");
        if (bl != null) {
            this.setEnabled(bl);
        }
        if ((d = restorableSupport.getStateValueAsDouble("rpf.Opacity")) != null) {
            this.setOpacity(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble("rpf.MinActiveAltitude")) != null) {
            this.setMinActiveAltitude(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble("rpf.MaxActiveAltitude")) != null) {
            this.setMaxActiveAltitude(d);
        }
        if ((string2 = restorableSupport.getStateValueAsString("rpf.LayerName")) != null) {
            this.setName(string2);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean("rpf.UseMipMaps")) != null) {
            this.setUseMipMaps(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean("rpf.UseTransparentTextures")) != null) {
            this.setUseTransparentTextures(bl);
        }
        if ((stateObject = restorableSupport.getStateObject("avlist")) != null && (stateObjectArray = restorableSupport.getAllStateObjects(stateObject, "")) != null) {
            for (RestorableSupport.StateObject stateObject2 : stateObjectArray) {
                if (stateObject2 == null) continue;
                this.setValue(stateObject2.getName(), stateObject2.getValue());
            }
        }
    }

    public RPFTiledImageLayer(AVList aVList) {
        super(new LevelSet(RPFTiledImageLayer.initParams(aVList)));
        this.initRPFFileIndex(aVList);
        this.creationParams = aVList.copy();
        this.rpfGenerator = new RPFGenerator(aVList);
        this.setValue("gov.nasa.worldwind.avkey.ConstructionParameters", aVList);
        this.setUseTransparentTextures(true);
        this.setName(RPFTiledImageLayer.makeTitle(aVList));
    }

    protected void initRPFFileIndex(AVList aVList) {
        FileStore fileStore = WorldWind.getDataFileStore();
        String string = aVList.getStringValue(RPF_ROOT_PATH);
        String string2 = aVList.getStringValue(RPF_DATA_SERIES_ID);
        File file = fileStore.newFile(RPFTiledImageLayer.getFileIndexCachePath(string, string2));
        RPFFileIndex rPFFileIndex = (RPFFileIndex)aVList.getValue("RPFGenerator.RPFFileIndex");
        if (rPFFileIndex == null) {
            rPFFileIndex = RPFTiledImageLayer.initFileIndex(file);
            if (rPFFileIndex == null) {
                String string3 = Logging.getMessage("nullValue.RPFFileIndexIsNull");
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            aVList.setValue("RPFGenerator.RPFFileIndex", rPFFileIndex);
        }
        Long l = new GregorianCalendar(2009, 1, 25).getTimeInMillis();
        if (file != null && file.lastModified() > l) {
            l = file.lastModified();
        }
        this.setExpiryTime(l);
    }

    private static AVList initParams(AVList aVList) {
        Object object;
        Comparable<Angle> comparable;
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.LayerConfigParams");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = aVList.getStringValue(RPF_ROOT_PATH);
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.RPFRootPath");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = aVList.getStringValue(RPF_DATA_SERIES_ID);
        if (string3 == null) {
            String string4 = Logging.getMessage("nullValue.RPFDataSeriesIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ServiceURLKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "file://" + RPFGenerator.class.getName() + "?");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string3);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta") == null) {
            comparable = Angle.fromDegrees(36.0);
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon((Angle)comparable, (Angle)comparable));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 512);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 512);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".dds");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", 14);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        }
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder());
        comparable = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (comparable == null) {
            object = (RPFFileIndex)aVList.getValue("RPFGenerator.RPFFileIndex");
            if (object != null && ((RPFFileIndex)object).getIndexProperties() != null) {
                comparable = ((RPFFileIndex)object).getIndexProperties().getBoundingSector();
            }
            if (comparable == null) {
                String string5 = Logging.getMessage("RPFTiledImageLayer.NoGeographicBoundingBox");
                Logging.logger().severe(string5);
                throw new IllegalArgumentException(string5);
            }
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", comparable);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey") == null) {
            object = WWIO.formPath(string, string3);
            aVList.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", object);
        }
        return aVList;
    }

    private static RPFFileIndex initFileIndex(File file) {
        MappedByteBuffer mappedByteBuffer;
        try {
            mappedByteBuffer = WWIO.mapFile(file);
        }
        catch (Exception exception) {
            String string = "Exception while attempting to map file: " + file;
            Logging.logger().log(Level.SEVERE, string, exception);
            mappedByteBuffer = null;
        }
        RPFFileIndex rPFFileIndex = null;
        try {
            if (mappedByteBuffer != null) {
                rPFFileIndex = new RPFFileIndex();
                rPFFileIndex.load(mappedByteBuffer);
            }
        }
        catch (Exception exception) {
            String string = "Exception while attempting to load RPFFileIndex: " + file;
            Logging.logger().log(Level.SEVERE, string, exception);
            rPFFileIndex = null;
        }
        return rPFFileIndex;
    }

    private static String makeTitle(AVList aVList) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = aVList.getValue("RPFGenerator.RPFFileIndex");
        if (object2 != null && object2 instanceof RPFFileIndex && ((RPFFileIndex)(object = (RPFFileIndex)object2)).getIndexProperties() != null) {
            if (((RPFFileIndex)object).getIndexProperties().getDescription() != null) {
                stringBuilder.append(((RPFFileIndex)object).getIndexProperties().getDescription());
            } else {
                stringBuilder.append(((RPFFileIndex)object).getIndexProperties().getDataSeriesIdentifier());
            }
        }
        if (stringBuilder.length() == 0) {
            object = aVList.getStringValue(RPF_ROOT_PATH);
            String string = aVList.getStringValue(RPF_DATA_SERIES_ID);
            if (object != null && string != null) {
                stringBuilder.append((String)object).append(":").append(string);
            }
        }
        return stringBuilder.toString();
    }

    protected void checkResources() {
    }

    private RestorableSupport makeRestorableState(AVList aVList) {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        for (Map.Entry<String, Object> entry : aVList.getEntries()) {
            if (entry.getValue() instanceof LatLon) {
                restorableSupport.addStateValueAsDouble(entry.getKey() + ".Latitude", ((LatLon)entry.getValue()).getLatitude().degrees);
                restorableSupport.addStateValueAsDouble(entry.getKey() + ".Longitude", ((LatLon)entry.getValue()).getLongitude().degrees);
                continue;
            }
            if (entry.getValue() instanceof Sector) {
                restorableSupport.addStateValueAsDouble(entry.getKey() + ".MinLatitude", ((Sector)entry.getValue()).getMinLatitude().degrees);
                restorableSupport.addStateValueAsDouble(entry.getKey() + ".MaxLatitude", ((Sector)entry.getValue()).getMaxLatitude().degrees);
                restorableSupport.addStateValueAsDouble((String)entry.getKey() + ".MinLongitude", ((Sector)entry.getValue()).getMinLongitude().degrees);
                restorableSupport.addStateValueAsDouble((String)entry.getKey() + ".MaxLongitude", ((Sector)entry.getValue()).getMaxLongitude().degrees);
                continue;
            }
            if (entry.getValue() instanceof URLBuilder || entry.getKey().equals("RPFGenerator.RPFFileIndex")) continue;
            super.getRestorableStateForAVPair(entry.getKey(), entry.getValue(), restorableSupport, null);
        }
        restorableSupport.addStateValueAsBoolean("rpf.LayerEnabled", this.isEnabled());
        restorableSupport.addStateValueAsDouble("rpf.Opacity", this.getOpacity());
        restorableSupport.addStateValueAsDouble("rpf.MinActiveAltitude", this.getMinActiveAltitude());
        restorableSupport.addStateValueAsDouble("rpf.MaxActiveAltitude", this.getMaxActiveAltitude());
        restorableSupport.addStateValueAsString("rpf.LayerName", this.getName());
        restorableSupport.addStateValueAsBoolean("rpf.UseMipMaps", this.isUseMipMaps());
        restorableSupport.addStateValueAsBoolean("rpf.UseTransparentTextures", this.isUseTransparentTextures());
        RestorableSupport.StateObject stateObject = restorableSupport.addStateObject("avlist");
        for (Map.Entry entry : this.getEntries()) {
            if (((String)entry.getKey()).equals("gov.nasa.worldwind.avkey.ConstructionParameters")) continue;
            super.getRestorableStateForAVPair((String)entry.getKey(), entry.getValue(), restorableSupport, stateObject);
        }
        return restorableSupport;
    }

    @Override
    public String getRestorableState() {
        return this.makeRestorableState(this.creationParams).getStateAsXml();
    }

    public static AVList xmlStateToParams(String string) {
        Integer n;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AVListImpl aVListImpl = new AVListImpl();
        String string4 = restorableSupport.getStateValueAsString(RPF_ROOT_PATH);
        if (string4 != null) {
            aVListImpl.setValue(RPF_ROOT_PATH, string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString(RPF_DATA_SERIES_ID)) != null) {
            aVListImpl.setValue(RPF_DATA_SERIES_ID, string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.ImageFormat")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ImageFormat", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.DataCacheNameKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.ServiceURLKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.Title")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Title", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.DisplayName")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DisplayName", string4);
        }
        RestorableSupport.adjustTitleAndDisplayName(aVListImpl);
        string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.DatasetNameKey");
        if (string4 != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.FormatSuffixKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.LayerNames")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.LayerNames", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.StyleNames")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.StyleNames", string4);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.NumEmptyLevels")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.NumLevels")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.TileWidthKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.TileHeightKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", n);
        }
        Double d = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avkey.LevelZeroTileDelta.Latitude");
        Double d2 = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avkey.LevelZeroTileDelta.Longitude");
        if (d != null && d2 != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", LatLon.fromDegrees(d, d2));
        }
        Double d3 = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avKey.Sector.MinLatitude");
        Double d4 = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avKey.Sector.MinLongitude");
        Double d5 = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avKey.Sector.MaxLatitude");
        Double d6 = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avKey.Sector.MaxLongitude");
        if (d3 != null && d4 != null && d5 != null && d6 != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.fromDegrees(d3, d5, d4, d6));
        }
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder());
        return aVListImpl;
    }

    @Override
    public void restoreState(String string) {
        String string2 = Logging.getMessage("RestorableSupport.RestoreRequiresConstructor");
        Logging.logger().severe(string2);
        throw new UnsupportedOperationException(string2);
    }

    @Override
    protected void forceTextureLoad(TextureTile textureTile) {
        URL uRL = WorldWind.getDataFileStore().findFile(textureTile.getPath(), true);
        if (uRL != null) {
            this.loadTexture(textureTile, uRL);
        }
    }

    @Override
    protected void requestTexture(DrawContext drawContext, TextureTile textureTile) {
        Vec4 vec4 = textureTile.getCentroidPoint(drawContext.getGlobe());
        Vec4 vec42 = this.getReferencePoint(drawContext);
        if (vec42 != null) {
            textureTile.setPriority(vec4.distanceTo3(vec42));
        }
        RequestTask requestTask = new RequestTask(textureTile, this);
        this.getRequestQ().add(requestTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTexture(TextureTile textureTile, URL uRL) {
        TextureData textureData;
        if (WWIO.isFileOutOfDate(uRL, textureTile.getLevel().getExpiryTime())) {
            WorldWind.getDataFileStore().removeFile(uRL);
            String string = Logging.getMessage("generic.DataFileExpired", uRL);
            Logging.logger().fine(string);
            return false;
        }
        Object object = this.fileLock;
        synchronized (object) {
            textureData = RPFTiledImageLayer.readTexture(uRL, this.isUseMipMaps());
        }
        if (textureData == null) {
            return false;
        }
        textureTile.setTextureData(textureData);
        if (textureTile.getLevelNumber() != 0 || !this.isRetainLevelZeroTiles()) {
            this.addTileToCache(textureTile);
        }
        return true;
    }

    private static TextureData readTexture(URL uRL, boolean bl) {
        try {
            return OGLUtil.newTextureData(Configuration.getMaxCompatibleGLProfile(), uRL, bl);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("layers.TextureLayer.ExceptionAttemptingToReadTextureFile", uRL.toString());
            Logging.logger().log(Level.SEVERE, string, exception);
            return null;
        }
    }

    private void addTileToCache(TextureTile textureTile) {
        TextureTile.getMemoryCache().add(textureTile.getTileKey(), textureTile);
    }

    protected void downloadTexture(TextureTile textureTile) {
        URL uRL;
        RPFGenerator.RPFServiceInstance rPFServiceInstance = this.rpfGenerator.getServiceInstance();
        if (rPFServiceInstance == null) {
            return;
        }
        try {
            uRL = textureTile.getResourceURL();
        }
        catch (MalformedURLException malformedURLException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("layers.TextureLayer.ExceptionCreatingTextureUrl", textureTile), malformedURLException);
            return;
        }
        if (WorldWind.getRetrievalService().isAvailable()) {
            RPFRetriever rPFRetriever = new RPFRetriever(rPFServiceInstance, uRL, new DownloadPostProcessor(textureTile, this));
            Integer n = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit");
            if (n != null && n > 0) {
                rPFRetriever.setStaleRequestLimit(n);
            }
            WorldWind.getRetrievalService().runRetriever(rPFRetriever, textureTile.getPriority());
        } else {
            DownloadTask downloadTask = new DownloadTask(rPFServiceInstance, uRL, textureTile, this);
            this.getRequestQ().add(downloadTask);
        }
    }

    private static ByteBuffer createImage(RPFGenerator.RPFServiceInstance rPFServiceInstance, URL uRL) throws IOException {
        ByteBuffer byteBuffer = null;
        BufferedImage bufferedImage = rPFServiceInstance.serviceRequest(uRL);
        if (bufferedImage != null) {
            byteBuffer = DDSCompressor.compressImage(bufferedImage);
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            WWIO.saveBuffer(byteBuffer, file);
        }
    }

    private static class TileTask
    implements Runnable,
    Comparable<TileTask> {
        private final TextureTile tile;

        private TileTask(TextureTile textureTile) {
            this.tile = textureTile;
        }

        public final TextureTile getTile() {
            return this.tile;
        }

        @Override
        public void run() {
        }

        @Override
        public int compareTo(TileTask tileTask) {
            if (tileTask == null) {
                String string = Logging.getMessage("nullValue.RequestTaskIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.tile.getPriority() == tileTask.tile.getPriority() ? 0 : (this.tile.getPriority() < tileTask.tile.getPriority() ? -1 : 1);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TileTask tileTask = (TileTask)object;
            return !(this.tile == null ? tileTask.tile != null : !this.tile.equals(tileTask.tile));
        }

        public int hashCode() {
            return this.tile != null ? this.tile.hashCode() : 0;
        }

        public String toString() {
            return this.tile.getPath();
        }
    }

    private static class DownloadTask
    extends TileTask {
        private final RPFGenerator.RPFServiceInstance service;
        private final URL url;
        private final RPFTiledImageLayer layer;

        private DownloadTask(RPFGenerator.RPFServiceInstance rPFServiceInstance, URL uRL, TextureTile textureTile, RPFTiledImageLayer rPFTiledImageLayer) {
            super(textureTile);
            this.service = rPFServiceInstance;
            this.url = uRL;
            this.layer = rPFTiledImageLayer;
        }

        @Override
        public void run() {
            TextureTile textureTile = this.getTile();
            try {
                File file;
                ByteBuffer byteBuffer = RPFTiledImageLayer.createImage(this.service, this.url);
                if (byteBuffer != null && (file = WorldWind.getDataFileStore().newFile(textureTile.getPath())) != null) {
                    this.layer.saveBuffer(byteBuffer, file);
                }
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "layers.TextureLayer.ExceptionAttemptingToCreateTileImage", exception);
                this.layer.getLevels().markResourceAbsent(textureTile);
            }
        }
    }

    private static class DownloadPostProcessor
    extends AbstractRetrievalPostProcessor {
        private final TextureTile tile;
        private final RPFTiledImageLayer layer;

        public DownloadPostProcessor(TextureTile textureTile, RPFTiledImageLayer rPFTiledImageLayer) {
            this.tile = textureTile;
            this.layer = rPFTiledImageLayer;
        }

        @Override
        protected void markResourceAbsent() {
            this.layer.getLevels().markResourceAbsent(this.tile);
        }

        @Override
        protected Object getFileLock() {
            return this.layer.fileLock;
        }

        @Override
        protected File doGetOutputFile() {
            return WorldWind.getDataFileStore().newFile(this.tile.getPath());
        }

        @Override
        protected ByteBuffer handleSuccessfulRetrieval() {
            ByteBuffer byteBuffer = super.handleSuccessfulRetrieval();
            if (byteBuffer != null) {
                this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
            }
            return byteBuffer;
        }

        @Override
        protected boolean validateResponseCode() {
            if (this.getRetriever() instanceof RPFRetriever) {
                return ((RPFRetriever)this.getRetriever()).getResponseCode() == 1;
            }
            return super.validateResponseCode();
        }

        @Override
        protected ByteBuffer handleTextContent() throws IOException {
            this.markResourceAbsent();
            return super.handleTextContent();
        }
    }

    private static class RequestTask
    extends TileTask {
        private final RPFTiledImageLayer layer;

        private RequestTask(TextureTile textureTile, RPFTiledImageLayer rPFTiledImageLayer) {
            super(textureTile);
            this.layer = rPFTiledImageLayer;
        }

        @Override
        public void run() {
            TextureTile textureTile = this.getTile();
            URL uRL = WorldWind.getDataFileStore().findFile(textureTile.getPath(), false);
            if (uRL != null) {
                if (this.layer.loadTexture(textureTile, uRL)) {
                    this.layer.getLevels().unmarkResourceAbsent(textureTile);
                    this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    return;
                }
                WorldWind.getDataFileStore().removeFile(uRL);
                this.layer.getLevels().markResourceAbsent(textureTile);
                String string = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                Logging.logger().info(string);
            }
            this.layer.downloadTexture(textureTile);
        }
    }

    private static class URLBuilder
    implements TileUrlBuilder {
        public String URLTemplate = null;

        private URLBuilder() {
        }

        @Override
        public URL getURL(Tile tile, String string) throws MalformedURLException {
            StringBuffer stringBuffer;
            if (this.URLTemplate == null) {
                stringBuffer = new StringBuffer(tile.getLevel().getService());
                stringBuffer.append("dataset=");
                stringBuffer.append(tile.getLevel().getDataset());
                stringBuffer.append("&width=");
                stringBuffer.append(tile.getLevel().getTileWidth());
                stringBuffer.append("&height=");
                stringBuffer.append(tile.getLevel().getTileHeight());
                this.URLTemplate = stringBuffer.toString();
            } else {
                stringBuffer = new StringBuffer(this.URLTemplate);
            }
            Sector sector = tile.getSector();
            stringBuffer.append("&bbox=");
            stringBuffer.append(sector.getMinLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMinLatitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLatitude().getDegrees());
            stringBuffer.append("&");
            return new URL(stringBuffer.toString().replace(" ", "%20"));
        }
    }
}

