/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.formats.tiff.TiffIFDEntry;
import gov.nasa.worldwind.util.Logging;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

class TIFFIFDFactory {
    public static int MASK_USHORT = 65535;
    public static long MASK_UINT = 0xFFFFFFFFL;

    private TIFFIFDFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TiffIFDEntry create(FileChannel fileChannel, ByteOrder byteOrder) {
        if (null == fileChannel) {
            return null;
        }
        long l = 0L;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[12]).order(byteOrder);
        try {
            fileChannel.read(byteBuffer);
            byteBuffer.flip();
            int n = TIFFIFDFactory.getUnsignedShort(byteBuffer);
            int n2 = TIFFIFDFactory.getUnsignedShort(byteBuffer);
            long l2 = TIFFIFDFactory.getUnsignedInt(byteBuffer);
            if (n2 == 3 && l2 == 1L) {
                int n3 = TIFFIFDFactory.getUnsignedShort(byteBuffer);
                int n4 = TIFFIFDFactory.getUnsignedShort(byteBuffer);
                long l3 = (MASK_USHORT & n3) << 16 | MASK_USHORT & n4;
                TiffIFDEntry tiffIFDEntry = new TiffIFDEntry(n, n2, l3);
                return tiffIFDEntry;
            }
            if (l2 == 1L && (n2 == 4 || n2 == 11)) {
                long l4 = byteBuffer.getInt();
                TiffIFDEntry tiffIFDEntry = new TiffIFDEntry(n, n2, l4);
                return tiffIFDEntry;
            }
            long l5 = TIFFIFDFactory.getUnsignedInt(byteBuffer);
            int n5 = MASK_USHORT & (int)TIFFIFDFactory.calcSize(n2, l2);
            if ((long)n5 > 0L) {
                ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n5).order(byteOrder);
                l = fileChannel.position();
                fileChannel.position(l5);
                fileChannel.read(byteBuffer2);
                byteBuffer2.flip();
                fileChannel.position(l);
                l = 0L;
                TiffIFDEntry tiffIFDEntry = new TiffIFDEntry(n, n2, l2, l5, byteBuffer2);
                return tiffIFDEntry;
            }
            TiffIFDEntry tiffIFDEntry = new TiffIFDEntry(n, n2, l2, l5);
            return tiffIFDEntry;
        }
        catch (Exception exception) {
            Logging.logger().finest(exception.getMessage());
        }
        finally {
            if (l != 0L && fileChannel != null) {
                try {
                    fileChannel.position(l);
                }
                catch (Exception exception) {
                    Logging.logger().finest(exception.getMessage());
                }
            }
        }
        return null;
    }

    private static long calcSize(int n, long l) {
        switch (n) {
            case 1: 
            case 2: 
            case 6: {
                return l;
            }
            case 3: 
            case 8: {
                return l * 2L;
            }
            case 4: 
            case 9: {
                return l * 4L;
            }
            case 11: {
                return l * 4L;
            }
            case 12: {
                return l * 8L;
            }
            case 5: 
            case 10: {
                return l * 8L;
            }
        }
        return 0L;
    }

    private static int getUnsignedShort(ByteBuffer byteBuffer) {
        return MASK_USHORT & byteBuffer.getShort();
    }

    private static long getUnsignedInt(ByteBuffer byteBuffer) {
        return MASK_UINT & (long)byteBuffer.getInt();
    }
}

