/*
 * Decompiled with CFR 0.152.
 */
package org.jocl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jocl.BuildProgramFunction;
import org.jocl.CLException;
import org.jocl.CreateContextFunction;
import org.jocl.EnqueueNativeKernelFunction;
import org.jocl.LibUtils;
import org.jocl.NativePointerObject;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_command_queue;
import org.jocl.cl_context;
import org.jocl.cl_context_properties;
import org.jocl.cl_device_id;
import org.jocl.cl_event;
import org.jocl.cl_image_format;
import org.jocl.cl_kernel;
import org.jocl.cl_mem;
import org.jocl.cl_platform_id;
import org.jocl.cl_program;
import org.jocl.cl_sampler;

public final class CL {
    public static final int CL_VERSION_1_0 = 1;
    public static final int CL_CHAR_BIT = 8;
    public static final int CL_SCHAR_MAX = 127;
    public static final int CL_SCHAR_MIN = -128;
    public static final int CL_CHAR_MAX = 127;
    public static final int CL_CHAR_MIN = -128;
    public static final int CL_UCHAR_MAX = 255;
    public static final int CL_SHRT_MAX = Short.MAX_VALUE;
    public static final int CL_SHRT_MIN = Short.MIN_VALUE;
    public static final int CL_USHRT_MAX = 65535;
    public static final int CL_INT_MAX = Integer.MAX_VALUE;
    public static final int CL_INT_MIN = Integer.MIN_VALUE;
    public static final long CL_UINT_MAX = -1L;
    public static final long CL_LONG_MAX = Long.MAX_VALUE;
    public static final long CL_LONG_MIN = Long.MIN_VALUE;
    public static final long CL_ULONG_MAX = -1L;
    public static final int CL_FLT_DIG = 6;
    public static final int CL_FLT_MANT_DIG = 24;
    public static final int CL_FLT_MAX_10_EXP = 38;
    public static final int CL_FLT_MAX_EXP = 128;
    public static final int CL_FLT_MIN_10_EXP = -37;
    public static final int CL_FLT_MIN_EXP = -125;
    public static final int CL_FLT_RADIX = 2;
    public static final float CL_FLT_MAX = Float.MAX_VALUE;
    public static final float CL_FLT_MIN = Float.MIN_NORMAL;
    public static final float CL_FLT_EPSILON = 1.1920929E-7f;
    public static final int CL_DBL_DIG = 15;
    public static final int CL_DBL_MANT_DIG = 53;
    public static final int CL_DBL_MAX_10_EXP = 308;
    public static final int CL_DBL_MAX_EXP = 1024;
    public static final int CL_DBL_MIN_10_EXP = -307;
    public static final int CL_DBL_MIN_EXP = -1021;
    public static final int CL_DBL_RADIX = 2;
    public static final double CL_DBL_MAX = Double.MAX_VALUE;
    public static final double CL_DBL_MIN = Double.MIN_NORMAL;
    public static final double CL_DBL_EPSILON = 2.220446049250313E-16;
    public static final int CL_SUCCESS = 0;
    public static final int CL_DEVICE_NOT_FOUND = -1;
    public static final int CL_DEVICE_NOT_AVAILABLE = -2;
    public static final int CL_COMPILER_NOT_AVAILABLE = -3;
    public static final int CL_MEM_OBJECT_ALLOCATION_FAILURE = -4;
    public static final int CL_OUT_OF_RESOURCES = -5;
    public static final int CL_OUT_OF_HOST_MEMORY = -6;
    public static final int CL_PROFILING_INFO_NOT_AVAILABLE = -7;
    public static final int CL_MEM_COPY_OVERLAP = -8;
    public static final int CL_IMAGE_FORMAT_MISMATCH = -9;
    public static final int CL_IMAGE_FORMAT_NOT_SUPPORTED = -10;
    public static final int CL_BUILD_PROGRAM_FAILURE = -11;
    public static final int CL_MAP_FAILURE = -12;
    public static final int CL_INVALID_VALUE = -30;
    public static final int CL_INVALID_DEVICE_TYPE = -31;
    public static final int CL_INVALID_PLATFORM = -32;
    public static final int CL_INVALID_DEVICE = -33;
    public static final int CL_INVALID_CONTEXT = -34;
    public static final int CL_INVALID_QUEUE_PROPERTIES = -35;
    public static final int CL_INVALID_COMMAND_QUEUE = -36;
    public static final int CL_INVALID_HOST_PTR = -37;
    public static final int CL_INVALID_MEM_OBJECT = -38;
    public static final int CL_INVALID_IMAGE_FORMAT_DESCRIPTOR = -39;
    public static final int CL_INVALID_IMAGE_SIZE = -40;
    public static final int CL_INVALID_SAMPLER = -41;
    public static final int CL_INVALID_BINARY = -42;
    public static final int CL_INVALID_BUILD_OPTIONS = -43;
    public static final int CL_INVALID_PROGRAM = -44;
    public static final int CL_INVALID_PROGRAM_EXECUTABLE = -45;
    public static final int CL_INVALID_KERNEL_NAME = -46;
    public static final int CL_INVALID_KERNEL_DEFINITION = -47;
    public static final int CL_INVALID_KERNEL = -48;
    public static final int CL_INVALID_ARG_INDEX = -49;
    public static final int CL_INVALID_ARG_VALUE = -50;
    public static final int CL_INVALID_ARG_SIZE = -51;
    public static final int CL_INVALID_KERNEL_ARGS = -52;
    public static final int CL_INVALID_WORK_DIMENSION = -53;
    public static final int CL_INVALID_WORK_GROUP_SIZE = -54;
    public static final int CL_INVALID_WORK_ITEM_SIZE = -55;
    public static final int CL_INVALID_GLOBAL_OFFSET = -56;
    public static final int CL_INVALID_EVENT_WAIT_LIST = -57;
    public static final int CL_INVALID_EVENT = -58;
    public static final int CL_INVALID_OPERATION = -59;
    public static final int CL_INVALID_GL_OBJECT = -60;
    public static final int CL_INVALID_BUFFER_SIZE = -61;
    public static final int CL_INVALID_MIP_LEVEL = -62;
    public static final int CL_INVALID_GLOBAL_WORK_SIZE = -63;
    public static final int CL_JOCL_INTERNAL_ERROR = -64;
    public static final int CL_INVALID_GL_SHAREGROUP_REFERENCE_KHR = -1000;
    public static final boolean CL_TRUE = true;
    public static final boolean CL_FALSE = false;
    public static final int CL_PLATFORM_PROFILE = 2304;
    public static final int CL_PLATFORM_VERSION = 2305;
    public static final int CL_PLATFORM_NAME = 2306;
    public static final int CL_PLATFORM_VENDOR = 2307;
    public static final int CL_PLATFORM_EXTENSIONS = 2308;
    public static final long CL_DEVICE_TYPE_DEFAULT = 1L;
    public static final long CL_DEVICE_TYPE_CPU = 2L;
    public static final long CL_DEVICE_TYPE_GPU = 4L;
    public static final long CL_DEVICE_TYPE_ACCELERATOR = 8L;
    public static final long CL_DEVICE_TYPE_ALL = -1L;
    public static final int CL_DEVICE_TYPE = 4096;
    public static final int CL_DEVICE_VENDOR_ID = 4097;
    public static final int CL_DEVICE_MAX_COMPUTE_UNITS = 4098;
    public static final int CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS = 4099;
    public static final int CL_DEVICE_MAX_WORK_GROUP_SIZE = 4100;
    public static final int CL_DEVICE_MAX_WORK_ITEM_SIZES = 4101;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR = 4102;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT = 4103;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_INT = 4104;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG = 4105;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT = 4106;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE = 4107;
    public static final int CL_DEVICE_MAX_CLOCK_FREQUENCY = 4108;
    public static final int CL_DEVICE_ADDRESS_BITS = 4109;
    public static final int CL_DEVICE_MAX_READ_IMAGE_ARGS = 4110;
    public static final int CL_DEVICE_MAX_WRITE_IMAGE_ARGS = 4111;
    public static final int CL_DEVICE_MAX_MEM_ALLOC_SIZE = 4112;
    public static final int CL_DEVICE_IMAGE2D_MAX_WIDTH = 4113;
    public static final int CL_DEVICE_IMAGE2D_MAX_HEIGHT = 4114;
    public static final int CL_DEVICE_IMAGE3D_MAX_WIDTH = 4115;
    public static final int CL_DEVICE_IMAGE3D_MAX_HEIGHT = 4116;
    public static final int CL_DEVICE_IMAGE3D_MAX_DEPTH = 4117;
    public static final int CL_DEVICE_IMAGE_SUPPORT = 4118;
    public static final int CL_DEVICE_MAX_PARAMETER_SIZE = 4119;
    public static final int CL_DEVICE_MAX_SAMPLERS = 4120;
    public static final int CL_DEVICE_MEM_BASE_ADDR_ALIGN = 4121;
    public static final int CL_DEVICE_MIN_DATA_TYPE_ALIGN_SIZE = 4122;
    public static final int CL_DEVICE_SINGLE_FP_CONFIG = 4123;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_TYPE = 4124;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE = 4125;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_SIZE = 4126;
    public static final int CL_DEVICE_GLOBAL_MEM_SIZE = 4127;
    public static final int CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE = 4128;
    public static final int CL_DEVICE_MAX_CONSTANT_ARGS = 4129;
    public static final int CL_DEVICE_LOCAL_MEM_TYPE = 4130;
    public static final int CL_DEVICE_LOCAL_MEM_SIZE = 4131;
    public static final int CL_DEVICE_ERROR_CORRECTION_SUPPORT = 4132;
    public static final int CL_DEVICE_PROFILING_TIMER_RESOLUTION = 4133;
    public static final int CL_DEVICE_ENDIAN_LITTLE = 4134;
    public static final int CL_DEVICE_AVAILABLE = 4135;
    public static final int CL_DEVICE_COMPILER_AVAILABLE = 4136;
    public static final int CL_DEVICE_EXECUTION_CAPABILITIES = 4137;
    public static final int CL_DEVICE_QUEUE_PROPERTIES = 4138;
    public static final int CL_DEVICE_NAME = 4139;
    public static final int CL_DEVICE_VENDOR = 4140;
    public static final int CL_DRIVER_VERSION = 4141;
    public static final int CL_DEVICE_PROFILE = 4142;
    public static final int CL_DEVICE_VERSION = 4143;
    public static final int CL_DEVICE_EXTENSIONS = 4144;
    public static final int CL_DEVICE_PLATFORM = 4145;
    public static final long CL_DEVICE_ADDRESS_32_BITS = 1L;
    public static final long CL_DEVICE_ADDRESS_64_BITS = 2L;
    public static final long CL_FP_DENORM = 1L;
    public static final long CL_FP_INF_NAN = 2L;
    public static final long CL_FP_ROUND_TO_NEAREST = 4L;
    public static final long CL_FP_ROUND_TO_ZERO = 8L;
    public static final long CL_FP_ROUND_TO_INF = 16L;
    public static final long CL_FP_FMA = 32L;
    public static final int CL_NONE = 0;
    public static final int CL_READ_ONLY_CACHE = 1;
    public static final int CL_READ_WRITE_CACHE = 2;
    public static final int CL_LOCAL = 1;
    public static final int CL_GLOBAL = 2;
    public static final long CL_EXEC_KERNEL = 1L;
    public static final long CL_EXEC_NATIVE_KERNEL = 2L;
    public static final long CL_QUEUE_OUT_OF_ORDER_EXEC_MODE_ENABLE = 1L;
    public static final long CL_QUEUE_PROFILING_ENABLE = 2L;
    public static final int CL_CONTEXT_REFERENCE_COUNT = 4224;
    public static final int CL_CONTEXT_DEVICES = 4225;
    public static final int CL_CONTEXT_PROPERTIES = 4226;
    public static final int CL_CONTEXT_PLATFORM = 4228;
    public static final int CL_QUEUE_CONTEXT = 4240;
    public static final int CL_QUEUE_DEVICE = 4241;
    public static final int CL_QUEUE_REFERENCE_COUNT = 4242;
    public static final int CL_QUEUE_PROPERTIES = 4243;
    public static final long CL_MEM_READ_WRITE = 1L;
    public static final long CL_MEM_WRITE_ONLY = 2L;
    public static final long CL_MEM_READ_ONLY = 4L;
    public static final long CL_MEM_USE_HOST_PTR = 8L;
    public static final long CL_MEM_ALLOC_HOST_PTR = 16L;
    public static final long CL_MEM_COPY_HOST_PTR = 32L;
    public static final int CL_R = 4272;
    public static final int CL_A = 4273;
    public static final int CL_RG = 4274;
    public static final int CL_RA = 4275;
    public static final int CL_RGB = 4276;
    public static final int CL_RGBA = 4277;
    public static final int CL_BGRA = 4278;
    public static final int CL_ARGB = 4279;
    public static final int CL_INTENSITY = 4280;
    public static final int CL_LUMINANCE = 4281;
    public static final int CL_SNORM_INT8 = 4304;
    public static final int CL_SNORM_INT16 = 4305;
    public static final int CL_UNORM_INT8 = 4306;
    public static final int CL_UNORM_INT16 = 4307;
    public static final int CL_UNORM_SHORT_565 = 4308;
    public static final int CL_UNORM_SHORT_555 = 4309;
    public static final int CL_UNORM_INT_101010 = 4310;
    public static final int CL_SIGNED_INT8 = 4311;
    public static final int CL_SIGNED_INT16 = 4312;
    public static final int CL_SIGNED_INT32 = 4313;
    public static final int CL_UNSIGNED_INT8 = 4314;
    public static final int CL_UNSIGNED_INT16 = 4315;
    public static final int CL_UNSIGNED_INT32 = 4316;
    public static final int CL_HALF_FLOAT = 4317;
    public static final int CL_FLOAT = 4318;
    public static final int CL_MEM_OBJECT_BUFFER = 4336;
    public static final int CL_MEM_OBJECT_IMAGE2D = 4337;
    public static final int CL_MEM_OBJECT_IMAGE3D = 4338;
    public static final int CL_MEM_TYPE = 4352;
    public static final int CL_MEM_FLAGS = 4353;
    public static final int CL_MEM_SIZE = 4354;
    public static final int CL_MEM_HOST_PTR = 4355;
    public static final int CL_MEM_MAP_COUNT = 4356;
    public static final int CL_MEM_REFERENCE_COUNT = 4357;
    public static final int CL_MEM_CONTEXT = 4358;
    public static final int CL_IMAGE_FORMAT = 4368;
    public static final int CL_IMAGE_ELEMENT_SIZE = 4369;
    public static final int CL_IMAGE_ROW_PITCH = 4370;
    public static final int CL_IMAGE_SLICE_PITCH = 4371;
    public static final int CL_IMAGE_WIDTH = 4372;
    public static final int CL_IMAGE_HEIGHT = 4373;
    public static final int CL_IMAGE_DEPTH = 4374;
    public static final int CL_ADDRESS_NONE = 4400;
    public static final int CL_ADDRESS_CLAMP_TO_EDGE = 4401;
    public static final int CL_ADDRESS_CLAMP = 4402;
    public static final int CL_ADDRESS_REPEAT = 4403;
    public static final int CL_FILTER_NEAREST = 4416;
    public static final int CL_FILTER_LINEAR = 4417;
    public static final int CL_SAMPLER_REFERENCE_COUNT = 4432;
    public static final int CL_SAMPLER_CONTEXT = 4433;
    public static final int CL_SAMPLER_NORMALIZED_COORDS = 4434;
    public static final int CL_SAMPLER_ADDRESSING_MODE = 4435;
    public static final int CL_SAMPLER_FILTER_MODE = 4436;
    public static final long CL_MAP_READ = 1L;
    public static final long CL_MAP_WRITE = 2L;
    public static final int CL_PROGRAM_REFERENCE_COUNT = 4448;
    public static final int CL_PROGRAM_CONTEXT = 4449;
    public static final int CL_PROGRAM_NUM_DEVICES = 4450;
    public static final int CL_PROGRAM_DEVICES = 4451;
    public static final int CL_PROGRAM_SOURCE = 4452;
    public static final int CL_PROGRAM_BINARY_SIZES = 4453;
    public static final int CL_PROGRAM_BINARIES = 4454;
    public static final int CL_PROGRAM_BUILD_STATUS = 4481;
    public static final int CL_PROGRAM_BUILD_OPTIONS = 4482;
    public static final int CL_PROGRAM_BUILD_LOG = 4483;
    public static final int CL_BUILD_SUCCESS = 0;
    public static final int CL_BUILD_NONE = -1;
    public static final int CL_BUILD_ERROR = -2;
    public static final int CL_BUILD_IN_PROGRESS = -3;
    public static final int CL_KERNEL_FUNCTION_NAME = 4496;
    public static final int CL_KERNEL_NUM_ARGS = 4497;
    public static final int CL_KERNEL_REFERENCE_COUNT = 4498;
    public static final int CL_KERNEL_CONTEXT = 4499;
    public static final int CL_KERNEL_PROGRAM = 4500;
    public static final int CL_KERNEL_WORK_GROUP_SIZE = 4528;
    public static final int CL_KERNEL_COMPILE_WORK_GROUP_SIZE = 4529;
    public static final int CL_KERNEL_LOCAL_MEM_SIZE = 4530;
    public static final int CL_EVENT_COMMAND_QUEUE = 4560;
    public static final int CL_EVENT_COMMAND_TYPE = 4561;
    public static final int CL_EVENT_REFERENCE_COUNT = 4562;
    public static final int CL_EVENT_COMMAND_EXECUTION_STATUS = 4563;
    public static final int CL_COMMAND_NDRANGE_KERNEL = 4592;
    public static final int CL_COMMAND_TASK = 4593;
    public static final int CL_COMMAND_NATIVE_KERNEL = 4594;
    public static final int CL_COMMAND_READ_BUFFER = 4595;
    public static final int CL_COMMAND_WRITE_BUFFER = 4596;
    public static final int CL_COMMAND_COPY_BUFFER = 4597;
    public static final int CL_COMMAND_READ_IMAGE = 4598;
    public static final int CL_COMMAND_WRITE_IMAGE = 4599;
    public static final int CL_COMMAND_COPY_IMAGE = 4600;
    public static final int CL_COMMAND_COPY_IMAGE_TO_BUFFER = 4601;
    public static final int CL_COMMAND_COPY_BUFFER_TO_IMAGE = 4602;
    public static final int CL_COMMAND_MAP_BUFFER = 4603;
    public static final int CL_COMMAND_MAP_IMAGE = 4604;
    public static final int CL_COMMAND_UNMAP_MEM_OBJECT = 4605;
    public static final int CL_COMMAND_MARKER = 4606;
    public static final int CL_COMMAND_ACQUIRE_GL_OBJECTS = 4607;
    public static final int CL_COMMAND_RELEASE_GL_OBJECTS = 4608;
    public static final int CL_COMPLETE = 0;
    public static final int CL_RUNNING = 1;
    public static final int CL_SUBMITTED = 2;
    public static final int CL_QUEUED = 3;
    public static final int CL_PROFILING_COMMAND_QUEUED = 4736;
    public static final int CL_PROFILING_COMMAND_SUBMIT = 4737;
    public static final int CL_PROFILING_COMMAND_START = 4738;
    public static final int CL_PROFILING_COMMAND_END = 4739;
    public static final int CL_GL_OBJECT_BUFFER = 8192;
    public static final int CL_GL_OBJECT_TEXTURE2D = 8193;
    public static final int CL_GL_OBJECT_TEXTURE3D = 8194;
    public static final int CL_GL_OBJECT_RENDERBUFFER = 8195;
    public static final int CL_GL_TEXTURE_TARGET = 8196;
    public static final int CL_GL_MIPMAP_LEVEL = 8197;
    public static final int CL_CURRENT_DEVICE_FOR_GL_CONTEXT_KHR = 8198;
    public static final int CL_DEVICES_FOR_GL_CONTEXT_KHR = 8199;
    public static final int CL_GL_CONTEXT_KHR = 8200;
    public static final int CL_EGL_DISPLAY_KHR = 8201;
    public static final int CL_GLX_DISPLAY_KHR = 8202;
    public static final int CL_WGL_HDC_KHR = 8203;
    public static final int CL_CGL_SHAREGROUP_KHR = 8204;
    private static volatile boolean initialized = false;
    private static boolean exceptionsEnabled = false;
    private static Thread memoryManagementThread = null;
    private static Map<WeakReference<ByteBuffer>, Pointer> alignedByteBufferMap = new HashMap<WeakReference<ByteBuffer>, Pointer>();
    private static ReferenceQueue<ByteBuffer> alignedByteBufferReferenceQueue = new ReferenceQueue();
    private static ThreadFactory daemonThreadFactory = new ThreadFactory(){
        private long currentID = 0L;

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "AsyncOpThread-" + this.currentID++);
            thread.setPriority(1);
            thread.setDaemon(true);
            return thread;
        }
    };
    private static Executor referenceReleaseExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), daemonThreadFactory);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CLException(CL.stringFor_errorCode(result));
        }
        return result;
    }

    public static String stringFor_errorCode(int n) {
        switch (n) {
            case 0: {
                return "CL_SUCCESS";
            }
            case -1: {
                return "CL_DEVICE_NOT_FOUND";
            }
            case -2: {
                return "CL_DEVICE_NOT_AVAILABLE";
            }
            case -3: {
                return "CL_COMPILER_NOT_AVAILABLE";
            }
            case -4: {
                return "CL_MEM_OBJECT_ALLOCATION_FAILURE";
            }
            case -5: {
                return "CL_OUT_OF_RESOURCES";
            }
            case -6: {
                return "CL_OUT_OF_HOST_MEMORY";
            }
            case -7: {
                return "CL_PROFILING_INFO_NOT_AVAILABLE";
            }
            case -8: {
                return "CL_MEM_COPY_OVERLAP";
            }
            case -9: {
                return "CL_IMAGE_FORMAT_MISMATCH";
            }
            case -10: {
                return "CL_IMAGE_FORMAT_NOT_SUPPORTED";
            }
            case -11: {
                return "CL_BUILD_PROGRAM_FAILURE";
            }
            case -12: {
                return "CL_MAP_FAILURE";
            }
            case -30: {
                return "CL_INVALID_VALUE";
            }
            case -31: {
                return "CL_INVALID_DEVICE_TYPE";
            }
            case -32: {
                return "CL_INVALID_PLATFORM";
            }
            case -33: {
                return "CL_INVALID_DEVICE";
            }
            case -34: {
                return "CL_INVALID_CONTEXT";
            }
            case -35: {
                return "CL_INVALID_QUEUE_PROPERTIES";
            }
            case -36: {
                return "CL_INVALID_COMMAND_QUEUE";
            }
            case -37: {
                return "CL_INVALID_HOST_PTR";
            }
            case -38: {
                return "CL_INVALID_MEM_OBJECT";
            }
            case -39: {
                return "CL_INVALID_IMAGE_FORMAT_DESCRIPTOR";
            }
            case -40: {
                return "CL_INVALID_IMAGE_SIZE";
            }
            case -41: {
                return "CL_INVALID_SAMPLER";
            }
            case -42: {
                return "CL_INVALID_BINARY";
            }
            case -43: {
                return "CL_INVALID_BUILD_OPTIONS";
            }
            case -44: {
                return "CL_INVALID_PROGRAM";
            }
            case -45: {
                return "CL_INVALID_PROGRAM_EXECUTABLE";
            }
            case -46: {
                return "CL_INVALID_KERNEL_NAME";
            }
            case -47: {
                return "CL_INVALID_KERNEL_DEFINITION";
            }
            case -48: {
                return "CL_INVALID_KERNEL";
            }
            case -49: {
                return "CL_INVALID_ARG_INDEX";
            }
            case -50: {
                return "CL_INVALID_ARG_VALUE";
            }
            case -51: {
                return "CL_INVALID_ARG_SIZE";
            }
            case -52: {
                return "CL_INVALID_KERNEL_ARGS";
            }
            case -53: {
                return "CL_INVALID_WORK_DIMENSION";
            }
            case -54: {
                return "CL_INVALID_WORK_GROUP_SIZE";
            }
            case -55: {
                return "CL_INVALID_WORK_ITEM_SIZE";
            }
            case -56: {
                return "CL_INVALID_GLOBAL_OFFSET";
            }
            case -57: {
                return "CL_INVALID_EVENT_WAIT_LIST";
            }
            case -58: {
                return "CL_INVALID_EVENT";
            }
            case -59: {
                return "CL_INVALID_OPERATION";
            }
            case -60: {
                return "CL_INVALID_GL_OBJECT";
            }
            case -61: {
                return "CL_INVALID_BUFFER_SIZE";
            }
            case -62: {
                return "CL_INVALID_MIP_LEVEL";
            }
            case -63: {
                return "CL_INVALID_GLOBAL_WORK_SIZE";
            }
            case -64: {
                return "CL_JOCL_INTERNAL_ERROR";
            }
            case -1000: {
                return "CL_INVALID_GL_SHAREGROUP_REFERENCE_KHR";
            }
            case 1: {
                return "Error in program source code";
            }
        }
        return "INVALID error code: " + n;
    }

    public static String stringFor_cl_platform_info(int n) {
        switch (n) {
            case 2304: {
                return "CL_PLATFORM_PROFILE";
            }
            case 2305: {
                return "CL_PLATFORM_VERSION";
            }
            case 2306: {
                return "CL_PLATFORM_NAME";
            }
            case 2307: {
                return "CL_PLATFORM_VENDOR";
            }
            case 2308: {
                return "CL_PLATFORM_EXTENSIONS";
            }
        }
        return "INVALID cl_platform_info: " + n;
    }

    public static String stringFor_cl_device_info(int n) {
        switch (n) {
            case 4096: {
                return "CL_DEVICE_TYPE";
            }
            case 4097: {
                return "CL_DEVICE_VENDOR_ID";
            }
            case 4098: {
                return "CL_DEVICE_MAX_COMPUTE_UNITS";
            }
            case 4099: {
                return "CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS";
            }
            case 4100: {
                return "CL_DEVICE_MAX_WORK_GROUP_SIZE";
            }
            case 4101: {
                return "CL_DEVICE_MAX_WORK_ITEM_SIZES";
            }
            case 4102: {
                return "CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR";
            }
            case 4103: {
                return "CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT";
            }
            case 4104: {
                return "CL_DEVICE_PREFERRED_VECTOR_WIDTH_INT";
            }
            case 4105: {
                return "CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG";
            }
            case 4106: {
                return "CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT";
            }
            case 4107: {
                return "CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE";
            }
            case 4108: {
                return "CL_DEVICE_MAX_CLOCK_FREQUENCY";
            }
            case 4109: {
                return "CL_DEVICE_ADDRESS_BITS";
            }
            case 4110: {
                return "CL_DEVICE_MAX_READ_IMAGE_ARGS";
            }
            case 4111: {
                return "CL_DEVICE_MAX_WRITE_IMAGE_ARGS";
            }
            case 4112: {
                return "CL_DEVICE_MAX_MEM_ALLOC_SIZE";
            }
            case 4113: {
                return "CL_DEVICE_IMAGE2D_MAX_WIDTH";
            }
            case 4114: {
                return "CL_DEVICE_IMAGE2D_MAX_HEIGHT";
            }
            case 4115: {
                return "CL_DEVICE_IMAGE3D_MAX_WIDTH";
            }
            case 4116: {
                return "CL_DEVICE_IMAGE3D_MAX_HEIGHT";
            }
            case 4117: {
                return "CL_DEVICE_IMAGE3D_MAX_DEPTH";
            }
            case 4118: {
                return "CL_DEVICE_IMAGE_SUPPORT";
            }
            case 4119: {
                return "CL_DEVICE_MAX_PARAMETER_SIZE";
            }
            case 4120: {
                return "CL_DEVICE_MAX_SAMPLERS";
            }
            case 4121: {
                return "CL_DEVICE_MEM_BASE_ADDR_ALIGN";
            }
            case 4122: {
                return "CL_DEVICE_MIN_DATA_TYPE_ALIGN_SIZE";
            }
            case 4123: {
                return "CL_DEVICE_SINGLE_FP_CONFIG";
            }
            case 4124: {
                return "CL_DEVICE_GLOBAL_MEM_CACHE_TYPE";
            }
            case 4125: {
                return "CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE";
            }
            case 4126: {
                return "CL_DEVICE_GLOBAL_MEM_CACHE_SIZE";
            }
            case 4127: {
                return "CL_DEVICE_GLOBAL_MEM_SIZE";
            }
            case 4128: {
                return "CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE";
            }
            case 4129: {
                return "CL_DEVICE_MAX_CONSTANT_ARGS";
            }
            case 4130: {
                return "CL_DEVICE_LOCAL_MEM_TYPE";
            }
            case 4131: {
                return "CL_DEVICE_LOCAL_MEM_SIZE";
            }
            case 4132: {
                return "CL_DEVICE_ERROR_CORRECTION_SUPPORT";
            }
            case 4133: {
                return "CL_DEVICE_PROFILING_TIMER_RESOLUTION";
            }
            case 4134: {
                return "CL_DEVICE_ENDIAN_LITTLE";
            }
            case 4135: {
                return "CL_DEVICE_AVAILABLE";
            }
            case 4136: {
                return "CL_DEVICE_COMPILER_AVAILABLE";
            }
            case 4137: {
                return "CL_DEVICE_EXECUTION_CAPABILITIES";
            }
            case 4138: {
                return "CL_DEVICE_QUEUE_PROPERTIES";
            }
            case 4139: {
                return "CL_DEVICE_NAME";
            }
            case 4140: {
                return "CL_DEVICE_VENDOR";
            }
            case 4141: {
                return "CL_DRIVER_VERSION";
            }
            case 4142: {
                return "CL_DEVICE_PROFILE";
            }
            case 4143: {
                return "CL_DEVICE_VERSION";
            }
            case 4144: {
                return "CL_DEVICE_EXTENSIONS";
            }
            case 4145: {
                return "CL_DEVICE_PLATFORM";
            }
        }
        return "INVALID cl_device_info: " + n;
    }

    public static String stringFor_cl_device_mem_cache_type(int n) {
        switch (n) {
            case 0: {
                return "CL_NONE";
            }
            case 1: {
                return "CL_READ_ONLY_CACHE";
            }
            case 2: {
                return "CL_READ_WRITE_CACHE";
            }
        }
        return "INVALID cl_device_mem_cache_type: " + n;
    }

    public static String stringFor_cl_device_local_mem_type(int n) {
        switch (n) {
            case 1: {
                return "CL_LOCAL";
            }
            case 2: {
                return "CL_GLOBAL";
            }
        }
        return "INVALID cl_device_local_mem_type: " + n;
    }

    public static String stringFor_cl_context_info(int n) {
        switch (n) {
            case 4224: {
                return "CL_CONTEXT_REFERENCE_COUNT";
            }
            case 4225: {
                return "CL_CONTEXT_DEVICES";
            }
            case 4226: {
                return "CL_CONTEXT_PROPERTIES";
            }
        }
        return "INVALID cl_context_info: " + n;
    }

    public static String stringFor_cl_context_properties(int n) {
        switch (n) {
            case 4228: {
                return "CL_CONTEXT_PLATFORM";
            }
            case 8200: {
                return "CL_GL_CONTEXT_KHR";
            }
            case 8201: {
                return "CL_EGL_DISPLAY_KHR";
            }
            case 8202: {
                return "CL_GLX_DISPLAY_KHR";
            }
            case 8203: {
                return "CL_WGL_HDC_KHR";
            }
            case 8204: {
                return "CL_CGL_SHAREGROUP_KHR";
            }
        }
        return "INVALID cl_context_properties: " + n;
    }

    public static String stringFor_cl_command_queue_info(int n) {
        switch (n) {
            case 4240: {
                return "CL_QUEUE_CONTEXT";
            }
            case 4241: {
                return "CL_QUEUE_DEVICE";
            }
            case 4242: {
                return "CL_QUEUE_REFERENCE_COUNT";
            }
            case 4243: {
                return "CL_QUEUE_PROPERTIES";
            }
        }
        return "INVALID cl_command_queue_info: " + n;
    }

    public static String stringFor_cl_channel_order(int n) {
        switch (n) {
            case 4272: {
                return "CL_R";
            }
            case 4273: {
                return "CL_A";
            }
            case 4274: {
                return "CL_RG";
            }
            case 4275: {
                return "CL_RA";
            }
            case 4276: {
                return "CL_RGB";
            }
            case 4277: {
                return "CL_RGBA";
            }
            case 4278: {
                return "CL_BGRA";
            }
            case 4279: {
                return "CL_ARGB";
            }
            case 4280: {
                return "CL_INTENSITY";
            }
            case 4281: {
                return "CL_LUMINANCE";
            }
        }
        return "INVALID cl_channel_order: " + n;
    }

    public static String stringFor_cl_channel_type(int n) {
        switch (n) {
            case 4304: {
                return "CL_SNORM_INT8";
            }
            case 4305: {
                return "CL_SNORM_INT16";
            }
            case 4306: {
                return "CL_UNORM_INT8";
            }
            case 4307: {
                return "CL_UNORM_INT16";
            }
            case 4308: {
                return "CL_UNORM_SHORT_565";
            }
            case 4309: {
                return "CL_UNORM_SHORT_555";
            }
            case 4310: {
                return "CL_UNORM_INT_101010";
            }
            case 4311: {
                return "CL_SIGNED_INT8";
            }
            case 4312: {
                return "CL_SIGNED_INT16";
            }
            case 4313: {
                return "CL_SIGNED_INT32";
            }
            case 4314: {
                return "CL_UNSIGNED_INT8";
            }
            case 4315: {
                return "CL_UNSIGNED_INT16";
            }
            case 4316: {
                return "CL_UNSIGNED_INT32";
            }
            case 4317: {
                return "CL_HALF_FLOAT";
            }
            case 4318: {
                return "CL_FLOAT";
            }
        }
        return "INVALID cl_channel_type: " + n;
    }

    public static String stringFor_cl_mem_object_type(int n) {
        switch (n) {
            case 4336: {
                return "CL_MEM_OBJECT_BUFFER";
            }
            case 4337: {
                return "CL_MEM_OBJECT_IMAGE2D";
            }
            case 4338: {
                return "CL_MEM_OBJECT_IMAGE3D";
            }
        }
        return "INVALID cl_mem_object_type: " + n;
    }

    public static String stringFor_cl_mem_info(int n) {
        switch (n) {
            case 4352: {
                return "CL_MEM_TYPE";
            }
            case 4353: {
                return "CL_MEM_FLAGS";
            }
            case 4354: {
                return "CL_MEM_SIZE";
            }
            case 4355: {
                return "CL_MEM_HOST_PTR";
            }
            case 4356: {
                return "CL_MEM_MAP_COUNT";
            }
            case 4357: {
                return "CL_MEM_REFERENCE_COUNT";
            }
            case 4358: {
                return "CL_MEM_CONTEXT";
            }
        }
        return "INVALID cl_mem_info: " + n;
    }

    public static String stringFor_cl_image_info(int n) {
        switch (n) {
            case 4368: {
                return "CL_IMAGE_FORMAT";
            }
            case 4369: {
                return "CL_IMAGE_ELEMENT_SIZE";
            }
            case 4370: {
                return "CL_IMAGE_ROW_PITCH";
            }
            case 4371: {
                return "CL_IMAGE_SLICE_PITCH";
            }
            case 4372: {
                return "CL_IMAGE_WIDTH";
            }
            case 4373: {
                return "CL_IMAGE_HEIGHT";
            }
            case 4374: {
                return "CL_IMAGE_DEPTH";
            }
        }
        return "INVALID cl_image_info: " + n;
    }

    public static String stringFor_cl_addressing_mode(int n) {
        switch (n) {
            case 4400: {
                return "CL_ADDRESS_NONE";
            }
            case 4401: {
                return "CL_ADDRESS_CLAMP_TO_EDGE";
            }
            case 4402: {
                return "CL_ADDRESS_CLAMP";
            }
            case 4403: {
                return "CL_ADDRESS_REPEAT";
            }
        }
        return "INVALID cl_addressing_mode: " + n;
    }

    public static String stringFor_cl_filter_mode(int n) {
        switch (n) {
            case 4416: {
                return "CL_FILTER_NEAREST";
            }
            case 4417: {
                return "CL_FILTER_LINEAR";
            }
        }
        return "INVALID cl_filter_mode: " + n;
    }

    public static String stringFor_cl_sampler_info(int n) {
        switch (n) {
            case 4432: {
                return "CL_SAMPLER_REFERENCE_COUNT";
            }
            case 4433: {
                return "CL_SAMPLER_CONTEXT";
            }
            case 4434: {
                return "CL_SAMPLER_NORMALIZED_COORDS";
            }
            case 4435: {
                return "CL_SAMPLER_ADDRESSING_MODE";
            }
            case 4436: {
                return "CL_SAMPLER_FILTER_MODE";
            }
        }
        return "INVALID cl_sampler_info: " + n;
    }

    public static String stringFor_cl_program_info(int n) {
        switch (n) {
            case 4448: {
                return "CL_PROGRAM_REFERENCE_COUNT";
            }
            case 4449: {
                return "CL_PROGRAM_CONTEXT";
            }
            case 4450: {
                return "CL_PROGRAM_NUM_DEVICES";
            }
            case 4451: {
                return "CL_PROGRAM_DEVICES";
            }
            case 4452: {
                return "CL_PROGRAM_SOURCE";
            }
            case 4453: {
                return "CL_PROGRAM_BINARY_SIZES";
            }
            case 4454: {
                return "CL_PROGRAM_BINARIES";
            }
        }
        return "INVALID cl_program_info: " + n;
    }

    public static String stringFor_cl_program_build_info(int n) {
        switch (n) {
            case 4481: {
                return "CL_PROGRAM_BUILD_STATUS";
            }
            case 4482: {
                return "CL_PROGRAM_BUILD_OPTIONS";
            }
            case 4483: {
                return "CL_PROGRAM_BUILD_LOG";
            }
        }
        return "INVALID cl_program_build_info: " + n;
    }

    public static String stringFor_cl_build_status(int n) {
        switch (n) {
            case 0: {
                return "CL_BUILD_SUCCESS";
            }
            case -1: {
                return "CL_BUILD_NONE";
            }
            case -2: {
                return "CL_BUILD_ERROR";
            }
            case -3: {
                return "CL_BUILD_IN_PROGRESS";
            }
        }
        return "INVALID cl_build_status: " + n;
    }

    public static String stringFor_cl_kernel_info(int n) {
        switch (n) {
            case 4496: {
                return "CL_KERNEL_FUNCTION_NAME";
            }
            case 4497: {
                return "CL_KERNEL_NUM_ARGS";
            }
            case 4498: {
                return "CL_KERNEL_REFERENCE_COUNT";
            }
            case 4499: {
                return "CL_KERNEL_CONTEXT";
            }
            case 4500: {
                return "CL_KERNEL_PROGRAM";
            }
        }
        return "INVALID cl_kernel_info: " + n;
    }

    public static String stringFor_cl_kernel_work_group_info(int n) {
        switch (n) {
            case 4528: {
                return "CL_KERNEL_WORK_GROUP_SIZE";
            }
            case 4529: {
                return "CL_KERNEL_COMPILE_WORK_GROUP_SIZE";
            }
            case 4530: {
                return "CL_KERNEL_LOCAL_MEM_SIZE";
            }
        }
        return "INVALID cl_kernel_work_group_info: " + n;
    }

    public static String stringFor_cl_event_info(int n) {
        switch (n) {
            case 4560: {
                return "CL_EVENT_COMMAND_QUEUE";
            }
            case 4561: {
                return "CL_EVENT_COMMAND_TYPE";
            }
            case 4562: {
                return "CL_EVENT_REFERENCE_COUNT";
            }
            case 4563: {
                return "CL_EVENT_COMMAND_EXECUTION_STATUS";
            }
        }
        return "INVALID cl_event_info: " + n;
    }

    public static String stringFor_cl_command_type(int n) {
        switch (n) {
            case 4592: {
                return "CL_COMMAND_NDRANGE_KERNEL";
            }
            case 4593: {
                return "CL_COMMAND_TASK";
            }
            case 4594: {
                return "CL_COMMAND_NATIVE_KERNEL";
            }
            case 4595: {
                return "CL_COMMAND_READ_BUFFER";
            }
            case 4596: {
                return "CL_COMMAND_WRITE_BUFFER";
            }
            case 4597: {
                return "CL_COMMAND_COPY_BUFFER";
            }
            case 4598: {
                return "CL_COMMAND_READ_IMAGE";
            }
            case 4599: {
                return "CL_COMMAND_WRITE_IMAGE";
            }
            case 4600: {
                return "CL_COMMAND_COPY_IMAGE";
            }
            case 4601: {
                return "CL_COMMAND_COPY_IMAGE_TO_BUFFER";
            }
            case 4602: {
                return "CL_COMMAND_COPY_BUFFER_TO_IMAGE";
            }
            case 4603: {
                return "CL_COMMAND_MAP_BUFFER";
            }
            case 4604: {
                return "CL_COMMAND_MAP_IMAGE";
            }
            case 4605: {
                return "CL_COMMAND_UNMAP_MEM_OBJECT";
            }
            case 4606: {
                return "CL_COMMAND_MARKER";
            }
            case 4607: {
                return "CL_COMMAND_ACQUIRE_GL_OBJECTS";
            }
            case 4608: {
                return "CL_COMMAND_RELEASE_GL_OBJECTS";
            }
        }
        return "INVALID cl_command_type: " + n;
    }

    public static String stringFor_command_execution_status(int n) {
        switch (n) {
            case 0: {
                return "CL_COMPLETE";
            }
            case 1: {
                return "CL_RUNNING";
            }
            case 2: {
                return "CL_SUBMITTED";
            }
            case 3: {
                return "CL_QUEUED";
            }
        }
        return "INVALID command_execution_status: " + n;
    }

    public static String stringFor_cl_profiling_info(int n) {
        switch (n) {
            case 4736: {
                return "CL_PROFILING_COMMAND_QUEUED";
            }
            case 4737: {
                return "CL_PROFILING_COMMAND_SUBMIT";
            }
            case 4738: {
                return "CL_PROFILING_COMMAND_START";
            }
            case 4739: {
                return "CL_PROFILING_COMMAND_END";
            }
        }
        return "INVALID cl_profiling_info: " + n;
    }

    public static String stringFor_cl_gl_object_type(int n) {
        switch (n) {
            case 8192: {
                return "CL_GL_OBJECT_BUFFER";
            }
            case 8193: {
                return "CL_GL_OBJECT_TEXTURE2D";
            }
            case 8194: {
                return "CL_GL_OBJECT_TEXTURE3D";
            }
            case 8195: {
                return "CL_GL_OBJECT_RENDERBUFFER";
            }
        }
        return "INVALID cl_gl_object_type: " + n;
    }

    public static String stringFor_cl_gl_texture_info(int n) {
        switch (n) {
            case 8196: {
                return "CL_GL_TEXTURE_TARGET";
            }
            case 8197: {
                return "CL_GL_MIPMAP_LEVEL";
            }
            case 8194: {
                return "CL_GL_OBJECT_TEXTURE3D";
            }
            case 8195: {
                return "CL_GL_OBJECT_RENDERBUFFER";
            }
        }
        return "INVALID cl_gl_texture_info: " + n;
    }

    public static String stringFor_cl_khr_gl_sharing(int n) {
        switch (n) {
            case 8198: {
                return "CL_CURRENT_DEVICE_FOR_GL_CONTEXT_KHR";
            }
            case 8199: {
                return "CL_DEVICES_FOR_GL_CONTEXT_KHR";
            }
            case 8200: {
                return "CL_GL_CONTEXT_KHR";
            }
            case 8201: {
                return "CL_EGL_DISPLAY_KHR";
            }
            case 8202: {
                return "CL_GLX_DISPLAY_KHR";
            }
            case 8203: {
                return "CL_WGL_HDC_KHR";
            }
            case 8204: {
                return "CL_CGL_SHAREGROUP_KHR";
            }
        }
        return "INVALID cl_khr_gl_sharing: " + n;
    }

    public static String stringFor_cl_device_type(long n) {
        if (n == 0L) {
            return "(none)";
        }
        String result = "";
        if ((n & 0xFFFFFFFFFFFFFFFFL) != -1L) {
            result = String.valueOf(result) + "CL_DEVICE_TYPE_ALL ";
        }
        if ((n & 1L) != 0L) {
            result = String.valueOf(result) + "CL_DEVICE_TYPE_DEFAULT ";
        }
        if ((n & 2L) != 0L) {
            result = String.valueOf(result) + "CL_DEVICE_TYPE_CPU ";
        }
        if ((n & 4L) != 0L) {
            result = String.valueOf(result) + "CL_DEVICE_TYPE_GPU ";
        }
        if ((n & 8L) != 0L) {
            result = String.valueOf(result) + "CL_DEVICE_TYPE_ACCELERATOR ";
        }
        return result;
    }

    public static String stringFor_cl_device_address_info(long n) {
        if (n == 0L) {
            return "(none)";
        }
        String result = "";
        if ((n & 1L) != 0L) {
            result = String.valueOf(result) + "CL_DEVICE_ADDRESS_32_BITS ";
        }
        if ((n & 2L) != 0L) {
            result = String.valueOf(result) + "CL_DEVICE_ADDRESS_64_BITS ";
        }
        return result;
    }

    public static String stringFor_cl_device_fp_config(long n) {
        if (n == 0L) {
            return "(none)";
        }
        String result = "";
        if ((n & 1L) != 0L) {
            result = String.valueOf(result) + "CL_FP_DENORM ";
        }
        if ((n & 2L) != 0L) {
            result = String.valueOf(result) + "CL_FP_INF_NAN ";
        }
        if ((n & 4L) != 0L) {
            result = String.valueOf(result) + "CL_FP_ROUND_TO_NEAREST ";
        }
        if ((n & 8L) != 0L) {
            result = String.valueOf(result) + "CL_FP_ROUND_TO_ZERO ";
        }
        if ((n & 0x10L) != 0L) {
            result = String.valueOf(result) + "CL_FP_ROUND_TO_INF ";
        }
        if ((n & 0x20L) != 0L) {
            result = String.valueOf(result) + "CL_FP_FMA ";
        }
        return result;
    }

    public static String stringFor_cl_device_exec_capabilities(long n) {
        if (n == 0L) {
            return "(none)";
        }
        String result = "";
        if ((n & 1L) != 0L) {
            result = String.valueOf(result) + "CL_EXEC_KERNEL ";
        }
        if ((n & 2L) != 0L) {
            result = String.valueOf(result) + "CL_EXEC_NATIVE_KERNEL ";
        }
        return result;
    }

    public static String stringFor_cl_command_queue_properties(long n) {
        if (n == 0L) {
            return "(none)";
        }
        String result = "";
        if ((n & 1L) != 0L) {
            result = String.valueOf(result) + "CL_QUEUE_OUT_OF_ORDER_EXEC_MODE_ENABLE ";
        }
        if ((n & 2L) != 0L) {
            result = String.valueOf(result) + "CL_QUEUE_PROFILING_ENABLE ";
        }
        return result;
    }

    public static String stringFor_cl_mem_flags(long n) {
        if (n == 0L) {
            return "(none)";
        }
        String result = "";
        if ((n & 1L) != 0L) {
            result = String.valueOf(result) + "CL_MEM_READ_WRITE ";
        }
        if ((n & 2L) != 0L) {
            result = String.valueOf(result) + "CL_MEM_WRITE_ONLY ";
        }
        if ((n & 4L) != 0L) {
            result = String.valueOf(result) + "CL_MEM_READ_ONLY ";
        }
        if ((n & 8L) != 0L) {
            result = String.valueOf(result) + "CL_MEM_USE_HOST_PTR ";
        }
        if ((n & 0x10L) != 0L) {
            result = String.valueOf(result) + "CL_MEM_ALLOC_HOST_PTR ";
        }
        if ((n & 0x20L) != 0L) {
            result = String.valueOf(result) + "CL_MEM_COPY_HOST_PTR ";
        }
        return result;
    }

    public static String stringFor_cl_map_flags(long n) {
        if (n == 0L) {
            return "(none)";
        }
        String result = "";
        if ((n & 1L) != 0L) {
            result = String.valueOf(result) + "CL_MAP_READ ";
        }
        if ((n & 2L) != 0L) {
            result = String.valueOf(result) + "CL_MAP_WRITE ";
        }
        return result;
    }

    public static void setLogLevel(LogLevel logLevel) {
        CL.assertInit();
        CL.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    static synchronized ByteBuffer allocateAligned(int size, int alignment) {
        Pointer pointer;
        ByteBuffer byteBuffer;
        CL.assertInit();
        if (memoryManagementThread == null) {
            CL.initMemoryManagementThread();
        }
        if ((byteBuffer = CL.allocateAlignedNative(size, alignment, pointer = new Pointer())) == null) {
            return null;
        }
        WeakReference<ByteBuffer> reference = new WeakReference<ByteBuffer>(byteBuffer, alignedByteBufferReferenceQueue);
        alignedByteBufferMap.put(reference, pointer);
        return byteBuffer;
    }

    private static native ByteBuffer allocateAlignedNative(int var0, int var1, Pointer var2);

    private static native void freeAlignedNative(Pointer var0);

    private static void initMemoryManagementThread() {
        memoryManagementThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        Reference reference = alignedByteBufferReferenceQueue.remove();
                        Pointer pointer = (Pointer)alignedByteBufferMap.get(reference);
                        CL.freeAlignedNative(pointer);
                        alignedByteBufferMap.remove(reference);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }, "memoryManagementThread");
        memoryManagementThread.setPriority(1);
        memoryManagementThread.setDaemon(true);
        memoryManagementThread.start();
    }

    private static void scheduleReferenceRelease(final cl_event event, Object object) {
        Runnable runnable = new Runnable(object){
            private Object localObject;
            {
                this.localObject = object;
            }

            @Override
            public void run() {
                CL.clWaitForEvents(1, new cl_event[]{event});
            }
        };
        referenceReleaseExecutor.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void assertInit() {
        if (initialized) return;
        Class<CL> clazz = CL.class;
        synchronized (CL.class) {
            if (initialized) return;
            LibUtils.loadLibrary("JOCL");
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static synchronized int clGetPlatformIDs(int num_entries, cl_platform_id[] platforms, int[] num_platforms) {
        CL.assertInit();
        return CL.checkResult(CL.clGetPlatformIDsNative(num_entries, platforms, num_platforms));
    }

    private static native int clGetPlatformIDsNative(int var0, cl_platform_id[] var1, int[] var2);

    public static synchronized int clGetPlatformInfo(cl_platform_id platform, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetPlatformInfoNative(platform, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetPlatformInfoNative(cl_platform_id var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized int clGetDeviceIDs(cl_platform_id platform, long device_type, int num_entries, cl_device_id[] devices, int[] num_devices) {
        CL.assertInit();
        return CL.checkResult(CL.clGetDeviceIDsNative(platform, device_type, num_entries, devices, num_devices));
    }

    private static native int clGetDeviceIDsNative(cl_platform_id var0, long var1, int var3, cl_device_id[] var4, int[] var5);

    public static synchronized int clGetDeviceInfo(cl_device_id device, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetDeviceInfoNative(device, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetDeviceInfoNative(cl_device_id var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized cl_context clCreateContext(cl_context_properties properties, int num_devices, cl_device_id[] devices, CreateContextFunction pfn_notify, Object user_data, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_context result = CL.clCreateContextNative(properties, num_devices, devices, pfn_notify, user_data, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_context result = CL.clCreateContextNative(properties, num_devices, devices, pfn_notify, user_data, errcode_ret);
        return result;
    }

    private static native cl_context clCreateContextNative(cl_context_properties var0, int var1, cl_device_id[] var2, CreateContextFunction var3, Object var4, int[] var5);

    public static synchronized cl_context clCreateContextFromType(cl_context_properties properties, long device_type, CreateContextFunction pfn_notify, Object user_data, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_context result = CL.clCreateContextFromTypeNative(properties, device_type, pfn_notify, user_data, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_context result = CL.clCreateContextFromTypeNative(properties, device_type, pfn_notify, user_data, errcode_ret);
        return result;
    }

    private static native cl_context clCreateContextFromTypeNative(cl_context_properties var0, long var1, CreateContextFunction var3, Object var4, int[] var5);

    public static synchronized int clRetainContext(cl_context context) {
        CL.assertInit();
        return CL.checkResult(CL.clRetainContextNative(context));
    }

    private static native int clRetainContextNative(cl_context var0);

    public static synchronized int clReleaseContext(cl_context context) {
        CL.assertInit();
        return CL.checkResult(CL.clReleaseContextNative(context));
    }

    private static native int clReleaseContextNative(cl_context var0);

    public static synchronized int clGetContextInfo(cl_context context, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetContextInfoNative(context, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetContextInfoNative(cl_context var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized cl_command_queue clCreateCommandQueue(cl_context context, cl_device_id device, long properties, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_command_queue result = CL.clCreateCommandQueueNative(context, device, properties, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_command_queue result = CL.clCreateCommandQueueNative(context, device, properties, errcode_ret);
        return result;
    }

    private static native cl_command_queue clCreateCommandQueueNative(cl_context var0, cl_device_id var1, long var2, int[] var4);

    public static synchronized int clRetainCommandQueue(cl_command_queue command_queue) {
        CL.assertInit();
        return CL.checkResult(CL.clRetainCommandQueueNative(command_queue));
    }

    private static native int clRetainCommandQueueNative(cl_command_queue var0);

    public static synchronized int clReleaseCommandQueue(cl_command_queue command_queue) {
        CL.assertInit();
        return CL.checkResult(CL.clReleaseCommandQueueNative(command_queue));
    }

    private static native int clReleaseCommandQueueNative(cl_command_queue var0);

    public static synchronized int clGetCommandQueueInfo(cl_command_queue command_queue, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetCommandQueueInfoNative(command_queue, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetCommandQueueInfoNative(cl_command_queue var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized int clSetCommandQueueProperty(cl_command_queue command_queue, long properties, boolean enable, long[] old_properties) {
        CL.assertInit();
        return CL.checkResult(CL.clSetCommandQueuePropertyNative(command_queue, properties, enable, old_properties));
    }

    private static native int clSetCommandQueuePropertyNative(cl_command_queue var0, long var1, boolean var3, long[] var4);

    public static synchronized cl_mem clCreateBuffer(cl_context context, long flags, long size, Pointer host_ptr, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_mem result = CL.clCreateBufferNative(context, flags, size, host_ptr, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_mem result = CL.clCreateBufferNative(context, flags, size, host_ptr, errcode_ret);
        return result;
    }

    private static native cl_mem clCreateBufferNative(cl_context var0, long var1, long var3, Pointer var5, int[] var6);

    public static synchronized cl_mem clCreateImage2D(cl_context context, long flags, cl_image_format[] image_format, long image_width, long image_height, long image_row_pitch, Pointer host_ptr, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_mem result = CL.clCreateImage2DNative(context, flags, image_format, image_width, image_height, image_row_pitch, host_ptr, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_mem result = CL.clCreateImage2DNative(context, flags, image_format, image_width, image_height, image_row_pitch, host_ptr, errcode_ret);
        return result;
    }

    private static native cl_mem clCreateImage2DNative(cl_context var0, long var1, cl_image_format[] var3, long var4, long var6, long var8, Pointer var10, int[] var11);

    public static synchronized cl_mem clCreateImage3D(cl_context context, long flags, cl_image_format[] image_format, long image_width, long image_height, long image_depth, long image_row_pitch, long image_slice_pitch, Pointer host_ptr, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_mem result = CL.clCreateImage3DNative(context, flags, image_format, image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, host_ptr, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_mem result = CL.clCreateImage3DNative(context, flags, image_format, image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, host_ptr, errcode_ret);
        return result;
    }

    private static native cl_mem clCreateImage3DNative(cl_context var0, long var1, cl_image_format[] var3, long var4, long var6, long var8, long var10, long var12, Pointer var14, int[] var15);

    public static synchronized int clRetainMemObject(cl_mem memobj) {
        CL.assertInit();
        return CL.checkResult(CL.clRetainMemObjectNative(memobj));
    }

    private static native int clRetainMemObjectNative(cl_mem var0);

    public static synchronized int clReleaseMemObject(cl_mem memobj) {
        CL.assertInit();
        return CL.checkResult(CL.clReleaseMemObjectNative(memobj));
    }

    private static native int clReleaseMemObjectNative(cl_mem var0);

    public static synchronized int clGetSupportedImageFormats(cl_context context, long flags, int image_type, int num_entries, cl_image_format[] image_formats, int[] num_image_formats) {
        CL.assertInit();
        return CL.checkResult(CL.clGetSupportedImageFormatsNative(context, flags, image_type, num_entries, image_formats, num_image_formats));
    }

    private static native int clGetSupportedImageFormatsNative(cl_context var0, long var1, int var3, int var4, cl_image_format[] var5, int[] var6);

    public static synchronized int clGetMemObjectInfo(cl_mem memobj, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetMemObjectInfoNative(memobj, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetMemObjectInfoNative(cl_mem var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized int clGetImageInfo(cl_mem image, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetImageInfoNative(image, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetImageInfoNative(cl_mem var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized cl_sampler clCreateSampler(cl_context context, boolean normalized_coords, int addressing_mode, int filter_mode, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_sampler result = CL.clCreateSamplerNative(context, normalized_coords, addressing_mode, filter_mode, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_sampler result = CL.clCreateSamplerNative(context, normalized_coords, addressing_mode, filter_mode, errcode_ret);
        return result;
    }

    private static native cl_sampler clCreateSamplerNative(cl_context var0, boolean var1, int var2, int var3, int[] var4);

    public static synchronized int clRetainSampler(cl_sampler sampler) {
        CL.assertInit();
        return CL.checkResult(CL.clRetainSamplerNative(sampler));
    }

    private static native int clRetainSamplerNative(cl_sampler var0);

    public static synchronized int clReleaseSampler(cl_sampler sampler) {
        CL.assertInit();
        return CL.checkResult(CL.clReleaseSamplerNative(sampler));
    }

    private static native int clReleaseSamplerNative(cl_sampler var0);

    public static synchronized int clGetSamplerInfo(cl_sampler sampler, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetSamplerInfoNative(sampler, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetSamplerInfoNative(cl_sampler var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized cl_program clCreateProgramWithSource(cl_context context, int count, String[] strings, long[] lengths, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_program result = CL.clCreateProgramWithSourceNative(context, count, strings, lengths, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_program result = CL.clCreateProgramWithSourceNative(context, count, strings, lengths, errcode_ret);
        return result;
    }

    private static native cl_program clCreateProgramWithSourceNative(cl_context var0, int var1, String[] var2, long[] var3, int[] var4);

    public static synchronized cl_program clCreateProgramWithBinary(cl_context context, int num_devices, cl_device_id[] device_list, long[] lengths, byte[][] binaries, int[] binary_status, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_program result = CL.clCreateProgramWithBinaryNative(context, num_devices, device_list, lengths, binaries, binary_status, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_program result = CL.clCreateProgramWithBinaryNative(context, num_devices, device_list, lengths, binaries, binary_status, errcode_ret);
        return result;
    }

    private static native cl_program clCreateProgramWithBinaryNative(cl_context var0, int var1, cl_device_id[] var2, long[] var3, byte[][] var4, int[] var5, int[] var6);

    public static synchronized int clRetainProgram(cl_program program) {
        CL.assertInit();
        return CL.checkResult(CL.clRetainProgramNative(program));
    }

    private static native int clRetainProgramNative(cl_program var0);

    public static synchronized int clReleaseProgram(cl_program program) {
        CL.assertInit();
        return CL.checkResult(CL.clReleaseProgramNative(program));
    }

    private static native int clReleaseProgramNative(cl_program var0);

    public static synchronized int clBuildProgram(cl_program program, int num_devices, cl_device_id[] device_list, String options, BuildProgramFunction pfn_notify, Object user_data) {
        CL.assertInit();
        int result = CL.clBuildProgramNative(program, num_devices, device_list, options, pfn_notify, user_data);
        if (result != 0 && exceptionsEnabled) {
            if (result != 1 && result != -11) {
                throw new CLException(CL.stringFor_errorCode(result));
            }
            throw new CLException(String.valueOf(CL.stringFor_errorCode(result)) + "\n" + CL.obtainBuildLogs(program));
        }
        return result;
    }

    private static String obtainBuildLogs(cl_program program) {
        int[] numDevices = new int[1];
        CL.clGetProgramInfo(program, 4450, 4L, Pointer.to(numDevices), null);
        NativePointerObject[] devices = new cl_device_id[numDevices[0]];
        CL.clGetProgramInfo(program, 4451, numDevices[0] * Sizeof.cl_device_id, Pointer.to(devices), null);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < devices.length) {
            sb.append("Build log for device " + i + ":\n");
            long[] logSize = new long[1];
            CL.clGetProgramBuildInfo(program, (cl_device_id)devices[i], 4483, 0L, null, logSize);
            byte[] logData = new byte[(int)logSize[0]];
            CL.clGetProgramBuildInfo(program, (cl_device_id)devices[i], 4483, logSize[0], Pointer.to(logData), null);
            sb.append(new String(logData, 0, logData.length - 1));
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    private static native int clBuildProgramNative(cl_program var0, int var1, cl_device_id[] var2, String var3, BuildProgramFunction var4, Object var5);

    public static synchronized int clUnloadCompiler() {
        CL.assertInit();
        return CL.checkResult(CL.clUnloadCompilerNative());
    }

    private static native int clUnloadCompilerNative();

    public static synchronized int clGetProgramInfo(cl_program program, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetProgramInfoNative(program, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetProgramInfoNative(cl_program var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized int clGetProgramBuildInfo(cl_program program, cl_device_id device, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetProgramBuildInfoNative(program, device, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetProgramBuildInfoNative(cl_program var0, cl_device_id var1, int var2, long var3, Pointer var5, long[] var6);

    public static synchronized cl_kernel clCreateKernel(cl_program program, String kernel_name, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_kernel result = CL.clCreateKernelNative(program, kernel_name, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_kernel result = CL.clCreateKernelNative(program, kernel_name, errcode_ret);
        return result;
    }

    private static native cl_kernel clCreateKernelNative(cl_program var0, String var1, int[] var2);

    public static synchronized int clCreateKernelsInProgram(cl_program program, int num_kernels, cl_kernel[] kernels, int[] num_kernels_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clCreateKernelsInProgramNative(program, num_kernels, kernels, num_kernels_ret));
    }

    private static native int clCreateKernelsInProgramNative(cl_program var0, int var1, cl_kernel[] var2, int[] var3);

    public static synchronized int clRetainKernel(cl_kernel kernel) {
        CL.assertInit();
        return CL.checkResult(CL.clRetainKernelNative(kernel));
    }

    private static native int clRetainKernelNative(cl_kernel var0);

    public static synchronized int clReleaseKernel(cl_kernel kernel) {
        CL.assertInit();
        return CL.checkResult(CL.clReleaseKernelNative(kernel));
    }

    private static native int clReleaseKernelNative(cl_kernel var0);

    public static synchronized int clSetKernelArg(cl_kernel kernel, int arg_index, long arg_size, Pointer arg_value) {
        CL.assertInit();
        return CL.checkResult(CL.clSetKernelArgNative(kernel, arg_index, arg_size, arg_value));
    }

    private static native int clSetKernelArgNative(cl_kernel var0, int var1, long var2, Pointer var4);

    public static synchronized int clGetKernelInfo(cl_kernel kernel, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetKernelInfoNative(kernel, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetKernelInfoNative(cl_kernel var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized int clGetKernelWorkGroupInfo(cl_kernel kernel, cl_device_id device, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetKernelWorkGroupInfoNative(kernel, device, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetKernelWorkGroupInfoNative(cl_kernel var0, cl_device_id var1, int var2, long var3, Pointer var5, long[] var6);

    public static synchronized int clWaitForEvents(int num_events, cl_event[] event_list) {
        CL.assertInit();
        return CL.checkResult(CL.clWaitForEventsNative(num_events, event_list));
    }

    private static native int clWaitForEventsNative(int var0, cl_event[] var1);

    public static synchronized int clGetEventInfo(cl_event event, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetEventInfoNative(event, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetEventInfoNative(cl_event var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized int clRetainEvent(cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clRetainEventNative(event));
    }

    private static native int clRetainEventNative(cl_event var0);

    public static synchronized int clReleaseEvent(cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clReleaseEventNative(event));
    }

    private static native int clReleaseEventNative(cl_event var0);

    public static synchronized int clGetEventProfilingInfo(cl_event event, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetEventProfilingInfoNative(event, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetEventProfilingInfoNative(cl_event var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized int clFlush(cl_command_queue command_queue) {
        CL.assertInit();
        return CL.checkResult(CL.clFlushNative(command_queue));
    }

    private static native int clFlushNative(cl_command_queue var0);

    public static synchronized int clFinish(cl_command_queue command_queue) {
        CL.assertInit();
        return CL.checkResult(CL.clFinishNative(command_queue));
    }

    private static native int clFinishNative(cl_command_queue var0);

    public static synchronized int clEnqueueReadBuffer(cl_command_queue command_queue, cl_mem buffer, boolean blocking_read, long offset, long cb, Pointer ptr, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        if (!blocking_read && !ptr.isDirectBufferPointer()) {
            throw new IllegalArgumentException("Non-blocking read operations may only be performed using pointers to direct buffers");
        }
        return CL.checkResult(CL.clEnqueueReadBufferNative(command_queue, buffer, blocking_read, offset, cb, ptr, num_events_in_wait_list, event_wait_list, event));
    }

    private static native int clEnqueueReadBufferNative(cl_command_queue var0, cl_mem var1, boolean var2, long var3, long var5, Pointer var7, int var8, cl_event[] var9, cl_event var10);

    public static synchronized int clEnqueueWriteBuffer(cl_command_queue command_queue, cl_mem buffer, boolean blocking_write, long offset, long cb, Pointer ptr, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        if (blocking_write) {
            return CL.checkResult(CL.clEnqueueWriteBufferNative(command_queue, buffer, blocking_write, offset, cb, ptr, num_events_in_wait_list, event_wait_list, event));
        }
        if (event == null) {
            event = new cl_event();
        }
        int result = CL.clEnqueueWriteBufferNative(command_queue, buffer, blocking_write, offset, cb, ptr, num_events_in_wait_list, event_wait_list, event);
        CL.scheduleReferenceRelease(event, ptr);
        return CL.checkResult(result);
    }

    private static native int clEnqueueWriteBufferNative(cl_command_queue var0, cl_mem var1, boolean var2, long var3, long var5, Pointer var7, int var8, cl_event[] var9, cl_event var10);

    public static synchronized int clEnqueueCopyBuffer(cl_command_queue command_queue, cl_mem src_buffer, cl_mem dst_buffer, long src_offset, long dst_offset, long cb, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueCopyBufferNative(command_queue, src_buffer, dst_buffer, src_offset, dst_offset, cb, num_events_in_wait_list, event_wait_list, event));
    }

    private static native int clEnqueueCopyBufferNative(cl_command_queue var0, cl_mem var1, cl_mem var2, long var3, long var5, long var7, int var9, cl_event[] var10, cl_event var11);

    public static synchronized int clEnqueueReadImage(cl_command_queue command_queue, cl_mem image, boolean blocking_read, long[] origin, long[] region, long row_pitch, long slice_pitch, Pointer ptr, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        if (!blocking_read && !ptr.isDirectBufferPointer()) {
            throw new IllegalArgumentException("Non-blocking read operations may only be performed using pointers to direct buffers");
        }
        return CL.checkResult(CL.clEnqueueReadImageNative(command_queue, image, blocking_read, origin, region, row_pitch, slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
    }

    private static native int clEnqueueReadImageNative(cl_command_queue var0, cl_mem var1, boolean var2, long[] var3, long[] var4, long var5, long var7, Pointer var9, int var10, cl_event[] var11, cl_event var12);

    public static synchronized int clEnqueueWriteImage(cl_command_queue command_queue, cl_mem image, boolean blocking_write, long[] origin, long[] region, long input_row_pitch, long input_slice_pitch, Pointer ptr, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        if (blocking_write) {
            return CL.checkResult(CL.clEnqueueWriteImageNative(command_queue, image, blocking_write, origin, region, input_row_pitch, input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event));
        }
        if (event == null) {
            event = new cl_event();
        }
        int result = CL.clEnqueueWriteImageNative(command_queue, image, blocking_write, origin, region, input_row_pitch, input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event);
        CL.scheduleReferenceRelease(event, ptr);
        return CL.checkResult(result);
    }

    private static native int clEnqueueWriteImageNative(cl_command_queue var0, cl_mem var1, boolean var2, long[] var3, long[] var4, long var5, long var7, Pointer var9, int var10, cl_event[] var11, cl_event var12);

    public static synchronized int clEnqueueCopyImage(cl_command_queue command_queue, cl_mem src_image, cl_mem dst_image, long[] src_origin, long[] dst_origin, long[] region, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueCopyImageNative(command_queue, src_image, dst_image, src_origin, dst_origin, region, num_events_in_wait_list, event_wait_list, event));
    }

    private static native int clEnqueueCopyImageNative(cl_command_queue var0, cl_mem var1, cl_mem var2, long[] var3, long[] var4, long[] var5, int var6, cl_event[] var7, cl_event var8);

    public static synchronized int clEnqueueCopyImageToBuffer(cl_command_queue command_queue, cl_mem src_image, cl_mem dst_buffer, long[] src_origin, long[] region, long dst_offset, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueCopyImageToBufferNative(command_queue, src_image, dst_buffer, src_origin, region, dst_offset, num_events_in_wait_list, event_wait_list, event));
    }

    private static native int clEnqueueCopyImageToBufferNative(cl_command_queue var0, cl_mem var1, cl_mem var2, long[] var3, long[] var4, long var5, int var7, cl_event[] var8, cl_event var9);

    public static synchronized int clEnqueueCopyBufferToImage(cl_command_queue command_queue, cl_mem src_buffer, cl_mem dst_image, long src_offset, long[] dst_origin, long[] region, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueCopyBufferToImageNative(command_queue, src_buffer, dst_image, src_offset, dst_origin, region, num_events_in_wait_list, event_wait_list, event));
    }

    private static native int clEnqueueCopyBufferToImageNative(cl_command_queue var0, cl_mem var1, cl_mem var2, long var3, long[] var5, long[] var6, int var7, cl_event[] var8, cl_event var9);

    public static synchronized ByteBuffer clEnqueueMapBuffer(cl_command_queue command_queue, cl_mem buffer, boolean blocking_map, long map_flags, long offset, long cb, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            ByteBuffer result = CL.clEnqueueMapBufferNative(command_queue, buffer, blocking_map, map_flags, offset, cb, num_events_in_wait_list, event_wait_list, event, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        ByteBuffer result = CL.clEnqueueMapBufferNative(command_queue, buffer, blocking_map, map_flags, offset, cb, num_events_in_wait_list, event_wait_list, event, errcode_ret);
        return result;
    }

    private static native ByteBuffer clEnqueueMapBufferNative(cl_command_queue var0, cl_mem var1, boolean var2, long var3, long var5, long var7, int var9, cl_event[] var10, cl_event var11, int[] var12);

    public static synchronized ByteBuffer clEnqueueMapImage(cl_command_queue command_queue, cl_mem image, boolean blocking_map, long map_flags, long[] origin, long[] region, long[] image_row_pitch, long[] image_slice_pitch, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            ByteBuffer result = CL.clEnqueueMapImageNative(command_queue, image, blocking_map, map_flags, origin, region, image_row_pitch, image_slice_pitch, num_events_in_wait_list, event_wait_list, event, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        ByteBuffer result = CL.clEnqueueMapImageNative(command_queue, image, blocking_map, map_flags, origin, region, image_row_pitch, image_slice_pitch, num_events_in_wait_list, event_wait_list, event, errcode_ret);
        return result;
    }

    private static native ByteBuffer clEnqueueMapImageNative(cl_command_queue var0, cl_mem var1, boolean var2, long var3, long[] var5, long[] var6, long[] var7, long[] var8, int var9, cl_event[] var10, cl_event var11, int[] var12);

    public static synchronized int clEnqueueUnmapMemObject(cl_command_queue command_queue, cl_mem memobj, ByteBuffer mapped_ptr, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        if (event == null) {
            event = new cl_event();
        }
        int result = CL.clEnqueueUnmapMemObjectNative(command_queue, memobj, mapped_ptr, num_events_in_wait_list, event_wait_list, event);
        CL.scheduleReferenceRelease(event, mapped_ptr);
        return CL.checkResult(result);
    }

    private static native int clEnqueueUnmapMemObjectNative(cl_command_queue var0, cl_mem var1, ByteBuffer var2, int var3, cl_event[] var4, cl_event var5);

    public static synchronized int clEnqueueNDRangeKernel(cl_command_queue command_queue, cl_kernel kernel, int work_dim, long[] global_work_offset, long[] global_work_size, long[] local_work_size, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueNDRangeKernelNative(command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size, num_events_in_wait_list, event_wait_list, event));
    }

    private static native int clEnqueueNDRangeKernelNative(cl_command_queue var0, cl_kernel var1, int var2, long[] var3, long[] var4, long[] var5, int var6, cl_event[] var7, cl_event var8);

    public static synchronized int clEnqueueTask(cl_command_queue command_queue, cl_kernel kernel, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueTaskNative(command_queue, kernel, num_events_in_wait_list, event_wait_list, event));
    }

    private static native int clEnqueueTaskNative(cl_command_queue var0, cl_kernel var1, int var2, cl_event[] var3, cl_event var4);

    public static synchronized int clEnqueueNativeKernel(cl_command_queue command_queue, EnqueueNativeKernelFunction user_func, Object args, long cb_args, int num_mem_objects, cl_mem[] mem_list, Pointer[] args_mem_loc, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueNativeKernelNative(command_queue, user_func, args, cb_args, num_mem_objects, mem_list, args_mem_loc, num_events_in_wait_list, event_wait_list, event));
    }

    private static native int clEnqueueNativeKernelNative(cl_command_queue var0, EnqueueNativeKernelFunction var1, Object var2, long var3, int var5, cl_mem[] var6, Pointer[] var7, int var8, cl_event[] var9, cl_event var10);

    public static synchronized int clEnqueueMarker(cl_command_queue command_queue, cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueMarkerNative(command_queue, event));
    }

    private static native int clEnqueueMarkerNative(cl_command_queue var0, cl_event var1);

    public static synchronized int clEnqueueWaitForEvents(cl_command_queue command_queue, int num_events, cl_event[] event_list) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueWaitForEventsNative(command_queue, num_events, event_list));
    }

    private static native int clEnqueueWaitForEventsNative(cl_command_queue var0, int var1, cl_event[] var2);

    public static synchronized int clEnqueueBarrier(cl_command_queue command_queue) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueBarrierNative(command_queue));
    }

    private static native int clEnqueueBarrierNative(cl_command_queue var0);

    public static synchronized cl_mem clCreateFromGLBuffer(cl_context context, long flags, int bufobj, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_mem result = CL.clCreateFromGLBufferNative(context, flags, bufobj, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_mem result = CL.clCreateFromGLBufferNative(context, flags, bufobj, errcode_ret);
        return result;
    }

    private static native cl_mem clCreateFromGLBufferNative(cl_context var0, long var1, int var3, int[] var4);

    public static synchronized cl_mem clCreateFromGLTexture2D(cl_context context, long flags, int target, int miplevel, int texture, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_mem result = CL.clCreateFromGLTexture2DNative(context, flags, target, miplevel, texture, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_mem result = CL.clCreateFromGLTexture2DNative(context, flags, target, miplevel, texture, errcode_ret);
        return result;
    }

    private static native cl_mem clCreateFromGLTexture2DNative(cl_context var0, long var1, int var3, int var4, int var5, int[] var6);

    public static synchronized cl_mem clCreateFromGLTexture3D(cl_context context, long flags, int target, int miplevel, int texture, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_mem result = CL.clCreateFromGLTexture3DNative(context, flags, target, miplevel, texture, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_mem result = CL.clCreateFromGLTexture3DNative(context, flags, target, miplevel, texture, errcode_ret);
        return result;
    }

    private static native cl_mem clCreateFromGLTexture3DNative(cl_context var0, long var1, int var3, int var4, int var5, int[] var6);

    public static synchronized cl_mem clCreateFromGLRenderbuffer(cl_context context, long flags, int renderbuffer, int[] errcode_ret) {
        CL.assertInit();
        if (exceptionsEnabled) {
            if (errcode_ret == null) {
                errcode_ret = new int[1];
            }
            cl_mem result = CL.clCreateFromGLRenderbufferNative(context, flags, renderbuffer, errcode_ret);
            CL.checkResult(errcode_ret[0]);
            return result;
        }
        cl_mem result = CL.clCreateFromGLRenderbufferNative(context, flags, renderbuffer, errcode_ret);
        return result;
    }

    private static native cl_mem clCreateFromGLRenderbufferNative(cl_context var0, long var1, int var3, int[] var4);

    public static synchronized int clGetGLObjectInfo(cl_mem memobj, int[] gl_object_type, int[] gl_object_name) {
        CL.assertInit();
        return CL.checkResult(CL.clGetGLObjectInfoNative(memobj, gl_object_type, gl_object_name));
    }

    private static native int clGetGLObjectInfoNative(cl_mem var0, int[] var1, int[] var2);

    public static synchronized int clGetGLTextureInfo(cl_mem memobj, int param_name, long param_value_size, Pointer param_value, long[] param_value_size_ret) {
        CL.assertInit();
        return CL.checkResult(CL.clGetGLTextureInfoNative(memobj, param_name, param_value_size, param_value, param_value_size_ret));
    }

    private static native int clGetGLTextureInfoNative(cl_mem var0, int var1, long var2, Pointer var4, long[] var5);

    public static synchronized int clEnqueueAcquireGLObjects(cl_command_queue command_queue, int num_objects, cl_mem[] mem_objects, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueAcquireGLObjectsNative(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
    }

    private static native int clEnqueueAcquireGLObjectsNative(cl_command_queue var0, int var1, cl_mem[] var2, int var3, cl_event[] var4, cl_event var5);

    public static synchronized int clEnqueueReleaseGLObjects(cl_command_queue command_queue, int num_objects, cl_mem[] mem_objects, int num_events_in_wait_list, cl_event[] event_wait_list, cl_event event) {
        CL.assertInit();
        return CL.checkResult(CL.clEnqueueReleaseGLObjectsNative(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event));
    }

    private static native int clEnqueueReleaseGLObjectsNative(cl_command_queue var0, int var1, cl_mem[] var2, int var3, cl_event[] var4, cl_event var5);

    private CL() {
    }

    public static enum LogLevel {
        LOG_QUIET,
        LOG_ERROR,
        LOG_WARNING,
        LOG_INFO,
        LOG_DEBUG,
        LOG_TRACE,
        LOG_DEBUGTRACE;

    }
}

