/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.net.URI;
import javax.measure.unit.Unit;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.Parameter;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatParameter
extends AbstractParameter
implements ParameterValue<Double> {
    private static final long serialVersionUID = 9027797654033417816L;
    private double value;

    public FloatParameter(ParameterDescriptor<Double> descriptor) {
        super((GeneralParameterDescriptor)descriptor);
        Class type = descriptor.getValueClass();
        Class<Double> expected = Double.class;
        if (!expected.equals((Object)type) && !Double.TYPE.equals(type)) {
            throw new IllegalArgumentException(Errors.format((int)45, (Object)type, expected));
        }
        Number value = (Number)descriptor.getDefaultValue();
        this.value = value != null ? value.doubleValue() : Double.NaN;
    }

    public FloatParameter(ParameterDescriptor<Double> descriptor, double value) {
        this(descriptor);
        this.setValue(value);
    }

    public ParameterDescriptor<Double> getDescriptor() {
        return (ParameterDescriptor)super.getDescriptor();
    }

    public Unit<?> getUnit() {
        return ((ParameterDescriptor)this.descriptor).getUnit();
    }

    public double doubleValue(Unit<?> unit) throws IllegalArgumentException {
        FloatParameter.ensureNonNull("unit", unit);
        Unit<?> thisUnit = this.getUnit();
        if (thisUnit == null) {
            throw FloatParameter.unitlessParameter(this.descriptor);
        }
        int expectedID = Parameter.getUnitMessageID(thisUnit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format((int)expectedID, unit));
        }
        return thisUnit.getConverterTo(unit).convert(this.value);
    }

    public double doubleValue() {
        return this.value;
    }

    public int intValue() {
        return (int)Math.round(this.value);
    }

    public boolean booleanValue() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public String stringValue() {
        return String.valueOf(this.value);
    }

    public double[] doubleValueList(Unit<?> unit) throws IllegalArgumentException {
        return new double[]{this.doubleValue(unit)};
    }

    public double[] doubleValueList() {
        return new double[]{this.doubleValue()};
    }

    public int[] intValueList() {
        return new int[]{this.intValue()};
    }

    public URI valueFile() throws InvalidParameterTypeException {
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), Parameter.getName(this.descriptor));
    }

    private static String getClassTypeError() {
        return Errors.format((int)51, Double.class);
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(double value, Unit<?> unit) throws InvalidParameterValueException {
        FloatParameter.ensureNonNull("unit", unit);
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Unit thisUnit = descriptor.getUnit();
        if (thisUnit == null) {
            throw FloatParameter.unitlessParameter((GeneralParameterDescriptor)descriptor);
        }
        int expectedID = Parameter.getUnitMessageID(thisUnit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format((int)expectedID, unit));
        }
        value = unit.getConverterTo(thisUnit).convert(value);
        this.value = (Double)Parameter.ensureValidValue(descriptor, value);
    }

    public void setValue(double value) throws InvalidParameterValueException {
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        this.value = (Double)Parameter.ensureValidValue(descriptor, value);
    }

    public void setValue(int value) throws InvalidParameterValueException {
        this.setValue((double)value);
    }

    public void setValue(boolean value) throws InvalidParameterValueException {
        this.setValue(value ? 1.0 : 0.0);
    }

    public void setValue(Object value) throws InvalidParameterValueException {
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        this.value = (Double)Parameter.ensureValidValue(descriptor, value);
    }

    public void setValue(double[] values, Unit<?> unit) throws InvalidParameterValueException {
        throw new InvalidParameterTypeException(FloatParameter.getClassTypeError(), Parameter.getName(this.descriptor));
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            FloatParameter that = (FloatParameter)object;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        long code = Double.doubleToLongBits(this.value);
        return (int)code ^ (int)(code >>> 32) + super.hashCode() * 37;
    }

    @Override
    public FloatParameter clone() {
        return (FloatParameter)super.clone();
    }
}

