/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.geotools.coverage.CoverageCache;
import org.geotools.parameter.Parameters;
import org.geotools.util.Utilities;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;

final class CachedOperation {
    private final Operation operation;
    private final String[] names;
    private final Object[] values;
    private final int hashCode;

    CachedOperation(Operation operation, ParameterValueGroup parameters) {
        Map<String, Object> param = Parameters.toNameValueMap((GeneralParameterValue)parameters, new TreeMap<String, Object>());
        this.operation = operation;
        int hashCode = operation.hashCode();
        this.names = new String[param.size()];
        this.values = new Object[this.names.length];
        int index = 0;
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            this.names[index] = entry.getKey().toLowerCase();
            Object value = entry.getValue();
            if (value instanceof Coverage) {
                value = CoverageCache.DEFAULT.reference((Coverage)value);
            }
            if (value != null) {
                hashCode = 37 * hashCode + value.hashCode();
            }
            this.values[index] = value;
            ++index;
        }
        this.hashCode = hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof CachedOperation) {
            CachedOperation that = (CachedOperation)object;
            return Utilities.equals((Object)this.operation, (Object)that.operation) && Arrays.equals(this.names, that.names) && Arrays.equals(this.values, that.values);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

