/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace;

import jams.JAMS;
import jams.JAMSException;
import jams.JAMSProperties;
import jams.model.SmallModelState;
import jams.runtime.JAMSRuntime;
import jams.runtime.StandardRuntime;
import jams.tools.FileTools;
import jams.tools.StringTools;
import jams.tools.XMLTools;
import jams.workspace.InvalidWorkspaceException;
import jams.workspace.TSDumpProcessor;
import jams.workspace.Workspace;
import jams.workspace.stores.DataStore;
import jams.workspace.stores.DefaultOutputDataStore;
import jams.workspace.stores.InputDataStore;
import jams.workspace.stores.J2KTSDataStore;
import jams.workspace.stores.OutputDataStore;
import jams.workspace.stores.ShapeFileDataStore;
import jams.workspace.stores.StandardInputDataStore;
import jams.workspace.stores.TSDataStore;
import jams.workspace.stores.TableDataStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JAMSWorkspace
implements Workspace {
    private static final String CONFIG_FILE_NAME = "config.txt";
    private static final String CONFIG_FILE_COMMENT = "JAMS workspace configuration";
    private static final String CONTEXT_ATTRIBUTE_NAME = "context";
    public static final String INPUT_DIR_NAME = "input";
    public static final String OUTPUT_DIR_NAME = "output";
    public static final String TEMP_DIR_NAME = "tmp";
    public static final String DUMP_DIR_NAME = "dump";
    public static final String LOCAL_INDIR_NAME = "local";
    public static final String EXPLORER_DIR_NAME = "explorer";
    public static final String SUFFIX_XML = "xml";
    private HashMap<String, Document> inputDataStores = new HashMap();
    private HashMap<String, Document> outputDataStores = new HashMap();
    private HashMap<String, Document> registeredInputDataStores = new HashMap();
    private HashMap<String, Document> registeredOutputDataStores = new HashMap();
    private HashMap<String, ArrayList<String>> contextStores = new HashMap();
    private JAMSRuntime runtime;
    private transient ClassLoader classLoader = ClassLoader.getSystemClassLoader();
    private File directory;
    private File inputDirectory;
    private File outputDirectory = null;
    private File outputDataDirectory;
    private File localInputDirectory;
    private File localDumpDirectory;
    private File tmpDirectory;
    private File explorerDirectory;
    private Properties properties = new Properties();
    private ArrayList<DataStore> currentStores = new ArrayList();
    private boolean readonly;

    public JAMSWorkspace(File directory, JAMSRuntime runtime) {
        this(directory, runtime, false);
    }

    public JAMSWorkspace(File directory, JAMSRuntime runtime, boolean readonly) {
        this.runtime = runtime;
        if (runtime.getClassLoader() != null) {
            this.classLoader = runtime.getClassLoader();
        }
        this.directory = directory;
        this.currentStores = new ArrayList();
        this.readonly = readonly;
    }

    public void init() throws InvalidWorkspaceException {
        this.contextStores.clear();
        this.inputDataStores.clear();
        this.outputDataStores.clear();
        this.loadConfig();
        this.checkValidity(this.readonly);
        this.updateDataStores();
        HashSet<DataStore> rmCandidates = new HashSet<DataStore>();
        for (DataStore d : this.currentStores) {
            try {
                if (d instanceof OutputDataStore) {
                    d.close();
                    rmCandidates.add(d);
                    continue;
                }
                d.setWorkspace((Workspace)this);
            }
            catch (IOException ioe) {
                throw new InvalidWorkspaceException(ioe.toString());
            }
        }
        this.currentStores.removeAll(rmCandidates);
    }

    public void setDirectory(File directory) throws InvalidWorkspaceException {
        this.directory = directory;
        this.init();
    }

    public void loadConfig() {
        try {
            this.properties.setProperty("description", "");
            this.properties.setProperty("title", "");
            this.properties.setProperty("persistent", "false");
            this.properties.setProperty("defaultmodel", "model.jam");
            this.properties.setProperty("INPUT_DIR_NAME", INPUT_DIR_NAME);
            this.properties.setProperty("OUTPUT_DIR_NAME", OUTPUT_DIR_NAME);
            this.properties.setProperty("TEMP_DIR_NAME", TEMP_DIR_NAME);
            this.properties.setProperty("LOCAL_INDIR_NAME", LOCAL_INDIR_NAME);
            this.properties.setProperty("DUMP_DIR_NAME", DUMP_DIR_NAME);
            this.properties.setProperty("EXPLORER_DIR_NAME", EXPLORER_DIR_NAME);
            File file = new File(this.directory, CONFIG_FILE_NAME);
            if (file.exists()) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                this.properties.load(is);
                is.close();
            } else {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                this.properties.store(os, CONFIG_FILE_COMMENT);
                os.close();
            }
            if (this.properties.containsKey("readonly")) {
                this.readonly = Boolean.parseBoolean(this.properties.getProperty("readonly"));
            }
        }
        catch (IOException ioe) {
            this.runtime.handle((Throwable)ioe);
        }
    }

    public void saveConfig() {
        try {
            File file = new File(this.directory.getPath() + File.separator + CONFIG_FILE_NAME);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            this.properties.store(os, CONFIG_FILE_COMMENT);
        }
        catch (IOException ioe) {
            this.runtime.handle((Throwable)ioe);
        }
    }

    public void restore(SmallModelState state) {
        Iterator<DataStore> iter = this.getRegisteredDataStores().iterator();
        while (iter.hasNext()) {
            try {
                state.recoverDataStoreState(iter.next());
            }
            catch (IOException e) {
                this.getRuntime().sendHalt(JAMS.i18n("error_occured_while_restoring_model_state") + ":" + e.toString());
                e.printStackTrace();
            }
        }
    }

    public void saveState(SmallModelState state) {
        Iterator<DataStore> iter = this.getRegisteredDataStores().iterator();
        while (iter.hasNext()) {
            state.saveDataStoreState(iter.next());
        }
    }

    private void checkValidity(boolean readonly) throws InvalidWorkspaceException {
        this.readonly = readonly;
        if (!this.directory.isDirectory()) {
            throw new InvalidWorkspaceException(JAMS.i18n("Error_during_model_setup:_") + this.directory.toString() + JAMS.i18n("_is_not_a_directory"));
        }
        this.loadConfig();
        File inDir = new File(this.directory, this.properties.getProperty("INPUT_DIR_NAME"));
        File outDir = new File(this.directory, this.properties.getProperty("OUTPUT_DIR_NAME"));
        File tmpDir = new File(this.directory, this.properties.getProperty("TEMP_DIR_NAME"));
        File localInDir = new File(inDir, this.properties.getProperty("LOCAL_INDIR_NAME"));
        File localDumpDir = new File(localInDir, this.properties.getProperty("DUMP_DIR_NAME"));
        File explorerDir = new File(this.directory, this.properties.getProperty("EXPLORER_DIR_NAME"));
        File[] allDirs = new File[]{inDir, outDir, localInDir, localDumpDir, explorerDir};
        if (this.readonly) {
            for (File dir : allDirs) {
                if (dir.exists()) continue;
                throw new InvalidWorkspaceException(JAMS.i18n("Error_during_model_setup:_") + this.directory.toString() + JAMS.i18n("_does_not_contain_needed_directory_") + dir.toString() + JAMS.i18n("_)"));
            }
        } else {
            try {
                for (File dir : allDirs) {
                    dir.mkdirs();
                }
            }
            catch (SecurityException se) {
                throw new InvalidWorkspaceException(JAMS.i18n("Error_during_model_setup:_") + this.directory.toString() + JAMS.i18n("_is_not_a_valid_workspace!"));
            }
        }
        this.inputDirectory = inDir;
        this.outputDirectory = outDir;
        this.localInputDirectory = localInDir;
        this.localDumpDirectory = localDumpDir;
        this.tmpDirectory = tmpDir;
        this.explorerDirectory = explorerDir;
        if (this.isPersistent()) {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
            this.outputDataDirectory = new File(this.outputDirectory.getPath() + File.separator + sdf.format(cal.getTime()));
        } else {
            this.outputDataDirectory = new File(this.outputDirectory.getPath() + File.separator + "current");
        }
    }

    private String getStoreID(File file) {
        String id = file.getName();
        StringTokenizer tok = new StringTokenizer(id, ".");
        if (tok.countTokens() > 1) {
            id = tok.nextToken();
        }
        return id;
    }

    private String getContextName(Document doc) {
        return doc.getDocumentElement().getAttribute(CONTEXT_ATTRIBUTE_NAME);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public JAMSRuntime getRuntime() {
        return this.runtime;
    }

    public Set<String> getInputDataStoreIDs() {
        return this.inputDataStores.keySet();
    }

    public List<String> getSortedInputDataStoreIDs() {
        ArrayList<String> inIDList = new ArrayList<String>(this.inputDataStores.keySet());
        Collections.sort(inIDList);
        return inIDList;
    }

    public Set<String> getOutputDataStoreIDs() {
        return this.outputDataStores.keySet();
    }

    public void removeDataStore(InputDataStore store) {
        this.inputDataStores.remove(store.getID());
    }

    public void registerInputDataStore(String id, Document doc) {
        if (StringTools.isEmptyString(id)) {
            return;
        }
        if (doc == null) {
            this.registeredInputDataStores.remove(id);
            this.inputDataStores.remove(id);
        } else {
            this.registeredInputDataStores.put(id, doc);
            this.inputDataStores.put(id, doc);
        }
    }

    public void registerOutputDataStore(String id, Document doc) {
        if (StringTools.isEmptyString(id)) {
            return;
        }
        if (doc == null) {
            this.registeredOutputDataStores.remove(id);
        } else {
            this.registeredOutputDataStores.put(id, doc);
        }
    }

    public InputDataStore getInputDataStore(String dsTitle) {
        Document doc = this.inputDataStores.get(dsTitle);
        if (doc == null) {
            return null;
        }
        StandardInputDataStore store = null;
        String type = doc.getDocumentElement().getTagName();
        try {
            if (type.equals("tabledatastore")) {
                store = new TableDataStore(this, dsTitle, doc);
            } else if (type.equals("tsdatastore")) {
                store = new TSDataStore(this, dsTitle, doc);
            } else if (type.equals("j2ktsdatastore")) {
                store = new J2KTSDataStore(this, dsTitle, doc);
            } else if (type.equals("shapefiledatastore")) {
                store = new ShapeFileDataStore(this, dsTitle, doc);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.getRuntime().sendErrorMsg(MessageFormat.format(JAMS.i18n("Error_initializing_datastore_"), dsTitle));
            this.getRuntime().handle((Throwable)cnfe);
            return null;
        }
        catch (IOException ioe) {
            this.getRuntime().sendErrorMsg(MessageFormat.format(JAMS.i18n("Error_initializing_datastore_"), dsTitle));
            this.getRuntime().handle((Throwable)ioe);
            return null;
        }
        catch (URISyntaxException use) {
            this.getRuntime().sendErrorMsg(MessageFormat.format(JAMS.i18n("Error_initializing_datastore_"), dsTitle));
            this.getRuntime().handle((Throwable)use);
            return null;
        }
        this.currentStores.add((DataStore)store);
        return store;
    }

    public ArrayList<DataStore> getRegisteredDataStores() {
        return this.currentStores;
    }

    public ShapeFileDataStore getFirstShapeInputDataStore() {
        InputDataStore store = null;
        Set<String> ids = this.getInputDataStoreIDs();
        for (String id : ids) {
            store = this.getInputDataStore(id);
            if (!(store instanceof ShapeFileDataStore)) continue;
            return (ShapeFileDataStore)store;
        }
        return null;
    }

    private DataStore getDataStoreByID(String storeID) {
        for (int j = 0; j < this.currentStores.size(); ++j) {
            if (!this.currentStores.get(j).getID().equals(storeID)) continue;
            return this.currentStores.get(j);
        }
        return null;
    }

    public OutputDataStore[] getOutputDataStores(String contextName) {
        ArrayList<String> stores = this.contextStores.get(contextName);
        if (stores == null) {
            return new OutputDataStore[0];
        }
        ArrayList<OutputDataStore> result = new ArrayList<OutputDataStore>();
        for (String storeID : stores) {
            OutputDataStore listedStore = (OutputDataStore)this.getDataStoreByID(storeID);
            if (listedStore != null) {
                result.add(listedStore);
                continue;
            }
            Document doc = this.outputDataStores.get(storeID);
            Element elem = (Element)doc.getElementsByTagName("plugin").item(0);
            String className = "";
            if (elem != null) {
                className = elem.getAttribute("type");
            }
            DefaultOutputDataStore store = null;
            if (!StringTools.isEmptyString(className)) {
                try {
                    ClassLoader loader = this.runtime.getClassLoader();
                    Class<?> clazz = loader.loadClass(className);
                    OutputDataStore io = (OutputDataStore)clazz.newInstance();
                    Method method = clazz.getMethod("setWorkspace", JAMSWorkspace.class);
                    method.invoke((Object)io, this);
                    method = clazz.getMethod("setDoc", Document.class);
                    method.invoke((Object)io, doc);
                    method = clazz.getMethod("setID", String.class);
                    method.invoke((Object)io, storeID);
                    NodeList parameterNodes = elem.getElementsByTagName("parameter");
                    for (int j = 0; j < parameterNodes.getLength(); ++j) {
                        Element parameterNode = (Element)parameterNodes.item(j);
                        String attributeName = parameterNode.getAttribute("id");
                        String attributeValue = "";
                        attributeValue = parameterNode.hasAttribute("value") ? parameterNode.getAttribute("value") : null;
                        String methodName = StringTools.getSetterName(attributeName);
                        method = clazz.getMethod(methodName, String.class);
                        method.invoke((Object)io, attributeValue);
                    }
                    store = io;
                }
                catch (Exception ie) {
                    this.getRuntime().handle((Throwable)ie);
                    return null;
                }
            } else {
                store = new DefaultOutputDataStore(this, doc, storeID);
            }
            if (!store.isValid()) continue;
            this.currentStores.add((DataStore)store);
            result.add(store);
        }
        return result.toArray(new OutputDataStore[result.size()]);
    }

    public void close() {
        for (DataStore store : this.currentStores) {
            try {
                store.close();
            }
            catch (IOException ioe) {
                this.runtime.handle((Throwable)ioe);
            }
        }
    }

    public String getTitle() {
        return this.properties.getProperty("title");
    }

    public void setTitle(String title) {
        this.properties.setProperty("title", title);
    }

    public String getDescription() {
        return this.properties.getProperty("description");
    }

    public void setDescription(String description) {
        this.properties.setProperty("description", description);
    }

    public boolean isPersistent() {
        return Boolean.parseBoolean(this.properties.getProperty("persistent"));
    }

    public void setPersistent(boolean persistent) {
        this.properties.setProperty("persistent", Boolean.toString(persistent));
    }

    public int getID() {
        String id = this.properties.getProperty("id");
        if (id == null) {
            return -1;
        }
        return Integer.parseInt(id);
    }

    public void setID(int id) {
        this.properties.setProperty("id", Integer.toString(id));
        this.saveConfig();
    }

    public String getModelFilename() {
        return this.properties.getProperty("defaultmodel");
    }

    public void setModelFile(String path) {
        this.properties.setProperty("defaultmodel", path);
    }

    public void updateDataStores() {
        File[] outChildren;
        File[] inChildren;
        this.inputDataStores.clear();
        for (String storeID : this.registeredInputDataStores.keySet()) {
            this.inputDataStores.put(storeID, this.registeredInputDataStores.get(storeID));
            this.getRuntime().println(MessageFormat.format(JAMS.i18n("Added_input_store_"), storeID, "XML"), 2);
        }
        for (File child : inChildren = FileTools.getFiles(this.inputDirectory, SUFFIX_XML)) {
            try {
                String storeID = this.getStoreID(child);
                if (this.inputDataStores.containsKey(storeID)) continue;
                Document doc = XMLTools.getDocument(child.getAbsolutePath());
                this.inputDataStores.put(storeID, doc);
                this.getRuntime().println(MessageFormat.format(JAMS.i18n("Added_input_store_"), storeID, child.getAbsolutePath()), 2);
            }
            catch (JAMSException jex) {
                this.getRuntime().sendErrorMsg(MessageFormat.format(JAMS.i18n("Error_reading_datastore_"), child.getAbsolutePath()));
            }
        }
        this.outputDataStores.clear();
        for (String storeID : this.registeredOutputDataStores.keySet()) {
            Document doc = this.registeredOutputDataStores.get(storeID);
            if (!this.isEnabledOutputDS(doc)) continue;
            this.outputDataStores.put(storeID, doc);
            this.getRuntime().println(MessageFormat.format(JAMS.i18n("Added_output_store_"), storeID, "XML"), 2);
        }
        for (File child : outChildren = FileTools.getFiles(this.outputDirectory, SUFFIX_XML)) {
            try {
                Document doc;
                String storeID = this.getStoreID(child);
                if (this.outputDataStores.containsKey(storeID) || !this.isEnabledOutputDS(doc = XMLTools.getDocument(child.getAbsolutePath()))) continue;
                this.outputDataStores.put(storeID, doc);
                this.getRuntime().println(MessageFormat.format(JAMS.i18n("Added_output_store_"), storeID, child.getAbsolutePath()), 2);
            }
            catch (JAMSException jex) {
                this.getRuntime().sendErrorMsg(MessageFormat.format(JAMS.i18n("Error_reading_datastore_"), child.getAbsolutePath()));
            }
        }
        for (String storeID : this.outputDataStores.keySet()) {
            Document doc = this.outputDataStores.get(storeID);
            String contextName = this.getContextName(doc);
            ArrayList<String> stores = this.contextStores.get(contextName);
            if (stores == null) {
                stores = new ArrayList();
                this.contextStores.put(contextName, stores);
            }
            stores.add(storeID);
        }
    }

    private boolean isEnabledOutputDS(Document doc) {
        Element root = doc.getDocumentElement();
        return !root.hasAttribute("enabled") || root.getAttribute("enabled").equals(Boolean.toString(true));
    }

    public String dataStoreToString(String dsTitle) throws IOException {
        InputDataStore store = this.getInputDataStore(dsTitle);
        String data = this.dataStoreToString(store);
        store.close();
        return data;
    }

    public String dataStoreToString(InputDataStore store) throws IOException {
        if (store == null) {
            return null;
        }
        if (store instanceof TSDataStore) {
            TSDumpProcessor asciiConverter = new TSDumpProcessor();
            String result = asciiConverter.toASCIIString((TSDataStore)store);
            return result;
        }
        return store.getClass().toString() + JAMS.i18n("_not_yet_supported!");
    }

    public void inputDataStoreToFile(InputDataStore store) throws IOException {
        if (store == null || store.getAccessMode() == 1) {
            return;
        }
        if (store instanceof TSDataStore) {
            TSDumpProcessor asciiConverter = new TSDumpProcessor();
            File file = new File(this.getLocalDumpDirectory(), store.getID() + ".dump");
            asciiConverter.toASCIIFile((TSDataStore)store, file);
            this.getRuntime().sendInfoMsg(JAMS.i18n("Dumped_input_datastore_1") + store.getID() + JAMS.i18n("Dumped_input_datastore_2") + file + JAMS.i18n("Dumped_input_datastore_3"));
        }
        store.close();
    }

    public void inputDataStoreToFile() throws IOException {
        for (String dsTitle : this.getInputDataStoreIDs()) {
            this.inputDataStoreToFile(this.getInputDataStore(dsTitle));
        }
    }

    public String[] getDataStoreIDs(String type) {
        ArrayList<String> list = new ArrayList<String>();
        for (String dsTitle : this.getInputDataStoreIDs()) {
            Document doc = this.inputDataStores.get(dsTitle);
            String thisType = doc.getDocumentElement().getTagName();
            if (!type.equals(thisType)) continue;
            list.add(dsTitle);
        }
        return list.toArray(new String[list.size()]);
    }

    public File getDirectory() {
        return this.directory;
    }

    public File getInputDirectory() {
        return this.inputDirectory;
    }

    public File getOutputDataDirectory() {
        return this.outputDataDirectory;
    }

    public File[] getOutputDataDirectories() {
        File[] list;
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().endsWith(".svn");
            }
        };
        TreeSet<File> files = new TreeSet<File>();
        for (File f : list = this.outputDirectory.listFiles(filter)) {
            files.add(f);
        }
        return files.toArray(new File[0]);
    }

    public File[] getOutputDataFiles(File outputDataDirectory) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                return pathname.isFile() && (pathname.getName().endsWith(".dat") || pathname.getName().endsWith(".sdat") || pathname.getName().endsWith(".cdat")) || pathname.getName().endsWith(".csv");
            }
        };
        return outputDataDirectory.listFiles(filter);
    }

    public File getLocalInputDirectory() {
        return this.localInputDirectory;
    }

    public File getLocalDumpDirectory() {
        return this.localDumpDirectory;
    }

    public File getTempDirectory() {
        return this.tmpDirectory;
    }

    public static void main(String[] args) throws IOException, InvalidWorkspaceException {
        JAMSProperties properties = JAMSProperties.createProperties();
        properties.load("e:/jamsapplication/nsk.jap");
        String[] libs = StringTools.toArray(properties.getProperty("libs", ""), ";");
        StandardRuntime runtime = new StandardRuntime(properties);
        runtime.setDebugLevel(2);
        runtime.addErrorLogObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                System.out.print(arg);
            }
        });
        runtime.addInfoLogObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                System.out.print(arg);
            }
        });
        JAMSWorkspace ws = new JAMSWorkspace(new File("D:/jamsapplication/JAMS-Gehlberg"), runtime, true);
        ws.init();
        InputDataStore store = ws.getInputDataStore("inData");
    }
}

