/*
 * Decompiled with CFR 0.152.
 */
package jams.model;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.JAMSLong;
import jams.data.JAMSTimeInterval;
import jams.io.datatracer.AbstractTracer;
import jams.io.datatracer.DataTracer;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.workspace.stores.Filter;
import jams.workspace.stores.OutputDataStore;

@JAMSComponentDescription(title="Temporal context", author="Sven Kralisch", date="2005-07-31", version="1.0_0", description="This component represents a JAMS context which can be used to represent iteration over discrete time steps typically used in conceptionalenvironmental models")
public class JAMSTemporalContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Time interval of temporal context")
    public JAMSTimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Current date of temporal context")
    public Attribute.Calendar current;
    private Attribute.Calendar lastValue;

    @Override
    protected DataTracer createDataTracer(OutputDataStore store) {
        return new AbstractTracer(this, store, JAMSLong.class){

            @Override
            public void trace() {
                for (Filter filter : this.store.getFilters()) {
                    String string;
                    if (filter.getContext() == JAMSTemporalContext.this || filter.isFiltered(string = filter.getContext().getTraceMark())) continue;
                    return;
                }
                String traceMark = JAMSTemporalContext.this.getTraceMark();
                for (Filter filter : this.store.getFilters()) {
                    if (filter.getContext() != JAMSTemporalContext.this || filter.isFiltered(traceMark)) continue;
                    return;
                }
                if (!this.hasOutput()) {
                    this.setOutput(true);
                    this.startMark();
                }
                this.output(traceMark);
                for (Filter filter : this.getAccessorObjects()) {
                    this.output(filter.getComponentObject());
                }
                this.nextRow();
                this.flush();
            }
        };
    }

    @Override
    public void init() {
        super.init();
        if (this.timeInterval == null) {
            this.getModel().getRuntime().sendErrorMsg(JAMS.i18n("time_interval_for_JAMS_Temporal_context_not_provided"));
        }
        if (this.timeInterval.getEnd() == null || this.timeInterval.getStart() == null) {
            this.getModel().getRuntime().sendErrorMsg(JAMS.i18n("time_interval_for_JAMS_Temporal_context_not_provided"));
        }
        this.lastValue = this.timeInterval.getEnd().clone();
        this.lastValue.add(this.timeInterval.getTimeUnit(), -this.timeInterval.getTimeUnitCount());
        this.lastValue.add(14, 1);
        if (this.current == null) {
            this.current = this.getModel().getRuntime().getDataFactory().createCalendar();
        }
    }

    @Override
    public void initAll() {
        super.initAll();
    }

    @Override
    public void cleanupAll() {
        super.cleanupAll();
    }

    @Override
    public void run() {
        super.run();
        if (!this.isPaused) {
            for (DataTracer dataTracer : this.dataTracers) {
                if (!dataTracer.hasOutput()) continue;
                dataTracer.endMark();
                dataTracer.setOutput(false);
            }
        }
    }

    @Override
    protected ComponentEnumerator getInitAllEnumerator() {
        return this.getInitEnumerator();
    }

    @Override
    protected ComponentEnumerator getCleanupAllEnumerator() {
        return this.getInitEnumerator();
    }

    @Override
    protected ComponentEnumerator getRunEnumerator() {
        if (!this.components.isEmpty()) {
            return new ComponentEnumerator(){
                ComponentEnumerator ce;
                {
                    this.ce = JAMSTemporalContext.this.getChildrenEnumerator();
                }

                public boolean hasNext() {
                    boolean nextTime = JAMSTemporalContext.this.current.before(JAMSTemporalContext.this.lastValue);
                    boolean nextComp = this.ce.hasNext();
                    return nextTime || nextComp;
                }

                public boolean hasPrevious() {
                    boolean prevTime = JAMSTemporalContext.this.current.after(JAMSTemporalContext.this.timeInterval.getStart());
                    boolean prevComp = this.ce.hasPrevious();
                    return prevTime || prevComp;
                }

                public Component next() {
                    if (!this.ce.hasNext() && JAMSTemporalContext.this.current.before(JAMSTemporalContext.this.lastValue)) {
                        for (DataTracer dataTracer : JAMSTemporalContext.this.dataTracers) {
                            dataTracer.trace();
                        }
                        JAMSTemporalContext.this.current.add(JAMSTemporalContext.this.timeInterval.getTimeUnit(), JAMSTemporalContext.this.timeInterval.getTimeUnitCount());
                        this.ce.reset();
                    }
                    return this.ce.next();
                }

                public void reset() {
                    JAMSTemporalContext.this.current.setValue(JAMSTemporalContext.this.timeInterval.getStart().getValue());
                    this.ce.reset();
                }

                public Component previous() {
                    if (this.ce.hasPrevious()) {
                        return this.ce.previous();
                    }
                    JAMSTemporalContext.this.current.add(JAMSTemporalContext.this.timeInterval.getTimeUnit(), -JAMSTemporalContext.this.timeInterval.getTimeUnitCount());
                    while (this.ce.hasNext()) {
                        this.ce.next();
                    }
                    return this.ce.previous();
                }
            };
        }
        return new ComponentEnumerator(){

            public boolean hasNext() {
                return false;
            }

            public boolean hasPrevious() {
                return false;
            }

            public Component next() {
                return null;
            }

            public Component previous() {
                return null;
            }

            public void reset() {
            }
        };
    }

    @Override
    public long getNumberOfIterations() {
        return this.timeInterval.getNumberOfTimesteps();
    }

    @Override
    public String getTraceMark() {
        return this.current.toString();
    }
}

