/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.JAMS;
import jams.JAMSException;
import jams.JAMSLogging;
import jams.meta.ComponentCollection;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.HelpComponent;
import jams.meta.MetaProcessor;
import jams.meta.MetaProcessorDescriptor;
import jams.meta.ModelNode;
import jams.meta.ModelProperties;
import jams.meta.OutputDSDescriptor;
import jams.runtime.JAMSRuntime;
import jams.tools.StringTools;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelDescriptor
extends ComponentCollection {
    private HashMap<String, OutputDSDescriptor> outputDataStores;
    private ArrayList<MetaProcessorDescriptor> preprocessors = new ArrayList();
    private ModelProperties modelProperties;
    private String author = "";
    private String date = "";
    private String description = "";
    private String helpBaseUrl = "";
    private String workspacePath = "";
    private String modelName = "";
    private ModelNode rootNode;

    public ModelDescriptor() {
        JAMSLogging.registerLogger(Logger.getLogger(this.getClass().getName()));
        this.modelProperties = new ModelProperties();
    }

    public ModelDescriptor(ModelDescriptor md) {
        JAMSLogging.registerLogger(Logger.getLogger(this.getClass().getName()));
        this.author = md.author;
        this.date = md.date;
        this.description = md.description;
        this.helpBaseUrl = md.helpBaseUrl;
        this.modelName = md.modelName;
        this.workspacePath = md.workspacePath;
        this.modelProperties = md.getModelProperties();
        this.outputDataStores = (HashMap)md.getDatastores().clone();
        this.preprocessors = (ArrayList)md.getPreprocessors().clone();
        this.rootNode = md.getRootNode().clone(this, true, new HashMap<ContextDescriptor, ContextDescriptor>());
    }

    @Override
    public String createComponentInstanceName(String name) {
        Set<String> names = this.getComponentDescriptors().keySet();
        if (!names.contains(name)) {
            return name;
        }
        String[] sArray = StringTools.toArray(name, "_");
        if (sArray.length > 1) {
            String suffix = "_" + sArray[sArray.length - 1];
            name = name.substring(0, name.length() - suffix.length());
        }
        int i = 1;
        String result = name + "_" + i;
        while (names.contains(result)) {
            result = name + "_" + ++i;
        }
        return result;
    }

    public void addOutputDataStore(OutputDSDescriptor dataStore) {
        this.outputDataStores.put(dataStore.getName(), dataStore);
    }

    public void removeOutputDataStore(OutputDSDescriptor dataStore) {
        this.outputDataStores.remove(dataStore.getName());
    }

    public void initPreprocessors(Node preprocessorNode) {
        this.preprocessors = new ArrayList();
        if (preprocessorNode == null) {
            return;
        }
        NodeList nodes = ((Element)preprocessorNode).getElementsByTagName("metaprocessor");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element processorElement = (Element)nodes.item(i);
            ComponentDescriptor context = this.getComponentDescriptor(processorElement.getAttribute("context"));
            if (context == null || !(context instanceof ContextDescriptor)) continue;
            HashMap<String, String> properties = new HashMap<String, String>();
            NodeList propertyNodes = processorElement.getElementsByTagName("property");
            for (int j = 0; j < propertyNodes.getLength(); ++j) {
                Element attributeElement = (Element)propertyNodes.item(j);
                properties.put(attributeElement.getAttribute("name"), attributeElement.getAttribute("value"));
            }
            String className = processorElement.getAttribute("class");
            boolean enabled = Boolean.parseBoolean(processorElement.getAttribute("enabled"));
            MetaProcessorDescriptor mpd = new MetaProcessorDescriptor(className, (ContextDescriptor)context, enabled);
            mpd.setProperties(properties);
            this.preprocessors.add(mpd);
        }
    }

    public void initDatastores(Node dataStoresNode) {
        this.outputDataStores = new HashMap();
        if (dataStoresNode == null) {
            return;
        }
        NodeList nodes = ((Element)dataStoresNode).getElementsByTagName("outputdatastore");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            ContextDescriptor context = (ContextDescriptor)this.getComponentDescriptor(e.getAttribute("context"));
            if (context == null) {
                Logger.getLogger(this.getClass().getName()).warning(MessageFormat.format(JAMS.i18n("Context_does_not_exist"), e.getAttribute("context")));
                continue;
            }
            String name = e.getAttribute("name");
            boolean enabled = Boolean.parseBoolean(e.getAttribute("enabled"));
            OutputDSDescriptor od = new OutputDSDescriptor(context);
            od.setName(name);
            od.setEnabled(enabled);
            ArrayList<ContextAttribute> contextAttributes = od.getContextAttributes();
            NodeList attributeNodes = e.getElementsByTagName("attribute");
            for (int j = 0; j < attributeNodes.getLength(); ++j) {
                Element attributeElement = (Element)attributeNodes.item(j);
                String attributeName = attributeElement.getAttribute("id");
                ContextAttribute ca = context.getDynamicAttributes().get(attributeName);
                if (ca == null) {
                    ca = context.getStaticAttributes().get(attributeName);
                }
                if (ca == null) {
                    Logger.getLogger(this.getClass().getName()).warning(MessageFormat.format(JAMS.i18n("Attribute_does_not_exist_and_is_removed"), attributeName, od.getName()));
                    continue;
                }
                contextAttributes.add(ca);
            }
            NodeList filterNodes = e.getElementsByTagName("filter");
            for (int j = 0; j < filterNodes.getLength(); ++j) {
                Element filterElement = (Element)filterNodes.item(j);
                String expression = filterElement.getAttribute("expression");
                ContextDescriptor filterContext = (ContextDescriptor)this.getComponentDescriptor(filterElement.getAttribute("context"));
                od.addFilter(filterContext, expression);
            }
            this.outputDataStores.put(od.getName(), od);
        }
    }

    public HashMap<String, OutputDSDescriptor> getDatastores() {
        return this.outputDataStores;
    }

    public void setModelParameters(Element launcherNode) {
        ArrayList<JAMSException> exceptions = new ArrayList<JAMSException>();
        ModelProperties mProp = this.getModelProperties();
        mProp.removeAll();
        NodeList groupNodes = launcherNode.getElementsByTagName("group");
        for (int gindex = 0; gindex < groupNodes.getLength(); ++gindex) {
            Node node = groupNodes.item(gindex);
            Element groupElement = (Element)node;
            String groupName = groupElement.getAttribute("name");
            mProp.addGroup(groupName);
            ModelProperties.Group group = mProp.getGroup(groupName);
            NodeList groupChildNodes = groupElement.getChildNodes();
            for (int pindex = 0; pindex < groupChildNodes.getLength(); ++pindex) {
                node = groupChildNodes.item(pindex);
                if (node.getNodeName().equalsIgnoreCase("property")) {
                    Element propertyElement = (Element)node;
                    try {
                        ModelProperties.ModelProperty property = this.getPropertyFromElement(propertyElement, mProp);
                        mProp.addProperty(group, property);
                    }
                    catch (JAMSException je) {
                        exceptions.add(je);
                        Logger.getLogger(this.getClass().getName()).warning(je.getMessage());
                    }
                }
                if (!node.getNodeName().equalsIgnoreCase("subgroup")) continue;
                Element subgroupElement = (Element)node;
                String subgroupName = subgroupElement.getAttribute("name");
                ModelProperties.Group subgroup = mProp.createSubgroup(group, subgroupName);
                this.setHelpComponent(subgroupElement, subgroup);
                NodeList propertyNodes = subgroupElement.getElementsByTagName("property");
                for (int kindex = 0; kindex < propertyNodes.getLength(); ++kindex) {
                    Element propertyElement = (Element)propertyNodes.item(kindex);
                    try {
                        ModelProperties.ModelProperty property = this.getPropertyFromElement(propertyElement, mProp);
                        mProp.addProperty(subgroup, property);
                        continue;
                    }
                    catch (JAMSException je) {
                        exceptions.add(je);
                        Logger.getLogger(this.getClass().getName()).warning(je.getMessage());
                    }
                }
            }
        }
    }

    private void setHelpComponent(Element theElement, ModelProperties.ModelElement theModelElement) throws DOMException {
        HelpComponent helpComponent = new HelpComponent(theElement);
        theModelElement.setHelpComponent(helpComponent);
    }

    private ModelProperties.ModelProperty getPropertyFromElement(Element propertyElement, ModelProperties mProp) {
        String lenStr;
        String range;
        StringTokenizer tok;
        ModelProperties.ModelProperty property = mProp.createProperty();
        property.component = this.getComponentDescriptor(propertyElement.getAttribute("component"));
        if (property.component == null) {
            throw new JAMSException(JAMS.i18n("Component_") + propertyElement.getAttribute("component") + JAMS.i18n("_does_not_exist,_but_is_referred_in_list_of_model_parameters!") + JAMS.i18n("Will_be_removed_when_model_is_saved!"), JAMS.i18n("Error_loading_model"));
        }
        String attributeName = propertyElement.getAttribute("attribute");
        if (!attributeName.equals("%enable%")) {
            property.var = property.component.getComponentFields().get(attributeName);
            if (property.component instanceof ContextDescriptor) {
                property.attribute = ((ContextDescriptor)property.component).getStaticAttributes().get(attributeName);
            }
        }
        if (property.attribute == null && property.var == null && !attributeName.equals("%enable%")) {
            throw new JAMSException(JAMS.i18n("Attribute_") + attributeName + JAMS.i18n("_does_not_exist_in_component_") + property.component.getInstanceName() + JAMS.i18n("._Removing_visual_editor!"), JAMS.i18n("Error_loading_model"));
        }
        property.description = propertyElement.getAttribute("description");
        property.name = propertyElement.getAttribute("name");
        if (propertyElement.hasAttribute("value") && !attributeName.equals("%enable%")) {
            String valueString = propertyElement.getAttribute("value");
            if (property.var != null) {
                property.var.setValue(valueString);
            } else {
                property.attribute.setValue(valueString);
            }
        }
        if ((tok = new StringTokenizer(range = propertyElement.getAttribute("range"), ";")).countTokens() == 2) {
            property.lowerBound = Double.parseDouble(tok.nextToken());
            property.upperBound = Double.parseDouble(tok.nextToken());
        }
        if ((lenStr = propertyElement.getAttribute("length")) != null && lenStr.length() > 0) {
            property.length = Integer.parseInt(lenStr);
        }
        this.setHelpComponent(propertyElement, property);
        return property;
    }

    public ModelProperties getModelProperties() {
        return this.modelProperties;
    }

    public void setModelProperties(ModelProperties modelProperties) {
        this.modelProperties = modelProperties;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHelpBaseUrl() {
        return this.helpBaseUrl;
    }

    public void setHelpBaseUrl(String helpBaseUrl) {
        this.helpBaseUrl = helpBaseUrl;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public void setWorkspacePath(String workspacePath) {
        this.workspacePath = workspacePath;
    }

    public ModelNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(ModelNode rootNode) {
        this.rootNode = rootNode;
    }

    public String getModelName() {
        return ((ComponentDescriptor)this.rootNode.getUserObject()).getInstanceName();
    }

    public ArrayList<ComponentField> getParameterFields() {
        ArrayList<ComponentField> fields = new ArrayList<ComponentField>();
        Enumeration<TreeNode> nodes = this.rootNode.breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            ComponentDescriptor cd = (ComponentDescriptor)((ModelNode)nodes.nextElement()).getUserObject();
            fields.addAll(cd.getParameterFields());
        }
        return fields;
    }

    public ArrayList<MetaProcessorDescriptor> getPreprocessors() {
        return this.preprocessors;
    }

    public void metaProcess(JAMSRuntime rt) {
        boolean metaProcessorActive = false;
        for (MetaProcessorDescriptor mpd : this.preprocessors) {
            if (!mpd.isEnabled()) continue;
            try {
                Class<?> clazz = rt.getClassLoader().loadClass(mpd.getClassName());
                MetaProcessor mp = (MetaProcessor)clazz.newInstance();
                for (Map.Entry<String, String> e : mpd.getProperties().entrySet()) {
                    mp.setValue(e.getKey(), e.getValue());
                }
                if (!metaProcessorActive) {
                    rt.println("");
                    metaProcessorActive = true;
                }
                rt.println("Running MetaProcessor " + clazz.getName() + " on " + mpd.getContext().getInstanceName());
                mp.process(mpd.getContext(), this, rt);
            }
            catch (Exception ex) {
                throw new JAMSException("Error while preprocessing model:\n" + StringTools.getStackTraceString(ex.getStackTrace()), (Throwable)ex);
            }
        }
        if (metaProcessorActive) {
            rt.println("");
        }
    }
}

