/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.JAMS;
import jams.JAMSException;
import jams.JAMSLogging;
import jams.meta.ComponentCollection;
import jams.meta.ComponentField;
import jams.meta.ModelNode;
import jams.model.Context;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import jams.tools.StringTools;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.logging.Logger;

public class ComponentDescriptor
extends Observable {
    private String instanceName = "";
    private Class<?> clazz;
    private ArrayList<String> componentFieldList = new ArrayList();
    protected HashMap<String, ComponentField> componentFields = new HashMap();
    private ComponentCollection componentRepository;
    private String version = "1.0_0";
    private ModelNode node;
    private boolean enabled = true;

    public ComponentDescriptor(String instanceName, Class clazz) {
        JAMSLogging.registerLogger(Logger.getLogger(this.getClass().getName()));
        if (clazz == null) {
            throw new NullClassException(JAMS.i18n("Could_not_find_class_for_component_") + instanceName + "_!", JAMS.i18n("Error"));
        }
        JAMSComponentDescription jcd = clazz.getAnnotation(JAMSComponentDescription.class);
        if (jcd != null) {
            this.version = jcd.version();
        }
        this.clazz = clazz;
        this.instanceName = instanceName;
        this.init();
    }

    public ComponentDescriptor(String instanceName, Class clazz, String versionID, ComponentCollection md) {
        this(instanceName, clazz);
        if (versionID != null && !versionID.equals(this.version)) {
            String message = MessageFormat.format(JAMS.i18n("ComponentVersionMismatch"), instanceName, this.version, versionID);
            VersionComments vc = clazz.getAnnotation(VersionComments.class);
            if (vc != null) {
                for (VersionComments.Entry entry : vc.entries()) {
                    if (entry.version().compareTo(versionID) <= 0) continue;
                    message = message + "\n=== version " + entry.version() + " ===\n" + entry.comment();
                }
            }
            Logger.getLogger(this.getClass().getName()).warning(message);
        }
        this.register(md);
    }

    public ComponentDescriptor(Class clazz, String versionID, ComponentCollection md) {
        this(clazz.getSimpleName(), clazz, versionID, md);
    }

    private void init() {
        Field[] compFields;
        for (Field field : compFields = this.getClazz().getFields()) {
            JAMSVarDescription jvd = field.getAnnotation(JAMSVarDescription.class);
            if (jvd == null) continue;
            int accessType = jvd.access() == JAMSVarDescription.AccessType.READ ? 0 : (jvd.access() == JAMSVarDescription.AccessType.WRITE ? 1 : 2);
            this.getComponentFields().put(field.getName(), new ComponentField(field.getName(), field.getType(), accessType, this));
            this.getComponentFieldList().add(field.getName());
        }
    }

    public String toString() {
        return this.getInstanceName();
    }

    public void setComponentAttribute_(String name, String value) {
        ComponentField ca = this.getComponentFields().get(name);
        if (ca != null) {
            ca.setValue(value);
        }
    }

    public ComponentDescriptor cloneNode() {
        ComponentDescriptor copy = new ComponentDescriptor(this.getInstanceName(), this.getClazz());
        copy.setEnabled(this.isEnabled());
        for (String name : this.componentFields.keySet()) {
            ComponentField ca = this.componentFields.get(name);
            ComponentField caCopy = new ComponentField(ca.getName(), ca.getType(), ca.getAccessType(), copy);
            caCopy.setValue(ca.getValue());
            copy.componentFields.put(name, caCopy);
            if (ca.getContextAttributes().size() <= 0) continue;
            caCopy.linkToAttribute(ca.getContext(), ca.getAttribute());
        }
        return copy;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public ArrayList<String> getComponentFieldList() {
        return this.componentFieldList;
    }

    public HashMap<String, ComponentField> getComponentFields() {
        return this.componentFields;
    }

    public void unregister() {
        this.componentRepository.unRegisterComponentDescriptor(this);
        this.componentRepository = null;
    }

    public final void register(ComponentCollection md) {
        this.componentRepository = md;
        this.setInstanceName(this.instanceName);
    }

    public void setInstanceName(String name) {
        String oldName = this.instanceName;
        this.instanceName = this.componentRepository.registerComponentDescriptor(oldName, name, this);
        if (!oldName.equals(this.instanceName)) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ComponentCollection getComponentRepository() {
        return this.componentRepository;
    }

    public String getVersion() {
        return this.version;
    }

    public ComponentField createComponentField(String name, Class type, int accessType) {
        return new ComponentField(name, type, accessType, this);
    }

    public ArrayList<ComponentField> getParameterFields() {
        ArrayList<ComponentField> fields = new ArrayList<ComponentField>();
        for (String fieldName : this.getComponentFieldList()) {
            ComponentField field = this.getComponentFields().get(fieldName);
            if (StringTools.isEmptyString(field.getValue())) continue;
            fields.add(field);
        }
        return fields;
    }

    public ModelNode getNode() {
        return this.node;
    }

    public void setNode(ModelNode node) {
        this.node = node;
    }

    public int getType() {
        if (this.node != null) {
            return this.node.getType();
        }
        if (Context.class.isAssignableFrom(this.clazz)) {
            return 1;
        }
        return 0;
    }

    public class NullClassException
    extends JAMSException {
        public NullClassException(String message, String header) {
            super(message, header);
        }
    }
}

