/*
 * Decompiled with CFR 0.152.
 */
package jams.io;

import jams.JAMS;
import jams.JAMSException;
import jams.data.DataFactory;
import jams.data.JAMSData;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.ModelDescriptor;
import jams.meta.ModelNode;
import jams.meta.OutputDSDescriptor;
import jams.model.Component;
import jams.model.Context;
import jams.model.GUIComponent;
import jams.model.JAMSModel;
import jams.model.JAMSVarDescription;
import jams.model.Model;
import jams.runtime.JAMSRuntime;
import jams.tools.JAMSTools;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class ModelLoader {
    private HashMap<String, Component> componentRepository = new HashMap();
    private transient ClassLoader loader;
    private DataFactory dataFactory;
    private Model jamsModel;
    private transient HashMap<Component, ArrayList<Field>> nullFields = new HashMap();
    private HashMap<String, Integer> idMap = new HashMap();
    private HashMap<Integer, String> versionMap = new HashMap();
    private int maxID = 0;

    public ModelLoader(JAMSRuntime rt) {
        this.loader = rt.getClassLoader();
        this.dataFactory = rt.getDataFactory();
        this.jamsModel = new JAMSModel(rt);
        this.jamsModel.setModel(this.jamsModel);
    }

    public Model loadModel(ModelDescriptor md) {
        ModelNode rootNode = md.getRootNode();
        ContextDescriptor modelContext = (ContextDescriptor)rootNode.getUserObject();
        this.jamsModel.setName(modelContext.getInstanceName());
        this.componentRepository.put(this.jamsModel.getName(), (Component)this.jamsModel);
        for (ContextAttribute attribute : modelContext.getStaticAttributes().values()) {
            this.jamsModel.addAttribute(attribute.getName(), attribute.getType().getName(), attribute.getValue());
        }
        this.jamsModel.setWorkspacePath(md.getWorkspacePath());
        if (this.jamsModel.getWorkspace() != null) {
            for (OutputDSDescriptor ds : md.getDatastores().values()) {
                try {
                    Document document = ds.createDocument();
                    this.jamsModel.getWorkspace().registerOutputDataStore(ds.getName(), document);
                }
                catch (ParserConfigurationException pce) {
                    this.jamsModel.getRuntime().handle((Throwable)pce);
                }
            }
        }
        this.jamsModel.getRuntime().println(JAMS.i18n("*************************************"), 1);
        this.jamsModel.getRuntime().println(JAMS.i18n("model_____:_") + this.jamsModel.getName(), 1);
        this.jamsModel.getRuntime().println(JAMS.i18n("workspace_:_") + this.jamsModel.getWorkspacePath(), 1);
        this.jamsModel.getRuntime().println(JAMS.i18n("author____:_") + md.getAuthor(), 1);
        this.jamsModel.getRuntime().println(JAMS.i18n("date______:_") + md.getDate(), 1);
        this.jamsModel.getRuntime().println(JAMS.i18n("*************************************"), 1);
        ArrayList<Component> childComponentList = new ArrayList<Component>();
        for (int index = 0; index < rootNode.getChildCount(); ++index) {
            ModelNode node = (ModelNode)rootNode.getChildAt(index);
            try {
                Component topComponent = this.loadComponent(node);
                if (topComponent == null) continue;
                childComponentList.add(topComponent);
                continue;
            }
            catch (ModelSpecificationException iae) {
                this.jamsModel.getRuntime().handle((Throwable)((Object)iae));
            }
        }
        this.jamsModel.setComponents(childComponentList);
        this.jamsModel.setNullFields(this.nullFields);
        ArrayList<Integer> idList = new ArrayList<Integer>(this.idMap.values());
        Collections.sort(idList);
        HashMap<Integer, String> classMap = new HashMap<Integer, String>();
        for (String className : this.idMap.keySet()) {
            classMap.put(this.idMap.get(className), className);
        }
        this.jamsModel.getRuntime().println(JAMS.i18n("Components:"), 1);
        for (Integer id : idList) {
            this.jamsModel.getRuntime().println("[id=" + String.format("%03d", id) + ", class=" + (String)classMap.get(id) + ", version=" + this.versionMap.get(id) + "]", 1);
        }
        return this.jamsModel;
    }

    private void registerComponent(ComponentDescriptor cd) {
        String className = cd.getClazz().getName();
        String version = cd.getVersion();
        if (!this.idMap.containsKey(className)) {
            int id = ++this.maxID;
            this.idMap.put(className, id);
            this.versionMap.put(id, version);
        }
    }

    public Component loadComponent(ModelNode rootNode) {
        String varClassName = "";
        Class<?> componentClazz = null;
        Class<?> varClazz = null;
        ArrayList<Component> childComponentList = new ArrayList<Component>();
        ComponentDescriptor rootCd = (ComponentDescriptor)rootNode.getUserObject();
        if (!rootCd.isEnabled()) {
            return null;
        }
        String componentName = rootCd.getInstanceName();
        String componentClassName = rootCd.getClazz().getName();
        Component existingComponent = this.componentRepository.get(componentName);
        if (existingComponent != null) {
            throw new ModelSpecificationException(JAMS.i18n("Component_with_name_") + componentName + JAMS.i18n("_is_already_exisiting_(") + existingComponent.getClass() + JAMS.i18n(")._Please_make_sure_component_names_are_unique!_Stopping_model_loading!"));
        }
        this.registerComponent(rootCd);
        Component component = null;
        try {
            componentClazz = this.loader.loadClass(componentClassName);
            component = (Component)componentClazz.newInstance();
            component.setModel(this.jamsModel);
            component.setInstanceName(componentName);
            if (component instanceof GUIComponent) {
                this.jamsModel.getRuntime().addGUIComponent((GUIComponent)component);
            }
            ArrayList<Field> nf = this.createMembers(component);
            this.nullFields.put(component, nf);
        }
        catch (ClassNotFoundException cnfe) {
            this.jamsModel.getRuntime().handle((Throwable)cnfe, false);
            return null;
        }
        catch (InstantiationException ie) {
            this.jamsModel.getRuntime().handle((Throwable)ie, false);
        }
        catch (IllegalAccessException iae) {
            this.jamsModel.getRuntime().handle((Throwable)iae, false);
        }
        catch (Throwable t) {
            this.jamsModel.getRuntime().handle(t, false);
        }
        this.componentRepository.put(componentName, component);
        for (ComponentField cdField : rootCd.getComponentFields().values()) {
            String varName = cdField.getName();
            try {
                Field field = JAMSTools.getField(componentClazz, varName);
                varClassName = field.getType().getName();
                if (field.isAnnotationPresent(JAMSVarDescription.class)) {
                    JAMSVarDescription jvd = field.getAnnotation(JAMSVarDescription.class);
                    String varValue = cdField.getValue();
                    if (varValue != null) {
                        Object data;
                        JAMSData[] variable;
                        varClazz = Class.forName(varClassName);
                        if (varClazz.isArray() && JAMSData.class.isAssignableFrom(varClazz.getComponentType())) {
                            String[] varValues = varValue.split(";");
                            Class<?> varComponentClazz = varClazz.getComponentType();
                            JAMSData[] array = (JAMSData[])Array.newInstance(varComponentClazz, varValues.length);
                            for (int i = 0; i < varValues.length; ++i) {
                                array[i] = this.dataFactory.createInstance(varComponentClazz);
                                array[i].setValue(varValues[i]);
                            }
                            variable = array;
                        } else if (JAMSData.class.isAssignableFrom(varClazz)) {
                            JAMSData[] jamsVar = this.dataFactory.createInstance(varClazz);
                            jamsVar.setValue(varValue);
                            variable = jamsVar;
                        } else {
                            throw new ModelSpecificationException(JAMS.i18n("Component_") + componentName + JAMS.i18n(":_variable_") + varName + JAMS.i18n(":_wrong_type!"));
                        }
                        try {
                            data = JAMSTools.setField(component, field, variable);
                        }
                        catch (NoSuchMethodException nsme) {
                            throw new ModelSpecificationException(JAMS.i18n("Component_") + componentName + JAMS.i18n(":_variable_") + varName + JAMS.i18n(":_Access_exception!"), nsme);
                        }
                        this.nullFields.get(component).remove(field);
                        if (data instanceof JAMSData) {
                            String id = componentName + "." + varName;
                            this.jamsModel.getRuntime().getDataHandles().put(id, (JAMSData)data);
                        }
                    }
                    if (cdField.getContext() == null) continue;
                    String contextName = cdField.getContext().getInstanceName();
                    Component context = this.componentRepository.get(contextName);
                    if (context == null) {
                        throw new ModelSpecificationException(JAMS.i18n("Component_") + "\"" + componentName + JAMS.i18n("_context_") + contextName + JAMS.i18n("_does_not_exist!"));
                    }
                    if (!(context instanceof Context)) {
                        throw new ModelSpecificationException(JAMS.i18n("Component_") + componentName + JAMS.i18n(":_Component_") + contextName + JAMS.i18n("_must_be_of_type_JAMSSpatialContext!"));
                    }
                    Context sc = (Context)context;
                    String attributeName = cdField.getAttribute();
                    if (jvd.access() == JAMSVarDescription.AccessType.READ) {
                        sc.addAccess(component, varName, attributeName, 0);
                    } else if (jvd.access() == JAMSVarDescription.AccessType.WRITE) {
                        sc.addAccess(component, varName, attributeName, 1);
                    } else if (jvd.access() == JAMSVarDescription.AccessType.READWRITE) {
                        sc.addAccess(component, varName, attributeName, 2);
                    }
                    this.nullFields.get(component).remove(field);
                    continue;
                }
                throw new ModelSpecificationException(JAMS.i18n("Component_") + componentName + JAMS.i18n(":_variable_") + varName + JAMS.i18n("_can_not_be_accessed_(missing_annotation)!"));
            }
            catch (NoSuchFieldException nsfe) {
                throw new ModelSpecificationException(JAMS.i18n("Component_") + componentName + JAMS.i18n(":_variable_") + varName + JAMS.i18n("_not_found!"), nsfe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ModelSpecificationException(JAMS.i18n("Component_") + componentName + JAMS.i18n(":_variable_class_") + varClassName + JAMS.i18n("_not_found!"), cnfe);
            }
            catch (IllegalArgumentException iae) {
                throw new ModelSpecificationException(JAMS.i18n("Component_") + componentName + JAMS.i18n(":_variable_") + varName + JAMS.i18n(":_wrong_type!"), iae);
            }
            catch (InstantiationException ie) {
                throw new ModelSpecificationException(JAMS.i18n("Component_") + componentName + JAMS.i18n(":_variable_") + varName + JAMS.i18n(":_Instantiation_exception!"), ie);
            }
            catch (IllegalAccessException iae) {
                throw new ModelSpecificationException(JAMS.i18n("Component_") + componentName + JAMS.i18n(":_variable_") + varName + JAMS.i18n(":_Access_exception!"), iae);
            }
            catch (Throwable ex) {
                this.jamsModel.getRuntime().handle(ex);
            }
        }
        if (rootCd instanceof ContextDescriptor) {
            if (!Context.class.isAssignableFrom(component.getClass())) {
                throw new ModelSpecificationException(JAMS.i18n("Attribute_tag_can_only_be_used_inside_context_components!_(component_") + componentName + JAMS.i18n(")"));
            }
            ContextDescriptor contextCd = (ContextDescriptor)rootCd;
            for (ContextAttribute attribute : contextCd.getStaticAttributes().values()) {
                ((Context)component).addAttribute(attribute.getName(), attribute.getType().getName(), attribute.getValue());
            }
        }
        for (int index = 0; index < rootNode.getChildCount(); ++index) {
            ModelNode childNode = (ModelNode)rootNode.getChildAt(index);
            Component childComponent = this.loadComponent(childNode);
            if (childComponent == null) continue;
            childComponentList.add(childComponent);
        }
        if (component instanceof Context) {
            ((Context)component).setComponents(childComponentList);
        }
        return component;
    }

    public HashMap<Component, ArrayList<Field>> getNullFields() {
        return this.nullFields;
    }

    public void setNullFields(HashMap<Component, ArrayList<Field>> nullFields) {
        this.nullFields = nullFields;
    }

    public HashMap<String, Integer> getIdMap() {
        return this.idMap;
    }

    private ArrayList<Field> createMembers(Component component) throws IllegalAccessException, InstantiationException {
        ArrayList<Field> result = new ArrayList<Field>();
        Field[] fields = component.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            Object o = fields[i].get(component);
            Class<?> dataType = fields[i].getType();
            if (!JAMSData.class.isAssignableFrom(dataType) || !fields[i].isAnnotationPresent(JAMSVarDescription.class)) continue;
            JAMSData dataObject = (JAMSData)o;
            JAMSVarDescription jvd = fields[i].getAnnotation(JAMSVarDescription.class);
            if (!(dataObject != null || jvd.defaultValue().equals("%NULL%") && jvd.access() != JAMSVarDescription.AccessType.WRITE)) {
                dataObject = this.dataFactory.createInstance(dataType);
                fields[i].set(component, dataObject);
            } else {
                result.add(fields[i]);
            }
            if (jvd.defaultValue().equals("%NULL%")) continue;
            try {
                dataObject.setValue(jvd.defaultValue());
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new JAMSException("Invalid default value (" + jvd.defaultValue() + ") for field " + fields[i].getName() + " in component " + component.getInstanceName(), (Throwable)nfe);
            }
        }
        return result;
    }

    class ModelSpecificationException
    extends JAMSException {
        public ModelSpecificationException(String errorMsg, Throwable e) {
            super(errorMsg, e);
        }

        public ModelSpecificationException(String errorMsg) {
            super(errorMsg);
        }
    }
}

