/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.multiwindow;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.EarthFlat;
import gov.nasa.worldwind.layers.AirspaceLayer;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.BMNGOneImage;
import gov.nasa.worldwind.layers.Earth.BMNGWMSLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3WMSLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.StarsLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.Box;
import gov.nasa.worldwind.render.airspaces.Cake;
import gov.nasa.worldwind.render.airspaces.CappedCylinder;
import gov.nasa.worldwind.render.airspaces.Curtain;
import gov.nasa.worldwind.render.airspaces.Orbit;
import gov.nasa.worldwind.render.airspaces.PartialCappedCylinder;
import gov.nasa.worldwind.render.airspaces.PolyArc;
import gov.nasa.worldwind.render.airspaces.Polygon;
import gov.nasa.worldwind.render.airspaces.Route;
import gov.nasa.worldwind.render.airspaces.SphereAirspace;
import gov.nasa.worldwind.render.airspaces.TrackAirspace;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.view.orbit.FlatOrbitView;
import gov.nasa.worldwindx.examples.util.HighlightController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SharedShapes {
    protected static Layer makeAirspaceLayer() {
        AirspaceLayer airspaceLayer = new AirspaceLayer();
        airspaceLayer.setName("Airspaces");
        BasicAirspaceAttributes basicAirspaceAttributes = new BasicAirspaceAttributes();
        basicAirspaceAttributes.setMaterial(Material.RED);
        AbstractAirspace abstractAirspace = new Orbit(LatLon.fromDegrees(37.5, -120.0), LatLon.fromDegrees(42.5, -120.0), "Center", 100000.0);
        abstractAirspace.setAltitudes(10000.0, 20000.0);
        abstractAirspace.setTerrainConforming(true);
        abstractAirspace.setAttributes(basicAirspaceAttributes);
        airspaceLayer.addAirspace(abstractAirspace);
        abstractAirspace = new Curtain(Arrays.asList(LatLon.fromDegrees(37.5, -112.5), LatLon.fromDegrees(42.5, -112.5), LatLon.fromDegrees(37.5, -107.5)));
        abstractAirspace.setAltitudes(10000.0, 20000.0);
        abstractAirspace.setTerrainConforming(true);
        abstractAirspace.setAttributes(basicAirspaceAttributes);
        airspaceLayer.addAirspace(abstractAirspace);
        abstractAirspace = new Polygon(Arrays.asList(LatLon.fromDegrees(37.5, -102.5), LatLon.fromDegrees(42.5, -102.5), LatLon.fromDegrees(37.5, -97.5)));
        abstractAirspace.setAltitudes(10000.0, 20000.0);
        abstractAirspace.setTerrainConforming(true);
        abstractAirspace.setAttributes(basicAirspaceAttributes);
        airspaceLayer.addAirspace(abstractAirspace);
        abstractAirspace = new PolyArc(Arrays.asList(LatLon.fromDegrees(37.5, -92.5), LatLon.fromDegrees(42.5, -92.5), LatLon.fromDegrees(37.5, -87.5)), 200000.0, Angle.fromDegrees(0.0), Angle.fromDegrees(90.0));
        abstractAirspace.setAltitudes(10000.0, 20000.0);
        abstractAirspace.setTerrainConforming(true);
        abstractAirspace.setAttributes(basicAirspaceAttributes);
        airspaceLayer.addAirspace(abstractAirspace);
        abstractAirspace = new Cake(Arrays.asList(new Cake.Layer(LatLon.fromDegrees(40.0, -80.0), 100000.0, Angle.ZERO, Angle.ZERO, 10000.0, 20000.0), new Cake.Layer(LatLon.fromDegrees(40.0, -80.0), 50000.0, Angle.ZERO, Angle.ZERO, 20000.0, 30000.0), new Cake.Layer(LatLon.fromDegrees(40.0, -80.0), 25000.0, Angle.ZERO, Angle.ZERO, 30000.0, 40000.0)));
        abstractAirspace.setTerrainConforming(true);
        abstractAirspace.setAttributes(basicAirspaceAttributes);
        airspaceLayer.addAirspace(abstractAirspace);
        abstractAirspace = new CappedCylinder(LatLon.fromDegrees(30.0, -120.0), 100000.0);
        abstractAirspace.setAltitudes(10000.0, 20000.0);
        abstractAirspace.setTerrainConforming(true);
        abstractAirspace.setAttributes(basicAirspaceAttributes);
        airspaceLayer.addAirspace(abstractAirspace);
        abstractAirspace = new PartialCappedCylinder(LatLon.fromDegrees(30.0, -110.0), 100000.0, Angle.fromDegrees(30.0), Angle.fromDegrees(330.0));
        abstractAirspace.setAltitudes(10000.0, 20000.0);
        abstractAirspace.setTerrainConforming(true);
        abstractAirspace.setAttributes(basicAirspaceAttributes);
        airspaceLayer.addAirspace(abstractAirspace);
        abstractAirspace = new SphereAirspace(LatLon.fromDegrees(30.0, -100.0), 100000.0);
        abstractAirspace.setAltitudes(10000.0, 20000.0);
        abstractAirspace.setTerrainConforming(true);
        abstractAirspace.setAttributes(basicAirspaceAttributes);
        airspaceLayer.addAirspace(abstractAirspace);
        abstractAirspace = new TrackAirspace(Arrays.asList(new Box(LatLon.fromDegrees(27.5, -92.5), LatLon.fromDegrees(32.5, -92.5), 100000.0, 100000.0), new Box(LatLon.fromDegrees(32.5, -92.5), LatLon.fromDegrees(27.5, -87.5), 100000.0, 100000.0)));
        ((TrackAirspace)abstractAirspace).getLegs().get(0).setAltitudes(10000.0, 20000.0);
        ((TrackAirspace)abstractAirspace).getLegs().get(1).setAltitudes(20000.0, 30000.0);
        abstractAirspace.setTerrainConforming(true);
        abstractAirspace.setAttributes(basicAirspaceAttributes);
        airspaceLayer.addAirspace(abstractAirspace);
        abstractAirspace = new Route(Arrays.asList(LatLon.fromDegrees(27.5, -82.5), LatLon.fromDegrees(32.5, -82.5), LatLon.fromDegrees(27.5, -77.5)), 200000.0);
        abstractAirspace.setAltitudes(10000.0, 20000.0);
        abstractAirspace.setTerrainConforming(true);
        abstractAirspace.setAttributes(basicAirspaceAttributes);
        airspaceLayer.addAirspace(abstractAirspace);
        return airspaceLayer;
    }

    public static void main(String[] stringArray) {
        Layer[] layerArray = new Layer[]{new StarsLayer(), new CompassLayer(), new BMNGOneImage(), new BMNGWMSLayer(), new LandsatI3WMSLayer()};
        Layer[] layerArray2 = new Layer[]{SharedShapes.makeAirspaceLayer()};
        Layer[] layerArray3 = new Layer[layerArray.length + layerArray2.length];
        System.arraycopy(layerArray, 0, layerArray3, 0, layerArray.length);
        System.arraycopy(layerArray2, 0, layerArray3, layerArray.length, layerArray2.length);
        BasicModel basicModel = new BasicModel(new Earth(), new LayerList(layerArray3));
        BasicModel basicModel2 = new BasicModel(new EarthFlat(), new LayerList(layerArray3));
        WWPanel wWPanel = new WWPanel(null, basicModel, new Dimension(900, 900));
        SharedLayerPanel sharedLayerPanel = new SharedLayerPanel("Shared Shapes", new Dimension(200, 0), Arrays.asList(layerArray2));
        javax.swing.Box box = javax.swing.Box.createHorizontalBox();
        box.add(sharedLayerPanel);
        box.add(javax.swing.Box.createHorizontalStrut(5));
        box.add(wWPanel);
        JFrame jFrame = new JFrame("World Wind Shared Shapes");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)box, "Center");
        jFrame.setVisible(true);
        WWPanel wWPanel2 = new WWPanel(wWPanel.getWwd(), basicModel2, new Dimension(900, 900));
        wWPanel2.getWwd().setView(new FlatOrbitView());
        box.add(javax.swing.Box.createHorizontalStrut(5));
        box.add(wWPanel2);
        jFrame.pack();
        WWUtil.alignComponent(null, jFrame, "gov.nasa.worldwind.avkey.Center");
    }

    protected static class SharedLayerPanel
    extends JPanel {
        protected JComponent layersComponent;

        public SharedLayerPanel(String string, Dimension dimension, Iterable<? extends Layer> iterable) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createTitledBorder(string)));
            this.layersComponent = javax.swing.Box.createVerticalBox();
            this.layersComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.update(iterable);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.layersComponent, "North");
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            if (dimension != null) {
                jScrollPane.setPreferredSize(dimension);
            }
            this.add((Component)jScrollPane, "Center");
        }

        public void update(Iterable<? extends Layer> iterable) {
            this.layersComponent.removeAll();
            if (iterable != null) {
                for (Layer layer : iterable) {
                    this.addLayer(layer);
                }
            }
            this.revalidate();
        }

        protected void addLayer(final Layer layer) {
            final JCheckBox jCheckBox = new JCheckBox(layer.getName(), layer.isEnabled());
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    layer.setEnabled(jCheckBox.isSelected());
                    layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, layer);
                }
            });
            this.layersComponent.add(jCheckBox);
            this.layersComponent.add(javax.swing.Box.createVerticalStrut(5));
        }
    }

    protected static class WWPanel
    extends JPanel {
        protected WorldWindowGLCanvas wwd;
        protected HighlightController highlightController;

        public WWPanel(WorldWindow worldWindow, Model model, Dimension dimension) {
            super(new BorderLayout(5, 5));
            WorldWindowGLCanvas worldWindowGLCanvas = this.wwd = worldWindow != null ? new WorldWindowGLCanvas(worldWindow) : new WorldWindowGLCanvas();
            if (dimension != null) {
                this.wwd.setPreferredSize(dimension);
            }
            this.wwd.setModel(model);
            this.add((Component)((Object)this.wwd), "Center");
            StatusBar statusBar = new StatusBar();
            statusBar.setEventSource(this.wwd);
            this.add((Component)statusBar, "South");
            this.highlightController = new HighlightController(this.wwd, "gov.nasa.worldwind.SelectEvent.Rollover");
        }

        public WorldWindow getWwd() {
            return this.wwd;
        }
    }
}

