/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples.layermanager;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class LayerPanel
extends JPanel {
    public static final ImageIcon UP_ARROW = new ImageIcon(LayerPanel.class.getResource("/images/up_arrow_16x16.png"));
    public static final ImageIcon DOWN_ARROW = new ImageIcon(LayerPanel.class.getResource("/images/down_arrow_16x16.png"));
    protected Layer layer;
    protected JCheckBox checkBox;
    protected JButton upButton;
    protected JButton downButton;

    public LayerPanel(final WorldWindow worldWindow, final Layer layer) {
        super(new BorderLayout(10, 10));
        this.layer = layer;
        SelectLayerAction selectLayerAction = new SelectLayerAction(worldWindow, layer, layer.isEnabled());
        this.checkBox = new JCheckBox(selectLayerAction);
        this.checkBox.setSelected(selectLayerAction.selected);
        this.add((Component)this.checkBox, "Center");
        this.upButton = new JButton(UP_ARROW);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayerPanel.this.moveLayer(worldWindow, layer, -1);
            }
        });
        this.downButton = new JButton(DOWN_ARROW);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayerPanel.this.moveLayer(worldWindow, layer, 1);
            }
        });
        this.upButton.setBorderPainted(false);
        this.upButton.setContentAreaFilled(false);
        this.upButton.setPreferredSize(new Dimension(24, 24));
        this.downButton.setBorderPainted(false);
        this.downButton.setContentAreaFilled(false);
        this.downButton.setPreferredSize(new Dimension(24, 24));
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 5, 0));
        jPanel.add(this.upButton);
        jPanel.add(this.downButton);
        this.add((Component)jPanel, "East");
        int n = this.findLayerPosition(worldWindow, layer);
        this.upButton.setEnabled(n != 0);
        this.downButton.setEnabled(n != worldWindow.getModel().getLayers().size() - 1);
    }

    public Layer getLayer() {
        return this.layer;
    }

    public Font getLayerNameFont() {
        return this.checkBox.getFont();
    }

    public void setLayerNameFont(Font font) {
        this.checkBox.setFont(font);
    }

    protected void moveLayer(WorldWindow worldWindow, Layer layer, int n) {
        int n2 = this.findLayerPosition(worldWindow, layer);
        if (n2 < 0) {
            return;
        }
        LayerList layerList = worldWindow.getModel().getLayers();
        this.upButton.setEnabled(true);
        this.downButton.setEnabled(true);
        if (n < 0 && n2 == 0) {
            this.upButton.setEnabled(false);
            return;
        }
        if (n > 0 && n2 == layerList.size() - 1) {
            this.downButton.setEnabled(false);
            return;
        }
        layerList.remove(layer);
        if (n > 0) {
            layerList.add(n2 + 1, layer);
        } else if (n < 0) {
            layerList.add(n2 - 1, layer);
        }
        worldWindow.redraw();
    }

    protected int findLayerPosition(WorldWindow worldWindow, Layer layer) {
        for (int i = 0; i < worldWindow.getModel().getLayers().size(); ++i) {
            if (layer != worldWindow.getModel().getLayers().get(i)) continue;
            return i;
        }
        return -1;
    }

    protected static class SelectLayerAction
    extends AbstractAction {
        protected WorldWindow wwd;
        protected Layer layer;
        protected boolean selected;

        public SelectLayerAction(WorldWindow worldWindow, Layer layer, boolean bl) {
            super(layer.getName());
            this.wwd = worldWindow;
            this.layer = layer;
            this.selected = bl;
            this.layer.setEnabled(this.selected);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                this.layer.setEnabled(true);
            } else {
                this.layer.setEnabled(false);
            }
            this.wwd.redraw();
        }
    }
}

