/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class Polygons
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Extruded Polygons", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            this.getWwd().addSelectListener(new BasicDragger(this.getWwd()));
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setOutlineOpacity(0.5);
            basicShapeAttributes.setInteriorOpacity(0.8);
            basicShapeAttributes.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawOutline(true);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setEnableLighting(true);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes(basicShapeAttributes);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineOpacity(1.0);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            arrayList.add(Position.fromDegrees(28.0, -106.0, 30000.0));
            arrayList.add(Position.fromDegrees(35.0, -104.0, 30000.0));
            arrayList.add(Position.fromDegrees(35.0, -107.0, 90000.0));
            arrayList.add(Position.fromDegrees(28.0, -107.0, 90000.0));
            arrayList.add(Position.fromDegrees(28.0, -106.0, 30000.0));
            Polygon polygon = new Polygon(arrayList);
            polygon.setValue("gov.nasa.worldwind.avkey.DisplayName", "Has a hole\nRotated -170\u00b0");
            arrayList.clear();
            arrayList.add(Position.fromDegrees(29.0, -106.4, 40000.0));
            arrayList.add(Position.fromDegrees(30.0, -106.4, 40000.0));
            arrayList.add(Position.fromDegrees(29.0, -106.8, 70000.0));
            arrayList.add(Position.fromDegrees(29.0, -106.4, 40000.0));
            polygon.addInnerBoundary(arrayList);
            polygon.setAltitudeMode(2);
            polygon.setAttributes(basicShapeAttributes);
            polygon.setHighlightAttributes(basicShapeAttributes2);
            polygon.setRotation(-170.0);
            renderableLayer.addRenderable(polygon);
            ArrayList<Position> arrayList2 = new ArrayList<Position>();
            arrayList2.add(Position.fromDegrees(28.0, -110.0, 50000.0));
            arrayList2.add(Position.fromDegrees(35.0, -108.0, 50000.0));
            arrayList2.add(Position.fromDegrees(35.0, -111.0, 50000.0));
            arrayList2.add(Position.fromDegrees(28.0, -111.0, 50000.0));
            arrayList2.add(Position.fromDegrees(28.0, -110.0, 50000.0));
            polygon = new Polygon(arrayList2);
            polygon.setValue("gov.nasa.worldwind.avkey.DisplayName", "Has an image");
            basicShapeAttributes = new BasicShapeAttributes(basicShapeAttributes);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setInteriorMaterial(Material.WHITE);
            basicShapeAttributes.setInteriorOpacity(1.0);
            polygon.setAttributes(basicShapeAttributes);
            polygon.setHighlightAttributes(basicShapeAttributes2);
            float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f};
            polygon.setTextureImageSource("images/32x32-icon-nasa.png", fArray, 5);
            renderableLayer.addRenderable(polygon);
            arrayList2.clear();
            arrayList2.add(Position.fromDegrees(28.0, -170.0, 290000.0));
            arrayList2.add(Position.fromDegrees(35.0, -174.0, 290000.0));
            arrayList2.add(Position.fromDegrees(35.0, 174.0, 290000.0));
            arrayList2.add(Position.fromDegrees(28.0, 170.0, 290000.0));
            arrayList2.add(Position.fromDegrees(28.0, -170.0, 290000.0));
            polygon = new Polygon(arrayList2);
            polygon.setValue("gov.nasa.worldwind.avkey.DisplayName", "Spans dateline\nRotated -45\u00b0");
            basicShapeAttributes = new BasicShapeAttributes(basicShapeAttributes);
            basicShapeAttributes.setDrawInterior(true);
            polygon.setAttributes(basicShapeAttributes);
            polygon.setHighlightAttributes(basicShapeAttributes2);
            polygon.setAltitudeMode(2);
            polygon.setRotation(-45.0);
            renderableLayer.addRenderable(polygon);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

