/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.TerrainProfileLayer;
import gov.nasa.worldwind.util.measure.MeasureTool;
import gov.nasa.worldwind.util.measure.MeasureToolController;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import gov.nasa.worldwindx.examples.MeasureToolPanel;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MeasureToolUsage
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Measure Tool", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private int lastTabIndex = -1;
        private final JTabbedPane tabbedPane = new JTabbedPane();
        private TerrainProfileLayer profile = new TerrainProfileLayer();
        private PropertyChangeListener measureToolListener = new MeasureToolListener();

        public AppFrame() {
            super(true, false, true);
            this.profile.setEventSource(this.getWwd());
            this.profile.setFollow("gov.nasa.worldwind.TerrainProfileLayer.FollowPath");
            this.profile.setShowProfileLine(false);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.profile);
            this.tabbedPane.add(new JPanel());
            this.tabbedPane.setTitleAt(0, "+");
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.tabbedPane.getSelectedIndex() == 0) {
                        MeasureTool measureTool = new MeasureTool(AppFrame.this.getWwd());
                        measureTool.setController(new MeasureToolController());
                        AppFrame.this.tabbedPane.add(new MeasureToolPanel(AppFrame.this.getWwd(), measureTool));
                        AppFrame.this.tabbedPane.setTitleAt(AppFrame.this.tabbedPane.getTabCount() - 1, "" + (AppFrame.this.tabbedPane.getTabCount() - 1));
                        AppFrame.this.tabbedPane.setSelectedIndex(AppFrame.this.tabbedPane.getTabCount() - 1);
                        AppFrame.this.switchMeasureTool();
                    } else {
                        AppFrame.this.switchMeasureTool();
                    }
                }
            });
            MeasureTool measureTool = new MeasureTool(this.getWwd());
            measureTool.setController(new MeasureToolController());
            this.tabbedPane.add(new MeasureToolPanel(this.getWwd(), measureTool));
            this.tabbedPane.setTitleAt(1, "1");
            this.tabbedPane.setSelectedIndex(1);
            this.switchMeasureTool();
            this.getContentPane().add((Component)this.tabbedPane, "West");
        }

        private void switchMeasureTool() {
            MeasureTool measureTool;
            if (this.lastTabIndex != -1) {
                measureTool = ((MeasureToolPanel)this.tabbedPane.getComponentAt(this.lastTabIndex)).getMeasureTool();
                measureTool.setArmed(false);
                measureTool.removePropertyChangeListener(this.measureToolListener);
            }
            this.lastTabIndex = this.tabbedPane.getSelectedIndex();
            measureTool = ((MeasureToolPanel)this.tabbedPane.getComponentAt(this.lastTabIndex)).getMeasureTool();
            measureTool.addPropertyChangeListener(this.measureToolListener);
            this.updateProfile(measureTool);
        }

        private void updateProfile(MeasureTool measureTool) {
            ArrayList<? extends Position> arrayList = measureTool.getPositions();
            if (arrayList != null && arrayList.size() > 1) {
                this.profile.setPathPositions(arrayList);
                this.profile.setEnabled(true);
            } else {
                this.profile.setEnabled(false);
            }
            this.getWwd().redraw();
        }

        private class MeasureToolListener
        implements PropertyChangeListener {
            private MeasureToolListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("MeasureTool.AddPosition") || propertyChangeEvent.getPropertyName().equals("MeasureTool.RemovePosition") || propertyChangeEvent.getPropertyName().equals("MeasureTool.ReplacePosition")) {
                    AppFrame.this.updateProfile((MeasureTool)propertyChangeEvent.getSource());
                }
            }
        }
    }
}

