/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Ellipsoid;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Ellipsoids
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Ellipsoids", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            this.getLayerPanel().add((Component)this.makeDetailHintControlPanel(), "South");
            RenderableLayer renderableLayer = new RenderableLayer();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.YELLOW);
            basicShapeAttributes.setInteriorOpacity(0.7);
            basicShapeAttributes.setEnableLighting(true);
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setOutlineWidth(2.0);
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setDrawOutline(false);
            BasicShapeAttributes basicShapeAttributes2 = new BasicShapeAttributes();
            basicShapeAttributes2.setInteriorMaterial(Material.PINK);
            basicShapeAttributes2.setInteriorOpacity(1.0);
            basicShapeAttributes2.setEnableLighting(true);
            basicShapeAttributes2.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes2.setOutlineWidth(2.0);
            basicShapeAttributes2.setDrawOutline(false);
            Ellipsoid ellipsoid = new Ellipsoid(Position.fromDegrees(40.0, -120.0, 80000.0), 50000.0, 50000.0, 50000.0);
            ellipsoid.setAltitudeMode(0);
            ellipsoid.setAttributes(basicShapeAttributes);
            ellipsoid.setVisible(true);
            ellipsoid.setValue("gov.nasa.worldwind.avkey.DisplayName", "Ellipsoid with equal axes, ABSOLUTE altitude mode");
            renderableLayer.addRenderable(ellipsoid);
            Ellipsoid ellipsoid2 = new Ellipsoid(Position.fromDegrees(37.5, -115.0, 50000.0), 50000.0, 50000.0, 50000.0);
            ellipsoid2.setAltitudeMode(2);
            ellipsoid2.setAttributes(basicShapeAttributes);
            ellipsoid2.setVisible(true);
            ellipsoid2.setValue("gov.nasa.worldwind.avkey.DisplayName", "Ellipsoid with equal axes, RELATIVE_TO_GROUND altitude mode");
            renderableLayer.addRenderable(ellipsoid2);
            Ellipsoid ellipsoid3 = new Ellipsoid(Position.fromDegrees(35.0, -110.0, 50000.0), 50000.0, 50000.0, 50000.0);
            ellipsoid3.setAltitudeMode(1);
            ellipsoid3.setAttributes(basicShapeAttributes);
            ellipsoid3.setVisible(true);
            ellipsoid3.setValue("gov.nasa.worldwind.avkey.DisplayName", "Ellipsoid with equal axes, CLAMP_TO_GROUND altitude mode");
            renderableLayer.addRenderable(ellipsoid3);
            Ellipsoid ellipsoid4 = new Ellipsoid(Position.fromDegrees(0.0, -90.0, 600000.0), 600000.0, 600000.0, 600000.0);
            ellipsoid4.setAltitudeMode(2);
            ellipsoid4.setImageSources("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            ellipsoid4.setAttributes(basicShapeAttributes);
            ellipsoid4.setVisible(true);
            ellipsoid4.setValue("gov.nasa.worldwind.avkey.DisplayName", "Ellipsoid with a texture");
            renderableLayer.addRenderable(ellipsoid4);
            Ellipsoid ellipsoid5 = new Ellipsoid(Position.ZERO, 1000000.0, 500000.0, 100000.0);
            ellipsoid5.setAltitudeMode(0);
            ellipsoid5.setAttributes(basicShapeAttributes);
            ellipsoid5.setVisible(true);
            ellipsoid5.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Ellipsoid with default orientation");
            renderableLayer.addRenderable(ellipsoid5);
            Ellipsoid ellipsoid6 = new Ellipsoid(Position.fromDegrees(0.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            ellipsoid6.setAltitudeMode(2);
            ellipsoid6.setAttributes(basicShapeAttributes2);
            ellipsoid6.setVisible(true);
            ellipsoid6.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Ellipsoid with a pre-set orientation");
            renderableLayer.addRenderable(ellipsoid6);
            Ellipsoid ellipsoid7 = new Ellipsoid(Position.fromDegrees(30.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            ellipsoid7.setAltitudeMode(2);
            ellipsoid7.setImageSources("gov/nasa/worldwindx/examples/images/500px-Checkerboard_pattern.png");
            ellipsoid7.setAttributes(basicShapeAttributes2);
            ellipsoid7.setVisible(true);
            ellipsoid7.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Ellipsoid with a pre-set orientation");
            renderableLayer.addRenderable(ellipsoid7);
            Ellipsoid ellipsoid8 = new Ellipsoid(Position.fromDegrees(60.0, 30.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            ellipsoid8.setAltitudeMode(2);
            ellipsoid8.setAttributes(basicShapeAttributes2);
            ellipsoid8.setVisible(true);
            ellipsoid8.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled Ellipsoid with a pre-set orientation");
            renderableLayer.addRenderable(ellipsoid8);
            Ellipsoid ellipsoid9 = new Ellipsoid(Position.fromDegrees(-45.0, -180.0, 750000.0), 1000000.0, 500000.0, 100000.0, Angle.fromDegrees(90.0), Angle.fromDegrees(45.0), Angle.fromDegrees(30.0));
            ellipsoid9.setAltitudeMode(2);
            ellipsoid9.setAttributes(basicShapeAttributes2);
            ellipsoid9.setVisible(true);
            ellipsoid9.setValue("gov.nasa.worldwind.avkey.DisplayName", "Scaled, oriented Ellipsoid in the 3rd 'quadrant' (-X, -Y, -Z)");
            renderableLayer.addRenderable(ellipsoid9);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }

        protected JPanel makeDetailHintControlPanel() {
            JPanel jPanel = new JPanel(new BorderLayout(0, 10));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Detail Hint")));
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 5));
            int n = -10;
            int n2 = 10;
            int n3 = 0;
            JSlider jSlider = new JSlider(n, n2, n3);
            jSlider.setMajorTickSpacing(10);
            jSlider.setMinorTickSpacing(1);
            jSlider.setPaintTicks(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(-10, new JLabel("-1.0"));
            hashtable.put(0, new JLabel("0.0"));
            hashtable.put(10, new JLabel("1.0"));
            jSlider.setLabelTable(hashtable);
            jSlider.setPaintLabels(true);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    double d = (double)((JSlider)changeEvent.getSource()).getValue() / 10.0;
                    AppFrame.this.setEllipsoidDetailHint(d);
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel2.add((Component)jSlider, "South");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 0));
            jPanel3.add(jPanel2);
            jPanel.add((Component)jPanel3, "South");
            return jPanel;
        }

        protected RenderableLayer getLayer() {
            for (Layer layer : this.getWwd().getModel().getLayers()) {
                if (!layer.getName().contains("Renderable")) continue;
                return (RenderableLayer)layer;
            }
            return null;
        }

        protected void setEllipsoidDetailHint(double d) {
            for (Renderable renderable : this.getLayer().getRenderables()) {
                Ellipsoid ellipsoid = (Ellipsoid)renderable;
                ellipsoid.setDetailHint(d);
            }
            System.out.println("Ellipsoid detail hint set to " + d);
        }
    }
}

