/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.features;

import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSLayerCapabilities;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.wms.CapabilitiesRequest;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.ImageLibrary;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.WMSLayerInfo;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerManager;
import gov.nasa.worldwindx.applications.worldwindow.core.layermanager.LayerPath;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeaturePanel;
import gov.nasa.worldwindx.applications.worldwindow.features.NetworkActivitySignal;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerNode;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTree;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTreeGroupNode;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTreeModel;
import gov.nasa.worldwindx.applications.worldwindow.features.swinglayermanager.LayerTreeNode;
import gov.nasa.worldwindx.applications.worldwindow.util.GB;
import gov.nasa.worldwindx.applications.worldwindow.util.ShadedPanel;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.stream.XMLStreamException;

public class WMSPanel
extends AbstractFeaturePanel
implements TreeModelListener,
NetworkActivitySignal.NetworkUser {
    protected static final String FEATURE_TITLE = "WMS Server Panel";
    protected static final String ICON_PATH = "gov/nasa/worldwindx/applications/worldwindow/images/wms-64x64.png";
    protected LayerTree layerTree;
    protected JTextField nameField;
    protected JTextField urlField;
    protected JButton infoButton;
    protected Thread loadingThread;
    protected URI serverURI;

    public WMSPanel(Registry registry) {
        super(FEATURE_TITLE, "gov.nasa.worldwindx.applications.worldwindow.feature.WMSPanel", new ShadedPanel(new BorderLayout()), registry);
    }

    public String getURLString() {
        return this.urlField.getText();
    }

    @Override
    public boolean hasNetworkActivity() {
        return this.loadingThread != null && this.loadingThread.isAlive();
    }

    @Override
    public void initialize(final Controller controller) {
        super.initialize(controller);
        LayerTreeModel layerTreeModel = new LayerTreeModel();
        this.layerTree = new LayerTree(layerTreeModel);
        this.layerTree.getModel().addTreeModelListener(this);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(false);
        this.createComponents(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.add((Component)jPanel, "Center");
        this.panel.setOpaque(false);
        this.panel.add((Component)jPanel2, "Center");
        this.panel.setToolTipText("");
        this.urlField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = WMSPanel.this.urlField.getText();
                    if (!(WWUtil.isEmpty(string) || WMSPanel.this.serverURI != null && WMSPanel.this.serverURI.toString().contains(string))) {
                        if (WMSPanel.this.getTopGroup() != null) {
                            WMSPanel.this.firePropertyChange("NewServer", null, string);
                        } else {
                            WMSPanel.this.contactWMSServer(string);
                        }
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    String string = "Invalid URL";
                    Util.getLogger().log(Level.SEVERE, string, uRISyntaxException);
                    controller.showErrorDialog(uRISyntaxException, "Invalid URL", string, new Object[0]);
                }
            }
        });
        this.infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)WMSPanel.this.infoButton.getClientProperty("CapsURL");
                if (!WWUtil.isEmpty(string)) {
                    controller.openLink(string);
                }
            }
        });
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        if (objectArray == null || objectArray.length <= 0) {
            return;
        }
        for (Object object : objectArray) {
            if (object == null) continue;
            if (object instanceof LayerTreeGroupNode) {
                this.handleGroupSelection((LayerTreeGroupNode)object);
                continue;
            }
            if (!(object instanceof LayerNode)) continue;
            this.handleLayerSelection((LayerNode)object);
        }
    }

    protected void handleLayerSelection(LayerNode layerNode) {
        if (layerNode.getWmsLayerInfo() == null) {
            return;
        }
        LayerManager layerManager = this.controller.getLayerManager();
        if (layerNode.isSelected()) {
            if (layerNode.getLayer() == null) {
                try {
                    this.createLayer(layerNode);
                }
                catch (Exception exception) {
                    String string = "Error creating WMS layer " + layerNode.toString();
                    Util.getLogger().log(Level.SEVERE, string, exception);
                    this.controller.showErrorDialog(exception, "WMS Error", string, new Object[0]);
                }
            }
            if (layerNode.getLayer() != null) {
                layerManager.addLayer(layerNode.getLayer(), new LayerPath(this.nameField.getText(), new String[0]));
                layerManager.selectLayer(layerNode.getLayer(), true);
            }
        } else {
            layerManager.removeLayer(layerNode.getLayer());
        }
    }

    protected void handleGroupSelection(LayerTreeGroupNode layerTreeGroupNode) {
        Object object;
        Enumeration<TreeNode> enumeration = layerTreeGroupNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof LayerNode) || object instanceof LayerTreeGroupNode) continue;
            LayerNode layerNode = (LayerNode)object;
            layerNode.setSelected(layerTreeGroupNode.isSelected());
            this.handleLayerSelection(layerNode);
        }
        object = this.getLayerManagerGroupNode();
        if (object != null) {
            object.setSelected(layerTreeGroupNode.isSelected());
            this.controller.getLayerManager().expandGroup(object.getTitle());
        }
        this.layerTree.repaint();
    }

    protected void createLayer(LayerNode layerNode) {
        if (layerNode == null) {
            String string = "LayerNode is null";
            Util.getLogger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (layerNode.getWmsLayerInfo() != null) {
            WMSLayerInfo wMSLayerInfo = layerNode.getWmsLayerInfo();
            AVList aVList = wMSLayerInfo.getParams().copy();
            aVList.setValue("gov.nasa.worldwind.avkey.URLConnectTimeout", 30000);
            aVList.setValue("gov.nasa.worldwind.avkey.URLReadTimeout", 30000);
            aVList.setValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", 60000);
            Factory factory = (Factory)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.LayerFactory");
            Layer layer = (Layer)factory.createFromConfigSource(wMSLayerInfo.getCaps(), aVList);
            layerNode.setLayer(layer);
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public void cancel() {
        if (this.loadingThread != null && this.loadingThread.isAlive()) {
            this.loadingThread.interrupt();
        }
    }

    public void clearPanel() {
        if (this.loadingThread != null && this.loadingThread.isAlive()) {
            this.loadingThread.interrupt();
            return;
        }
        if (this.nameField != null) {
            this.nameField.setText("");
        }
        if (this.urlField != null) {
            this.urlField.setText("");
        }
        if (this.layerTree != null) {
            this.layerTree.clearTree();
        }
    }

    public void contactWMSServer(String string) throws URISyntaxException {
        this.serverURI = new URI(string.trim());
        this.loadingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block7: {
                    WMSPanel.this.controller.getNetworkActivitySignal().addNetworkUser(WMSPanel.this);
                    try {
                        CapabilitiesRequest capabilitiesRequest = new CapabilitiesRequest(WMSPanel.this.serverURI);
                        WMSCapabilities wMSCapabilities = new WMSCapabilities(capabilitiesRequest);
                        wMSCapabilities.parse(new Object[0]);
                        if (Thread.currentThread().isInterrupted()) break block7;
                        WMSPanel.this.createLayerList(wMSCapabilities);
                    }
                    catch (XMLStreamException xMLStreamException) {
                        String string = "Error retrieving servers capabilities " + WMSPanel.this.serverURI;
                        Util.getLogger().log(Level.SEVERE, string, xMLStreamException);
                        WMSPanel.this.controller.showErrorDialog(xMLStreamException, "Get Capabilities Error", string, new Object[0]);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WMSPanel.this.controller.getNetworkActivitySignal().removeNetworkUser(WMSPanel.this);
                                WMSPanel.this.panel.setCursor(Cursor.getDefaultCursor());
                            }
                        });
                    }
                    catch (Exception exception) {
                        block8: {
                            if (exception.getClass().getName().toLowerCase().contains("timeout")) {
                                String string = "Connection to server timed out\n" + WMSPanel.this.serverURI;
                                WMSPanel.this.controller.showErrorDialog(exception, "Connection Timeout", string, new Object[0]);
                                Util.getLogger().log(Level.SEVERE, string + WMSPanel.this.serverURI, exception);
                                break block8;
                            }
                            String string = "Attempt to contact server failed\n" + WMSPanel.this.serverURI;
                            WMSPanel.this.controller.showErrorDialog(exception, "Server Not Responding", string, new Object[0]);
                            Util.getLogger().log(Level.SEVERE, string + WMSPanel.this.serverURI, exception);
                            {
                                catch (Throwable throwable) {
                                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    throw throwable;
                                }
                            }
                        }
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        this.loadingThread.setPriority(1);
        this.loadingThread.start();
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
    }

    protected void createLayerList(final WMSCapabilities wMSCapabilities) {
        String string;
        String string2;
        List<WMSLayerCapabilities> list = wMSCapabilities.getCapabilityInformation().getLayerCapabilities();
        if (list.size() == 0) {
            return;
        }
        WMSLayerCapabilities wMSLayerCapabilities = list.get(0);
        this.addLayer(wMSCapabilities, wMSLayerCapabilities, null, (LayerTreeModel)this.layerTree.getModel());
        LayerTreeGroupNode layerTreeGroupNode = this.getTopGroup();
        if (layerTreeGroupNode != null) {
            layerTreeGroupNode.setEnableSelectionBox(false);
        }
        if ((string2 = wMSCapabilities.getServiceInformation().getServiceAbstract()) != null) {
            this.infoButton.setToolTipText(Util.makeMultiLineToolTip(string2));
        }
        this.infoButton.putClientProperty("CapsURL", (string = wMSCapabilities.getServiceInformation().getOnlineResource().getHref()) != null ? string : wMSCapabilities.getRequestURL("GetCapabilities", "HTTP", "Get"));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (WMSPanel.this.nameField.getText() == null || WMSPanel.this.nameField.getText().length() == 0) {
                    WMSPanel.this.nameField.setText(WMSPanel.this.getServerDisplayString(wMSCapabilities));
                }
                WMSPanel.this.urlField.setText(WMSPanel.this.serverURI.toString());
                WMSPanel.this.layerTree.expandRow(0);
            }
        });
    }

    protected LayerTreeGroupNode getTopGroup() {
        Object object = this.layerTree.getModel().getRoot();
        return object != null && object instanceof LayerTreeGroupNode && ((LayerTreeGroupNode)object).getChildCount() > 0 ? (LayerTreeGroupNode)((LayerTreeGroupNode)object).getFirstChild() : null;
    }

    protected LayerNode getLayerManagerGroupNode() {
        LayerTreeGroupNode layerTreeGroupNode = this.getTopGroup();
        if (layerTreeGroupNode == null) {
            return null;
        }
        LayerPath layerPath = new LayerPath(this.getTabTitle(), new String[0]);
        return this.controller.getLayerManager().getNode(layerPath);
    }

    public void addItemToComboBox(JComboBox jComboBox, Object object) {
        if (jComboBox == null || object == null) {
            return;
        }
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            Object e = jComboBox.getItemAt(i);
            if (e == null || !e.toString().trim().equals(object.toString().trim())) continue;
            return;
        }
        jComboBox.insertItemAt(object, 1);
    }

    protected String getServerDisplayString(WMSCapabilities wMSCapabilities) {
        String string = wMSCapabilities.getServiceInformation().getServiceTitle();
        return string != null ? string : this.serverURI.getHost();
    }

    protected void addLayer(WMSCapabilities wMSCapabilities, WMSLayerCapabilities wMSLayerCapabilities, LayerTreeGroupNode layerTreeGroupNode, LayerTreeModel layerTreeModel) {
        List<WMSLayerCapabilities> list = wMSLayerCapabilities.getLayers();
        if (list != null && list.size() > 0) {
            LayerTreeGroupNode layerTreeGroupNode2 = new LayerTreeGroupNode(new WMSLayerInfo(wMSCapabilities, wMSLayerCapabilities, null));
            if (layerTreeGroupNode == null) {
                layerTreeModel.insertNodeInto(layerTreeGroupNode2, (LayerTreeGroupNode)layerTreeModel.getRoot(), ((LayerTreeGroupNode)layerTreeModel.getRoot()).getChildCount());
            } else {
                layerTreeModel.insertNodeInto(layerTreeGroupNode2, layerTreeGroupNode, layerTreeGroupNode.getChildCount());
            }
            for (WMSLayerCapabilities wMSLayerCapabilities2 : list) {
                this.addLayer(wMSCapabilities, wMSLayerCapabilities2, layerTreeGroupNode2, layerTreeModel);
            }
            String string = wMSLayerCapabilities.getLayerAbstract();
            if (!WWUtil.isEmpty(string)) {
                layerTreeGroupNode2.setToolTipText(Util.makeMultiLineToolTip(string));
            }
        } else {
            List<WMSLayerInfo> list2 = WMSLayerInfo.createLayerInfos(wMSCapabilities, wMSLayerCapabilities);
            for (WMSLayerInfo wMSLayerInfo : list2) {
                String string;
                LayerTreeNode layerTreeNode = new LayerTreeNode(wMSLayerInfo);
                layerTreeNode.setSelected(false);
                layerTreeNode.setAllowsChildren(false);
                if (layerTreeGroupNode == null) {
                    layerTreeModel.insertNodeInto(layerTreeNode, (LayerTreeNode)layerTreeModel.getRoot(), ((DefaultMutableTreeNode)layerTreeModel.getRoot()).getChildCount());
                } else {
                    layerTreeModel.insertNodeInto(layerTreeNode, layerTreeGroupNode, layerTreeGroupNode.getChildCount());
                }
                if (WWUtil.isEmpty(string = wMSLayerCapabilities.getLayerAbstract())) continue;
                layerTreeNode.setToolTipText(Util.makeMultiLineToolTip(string));
            }
        }
    }

    protected void createComponents(JPanel jPanel) {
        jPanel.add((Component)this.makeTopPanel(), "North");
        jPanel.add((Component)this.makeTreePanel(), "Center");
    }

    protected JPanel makeTopPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel("Name");
        jLabel.setOpaque(false);
        this.nameField = new JTextField(20);
        this.nameField.setOpaque(false);
        this.nameField.setToolTipText("Enter a display name for the server");
        this.infoButton = new JButton(ImageLibrary.getIcon("gov/nasa/worldwindx/applications/worldwindow/images/info-20x20.png"));
        this.infoButton.setOpaque(false);
        this.infoButton.setBackground(new Color(0, 0, 0, 0));
        this.infoButton.setBorderPainted(false);
        JLabel jLabel2 = new JLabel("URL");
        jLabel2.setOpaque(false);
        this.urlField = new JTextField();
        this.urlField.setOpaque(false);
        this.urlField.setEditable(true);
        this.urlField.setToolTipText("Enter a WMS server URL");
        int n = 5;
        int n2 = 5;
        int n3 = 5;
        int n4 = 5;
        jPanel.add((Component)jLabel, new GB(0, 0).setWeight(0.0, 0.0).setAnchor(17).setInsets(n, n2, n3, n4));
        jPanel.add((Component)this.nameField, new GB(1, 0).setWeight(100.0, 100.0).setAnchor(17).setInsets(n, n2, n3, n4).setFill(2));
        jPanel.add((Component)this.infoButton, new GB(2, 0).setWeight(0.0, 0.0).setAnchor(17).setInsets(n, n2, n3, n4));
        jPanel.add((Component)jLabel2, new GB(0, 1).setWeight(0.0, 0.0).setAnchor(17).setInsets(n, n2, n3, n4));
        jPanel.add((Component)this.urlField, new GB(1, 1, 2, 1).setWeight(100.0, 100.0).setAnchor(17).setInsets(n, n2, n3, n4).setFill(2));
        this.nameField.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                if (WMSPanel.this.nameField.getText().trim().length() <= 0) {
                    return;
                }
                LayerNode layerNode = WMSPanel.this.getLayerManagerGroupNode();
                if (layerNode != null) {
                    layerNode.setTitle(WMSPanel.this.nameField.getText());
                    WMSPanel.this.controller.getLayerManager().redraw();
                }
                WMSPanel.this.setTabTitle(WMSPanel.this.nameField.getText());
            }
        });
        return jPanel;
    }

    protected void setTabTitle(String string) {
        Container container = this.panel.getParent();
        if (container instanceof JTabbedPane) {
            int n = ((JTabbedPane)this.panel.getParent()).indexOfComponent(this.panel);
            ((JTabbedPane)this.panel.getParent()).setTitleAt(n, string != null ? string : "");
        }
    }

    protected String getTabTitle() {
        Container container = this.panel.getParent();
        if (container instanceof JTabbedPane) {
            int n = ((JTabbedPane)this.panel.getParent()).indexOfComponent(this.panel);
            return ((JTabbedPane)this.panel.getParent()).getTitleAt(n);
        }
        return null;
    }

    protected JPanel makeTreePanel() {
        this.layerTree.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.layerTree.setVisibleRowCount(15);
        JScrollPane jScrollPane = new JScrollPane(this.layerTree);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setOpaque(false);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }
}

