/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar.segmentplane;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.awt.TextRenderer;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Triangle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.MultiLineTextRenderer;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.BasicMarkerShape;
import gov.nasa.worldwind.render.markers.MarkerShape;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlane;
import gov.nasa.worldwindx.applications.sar.segmentplane.SegmentPlaneAttributes;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL2;

public class SegmentPlaneRenderer {
    protected Map<SegmentPlane, RenderInfo> renderInfoMap;
    protected double minObjectSize = 0.01;
    protected double maxObjectSizeCoefficient = 0.005;
    protected final PickSupport pickSupport = new PickSupport();

    public SegmentPlaneRenderer() {
        this.renderInfoMap = new HashMap<SegmentPlane, RenderInfo>();
    }

    public double getMinObjectSize() {
        return this.minObjectSize;
    }

    public void setMinObjectSize(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "size < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minObjectSize = d;
    }

    public double getMaxObjectSizeCoefficient() {
        return this.maxObjectSizeCoefficient;
    }

    public void setMaxObjectSizeCoefficient(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "coefficient < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.maxObjectSizeCoefficient = d;
    }

    public void render(DrawContext drawContext, SegmentPlane segmentPlane) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (segmentPlane == null) {
            String string = Logging.getMessage("nullValue.SegmentPlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.draw(drawContext, segmentPlane, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pick(DrawContext drawContext, SegmentPlane segmentPlane, Point point, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (segmentPlane == null) {
            String string = Logging.getMessage("nullValue.SegmentPlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pickSupport.beginPicking(drawContext);
        try {
            this.draw(drawContext, segmentPlane, point, layer);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.clearPickList();
        }
    }

    public Vec4 intersect(Globe globe, Line line, SegmentPlane segmentPlane) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (segmentPlane == null) {
            String string = Logging.getMessage("nullValue.SegmentPlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        RenderInfo renderInfo = this.getRenderInfoFor(globe, segmentPlane);
        if (renderInfo == null) {
            return null;
        }
        return this.intersectRayWithFill(line, renderInfo);
    }

    public Position computeControlPointPosition(SectorGeometryList sectorGeometryList, Globe globe, SegmentPlane segmentPlane, SegmentPlane.ControlPoint controlPoint) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (segmentPlane == null) {
            String string = Logging.getMessage("nullValue.SegmentPlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (controlPoint == null) {
            String string = Logging.getMessage("nullValue.ControlPointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = controlPoint.getCoordinates();
        return this.computePositionOnPlane(sectorGeometryList, globe, segmentPlane, dArray[0], dArray[1], controlPoint.isRelativeToSurface());
    }

    public double computeObjectSize(View view, Globe globe, SegmentPlane segmentPlane, Object object, Vec4 vec4) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (segmentPlane == null) {
            String string = Logging.getMessage("nullValue.SegmentPlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeObjectSize(view, globe, segmentPlane, object, vec4, false);
    }

    protected RenderInfo getRenderInfoFor(Globe globe, SegmentPlane segmentPlane) {
        RenderInfo renderInfo = this.renderInfoMap.get(segmentPlane);
        if (renderInfo == null || renderInfo.isExpired(globe, segmentPlane)) {
            if (renderInfo == null) {
                renderInfo = new RenderInfo();
            }
            this.createSegmentPlaneGeometry(globe, segmentPlane, renderInfo);
            this.createBorderGeometry(globe, segmentPlane, renderInfo);
            this.createControlPointGeometry(globe, segmentPlane, renderInfo);
            renderInfo.makeCurrent(globe, segmentPlane);
            this.renderInfoMap.put(segmentPlane, renderInfo);
        }
        return renderInfo;
    }

    protected MultiLineTextRenderer getTextRendererFor(DrawContext drawContext, Font font) {
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
        return new MultiLineTextRenderer(textRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(DrawContext drawContext, SegmentPlane segmentPlane, Point point, Layer layer) {
        if (!segmentPlane.isVisible()) {
            return;
        }
        RenderInfo renderInfo = this.getRenderInfoFor(drawContext.getGlobe(), segmentPlane);
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        this.begin(drawContext, oGLStackHandler);
        try {
            this.drawSegmentPlane(drawContext, segmentPlane, renderInfo, point, layer);
        }
        finally {
            this.end(drawContext, oGLStackHandler);
        }
    }

    protected void drawSegmentPlane(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        this.drawPlaneGeometry(drawContext, segmentPlane, renderInfo, point, layer);
        this.drawPlaneBorder(drawContext, segmentPlane, renderInfo, point, layer);
        this.drawSegmentAltimeter(drawContext, segmentPlane, renderInfo, point, layer);
        this.drawControlPoints(drawContext, segmentPlane, renderInfo, point, layer);
        this.drawAxisLabels(drawContext, segmentPlane, renderInfo, point, layer);
    }

    protected void begin(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glEnableClientState(32884);
        gL2.glEnableClientState(32885);
        int n = 0xD | (!drawContext.isPickingMode() ? 16384 : 0) | (!drawContext.isPickingMode() ? 64 : 0) | (!drawContext.isPickingMode() ? 4096 : 0);
        oGLStackHandler.pushAttrib(gL2, n);
        gL2.glDisable(2884);
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(3042);
            OGLUtil.applyBlending(gL2, false);
            gL2.glDisable(2903);
            gL2.glDisable(16384);
            gL2.glEnable(2896);
            gL2.glEnable(16385);
            gL2.glEnable(2977);
            gL2.glLightModeli(2897, 1);
            gL2.glLightModeli(2898, 1);
            gL2.glShadeModel(7425);
            OGLUtil.applyLightingDirectionalFromViewer(gL2, 16385, new Vec4(1.0, 0.5, 1.0).normalize3());
        }
    }

    protected void end(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glDisableClientState(32884);
        gL2.glDisableClientState(32885);
        oGLStackHandler.pop(gL2);
    }

    protected boolean bindGeometryAttributes(DrawContext drawContext, SegmentPlane segmentPlane, Object object, boolean bl) {
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes = segmentPlane.getAttributes().getGeometryAttributes(object);
        if (geometryAttributes == null || !geometryAttributes.isVisible()) {
            return false;
        }
        if (drawContext.isPickingMode() && (bl || !geometryAttributes.isEnablePicking())) {
            return false;
        }
        if (drawContext.isPickingMode()) {
            this.bindPickableObject(drawContext, segmentPlane, object);
        }
        SegmentPlaneAttributes.applyGeometryAttributes(drawContext, geometryAttributes, true);
        return true;
    }

    protected boolean bindGeometryAttributesAsLine(DrawContext drawContext, SegmentPlane segmentPlane, Object object, boolean bl) {
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes = segmentPlane.getAttributes().getGeometryAttributes(object);
        if (geometryAttributes == null || !geometryAttributes.isVisible()) {
            return false;
        }
        if (drawContext.isPickingMode() && (bl || !geometryAttributes.isEnablePicking())) {
            return false;
        }
        if (drawContext.isPickingMode()) {
            this.bindPickableObject(drawContext, segmentPlane, object);
        }
        SegmentPlaneAttributes.applyGeometryAttributes(drawContext, geometryAttributes, false);
        SegmentPlaneAttributes.applyGeometryAttributesAsLine(drawContext, geometryAttributes);
        return true;
    }

    protected boolean bindLabelAttributes(DrawContext drawContext, SegmentPlane segmentPlane, Object object) {
        if (drawContext.isPickingMode()) {
            return false;
        }
        SegmentPlaneAttributes.LabelAttributes labelAttributes = segmentPlane.getAttributes().getLabelAttributes(object);
        return labelAttributes != null && labelAttributes.isVisible();
    }

    protected PickedObject bindPickableObject(DrawContext drawContext, Object object, Object object2) {
        Color color = drawContext.getUniquePickColor();
        int n = color.getRGB();
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        PickedObject pickedObject = new PickedObject(n, object);
        pickedObject.setValue("gov.nasa.worldwind.avkey.PickedObject.ID", object2);
        this.pickSupport.addPickableObject(pickedObject);
        return pickedObject;
    }

    protected PickedObject getTopPickedObject(DrawContext drawContext, Point point, Object object) {
        PickedObject pickedObject = this.pickSupport.getTopObject(drawContext, point);
        if (pickedObject == null) {
            return null;
        }
        Object object2 = pickedObject.getValue("gov.nasa.worldwind.avkey.PickedObject.ID");
        if (object2 != object) {
            return null;
        }
        return pickedObject;
    }

    protected void registerPickedObject(DrawContext drawContext, PickedObject pickedObject, Layer layer) {
        if (layer != null) {
            pickedObject.setParentLayer(layer);
        }
        drawContext.addPickedObject(pickedObject);
    }

    protected Position computePositionOnPlane(SectorGeometryList sectorGeometryList, Globe globe, SegmentPlane segmentPlane, double d, double d2, boolean bl) {
        double d3;
        double[] dArray = segmentPlane.getPlaneAltitudes();
        LatLon[] latLonArray = segmentPlane.getPlaneLocations();
        Angle angle = LatLon.rhumbAzimuth(latLonArray[0], latLonArray[1]);
        Angle angle2 = LatLon.rhumbDistance(latLonArray[0], latLonArray[1]);
        Angle angle3 = Angle.fromDegrees(angle2.degrees * d);
        LatLon latLon = LatLon.rhumbEndPosition(latLonArray[0], angle, angle3);
        if (bl) {
            double d4 = this.computeSurfaceElevation(sectorGeometryList, globe, latLon.getLatitude(), latLon.getLongitude());
            d3 = d4 + d2 * (dArray[1] - d4);
        } else {
            d3 = dArray[0] + d2 * (dArray[1] - dArray[0]);
        }
        return new Position(latLon, d3);
    }

    protected double computeSurfaceElevation(SectorGeometryList sectorGeometryList, Globe globe, Angle angle, Angle angle2) {
        Vec4 vec4;
        if (sectorGeometryList != null && (vec4 = sectorGeometryList.getSurfacePoint(angle, angle2)) != null) {
            Position position = globe.computePositionFromPoint(vec4);
            return position.getElevation();
        }
        return globe.getElevation(angle, angle2);
    }

    protected void computePlaneParameterization(Globe globe, SegmentPlane segmentPlane, int[] nArray, double[] dArray) {
        double[] dArray2 = segmentPlane.getPlaneAltitudes();
        LatLon[] latLonArray = segmentPlane.getPlaneLocations();
        double[] dArray3 = segmentPlane.getGridCellDimensions();
        double d = LatLon.rhumbDistance((LatLon)latLonArray[0], (LatLon)latLonArray[1]).radians * globe.getRadius();
        double d2 = Math.abs(dArray2[1] - dArray2[0]);
        nArray[0] = (int)Math.ceil(d / dArray3[0]);
        nArray[1] = (int)Math.ceil(d2 / dArray3[1]);
        dArray[0] = d != 0.0 ? dArray3[0] / d : 0.0;
        dArray[1] = d2 != 0.0 ? dArray3[1] / d2 : 0.0;
    }

    protected double computeObjectSize(View view, Globe globe, SegmentPlane segmentPlane, Object object, Vec4 vec4, boolean bl) {
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes = segmentPlane.getAttributes().getGeometryAttributes(object);
        if (geometryAttributes == null) {
            return 0.0;
        }
        double d = this.getMinObjectSize();
        double d2 = this.computeMaxSizeForPixels(globe, segmentPlane);
        double d3 = this.computeSizeForPixels(view, vec4, 1.0, d, d2);
        return d3 * (bl ? geometryAttributes.getPicksize() : geometryAttributes.getSize());
    }

    protected double computeSizeForPixels(View view, Vec4 vec4, double d, double d2, double d3) {
        double d4 = vec4.distanceTo3(view.getEyePoint());
        double d5 = d * view.computePixelSizeAtDistance(d4);
        if (d5 < d2) {
            d5 = d2;
        } else if (d5 > d3) {
            d5 = d3;
        }
        return d5;
    }

    protected double computeMaxSizeForPixels(Globe globe, SegmentPlane segmentPlane) {
        double[] dArray = segmentPlane.getPlaneAltitudes();
        LatLon[] latLonArray = segmentPlane.getPlaneLocations();
        Vec4[] vec4Array = new Vec4[]{globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[0]), globe.computePointFromPosition(latLonArray[1].getLatitude(), latLonArray[1].getLongitude(), dArray[0]), globe.computePointFromPosition(latLonArray[1].getLatitude(), latLonArray[1].getLongitude(), dArray[1]), globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[1])};
        double d = Vec4.getAverageDistance(Arrays.asList(vec4Array));
        return d * this.getMaxObjectSizeCoefficient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPlaneGeometry(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        drawContext.getView().pushReferenceCenter(drawContext, renderInfo.planeReferenceCenter);
        try {
            this.bindPlaneVertexGeometry(drawContext, renderInfo);
            this.drawPlaneBackground(drawContext, segmentPlane, renderInfo, point, layer);
            this.drawPlaneGrid(drawContext, segmentPlane, renderInfo, point, layer);
            this.drawPlaneOutline(drawContext, segmentPlane, renderInfo, point, layer);
        }
        finally {
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    protected void drawPlaneBackground(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        if (!this.bindGeometryAttributes(drawContext, segmentPlane, "SegmentPlane.PlaneBackground", false)) {
            return;
        }
        this.drawPlaneFillElements(drawContext, renderInfo);
        if (drawContext.isPickingMode()) {
            this.resolvePlaneBackgroundPick(drawContext, segmentPlane, renderInfo, point, layer);
        }
    }

    protected void drawPlaneOutline(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        if (!this.bindGeometryAttributesAsLine(drawContext, segmentPlane, "SegmentPlane.PlaneOutline", true)) {
            return;
        }
        if (!drawContext.isPickingMode()) {
            drawContext.getGL().glDisable(2896);
        }
        this.drawPlaneOutlineElements(drawContext, renderInfo);
        if (!drawContext.isPickingMode()) {
            drawContext.getGL().glEnable(2896);
        }
    }

    protected void drawPlaneGrid(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        if (!this.bindGeometryAttributesAsLine(drawContext, segmentPlane, "SegmentPlane.PlaneGrid", false)) {
            return;
        }
        if (!drawContext.isPickingMode()) {
            drawContext.getGL().glDisable(2896);
        }
        this.drawPlaneGridElements(drawContext, renderInfo);
        if (!drawContext.isPickingMode()) {
            drawContext.getGL().glEnable(2896);
        } else {
            this.resolvePlaneGridPick(drawContext, segmentPlane, renderInfo, point, layer);
        }
    }

    protected void bindPlaneVertexGeometry(DrawContext drawContext, RenderInfo renderInfo) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glVertexPointer(3, 5130, 0, (Buffer)renderInfo.planeVertices);
        gL2.glNormalPointer(5130, 0, (Buffer)renderInfo.planeNormals);
    }

    protected void drawPlaneFillElements(DrawContext drawContext, RenderInfo renderInfo) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glEnable(32823);
        gL2.glPolygonOffset(1.0f, 1.0f);
        gL2.glDrawElements(5, renderInfo.planeFillIndexCount, 5125, (Buffer)renderInfo.planeFillIndices);
        gL2.glDisable(32823);
    }

    protected void drawPlaneOutlineElements(DrawContext drawContext, RenderInfo renderInfo) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glDrawElements(1, renderInfo.planeOutlineIndexCount, 5125, (Buffer)renderInfo.planeOutlineIndices);
    }

    protected void drawPlaneGridElements(DrawContext drawContext, RenderInfo renderInfo) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glDrawElements(1, renderInfo.planeGridIndexCount, 5125, (Buffer)renderInfo.planeGridIndices);
    }

    protected void resolvePlaneBackgroundPick(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        if (point == null) {
            return;
        }
        PickedObject pickedObject = this.getTopPickedObject(drawContext, point, "SegmentPlane.PlaneBackground");
        if (pickedObject == null) {
            return;
        }
        Line line = drawContext.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Vec4 vec4 = this.intersectRayWithFill(line, renderInfo);
        if (vec4 == null) {
            return;
        }
        Position position = drawContext.getGlobe().computePositionFromPoint(vec4);
        pickedObject.setPosition(position);
        this.registerPickedObject(drawContext, pickedObject, layer);
    }

    protected void resolvePlaneOutlinePick(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        PickedObject pickedObject = this.getTopPickedObject(drawContext, point, "SegmentPlane.PlaneOutline");
        if (pickedObject == null) {
            return;
        }
        Line line = drawContext.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Plane plane = segmentPlane.computeInfinitePlane(drawContext.getGlobe());
        if (plane == null) {
            return;
        }
        Vec4 vec4 = plane.intersect(line);
        if (vec4 == null) {
            return;
        }
        Vec4 vec42 = this.computeNearestOutlineToPoint(vec4, renderInfo);
        if (vec42 == null) {
            return;
        }
        Position position = drawContext.getGlobe().computePositionFromPoint(vec42);
        pickedObject.setPosition(position);
        this.registerPickedObject(drawContext, pickedObject, layer);
    }

    protected void resolvePlaneGridPick(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        if (point == null) {
            return;
        }
        PickedObject pickedObject = this.getTopPickedObject(drawContext, point, "SegmentPlane.PlaneGrid");
        if (pickedObject == null) {
            return;
        }
        Line line = drawContext.getView().computeRayFromScreenPoint(point.getX(), point.getY());
        Plane plane = segmentPlane.computeInfinitePlane(drawContext.getGlobe());
        if (plane == null) {
            return;
        }
        Vec4 vec4 = plane.intersect(line);
        if (vec4 == null) {
            return;
        }
        Vec4 vec42 = this.computeNearestGridLineToPoint(vec4, renderInfo);
        if (vec42 == null) {
            return;
        }
        Position position = drawContext.getGlobe().computePositionFromPoint(vec42);
        pickedObject.setPosition(position);
        this.registerPickedObject(drawContext, pickedObject, layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPlaneBorder(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        if (!this.bindGeometryAttributes(drawContext, segmentPlane, "SegmentPlane.PlaneBorder", true)) {
            return;
        }
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes = segmentPlane.getAttributes().getGeometryAttributes("SegmentPlane.PlaneBorder");
        View view = drawContext.getView();
        Globe globe = drawContext.getGlobe();
        double[] dArray = segmentPlane.getPlaneAltitudes();
        LatLon[] latLonArray = segmentPlane.getPlaneLocations();
        int n = segmentPlane.getBorderMask();
        Vec4 vec4 = globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[0]);
        Vec4 vec42 = globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[1]);
        Vec4 vec43 = vec4.add3(vec42).divide3(2.0);
        double d = this.computeObjectSize(view, globe, segmentPlane, "SegmentPlane.PlaneBorder", vec43, drawContext.isPickingMode());
        double d2 = dArray[1] - dArray[0];
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushModelview(gL2);
        try {
            if ((n & 4) != 0) {
                Matrix matrix = view.getModelviewMatrix();
                matrix = matrix.multiply(globe.computeSurfaceOrientationAtPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[0]));
                this.drawBorder(drawContext, renderInfo, matrix, d, d2);
            }
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    protected void drawBorder(DrawContext drawContext, RenderInfo renderInfo, Matrix matrix, double d, double d2) {
        GL2 gL2 = drawContext.getGL().getGL2();
        double[] dArray = new double[16];
        Matrix matrix2 = Matrix.IDENTITY;
        matrix2 = matrix2.multiply(matrix);
        matrix2 = matrix2.multiply(Matrix.fromScale(d, d, d2));
        matrix2.toArray(dArray, 0, false);
        gL2.glLoadMatrixd(dArray, 0);
        this.drawBorderCylinder(drawContext, renderInfo);
        matrix2 = Matrix.IDENTITY;
        matrix2 = matrix2.multiply(matrix);
        matrix2 = matrix2.multiply(Matrix.fromScale(d));
        matrix2.toArray(dArray, 0, false);
        gL2.glLoadMatrixd(dArray, 0);
        this.drawBorderCap(drawContext, renderInfo);
        matrix2 = Matrix.IDENTITY;
        matrix2 = matrix2.multiply(matrix);
        matrix2 = matrix2.multiply(Matrix.fromTranslation(0.0, 0.0, d2));
        matrix2 = matrix2.multiply(Matrix.fromScale(d));
        matrix2.toArray(dArray, 0, false);
        gL2.glLoadMatrixd(dArray, 0);
        this.drawBorderCap(drawContext, renderInfo);
    }

    protected void drawBorderCylinder(DrawContext drawContext, RenderInfo renderInfo) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glVertexPointer(3, 5126, 0, (Buffer)renderInfo.borderCylinderVertices);
        gL2.glNormalPointer(5126, 0, (Buffer)renderInfo.borderCylinderNormals);
        gL2.glDrawElements(5, renderInfo.borderCylinderIndexCount, 5125, (Buffer)renderInfo.borderCylinderIndices);
    }

    protected void drawBorderCap(DrawContext drawContext, RenderInfo renderInfo) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glVertexPointer(3, 5126, 0, (Buffer)renderInfo.borderCapVertices);
        gL2.glNormalPointer(5126, 0, (Buffer)renderInfo.borderCapNormals);
        gL2.glDrawElements(5, renderInfo.borderCapIndexCount, 5125, (Buffer)renderInfo.borderCapIndices);
    }

    protected void drawSegmentAltimeter(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        this.drawSegmentAltimeterGeometry(drawContext, segmentPlane, renderInfo, point, layer);
        this.drawSegmentAltimeterLabel(drawContext, segmentPlane, renderInfo, point, layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawSegmentAltimeterGeometry(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        if (!this.bindGeometryAttributesAsLine(drawContext, segmentPlane, "SegmentPlane.Altimeter", true)) {
            return;
        }
        Globe globe = drawContext.getGlobe();
        Position position = segmentPlane.getSegmentPositions()[1];
        double d = this.computeSurfaceElevation(drawContext.getSurfaceGeometry(), globe, position.getLatitude(), position.getLongitude());
        Vec4 vec4 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), position.getElevation());
        Vec4 vec42 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
        Vec4 vec43 = vec4;
        vec4 = vec4.subtract3(vec43);
        vec42 = vec42.subtract3(vec43);
        if (!drawContext.isPickingMode()) {
            drawContext.getGL().glDisable(2896);
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        double[] dArray = new double[16];
        gL2.glGetDoublev(2983, dArray, 0);
        dArray[10] = dArray[10] * 0.99;
        oGLStackHandler.pushProjectionIdentity(gL2);
        gL2.glLoadMatrixd(dArray, 0);
        drawContext.getView().pushReferenceCenter(drawContext, vec43);
        gL2.glBegin(1);
        try {
            gL2.glVertex3d(vec4.x, vec4.y, vec4.z);
            gL2.glVertex3d(vec42.x, vec42.y, vec42.z);
        }
        finally {
            gL2.glEnd();
            drawContext.getView().popReferenceCenter(drawContext);
            oGLStackHandler.pop(gL2);
        }
        if (!drawContext.isPickingMode()) {
            drawContext.getGL().glEnable(2896);
        }
    }

    protected void drawSegmentAltimeterLabel(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        if (!this.bindLabelAttributes(drawContext, segmentPlane, "SegmentPlane.Altimeter")) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        Globe globe = drawContext.getGlobe();
        Position position = segmentPlane.getSegmentPositions()[1];
        double d = this.computeSurfaceElevation(sectorGeometryList, globe, position.getLatitude(), position.getLongitude());
        double d2 = position.getElevation() - d;
        Position position2 = new Position(position, d + d2 / 2.0);
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Height", d2);
        this.drawLabel(drawContext, segmentPlane, position2, aVListImpl, "SegmentPlane.Altimeter");
    }

    protected void drawControlPoints(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        Object object;
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        Globe globe = drawContext.getGlobe();
        for (SegmentPlane.ControlPoint positionArray2 : segmentPlane.getControlPoints()) {
            Position i = this.computeControlPointPosition(sectorGeometryList, globe, segmentPlane, positionArray2);
            object = renderInfo.getMarkerShape(positionArray2.getShapeType());
            if (i == null || object == null) continue;
            this.drawControlPoint(drawContext, segmentPlane, positionArray2, i, (MarkerShape)object);
        }
        Object[] objectArray = new Object[]{"SegmentPlane.SegmentBegin", "SegmentPlane.SegmentEnd"};
        Position[] positionArray = segmentPlane.getSegmentPositions();
        for (int i = 0; i < 2; ++i) {
            object = new SegmentPlane.ControlPoint(segmentPlane, objectArray[i], -1.0, -1.0, false, "gov.nasa.worldwind.render.markers.Sphere");
            MarkerShape markerShape = renderInfo.getMarkerShape(((SegmentPlane.ControlPoint)object).getShapeType());
            if (markerShape == null) continue;
            this.drawControlPoint(drawContext, segmentPlane, (SegmentPlane.ControlPoint)object, positionArray[i], markerShape);
        }
        if (drawContext.isPickingMode()) {
            this.resolveControlPointPick(drawContext, segmentPlane, renderInfo, point, layer);
        }
    }

    protected void drawControlPoint(DrawContext drawContext, SegmentPlane segmentPlane, SegmentPlane.ControlPoint controlPoint, Position position, MarkerShape markerShape) {
        ControlPointInfo controlPointInfo = new ControlPointInfo(controlPoint, position, markerShape);
        this.drawControlPointGeometry(drawContext, segmentPlane, controlPointInfo);
        this.drawControlPointLabel(drawContext, segmentPlane, controlPoint, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawControlPointGeometry(DrawContext drawContext, SegmentPlane segmentPlane, ControlPointInfo controlPointInfo) {
        Object object;
        Object object2 = controlPointInfo.controlPoint.getKey();
        if (!this.bindGeometryAttributes(drawContext, segmentPlane, object2, false)) {
            return;
        }
        SegmentPlaneAttributes.GeometryAttributes geometryAttributes = segmentPlane.getAttributes().getGeometryAttributes(object2);
        if (geometryAttributes == null || !geometryAttributes.isVisible()) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        View view = drawContext.getView();
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(controlPointInfo.position);
        double d = this.getMinObjectSize();
        double d2 = this.computeMaxSizeForPixels(globe, segmentPlane);
        double d3 = this.computeSizeForPixels(view, vec4, 1.0, d, d2);
        Matrix matrix = globe.computeSurfaceOrientationAtPosition(controlPointInfo.position);
        Vec4 vec42 = geometryAttributes.getOffset();
        vec42 = vec42.multiply3(d3);
        vec42 = vec42.transformBy3(matrix);
        vec4 = vec4.add3(vec42);
        controlPointInfo.position = globe.computePositionFromPoint(vec4);
        if (drawContext.isPickingMode()) {
            object = this.bindPickableObject(drawContext, controlPointInfo.controlPoint, controlPointInfo.controlPoint.getKey());
            ((PickedObject)object).setPosition(controlPointInfo.position);
        }
        object = new OGLStackHandler();
        ((OGLStackHandler)object).pushModelview(gL2);
        try {
            LatLon[] latLonArray = segmentPlane.getPlaneLocations();
            Angle angle = LatLon.rhumbAzimuth(latLonArray[0], latLonArray[1]);
            double d4 = d3 * (drawContext.isPickingMode() ? geometryAttributes.getPicksize() : geometryAttributes.getSize());
            BasicMarker basicMarker = new BasicMarker(controlPointInfo.position, new BasicMarkerAttributes(), angle);
            controlPointInfo.shape.render(drawContext, basicMarker, vec4, d4);
        }
        finally {
            ((OGLStackHandler)object).pop(gL2);
        }
    }

    protected void drawControlPointLabel(DrawContext drawContext, SegmentPlane segmentPlane, SegmentPlane.ControlPoint controlPoint, Position position) {
        if (!this.bindLabelAttributes(drawContext, segmentPlane, controlPoint.getKey())) {
            return;
        }
        double d = this.computeSurfaceElevation(drawContext.getSurfaceGeometry(), drawContext.getGlobe(), position.getLatitude(), position.getLongitude());
        double d2 = position.getElevation() - d;
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Height", d2);
        this.drawLabel(drawContext, segmentPlane, position, aVListImpl, controlPoint.getKey());
    }

    protected void resolveControlPointPick(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        Object[] objectArray;
        if (point == null) {
            return;
        }
        PickedObject pickedObject = null;
        Object[] objectArray2 = segmentPlane.getControlPoints().iterator();
        while (objectArray2.hasNext() && (pickedObject = this.getTopPickedObject(drawContext, point, (objectArray = objectArray2.next()).getKey())) == null) {
        }
        if (pickedObject == null) {
            Object object;
            objectArray = objectArray2 = new Object[]{"SegmentPlane.SegmentBegin", "SegmentPlane.SegmentEnd"};
            int n = objectArray.length;
            for (int i = 0; i < n && (pickedObject = this.getTopPickedObject(drawContext, point, object = objectArray[i])) == null; ++i) {
            }
        }
        if (pickedObject == null) {
            return;
        }
        this.registerPickedObject(drawContext, pickedObject, layer);
    }

    protected void drawAxisLabels(DrawContext drawContext, SegmentPlane segmentPlane, RenderInfo renderInfo, Point point, Layer layer) {
        this.drawHorizontalAxisLabels(drawContext, segmentPlane);
        this.drawVerticalAxisLabels(drawContext, segmentPlane);
    }

    protected void drawHorizontalAxisLabels(DrawContext drawContext, SegmentPlane segmentPlane) {
        double d;
        if (!this.bindLabelAttributes(drawContext, segmentPlane, "SegmentPlane.HorizontalAxisLabels")) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        Globe globe = drawContext.getGlobe();
        double[] dArray = segmentPlane.getGridCellDimensions();
        int[] nArray = new int[2];
        double[] dArray2 = new double[2];
        this.computePlaneParameterization(globe, segmentPlane, nArray, dArray2);
        int n = nArray[0];
        double d2 = dArray2[0];
        OrderedText[] orderedTextArray = new OrderedText[n];
        for (int i = 0; i < n; ++i) {
            d = SegmentPlaneRenderer.clamp((double)i * d2, 0.0, 1.0);
            double d3 = (double)i * dArray[0];
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Width", d3);
            Position position = this.computePositionOnPlane(sectorGeometryList, globe, segmentPlane, d, 0.0, true);
            double d4 = this.computeSurfaceElevation(sectorGeometryList, globe, position.getLatitude(), position.getLongitude());
            if (position.getElevation() < d4) {
                position = new Position(position, d4);
            }
            orderedTextArray[i] = this.createLabel(drawContext, segmentPlane, position, aVListImpl, "SegmentPlane.HorizontalAxisLabels");
        }
        Rectangle rectangle = this.computeAverageLabelSize(orderedTextArray, n);
        d = this.computeMinDistanceBetweenLabels(drawContext, orderedTextArray, n);
        this.drawAxisLabels(drawContext, orderedTextArray, 1, n, rectangle.getWidth(), d);
    }

    protected void drawVerticalAxisLabels(DrawContext drawContext, SegmentPlane segmentPlane) {
        double d;
        if (!this.bindLabelAttributes(drawContext, segmentPlane, "SegmentPlane.VerticalAxisLabels")) {
            return;
        }
        double[] dArray = segmentPlane.getGridCellDimensions();
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        Globe globe = drawContext.getGlobe();
        int[] nArray = new int[2];
        double[] dArray2 = new double[2];
        this.computePlaneParameterization(globe, segmentPlane, nArray, dArray2);
        int n = nArray[1];
        double d2 = dArray2[1];
        OrderedText[] orderedTextArray = new OrderedText[n];
        for (int i = 0; i < n; ++i) {
            d = SegmentPlaneRenderer.clamp((double)i * d2, 0.0, 1.0);
            double d3 = (double)i * dArray[1];
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Height", d3);
            Position position = this.computePositionOnPlane(sectorGeometryList, globe, segmentPlane, 1.0, d, false);
            double d4 = this.computeSurfaceElevation(sectorGeometryList, globe, position.getLatitude(), position.getLongitude());
            if (position.getElevation() < d4) continue;
            orderedTextArray[i] = this.createLabel(drawContext, segmentPlane, position, aVListImpl, "SegmentPlane.VerticalAxisLabels");
        }
        Rectangle rectangle = this.computeAverageLabelSize(orderedTextArray, n);
        d = this.computeMinDistanceBetweenLabels(drawContext, orderedTextArray, n);
        this.drawAxisLabels(drawContext, orderedTextArray, 1, n, rectangle.getHeight(), d);
    }

    protected void drawAxisLabels(DrawContext drawContext, OrderedText[] orderedTextArray, int n, int n2, double d, double d2) {
        int n3 = (int)Math.round(1.5 * d / d2);
        if (n3 < 1) {
            n3 = 1;
        }
        for (int i = n; i < n2; i += n3) {
            if (orderedTextArray[i] == null) continue;
            drawContext.addOrderedRenderable(orderedTextArray[i]);
        }
    }

    protected void drawLabel(DrawContext drawContext, SegmentPlane segmentPlane, Position position, AVList aVList, Object object) {
        OrderedText orderedText = this.createLabel(drawContext, segmentPlane, position, aVList, object);
        if (orderedText == null) {
            return;
        }
        drawContext.addOrderedRenderable(orderedText);
    }

    protected OrderedText createLabel(DrawContext drawContext, SegmentPlane segmentPlane, Position position, AVList aVList, Object object) {
        SegmentPlaneAttributes.LabelAttributes labelAttributes = segmentPlane.getAttributes().getLabelAttributes(object);
        if (labelAttributes == null) {
            return null;
        }
        Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(position);
        double d = drawContext.getView().getEyePoint().distanceTo3(vec4);
        if (d < labelAttributes.getMinActiveDistance() || d > labelAttributes.getMaxActiveDistance()) {
            return null;
        }
        Font font = labelAttributes.getFont();
        MultiLineTextRenderer multiLineTextRenderer = this.getTextRendererFor(drawContext, font);
        return new OrderedText(segmentPlane, position, d, aVList, labelAttributes, multiLineTextRenderer);
    }

    protected Rectangle computeAverageLabelSize(OrderedText[] orderedTextArray, int n) {
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (orderedTextArray[i] == null) continue;
            Rectangle rectangle = orderedTextArray[i].textRenderer.getBounds(orderedTextArray[i].getText());
            d += rectangle.getWidth();
            d2 += rectangle.getHeight();
            ++n2;
        }
        if (n2 > 1) {
            d /= (double)n2;
            d2 /= (double)n2;
        }
        return new Rectangle((int)d, (int)d2);
    }

    protected double computeMinDistanceBetweenLabels(DrawContext drawContext, OrderedText[] orderedTextArray, int n) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < n - 1; ++i) {
            if (orderedTextArray[i] == null) continue;
            for (int j = i + 1; j < n; ++j) {
                Vec4 vec4;
                Vec4 vec42;
                double d2;
                if (orderedTextArray[j] == null || !((d2 = (vec42 = orderedTextArray[i].getScreenPoint(drawContext)).distanceToSquared3(vec4 = orderedTextArray[j].getScreenPoint(drawContext))) < d)) continue;
                d = d2;
            }
        }
        if (d > 0.0) {
            d = Math.sqrt(d);
        }
        return d;
    }

    protected void createSegmentPlaneGeometry(Globe globe, SegmentPlane segmentPlane, RenderInfo renderInfo) {
        double[] dArray = segmentPlane.getPlaneAltitudes();
        LatLon[] latLonArray = segmentPlane.getPlaneLocations();
        int n = segmentPlane.getPlaneOutlineMask();
        renderInfo.planeReferenceCenter = globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[0]);
        int[] nArray = new int[2];
        double[] dArray2 = new double[2];
        this.computePlaneParameterization(globe, segmentPlane, nArray, dArray2);
        int n2 = nArray[0];
        int n3 = nArray[1];
        double d = dArray2[0];
        double d2 = dArray2[1];
        renderInfo.planeFillIndexCount = SegmentPlaneRenderer.getPlaneFillIndexCount(n2, n3);
        if (renderInfo.planeFillIndices == null || renderInfo.planeFillIndices.capacity() < renderInfo.planeFillIndexCount) {
            renderInfo.planeFillIndices = Buffers.newDirectIntBuffer((int)renderInfo.planeFillIndexCount);
        }
        renderInfo.planeOutlineIndexCount = SegmentPlaneRenderer.getPlaneOutlineIndexCount(n2, n3, n);
        if (renderInfo.planeOutlineIndices == null || renderInfo.planeOutlineIndices.capacity() < renderInfo.planeOutlineIndexCount) {
            renderInfo.planeOutlineIndices = Buffers.newDirectIntBuffer((int)renderInfo.planeOutlineIndexCount);
        }
        renderInfo.planeGridIndexCount = SegmentPlaneRenderer.getPlaneGridIndexCount(n2, n3);
        if (renderInfo.planeGridIndices == null || renderInfo.planeGridIndices.capacity() < renderInfo.planeGridIndexCount) {
            renderInfo.planeGridIndices = Buffers.newDirectIntBuffer((int)renderInfo.planeGridIndexCount);
        }
        int n4 = SegmentPlaneRenderer.getPlaneVertexCount(n2, n3);
        int n5 = 3 * n4;
        if (renderInfo.planeVertices == null || renderInfo.planeVertices.capacity() < n5) {
            renderInfo.planeVertices = Buffers.newDirectDoubleBuffer((int)n5);
        }
        if (renderInfo.planeNormals == null || renderInfo.planeNormals.capacity() < n5) {
            renderInfo.planeNormals = Buffers.newDirectDoubleBuffer((int)n5);
        }
        SegmentPlaneRenderer.computePlaneFillIndices(n2, n3, renderInfo.planeFillIndices);
        renderInfo.planeFillIndices.rewind();
        SegmentPlaneRenderer.computePlaneOutlineIndices(n2, n3, n, renderInfo.planeOutlineIndices);
        renderInfo.planeOutlineIndices.rewind();
        SegmentPlaneRenderer.computePlaneGridIndices(n2, n3, renderInfo.planeGridIndices);
        renderInfo.planeGridIndices.rewind();
        this.computePlaneVertices(globe, segmentPlane, n2, n3, d, d2, renderInfo.planeReferenceCenter, renderInfo.planeVertices);
        renderInfo.planeVertices.rewind();
        this.computePlaneNormals(globe, segmentPlane, renderInfo.planeFillIndexCount, n4, renderInfo.planeFillIndices, renderInfo.planeVertices, renderInfo.planeNormals);
        renderInfo.planeNormals.rewind();
    }

    protected static int getPlaneFillIndexCount(int n, int n2) {
        int n3 = 2 * (n + 1) * n2;
        if (n2 > 1) {
            n3 += 2 * (n2 - 1);
        }
        return n3;
    }

    protected static int getPlaneOutlineIndexCount(int n, int n2, int n3) {
        int n4 = 0;
        if ((n3 & 1) != 0) {
            n4 += 2 * n;
        }
        if ((n3 & 2) != 0) {
            n4 += 2 * n;
        }
        if ((n3 & 4) != 0) {
            n4 += 2 * n2;
        }
        if ((n3 & 8) != 0) {
            n4 += 2 * n2;
        }
        return n4;
    }

    protected static int getPlaneGridIndexCount(int n, int n2) {
        return 2 * n * (n2 - 1) + 2 * n2 * (n - 1);
    }

    protected static int getPlaneVertexCount(int n, int n2) {
        return (n + 1) * (n2 + 1);
    }

    protected static void computePlaneFillIndices(int n, int n2, IntBuffer intBuffer) {
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (i != 0) {
                n3 = n + (i - 1) * (n + 1);
                intBuffer.put(n3);
                n3 = i * (n + 1) + (n + 1);
                intBuffer.put(n3);
            }
            for (int j = 0; j <= n; ++j) {
                n3 = j + (i + 1) * (n + 1);
                intBuffer.put(n3);
                n3 = j + i * (n + 1);
                intBuffer.put(n3);
            }
        }
    }

    protected static void computePlaneOutlineIndices(int n, int n2, int n3, IntBuffer intBuffer) {
        int n4;
        int n5;
        if ((n3 & 1) != 0) {
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5 + n2 * (n + 1);
                intBuffer.put(n4);
                n4 = n5 + 1 + n2 * (n + 1);
                intBuffer.put(n4);
            }
        }
        if ((n3 & 2) != 0) {
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n5;
                intBuffer.put(n4);
                n4 = n5 + 1;
                intBuffer.put(n4);
            }
        }
        if ((n3 & 4) != 0) {
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n5 * (n + 1);
                intBuffer.put(n4);
                n4 = (n5 + 1) * (n + 1);
                intBuffer.put(n4);
            }
        }
        if ((n3 & 8) != 0) {
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = n + n5 * (n + 1);
                intBuffer.put(n4);
                n4 = n + (n5 + 1) * (n + 1);
                intBuffer.put(n4);
            }
        }
    }

    protected static void computePlaneGridIndices(int n, int n2, IntBuffer intBuffer) {
        int n3;
        int n4;
        int n5;
        for (n5 = 1; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 + n5 * (n + 1);
                intBuffer.put(n3);
                n3 = n4 + 1 + n5 * (n + 1);
                intBuffer.put(n3);
            }
        }
        for (n5 = 1; n5 < n; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = n5 + n4 * (n + 1);
                intBuffer.put(n3);
                n3 = n5 + (n4 + 1) * (n + 1);
                intBuffer.put(n3);
            }
        }
    }

    protected void computePlaneVertices(Globe globe, SegmentPlane segmentPlane, int n, int n2, double d, double d2, Vec4 vec4, DoubleBuffer doubleBuffer) {
        int n3 = 0;
        for (int i = 0; i <= n2; ++i) {
            double d3 = SegmentPlaneRenderer.clamp((double)i * d2, 0.0, 1.0);
            for (int j = 0; j <= n; ++j) {
                double d4 = SegmentPlaneRenderer.clamp((double)j * d, 0.0, 1.0);
                Position position = this.computePositionOnPlane(null, globe, segmentPlane, d4, d3, false);
                Vec4 vec42 = globe.computePointFromPosition(position);
                vec42 = vec42.subtract3(vec4);
                SegmentPlaneRenderer.putVertex3(vec42, n3++, doubleBuffer);
            }
        }
    }

    protected void computePlaneNormals(Globe globe, SegmentPlane segmentPlane, int n, int n2, IntBuffer intBuffer, DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        double[] dArray = segmentPlane.getPlaneAltitudes();
        LatLon[] latLonArray = segmentPlane.getPlaneLocations();
        Vec4 vec4 = globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[0]);
        Vec4 vec42 = globe.computePointFromPosition(latLonArray[1].getLatitude(), latLonArray[1].getLongitude(), dArray[0]);
        Vec4 vec43 = globe.computePointFromPosition(latLonArray[0].getLatitude(), latLonArray[0].getLongitude(), dArray[1]);
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = vec43.subtract3(vec4);
        Vec4 vec46 = vec44.cross3(vec45).normalize3();
        for (int i = 0; i < n2; ++i) {
            SegmentPlaneRenderer.putVertex3(vec46, i, doubleBuffer2);
        }
    }

    private static double clamp(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    protected void createBorderGeometry(Globe globe, SegmentPlane segmentPlane, RenderInfo renderInfo) {
        int n = 16;
        int n2 = 32;
        int n3 = 8;
        GeometryBuilder geometryBuilder = new GeometryBuilder();
        renderInfo.borderCylinderIndexCount = geometryBuilder.getCylinderIndexCount(n, n2);
        if (renderInfo.borderCylinderIndices == null || renderInfo.borderCylinderIndices.capacity() < renderInfo.borderCylinderIndexCount) {
            renderInfo.borderCylinderIndices = Buffers.newDirectIntBuffer((int)renderInfo.borderCylinderIndexCount);
        }
        renderInfo.borderCapIndexCount = geometryBuilder.getDiskIndexCount(n, n3);
        if (renderInfo.borderCapIndices == null || renderInfo.borderCapIndices.capacity() < renderInfo.borderCapIndexCount) {
            renderInfo.borderCapIndices = Buffers.newDirectIntBuffer((int)renderInfo.borderCapIndexCount);
        }
        int n4 = geometryBuilder.getCylinderVertexCount(n, n2);
        int n5 = 3 * n4;
        if (renderInfo.borderCylinderVertices == null || renderInfo.borderCylinderVertices.capacity() < n5) {
            renderInfo.borderCylinderVertices = Buffers.newDirectFloatBuffer((int)n5);
        }
        if (renderInfo.borderCylinderNormals == null || renderInfo.borderCylinderNormals.capacity() < n5) {
            renderInfo.borderCylinderNormals = Buffers.newDirectFloatBuffer((int)n5);
        }
        int n6 = geometryBuilder.getDiskVertexCount(n, n3);
        int n7 = 3 * n6;
        if (renderInfo.borderCapVertices == null || renderInfo.borderCapVertices.capacity() < n7) {
            renderInfo.borderCapVertices = Buffers.newDirectFloatBuffer((int)n7);
        }
        if (renderInfo.borderCapNormals == null || renderInfo.borderCapNormals.capacity() < n7) {
            renderInfo.borderCapNormals = Buffers.newDirectFloatBuffer((int)n7);
        }
        int[] nArray = new int[renderInfo.borderCylinderIndexCount];
        geometryBuilder.makeCylinderIndices(n, n2, nArray);
        renderInfo.borderCylinderIndices.put(nArray);
        renderInfo.borderCylinderIndices.rewind();
        nArray = new int[renderInfo.borderCapIndexCount];
        geometryBuilder.makeDiskIndices(n, n3, nArray);
        renderInfo.borderCapIndices.put(nArray);
        renderInfo.borderCapIndices.rewind();
        float[] fArray = new float[n5];
        geometryBuilder.makeCylinderVertices(1.0f, 1.0f, n, n2, fArray);
        renderInfo.borderCylinderVertices.put(fArray);
        renderInfo.borderCylinderVertices.rewind();
        float[] fArray2 = new float[n5];
        geometryBuilder.makeCylinderNormals(n, n2, fArray2);
        renderInfo.borderCylinderNormals.put(fArray2);
        renderInfo.borderCylinderNormals.rewind();
        fArray = new float[n7];
        geometryBuilder.makeDiskVertices(0.0f, 1.0f, n, n3, fArray);
        renderInfo.borderCapVertices.put(fArray);
        renderInfo.borderCapVertices.rewind();
        fArray2 = new float[n7];
        geometryBuilder.makeDiskNormals(n, n3, fArray2);
        renderInfo.borderCapNormals.put(fArray2);
        renderInfo.borderCapNormals.rewind();
    }

    protected void createControlPointGeometry(Globe globe, SegmentPlane segmentPlane, RenderInfo renderInfo) {
        if (renderInfo.markerShapeMap == null) {
            renderInfo.markerShapeMap = new HashMap<String, MarkerShape>();
        }
    }

    protected Vec4 intersectRayWithFill(Line line, RenderInfo renderInfo) {
        if (renderInfo.planeFillIndices != null && renderInfo.planeVertices != null) {
            return this.intersectRayWithTriangleStrip(line, renderInfo.planeFillIndexCount, renderInfo.planeFillIndices, renderInfo.planeVertices, renderInfo.planeReferenceCenter);
        }
        return null;
    }

    protected Vec4 computeNearestOutlineToPoint(Vec4 vec4, RenderInfo renderInfo) {
        if (renderInfo.planeOutlineIndices != null && renderInfo.planeVertices != null) {
            return this.computeNearestLineToPoint(vec4, renderInfo.planeOutlineIndexCount, renderInfo.planeOutlineIndices, renderInfo.planeVertices, renderInfo.planeReferenceCenter);
        }
        return null;
    }

    protected Vec4 computeNearestGridLineToPoint(Vec4 vec4, RenderInfo renderInfo) {
        if (renderInfo.planeGridIndices != null && renderInfo.planeVertices != null) {
            return this.computeNearestLineToPoint(vec4, renderInfo.planeGridIndexCount, renderInfo.planeGridIndices, renderInfo.planeVertices, renderInfo.planeReferenceCenter);
        }
        return null;
    }

    protected Vec4 computeNearestLineToPoint(Vec4 vec4, int n, IntBuffer intBuffer, DoubleBuffer doubleBuffer, Vec4 vec42) {
        Vec4 vec43 = null;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < n - 1; i += 2) {
            double d2;
            Vec4 vec44;
            int n2 = intBuffer.get(i);
            Vec4 vec45 = SegmentPlaneRenderer.getVertex3(n2, doubleBuffer).add3(vec42);
            Vec4 vec46 = SegmentPlaneRenderer.nearestPointOnSegment(vec45, vec44 = SegmentPlaneRenderer.getVertex3(n2 = intBuffer.get(i + 1), doubleBuffer).add3(vec42), vec4);
            if (vec46 == null || !((d2 = vec4.distanceTo3(vec46)) < d)) continue;
            d = d2;
            vec43 = vec46;
        }
        intBuffer.rewind();
        doubleBuffer.rewind();
        return vec43;
    }

    protected Vec4 intersectRayWithTriangleStrip(Line line, int n, IntBuffer intBuffer, DoubleBuffer doubleBuffer, Vec4 vec4) {
        Vec4 vec42 = null;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < n - 2; ++i) {
            double d2;
            int n2 = intBuffer.get(i);
            Vec4 vec43 = SegmentPlaneRenderer.getVertex3(n2, doubleBuffer).add3(vec4);
            n2 = intBuffer.get(i + 1);
            Vec4 vec44 = SegmentPlaneRenderer.getVertex3(n2, doubleBuffer).add3(vec4);
            n2 = intBuffer.get(i + 2);
            Vec4 vec45 = SegmentPlaneRenderer.getVertex3(n2, doubleBuffer).add3(vec4);
            Triangle triangle = i % 2 == 0 ? new Triangle(vec43, vec44, vec45) : new Triangle(vec44, vec43, vec45);
            Vec4 vec46 = triangle.intersect(line);
            if (vec46 == null || !((d2 = line.getOrigin().distanceTo3(vec46)) < d)) continue;
            d = d2;
            vec42 = vec46;
        }
        intBuffer.rewind();
        doubleBuffer.rewind();
        return vec42;
    }

    protected static Vec4 getVertex3(int n, DoubleBuffer doubleBuffer) {
        double[] dArray = new double[3];
        doubleBuffer.position(3 * n);
        doubleBuffer.get(dArray, 0, 3);
        return Vec4.fromArray3(dArray, 0);
    }

    protected static void putVertex3(Vec4 vec4, int n, DoubleBuffer doubleBuffer) {
        double[] dArray = new double[3];
        vec4.toArray3(dArray, 0);
        doubleBuffer.position(3 * n);
        doubleBuffer.put(dArray, 0, 3);
    }

    private static Vec4 nearestPointOnSegment(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = vec44.normalize3();
        double d = vec43.subtract3(vec4).dot3(vec45);
        if (d < 0.0) {
            return vec4;
        }
        if (d > vec44.getLength3()) {
            return vec42;
        }
        return Vec4.fromLine3(vec4, d, vec45);
    }

    protected static class OrderedText
    implements OrderedRenderable {
        protected SegmentPlane segmentPlane;
        protected final Position position;
        protected final double distanceFromEye;
        protected AVList values;
        protected SegmentPlaneAttributes.LabelAttributes attributes;
        protected MultiLineTextRenderer textRenderer;

        public OrderedText(SegmentPlane segmentPlane, Position position, double d, AVList aVList, SegmentPlaneAttributes.LabelAttributes labelAttributes, MultiLineTextRenderer multiLineTextRenderer) {
            this.segmentPlane = segmentPlane;
            this.position = position;
            this.distanceFromEye = d;
            this.values = aVList;
            this.attributes = labelAttributes;
            this.textRenderer = multiLineTextRenderer;
        }

        public String getText() {
            return this.attributes.getText(this.segmentPlane, this.position, this.values);
        }

        @Override
        public double getDistanceFromEye() {
            return this.distanceFromEye;
        }

        public Vec4 getScreenPoint(DrawContext drawContext) {
            if (drawContext.getGlobe() == null || drawContext.getView() == null) {
                return null;
            }
            Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(this.position.getLatitude(), this.position.getLongitude(), this.position.getElevation());
            if (vec4 == null) {
                return null;
            }
            return drawContext.getView().project(vec4).add3(this.attributes.getOffset());
        }

        protected Vec4 getScreenPoint(DrawContext drawContext, Position position) {
            if (drawContext.getGlobe() == null || drawContext.getView() == null) {
                return null;
            }
            Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), position.getElevation());
            if (vec4 == null) {
                return null;
            }
            return drawContext.getView().project(vec4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void render(DrawContext drawContext) {
            OGLStackHandler oGLStackHandler = new OGLStackHandler();
            this.begin(drawContext, oGLStackHandler);
            try {
                this.draw(drawContext);
            }
            finally {
                this.end(drawContext, oGLStackHandler);
            }
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
        }

        protected void draw(DrawContext drawContext) {
            String string = this.getText();
            if (string == null) {
                return;
            }
            Vec4 vec4 = this.getScreenPoint(drawContext);
            if (vec4 == null) {
                return;
            }
            Rectangle rectangle = drawContext.getView().getViewport();
            Color color = this.attributes.getColor();
            this.textRenderer.getTextRenderer().beginRendering(rectangle.width, rectangle.height);
            this.textRenderer.setTextColor(color);
            this.textRenderer.setBackColor(Color.BLACK);
            this.drawText(string, vec4, this.attributes, this.textRenderer);
            this.textRenderer.getTextRenderer().endRendering();
        }

        protected void begin(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
            GL2 gL2 = drawContext.getGL().getGL2();
            int n = 1;
            oGLStackHandler.pushAttrib(gL2, n);
        }

        protected void end(DrawContext drawContext, OGLStackHandler oGLStackHandler) {
            GL2 gL2 = drawContext.getGL().getGL2();
            oGLStackHandler.pop(gL2);
        }

        protected void drawText(String string, Vec4 vec4, SegmentPlaneAttributes.LabelAttributes labelAttributes, MultiLineTextRenderer multiLineTextRenderer) {
            double d = vec4.x;
            double d2 = vec4.y;
            if (labelAttributes != null) {
                String string2 = labelAttributes.getHorizontalAlignment();
                String string3 = labelAttributes.getVerticalAlignment();
                Rectangle rectangle = multiLineTextRenderer.getBounds(string);
                double d3 = rectangle.getWidth();
                double d4 = rectangle.getHeight();
                double d5 = rectangle.getWidth() / 2.0;
                double d6 = rectangle.getHeight() / 2.0;
                if (string2 != "gov.nasa.worldwind.avkey.Left") {
                    if (string2 == "gov.nasa.worldwind.avkey.Center") {
                        d -= d5;
                    } else if (string2 == "gov.nasa.worldwind.avkey.Right") {
                        d -= d3;
                    }
                }
                if (string3 != "gov.nasa.worldwind.avkey.Top") {
                    if (string3 == "gov.nasa.worldwind.avkey.Center") {
                        d2 += d6;
                    } else if (string3 == "gov.nasa.worldwind.avkey.Bottom") {
                        d2 += d4;
                    }
                }
            }
            multiLineTextRenderer.draw(string, (int)d, (int)d2, "gov.nasa.worldwind.avkey.TextEffectOutline");
        }
    }

    protected static class ControlPointInfo {
        protected SegmentPlane.ControlPoint controlPoint;
        protected Position position;
        protected MarkerShape shape;

        public ControlPointInfo(SegmentPlane.ControlPoint controlPoint, Position position, MarkerShape markerShape) {
            this.controlPoint = controlPoint;
            this.position = position;
            this.shape = markerShape;
        }
    }

    protected static class RenderInfo {
        protected Globe globe;
        protected Object segmentPlaneKey;
        protected Vec4 planeReferenceCenter;
        protected int planeFillIndexCount;
        protected int planeOutlineIndexCount;
        protected int planeGridIndexCount;
        protected IntBuffer planeFillIndices;
        protected IntBuffer planeOutlineIndices;
        protected IntBuffer planeGridIndices;
        protected DoubleBuffer planeVertices;
        protected DoubleBuffer planeNormals;
        protected int borderCylinderIndexCount;
        protected int borderCapIndexCount;
        protected IntBuffer borderCylinderIndices;
        protected IntBuffer borderCapIndices;
        protected FloatBuffer borderCylinderVertices;
        protected FloatBuffer borderCapVertices;
        protected FloatBuffer borderCylinderNormals;
        protected FloatBuffer borderCapNormals;
        protected Map<String, MarkerShape> markerShapeMap;

        protected RenderInfo() {
        }

        public boolean isExpired(Globe globe, SegmentPlane segmentPlane) {
            return this.globe == null || this.segmentPlaneKey == null || !this.globe.equals(globe) || !this.segmentPlaneKey.equals(segmentPlane.getStateKey());
        }

        public void makeCurrent(Globe globe, SegmentPlane segmentPlane) {
            this.globe = globe;
            this.segmentPlaneKey = segmentPlane.getStateKey();
        }

        public MarkerShape getMarkerShape(String string) {
            if (string == null) {
                return null;
            }
            MarkerShape markerShape = this.markerShapeMap.get(string);
            if (markerShape == null && !this.markerShapeMap.containsKey(string)) {
                markerShape = BasicMarkerShape.createShapeInstance(string);
                this.markerShapeMap.put(string, markerShape);
            }
            return markerShape;
        }
    }
}

