/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwindx.applications.sar.PositionTable;
import gov.nasa.worldwindx.applications.sar.actions.AddOffsetToPositionsAction;
import gov.nasa.worldwindx.applications.sar.actions.AppendPositionAction;
import gov.nasa.worldwindx.applications.sar.actions.DeletePositionsAction;
import gov.nasa.worldwindx.applications.sar.actions.InsertPositionAction;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PositionsContextMenu
extends MouseAdapter {
    private final PositionTable positionTable;

    public PositionsContextMenu(PositionTable positionTable) {
        this.positionTable = positionTable;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void checkPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new DeletePositionsAction(this.positionTable));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(new AppendPositionAction(this.positionTable));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new InsertPositionAction(true, this.positionTable));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new InsertPositionAction(false, this.positionTable));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(new AddOffsetToPositionsAction(this.positionTable));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(this.positionTable, mouseEvent.getX(), mouseEvent.getY());
    }
}

