/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.eurogeoss;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.eurogeoss.CatalogConnection;
import gov.nasa.worldwindx.applications.eurogeoss.GetRecordsRequest;
import gov.nasa.worldwindx.applications.eurogeoss.GetRecordsResponse;
import gov.nasa.worldwindx.applications.eurogeoss.Record;
import gov.nasa.worldwindx.applications.eurogeoss.RecordPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class CatalogPanel
extends JPanel
implements ActionListener {
    protected static final String SEARCH_BUTTON_TEXT = "Search";
    protected static final String CANCEL_BUTTON_TEXT = "Cancel";
    protected static final String MORE_BUTTON_TEXT = "More";
    protected String serviceUrl;
    protected WorldWindow wwd;
    protected ExecutorService searchService;
    protected Future searchFuture;
    protected GetRecordsRequest lastRequest;
    protected GetRecordsResponse lastResponse;
    protected JPanel searchPanel;
    protected JTextField searchField;
    protected JProgressBar searchProgress;
    protected JButton searchButton;
    protected JPanel recordsPanel;
    protected JPanel recordsScrollPanel;
    protected JScrollPane recordsScrollPane;
    protected JPanel morePanel;
    protected JButton moreButton;

    public CatalogPanel(String string, WorldWindow worldWindow) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ServiceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (worldWindow == null) {
            String string3 = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.serviceUrl = string;
        this.wwd = worldWindow;
        this.searchService = Executors.newSingleThreadExecutor();
        this.searchPanel = new JPanel();
        this.searchField = new JTextField();
        this.searchField.addActionListener(this);
        this.searchProgress = new JProgressBar();
        this.searchProgress.setIndeterminate(true);
        this.searchButton = new JButton(SEARCH_BUTTON_TEXT);
        this.searchButton.addActionListener(this);
        this.recordsPanel = new JPanel();
        this.recordsScrollPanel = new JPanel();
        this.recordsScrollPane = new JScrollPane(this.recordsScrollPanel);
        this.morePanel = new JPanel();
        this.morePanel.setVisible(false);
        this.moreButton = new JButton(MORE_BUTTON_TEXT);
        this.moreButton.addActionListener(this);
        this.searchPanel.setLayout(new BoxLayout(this.searchPanel, 0));
        this.searchPanel.add(this.searchField);
        this.searchPanel.add(this.searchProgress);
        this.searchPanel.add(Box.createHorizontalStrut(5));
        this.searchPanel.add(this.searchButton);
        this.searchProgress.setVisible(false);
        this.recordsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.recordsPanel.setLayout(new GridLayout(0, 1, 0, 5));
        this.recordsScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.recordsScrollPanel.setLayout(new BorderLayout(0, 10));
        this.recordsScrollPanel.add("North", this.recordsPanel);
        this.recordsScrollPanel.add("Center", this.morePanel);
        this.morePanel.setLayout(new FlowLayout(0));
        this.morePanel.add(this.moreButton);
        this.setPreferredSize(new Dimension(500, 0));
        this.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
        this.setLayout(new BorderLayout(0, 20));
        this.add("North", this.searchPanel);
        this.add("Center", this.recordsScrollPane);
        this.validate();
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ((actionEvent.getSource() == this.searchButton || actionEvent.getSource() == this.searchField) && this.searchButton.getText().equals(SEARCH_BUTTON_TEXT)) {
            GetRecordsRequest getRecordsRequest = new GetRecordsRequest();
            getRecordsRequest.setSearchText(this.searchField.getText().trim());
            this.sendGetRecordsRequest(getRecordsRequest, false);
        } else if (actionEvent.getSource() == this.searchButton && this.searchButton.getText().equals(CANCEL_BUTTON_TEXT)) {
            this.searchFuture.cancel(true);
        } else if (actionEvent.getSource() == this.moreButton) {
            GetRecordsRequest getRecordsRequest = new GetRecordsRequest(this.lastRequest);
            getRecordsRequest.setStartPosition(this.lastResponse.getNextRecord());
            this.sendGetRecordsRequest(getRecordsRequest, true);
        }
    }

    protected void sendGetRecordsRequest(GetRecordsRequest getRecordsRequest, boolean bl) {
        this.lastRequest = getRecordsRequest;
        this.searchField.setVisible(false);
        this.searchProgress.setVisible(true);
        this.searchButton.setText(CANCEL_BUTTON_TEXT);
        this.moreButton.setEnabled(false);
        this.validate();
        GetRecordsTask getRecordsTask = new GetRecordsTask(getRecordsRequest, bl);
        this.searchFuture = this.searchService.submit(getRecordsTask);
        this.searchService.submit(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CatalogPanel.this.searchField.setVisible(true);
                        CatalogPanel.this.searchProgress.setVisible(false);
                        CatalogPanel.this.searchButton.setText(CatalogPanel.SEARCH_BUTTON_TEXT);
                        CatalogPanel.this.moreButton.setEnabled(true);
                        CatalogPanel.this.validate();
                    }
                });
            }
        });
    }

    protected void handleGetRecordsResponse(GetRecordsResponse getRecordsResponse, boolean bl) {
        this.lastResponse = getRecordsResponse;
        if (!bl) {
            this.recordsPanel.removeAll();
        }
        if (getRecordsResponse.getRecords().size() > 0) {
            for (Record record : getRecordsResponse.getRecords()) {
                this.recordsPanel.add(new RecordPanel(record, this.wwd));
            }
        } else {
            JOptionPane.showMessageDialog(this, "No results", null, 1);
        }
        this.morePanel.setVisible(getRecordsResponse.nextRecord != 0);
        this.validate();
    }

    protected class GetRecordsTask
    implements Runnable {
        protected GetRecordsRequest request;
        protected boolean append;

        public GetRecordsTask(GetRecordsRequest getRecordsRequest, boolean bl) {
            this.request = getRecordsRequest;
            this.append = bl;
        }

        @Override
        public void run() {
            try {
                CatalogConnection catalogConnection = new CatalogConnection(CatalogPanel.this.serviceUrl);
                final GetRecordsResponse getRecordsResponse = catalogConnection.getRecords(this.request);
                if (Thread.interrupted()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CatalogPanel.this.handleGetRecordsResponse(getRecordsResponse, GetRecordsTask.this.append);
                    }
                });
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "Unable to search catalog " + CatalogPanel.this.serviceUrl, exception);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(CatalogPanel.this, "Unable to search catalog", null, 0);
                    }
                });
            }
        }
    }
}

