/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.server;

import com.sun.deploy.net.cookie.CookieHandler;
import com.sun.deploy.net.cookie.CookieUnavailableException;
import com.sun.deploy.net.offline.OfflineHandler;
import com.sun.deploy.net.proxy.BrowserProxyConfig;
import com.sun.deploy.net.proxy.BrowserProxyInfo;
import com.sun.deploy.net.proxy.ProxyConfigException;
import com.sun.deploy.net.proxy.ProxyHandler;
import com.sun.deploy.net.proxy.ProxyInfo;
import com.sun.deploy.net.proxy.ProxyUnavailableException;
import com.sun.deploy.security.BrowserAuthenticator;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CredentialManager;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import netscape.javascript.JSException;
import sun.plugin.services.BrowserService;
import sun.plugin2.ipc.Event;
import sun.plugin2.ipc.InProcEvent;
import sun.plugin2.liveconnect.BrowserSideObject;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.main.server.AbstractPlugin;
import sun.plugin2.main.server.AppletID;
import sun.plugin2.main.server.JVMManager;
import sun.plugin2.main.server.ResultHandler;
import sun.plugin2.util.NativeLibLoader;
import sun.plugin2.util.SharedWindow;
import sun.plugin2.util.SharedWindowHost;

public class WebKitPlugin
extends AbstractPlugin {
    private long wkPluginInstance;
    private long webPlugInContainer;
    private long windowScriptObject;
    private String baseURL;
    private Map params = new HashMap();
    private AppletID appletID;
    private boolean gotInitialSize;
    private boolean destroyed;
    private Event mainThreadEvent = new InProcEvent();
    private WKResultHandler handler = new WKResultHandler();
    private static boolean initialized;
    private static final long STOP_ACK_DELAY = 1100L;
    private static long connectionHandle;
    private long parentWindowHandle;
    private long childWindowHandle;
    private SharedWindow sharedWindow;
    private static List runnableQueue;
    private static Map idToNameMap;
    private static Map nameToIdMap;
    private static int nextId;
    private static Map javaObjectMap;

    public WebKitPlugin(long l, long l2, long l3) {
        this.wkPluginInstance = l;
        WebKitPlugin.nsObjectRetain(l2);
        this.webPlugInContainer = l2;
        WebKitPlugin.jsValueProtect(l2, l3);
        this.windowScriptObject = l3;
    }

    public void addParameters(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addParameter(stringArray[i], stringArray2[i]);
        }
    }

    private void addParameter(String string, String string2) {
        if (string != null) {
            string = string.trim().toLowerCase(Locale.ENGLISH);
            this.params.put(string, string2);
        }
    }

    public void setBaseURL(String string) {
        if (DEBUG) {
            System.out.println("WebKitPlugin.setBaseURL(" + string + ")");
        }
        this.baseURL = string;
    }

    public void forceOverlayWindowFront() {
        this.sharedWindow.orderOnTopOf(this.parentWindowHandle);
        if (DEBUG && VERBOSE) {
            System.out.println("WebKitPlugin.forceOverlayWindowFront()");
        }
    }

    public void setFrame(float f, float f2, float f3, float f4) {
        this.setSizeImpl(f, f2, f3, f4);
        if (DEBUG && VERBOSE) {
            System.out.println("WebKitPlugin.setFrame(" + f + ", " + f2 + ", " + f3 + ", " + f4 + ")");
        }
    }

    public void setBounds(float f, float f2, float f3, float f4) {
        this.setSizeImpl(f, f2, f3, f4);
        if (DEBUG && VERBOSE) {
            System.out.println("WebKitPlugin.setBounds(" + f + ", " + f2 + ", " + f3 + ", " + f4 + ")");
        }
    }

    private void setSizeImpl(float f, float f2, float f3, float f4) {
        if (this.appletID != null) {
            JVMManager.getManager().setAppletSize(this.appletID, (int)f3, (int)f4);
        } else {
            this.params.put("width", Integer.toString((int)f3));
            this.params.put("height", Integer.toString((int)f4));
            this.gotInitialSize = true;
            this.maybeStartApplet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webPlugInInitialize() {
        if (DEBUG) {
            System.out.println("WebKitPlugin.webPlugInInitialize()");
        }
        Object object = WebKitPlugin.class;
        synchronized (object) {
            if (!initialized) {
                initialized = true;
                WebKitPlugin.webPlugInInitialize0();
            }
        }
        object = this.javaScriptGetWindowInternal(false);
        if (object != null) {
            try {
                this.defineNameSpaceVariable((BrowserSideObject)object, "Packages", "");
                this.defineNameSpaceVariable((BrowserSideObject)object, "java", "java");
                this.defineNameSpaceVariable((BrowserSideObject)object, "netscape", "netscape");
                if (DEBUG) {
                    System.out.println("WebKitPlugin: successfully defined namespace variables");
                }
            }
            catch (JSException jSException) {
                jSException.printStackTrace();
            }
        }
        this.maybeStartApplet();
    }

    private static native void webPlugInInitialize0();

    public void webPlugInStart() {
        if (DEBUG) {
            System.out.println("WebKitPlugin.webPlugInStart");
        }
    }

    public void webPlugInStop() {
        if (DEBUG) {
            System.out.println("WebKitPlugin.webPlugInStop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void webPlugInDestroy() {
        if (DEBUG) {
            System.out.println("WebKitPlugin.webPlugInDestroy");
        }
        if (this.sharedWindow != null) {
            SharedWindowHost.unlinkSharedWindowFrame(this.parentWindowHandle, this.sharedWindow);
            this.sharedWindow = null;
        }
        if (this.appletID != null) {
            if (DEBUG) {
                System.out.println("  Stopping applet ID " + this.appletID);
            }
            JVMManager.getManager().sendStopApplet(this.appletID);
            try {
                this.mainThreadEvent.waitForSignal(1100L);
                Object var2_1 = null;
                JVMManager.getManager().recycleAppletID(this.appletID);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                JVMManager.getManager().recycleAppletID(this.appletID);
                this.appletStopped();
                this.appletID = null;
                throw throwable;
            }
            this.appletStopped();
            this.appletID = null;
            {
            }
        }
        if (this.windowScriptObject != 0L && this.webPlugInContainer != 0L) {
            WebKitPlugin.jsValueUnprotect(this.webPlugInContainer, this.windowScriptObject);
            this.windowScriptObject = 0L;
        }
        if (this.webPlugInContainer != 0L) {
            WebKitPlugin.nsObjectRelease(this.webPlugInContainer);
            this.webPlugInContainer = 0L;
        }
        this.destroyed = true;
    }

    public void webPlugInSetIsSelected(boolean bl) {
        if (DEBUG) {
            System.out.println("WebKitPlugin.webPlugInSetIsSelected(" + bl + ")");
        }
    }

    private void gotFocus(boolean bl) {
        JVMManager.getManager().sendGotFocus(this.appletID, bl);
    }

    private void sendKeyEvent(byte[] byArray) {
        JVMManager.getManager().sendKeyEventData(this.appletID, byArray);
    }

    private void sendMouseEvent(byte[] byArray) {
        JVMManager.getManager().sendMouseEventData(this.appletID, byArray);
    }

    private void maybeStartApplet() {
        if (this.appletID == null && this.gotInitialSize) {
            this.appletID = JVMManager.getManager().startApplet(this.params, this, this.parentWindowHandle, WebKitPlugin.getConnectionHandle(), false);
            this.appletStarted(this.appletID, this.handler);
        }
    }

    private static long getConnectionHandle() {
        if (connectionHandle == 0L) {
            connectionHandle = SharedWindowHost.getConnectionHandle();
        }
        return connectionHandle;
    }

    private void setWindowHandle(long l) {
        this.parentWindowHandle = l;
    }

    public void setChildWindowHandle(long l) {
        this.childWindowHandle = l;
        if (DEBUG) {
            System.out.println("WebKitPlugin: linking 0x" + Long.toHexString(this.parentWindowHandle) + " to 0x" + Long.toHexString(this.childWindowHandle));
        }
        this.sharedWindow = SharedWindowHost.linkSharedWindowTo(this.parentWindowHandle, this.childWindowHandle);
        this.sharedWindow.setVisible(false);
        new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < 5; ++i) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    WebKitPlugin.this.invokeLater(new Runnable(){

                        public void run() {
                            WebKitPlugin.this.updateLocationAndClip(WebKitPlugin.this.wkPluginInstance);
                            WebKitPlugin.this.sharedWindow.setVisible(true);
                            WebKitPlugin.this.forceOverlayWindowFront();
                        }
                    });
                }
            }
        }).start();
    }

    private native void updateLocationAndClip(long var1);

    private void setLocationAndClip(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.sharedWindow != null) {
            if (DEBUG) {
                System.out.println("WebKitPlugin: Setting location: " + d + ", " + d2);
                System.out.println("            clip: " + d3 + ", " + d4 + " -- " + d5 + ", " + d6);
            }
            this.sharedWindow.setLocationAndClip(d, d2, d3, d4, d5, d6);
            this.sharedWindow.setVisible(true);
        }
    }

    private void setVisible(boolean bl) {
        if (this.sharedWindow != null) {
            this.sharedWindow.setVisible(bl);
        }
    }

    private static native void nsObjectRetain(long var0);

    private static native void nsObjectRelease(long var0);

    private static native void jsValueProtect(long var0, long var2);

    private static native void jsValueUnprotect(long var0, long var2);

    private boolean isDestroyed() {
        return this.destroyed;
    }

    public void invokeLater(Runnable runnable) {
        runnableQueue.add(new RunnableWrapper(runnable, this));
        this.invokeLater0(this.wkPluginInstance);
    }

    private native void invokeLater0(long var1);

    private static void drainRunnableQueue() {
        while (!runnableQueue.isEmpty()) {
            RunnableWrapper runnableWrapper = (RunnableWrapper)runnableQueue.remove(0);
            if (runnableWrapper.getPlugin().isDestroyed()) continue;
            runnableWrapper.run();
        }
    }

    public void notifyMainThread() {
        this.mainThreadEvent.signal();
    }

    public String getDocumentBase() {
        return this.baseURL;
    }

    public void showDocument(String string, String string2) {
        if (this.webPlugInContainer != 0L) {
            this.showDocument0(this.webPlugInContainer, string, string2);
        }
    }

    private native void showDocument0(long var1, String var3, String var4);

    public void showStatus(String string) {
        if (this.webPlugInContainer != 0L) {
            this.showStatus0(this.webPlugInContainer, string);
        }
    }

    private native void showStatus0(long var1, String var3);

    public String getCookie(URL uRL) throws CookieUnavailableException {
        try {
            return this.getCookie0(this.webPlugInContainer, uRL.toString());
        }
        catch (Exception exception) {
            throw (CookieUnavailableException)new CookieUnavailableException().initCause((Throwable)exception);
        }
    }

    private native String getCookie0(long var1, String var3) throws RuntimeException;

    public void setCookie(URL uRL, String string) throws CookieUnavailableException {
        try {
            this.setCookie0(this.webPlugInContainer, uRL.toString(), string);
        }
        catch (Exception exception) {
            throw (CookieUnavailableException)new CookieUnavailableException().initCause((Throwable)exception);
        }
    }

    private native void setCookie0(long var1, String var3, String var4) throws RuntimeException;

    public PasswordAuthentication getAuthentication(String string, String string2, int n, String string3, String string4, URL uRL, boolean bl) {
        throw new RuntimeException("unimplemented");
    }

    public void waitForSignalWithModalBlocking() {
        if (DEBUG) {
            System.out.println("WebKitPlugin entering waitForSignalWithModalBlocking for " + this.appletID);
        }
        this.handler.waitForSignalWithModalBlocking();
        if (DEBUG) {
            System.out.println("WebKitPlugin exiting waitForSignalWithModalBlocking for " + this.appletID);
        }
    }

    private BrowserSideObject javaScriptGetWindowInternal(boolean bl) {
        if (this.windowScriptObject == 0L) {
            return null;
        }
        return this.newBrowserSideObject(this.windowScriptObject, bl);
    }

    public BrowserSideObject javaScriptGetWindow() {
        return this.javaScriptGetWindowInternal(true);
    }

    public void javaScriptRetainObject(BrowserSideObject browserSideObject) {
        WebKitPlugin.jsValueProtect(this.webPlugInContainer, browserSideObject.getNativeObjectReference());
    }

    public void javaScriptReleaseObject(BrowserSideObject browserSideObject) {
        WebKitPlugin.jsValueUnprotect(this.webPlugInContainer, browserSideObject.getNativeObjectReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object javaScriptCall(BrowserSideObject browserSideObject, String string, Object[] objectArray) throws JSException {
        long l = 0L;
        int n = 0;
        long l2 = 0L;
        try {
            if (objectArray != null && objectArray.length > 0) {
                n = objectArray.length;
                l = this.allocateVariantArray(n);
                for (int i = 0; i < n; ++i) {
                    this.objectToVariantArrayElement(objectArray[i], l, i);
                }
            }
            l2 = this.allocateVariantArray(1);
            Object[] objectArray2 = new Object[1];
            boolean bl = this.javaScriptCall0(this.webPlugInContainer, browserSideObject.getNativeObjectReference(), string, l, n, l2, objectArray2);
            if (!bl) {
                String string2 = "JavaScript error while calling \"" + string + "\"";
                if (objectArray2[0] != null) {
                    string2 = string2 + ": " + objectArray2[0];
                }
                throw new JSException(string2);
            }
            Object object = this.variantArrayElementToObject(l2, 0);
            Object var13_12 = null;
            if (l != 0L) {
                this.freeVariantArray(l, n);
            }
            if (l2 != 0L) {
                this.freeVariantArray(l2, 1);
            }
            return object;
        }
        catch (Throwable throwable) {
            block9: {
                Object var13_13 = null;
                if (l != 0L) {
                    this.freeVariantArray(l, n);
                }
                if (l2 == 0L) break block9;
                this.freeVariantArray(l2, 1);
            }
            throw throwable;
        }
    }

    private native boolean javaScriptCall0(long var1, long var3, String var5, long var6, int var8, long var9, Object[] var11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object javaScriptEval(BrowserSideObject browserSideObject, String string) throws JSException {
        long l = this.allocateVariantArray(1);
        try {
            Object[] objectArray = new Object[1];
            if (!this.javaScriptEval0(this.webPlugInContainer, browserSideObject.getNativeObjectReference(), string, l, objectArray)) {
                String string2 = "JavaScript error evaluating code \"" + string + "\"";
                if (objectArray[0] != null) {
                    string2 = string2 + ": " + objectArray[0];
                }
                throw new JSException(string2);
            }
            Object object = this.variantArrayElementToObject(l, 0);
            Object var8_7 = null;
            this.freeVariantArray(l, 1);
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.freeVariantArray(l, 1);
            throw throwable;
        }
    }

    private native boolean javaScriptEval0(long var1, long var3, String var5, long var6, Object[] var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object javaScriptGetMember(BrowserSideObject browserSideObject, String string) throws JSException {
        long l = this.allocateVariantArray(1);
        try {
            Object[] objectArray = new Object[1];
            if (!this.javaScriptGetMember0(this.webPlugInContainer, browserSideObject.getNativeObjectReference(), string, l, objectArray)) {
                String string2 = "JavaScript error while getting property \"" + string + "\"";
                if (objectArray[0] != null) {
                    string2 = string2 + ": " + objectArray[0];
                }
                throw new JSException(string2);
            }
            Object object = this.variantArrayElementToObject(l, 0);
            Object var8_7 = null;
            this.freeVariantArray(l, 1);
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.freeVariantArray(l, 1);
            throw throwable;
        }
    }

    private native boolean javaScriptGetMember0(long var1, long var3, String var5, long var6, Object[] var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void javaScriptSetMember(BrowserSideObject browserSideObject, String string, Object object) throws JSException {
        long l = this.allocateVariantArray(1);
        try {
            this.objectToVariantArrayElement(object, l, 0);
            Object[] objectArray = new Object[1];
            if (!this.javaScriptSetMember0(this.webPlugInContainer, browserSideObject.getNativeObjectReference(), string, l, objectArray)) {
                String string2 = "JavaScript error while setting property \"" + string + "\"";
                if (objectArray[0] != null) {
                    string2 = string2 + ": " + objectArray[0];
                }
                throw new JSException(string2);
            }
            Object var9_7 = null;
            this.freeVariantArray(l, 1);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.freeVariantArray(l, 1);
            throw throwable;
        }
    }

    private native boolean javaScriptSetMember0(long var1, long var3, String var5, long var6, Object[] var8);

    public void javaScriptRemoveMember(BrowserSideObject browserSideObject, String string) throws JSException {
        Object[] objectArray = new Object[1];
        if (!this.javaScriptRemoveMember0(this.webPlugInContainer, browserSideObject.getNativeObjectReference(), string, objectArray)) {
            String string2 = "JavaScript error while removing property \"" + string + "\"";
            if (objectArray[0] != null) {
                string2 = string2 + ": " + objectArray[0];
            }
            throw new JSException(string2);
        }
    }

    private native boolean javaScriptRemoveMember0(long var1, long var3, String var5, Object[] var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object javaScriptGetSlot(BrowserSideObject browserSideObject, int n) throws JSException {
        long l = this.allocateVariantArray(1);
        try {
            Object[] objectArray = new Object[1];
            if (!this.javaScriptGetSlot0(this.webPlugInContainer, browserSideObject.getNativeObjectReference(), n, l, objectArray)) {
                String string = "JavaScript error while getting index " + n;
                if (objectArray[0] != null) {
                    string = string + ": " + objectArray[0];
                }
                throw new JSException(string);
            }
            Object object = this.variantArrayElementToObject(l, 0);
            Object var8_7 = null;
            this.freeVariantArray(l, 1);
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.freeVariantArray(l, 1);
            throw throwable;
        }
    }

    private native boolean javaScriptGetSlot0(long var1, long var3, int var5, long var6, Object[] var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void javaScriptSetSlot(BrowserSideObject browserSideObject, int n, Object object) throws JSException {
        long l = this.allocateVariantArray(1);
        try {
            Object[] objectArray = new Object[1];
            this.objectToVariantArrayElement(object, l, 0);
            if (!this.javaScriptSetSlot0(this.webPlugInContainer, browserSideObject.getNativeObjectReference(), n, l, objectArray)) {
                String string = "JavaScript error while setting index " + n;
                if (objectArray[0] != null) {
                    string = string + ": " + objectArray[0];
                }
                throw new JSException(string);
            }
            Object var9_7 = null;
            this.freeVariantArray(l, 1);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.freeVariantArray(l, 1);
            throw throwable;
        }
    }

    private native boolean javaScriptSetSlot0(long var1, long var3, int var5, long var6, Object[] var8);

    public String javaScriptToString(BrowserSideObject browserSideObject) throws JSException {
        Object[] objectArray = new Object[1];
        String string = this.javaScriptToString0(this.webPlugInContainer, browserSideObject.getNativeObjectReference(), objectArray);
        if (string == null) {
            String string2 = "JavaScript error converting object to string";
            if (objectArray[0] != null) {
                string2 = string2 + ": " + objectArray[0];
            }
            throw new JSException(string2);
        }
        return string;
    }

    private native String javaScriptToString0(long var1, long var3, Object[] var5);

    protected boolean scriptingObjectArgumentListsAreReversed() {
        return false;
    }

    protected long allocateVariantArray(int n) {
        return this.allocateVariantArray0(this.webPlugInContainer, n);
    }

    protected native long allocateVariantArray0(long var1, int var3);

    protected native void freeVariantArray(long var1, int var3);

    protected void setVariantArrayElement(long l, int n, boolean bl) {
        this.setVariantArrayElement0(this.webPlugInContainer, l, n, bl);
    }

    protected native void setVariantArrayElement0(long var1, long var3, int var5, boolean var6);

    protected void setVariantArrayElement(long l, int n, byte by) {
        this.setVariantArrayElement0(this.webPlugInContainer, l, n, by);
    }

    protected native void setVariantArrayElement0(long var1, long var3, int var5, byte var6);

    protected void setVariantArrayElement(long l, int n, char c) {
        this.setVariantArrayElement0(this.webPlugInContainer, l, n, c);
    }

    protected native void setVariantArrayElement0(long var1, long var3, int var5, char var6);

    protected void setVariantArrayElement(long l, int n, short s) {
        this.setVariantArrayElement0(this.webPlugInContainer, l, n, s);
    }

    protected native void setVariantArrayElement0(long var1, long var3, int var5, short var6);

    protected void setVariantArrayElement(long l, int n, int n2) {
        this.setVariantArrayElement0(this.webPlugInContainer, l, n, n2);
    }

    protected native void setVariantArrayElement0(long var1, long var3, int var5, int var6);

    protected void setVariantArrayElement(long l, int n, long l2) {
        this.setVariantArrayElement0(this.webPlugInContainer, l, n, l2);
    }

    protected native void setVariantArrayElement0(long var1, long var3, int var5, long var6);

    protected void setVariantArrayElement(long l, int n, float f) {
        this.setVariantArrayElement0(this.webPlugInContainer, l, n, f);
    }

    protected native void setVariantArrayElement0(long var1, long var3, int var5, float var6);

    protected void setVariantArrayElement(long l, int n, double d) {
        this.setVariantArrayElement0(this.webPlugInContainer, l, n, d);
    }

    protected native void setVariantArrayElement0(long var1, long var3, int var5, double var6);

    protected void setVariantArrayElement(long l, int n, String string) {
        this.setVariantArrayElement0(this.webPlugInContainer, l, n, string);
    }

    protected native void setVariantArrayElement0(long var1, long var3, int var5, String var6);

    protected void setVariantArrayElementToScriptingObject(long l, int n, long l2) {
        this.setVariantArrayElementToScriptingObject0(this.webPlugInContainer, l, n, l2);
    }

    protected native void setVariantArrayElementToScriptingObject0(long var1, long var3, int var5, long var6);

    protected void setVariantArrayElementToVoid(long l, int n) {
        this.setVariantArrayElementToVoid0(this.webPlugInContainer, l, n);
    }

    protected native void setVariantArrayElementToVoid0(long var1, long var3, int var5);

    protected Object variantArrayElementToObject(long l, int n) {
        return this.variantArrayElementToObject0(this.webPlugInContainer, l, n);
    }

    protected native Object variantArrayElementToObject0(long var1, long var3, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long stringToIdentifier(String string) {
        Class clazz = WebKitPlugin.class;
        synchronized (clazz) {
            Integer n = (Integer)nameToIdMap.get(string);
            if (n == null) {
                n = new Integer(++nextId);
                nameToIdMap.put(string, n);
                idToNameMap.put(n, string);
            }
            return n.longValue();
        }
    }

    private long slotToIdentifier(int n) {
        return this.stringToIdentifier(Integer.toString(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String identifierToString(long l) {
        if (l == 0L) {
            return "toString";
        }
        Class clazz = WebKitPlugin.class;
        synchronized (clazz) {
            String string = (String)idToNameMap.get(new Integer((int)l));
            return string;
        }
    }

    private native long allocateJavaObject(long var1, RemoteJavaObject var3);

    private native long allocateJavaObjectForNameSpace(long var1, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long lookupScriptingObject(RemoteJavaObject remoteJavaObject, boolean bl) {
        Map map = javaObjectMap;
        synchronized (map) {
            Long l = (Long)javaObjectMap.get(remoteJavaObject);
            if (l != null) {
                return l;
            }
            long l2 = this.allocateJavaObject(this.webPlugInContainer, remoteJavaObject);
            if (l2 != 0L) {
                l = new Long(l2);
                javaObjectMap.put(remoteJavaObject, l);
                return l;
            }
            return 0L;
        }
    }

    protected Object wrapOrUnwrapScriptingObject(long l) {
        return this.newBrowserSideObject(l);
    }

    protected void fillInExceptionInfo(long l, String string) {
        if (l == 0L) {
            if (DEBUG) {
                System.out.println("WebKitPlugin: JavaScript error: " + string);
            }
        } else {
            this.fillInExceptionInfo0(this.webPlugInContainer, l, string);
        }
    }

    protected void fillInExceptionInfo(long l, Exception exception) {
        if (l == 0L) {
            if (DEBUG) {
                exception.printStackTrace();
            }
        } else {
            this.fillInExceptionInfo(l, exception.getMessage());
        }
    }

    protected native void fillInExceptionInfo0(long var1, long var3, String var5);

    private void defineNameSpaceVariable(BrowserSideObject browserSideObject, String string, String string2) {
        block5: {
            Object object = null;
            try {
                object = this.javaScriptGetMember(browserSideObject, string);
            }
            catch (JSException jSException) {
                // empty catch block
            }
            if (object == null) {
                long l = this.allocateJavaObjectForNameSpace(this.webPlugInContainer, string2);
                BrowserSideObject browserSideObject2 = this.newBrowserSideObject(l, false);
                try {
                    this.javaScriptSetMember(browserSideObject, string, browserSideObject2);
                }
                catch (JSException jSException) {
                    if (!DEBUG) break block5;
                    System.out.println("WebKitPlugin.defineNameSpaceVariable: error setting up namespace variable \"" + string + "\"");
                    jSException.printStackTrace();
                }
            }
        }
    }

    static {
        NativeLibLoader.load(new String[]{"deploy", "plugin2_webkit"});
        try {
            ServiceManager.setService((Service)new WKBrowserService());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JVMManager.setBrowserType(4);
        initialized = false;
        runnableQueue = Collections.synchronizedList(new LinkedList());
        idToNameMap = new HashMap();
        nameToIdMap = new HashMap();
        javaObjectMap = new HashMap();
    }

    static class WKBrowserService
    implements BrowserService {
        WKBrowserService() {
        }

        public CookieHandler getCookieHandler() {
            return new WKCookieHandler();
        }

        public BrowserProxyConfig getProxyConfig() {
            return new WKProxyConfig();
        }

        public ProxyHandler getAutoProxyHandler() {
            return new WKProxyHandler();
        }

        public ProxyHandler getSystemProxyHandler() {
            return null;
        }

        public ProxyHandler getBrowserProxyHandler() {
            return null;
        }

        public CertStore getBrowserSigningRootCertStore() {
            return null;
        }

        public CertStore getBrowserSSLRootCertStore() {
            return null;
        }

        public CertStore getBrowserTrustedCertStore() {
            return null;
        }

        public KeyStore getBrowserClientAuthKeyStore() {
            return null;
        }

        public Object getAppletContext() {
            return null;
        }

        public Object getBeansContext() {
            return null;
        }

        public SecureRandom getSecureRandom() {
            return new SecureRandom();
        }

        public boolean isIExplorer() {
            return false;
        }

        public boolean isNetscape() {
            return false;
        }

        public float getBrowserVersion() {
            return 1.0f;
        }

        public boolean isConsoleIconifiedOnClose() {
            return false;
        }

        public boolean installBrowserEventListener() {
            throw new RuntimeException("Unimplemented");
        }

        public BrowserAuthenticator getBrowserAuthenticator() {
            return null;
        }

        public CredentialManager getCredentialManager() {
            return null;
        }

        public String mapBrowserElement(String string) {
            throw new RuntimeException("No longer used");
        }

        public OfflineHandler getOfflineHandler() {
            return null;
        }
    }

    static class WKProxyHandler
    implements ProxyHandler {
        WKProxyHandler() {
        }

        public boolean isSupported(int n) {
            return n == 0;
        }

        public boolean isProxyCacheSupported() {
            return true;
        }

        public void init(BrowserProxyInfo browserProxyInfo) throws ProxyConfigException {
        }

        public ProxyInfo[] getProxyInfo(URL uRL) throws ProxyUnavailableException {
            return new ProxyInfo[]{new ProxyInfo(null)};
        }
    }

    static class WKProxyConfig
    implements BrowserProxyConfig {
        WKProxyConfig() {
        }

        public BrowserProxyInfo getBrowserProxyInfo() {
            return new BrowserProxyInfo();
        }

        public void getSystemProxy(BrowserProxyInfo browserProxyInfo) {
        }
    }

    static class WKCookieHandler
    implements CookieHandler {
        private Map cookieMap = new HashMap();

        WKCookieHandler() {
        }

        public String getCookieInfo(URL uRL) throws CookieUnavailableException {
            return (String)this.cookieMap.get(uRL);
        }

        public void setCookieInfo(URL uRL, String string) throws CookieUnavailableException {
            this.cookieMap.put(uRL, string);
        }
    }

    class WKResultHandler
    extends ResultHandler {
        WKResultHandler() {
        }

        public void waitForSignal() {
            this.waitForSignal(0L);
        }

        public void waitForSignal(long l) {
            WebKitPlugin.this.mainThreadEvent.waitForSignal(l);
            WebKitPlugin.drainRunnableQueue();
        }

        public void waitForSignalWithModalBlocking() {
            this.waitForSignal();
        }
    }

    static class RunnableWrapper
    implements Runnable {
        private Runnable runnable;
        private WebKitPlugin plugin;

        public RunnableWrapper(Runnable runnable, WebKitPlugin webKitPlugin) {
            this.runnable = runnable;
            this.plugin = webKitPlugin;
        }

        public void run() {
            this.runnable.run();
        }

        public WebKitPlugin getPlugin() {
            return this.plugin;
        }
    }
}

