/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Random;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ConstantExpression;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class StyleUtils {
    static final StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
    static final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    public static Style createStyle(File file, FeatureType schema) throws IOException, NullPointerException {
        File sld = StyleUtils.toSLDFile(file);
        if (sld.exists()) {
            return StyleUtils.createFromSLD(sld);
        }
        Class type = schema.getGeometryDescriptor().getType().getBinding();
        if (type.isAssignableFrom(Polygon.class) || type.isAssignableFrom(MultiPolygon.class)) {
            return StyleUtils.createPolygonStyle();
        }
        if (type.isAssignableFrom(LineString.class) || type.isAssignableFrom(MultiLineString.class)) {
            return StyleUtils.createLineStyle();
        }
        return StyleUtils.createPointStyle();
    }

    private static Style createFromSLD(File sld) throws IOException, MalformedURLException {
        SLDParser stylereader = new SLDParser(styleFactory, sld.toURL());
        Style[] style = stylereader.readXML();
        return style[0];
    }

    public static Style createFromSLDString(String sldtext) {
        SLDParser parser = new SLDParser(styleFactory, (Reader)new StringReader(sldtext));
        return parser.readXML()[0];
    }

    public static Style createFromFile(File sldFile) throws FileNotFoundException {
        SLDParser parser = new SLDParser(styleFactory, sldFile);
        return parser.readXML()[0];
    }

    private static String getRandomColorHex() {
        Random r = new Random();
        Color randomColor = new Color(r.nextInt(255), r.nextInt(255), r.nextInt(255), 0);
        return "#" + Integer.toHexString(randomColor.getRGB());
    }

    public static void hidePolygonStrokes(Style style) {
        for (FeatureTypeStyle s : style.getFeatureTypeStyles()) {
            Rule[] arr$ = s.getRules();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Rule ruleObject;
                Rule r = ruleObject = arr$[i$];
                for (Symbolizer symbolizer : r.getSymbolizers()) {
                    try {
                        PolygonSymbolizer sym = (PolygonSymbolizer)symbolizer;
                        Stroke stroke = sym.getStroke();
                        stroke.setOpacity((Expression)ConstantExpression.ZERO);
                        sym.setStroke(stroke);
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static Style createPointStyle() {
        PointSymbolizer symbolizer = styleFactory.createPointSymbolizer();
        symbolizer.getGraphic().setSize((Expression)filterFactory.literal(4));
        Rule rule = styleFactory.createRule();
        rule.setSymbolizers(new Symbolizer[]{symbolizer});
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle();
        fts.setRules(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.addFeatureTypeStyle(fts);
        return style;
    }

    private static Style createLineStyle() {
        LineSymbolizer symbolizer = styleFactory.createLineSymbolizer();
        SLD.setLineColour((LineSymbolizer)symbolizer, (Color)Color.BLUE);
        symbolizer.getStroke().setWidth((Expression)filterFactory.literal(1));
        symbolizer.getStroke().setColor((Expression)filterFactory.literal((Object)StyleUtils.getRandomColorHex()));
        Rule rule = styleFactory.createRule();
        rule.setSymbolizers(new Symbolizer[]{symbolizer});
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle();
        fts.setRules(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.addFeatureTypeStyle(fts);
        return style;
    }

    private static Style createPolygonStyle() {
        PolygonSymbolizer symbolizer = styleFactory.createPolygonSymbolizer();
        Fill fill = styleFactory.createFill((Expression)filterFactory.literal((Object)StyleUtils.getRandomColorHex()), (Expression)filterFactory.literal(1.0));
        symbolizer.setFill(fill);
        Rule rule = styleFactory.createRule();
        rule.setSymbolizers(new Symbolizer[]{symbolizer});
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle();
        fts.setRules(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.addFeatureTypeStyle(fts);
        return style;
    }

    public static File toSLDFile(File file) {
        String filename = file.getAbsolutePath();
        if (filename.endsWith(".shp") || filename.endsWith(".dbf") || filename.endsWith(".shx")) {
            filename = filename.substring(0, filename.length() - 4);
            filename = filename + ".sld";
        } else if (filename.endsWith(".SLD") || filename.endsWith(".SLD") || filename.endsWith(".SLD")) {
            filename = filename.substring(0, filename.length() - 4);
            filename = filename + ".SLD";
        }
        return new File(filename);
    }
}

