/*
 * Decompiled with CFR 0.152.
 */
package gw.renderables.experimental;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class Needle
implements Renderable {
    private Position position;
    private Color color;
    int lineWidth = 2;
    private double length = 4000.0;

    public Needle(Position position, Color color) {
        this.position = position;
        this.color = color;
    }

    public void setPosition(Position p) {
        this.position = p;
    }

    public Position getPosition() {
        return this.position;
    }

    private void drawPrimitives(DrawContext dc) {
        GL gl = dc.getGL();
        GLU glu = dc.getGLU();
        Globe myglobe = dc.getGlobe();
        gl.glPushAttrib(1 | 0x2000);
        gl.glDisable(3553);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glLineWidth((float)this.lineWidth);
        gl.glBegin(3);
        gl.glColor4d((double)this.color.getRed() / 255.0, (double)this.color.getGreen() / 255.0, (double)this.color.getBlue() / 255.0, (double)this.color.getAlpha() / 255.0);
        double elevation = myglobe.getElevation(this.position.getLatitude(), this.position.getLongitude());
        Position upvec = Position.fromDegrees((double)0.0, (double)0.0, (double)this.length);
        Vec4 pointA = myglobe.computePointFromPosition(this.position);
        Vec4 pointB = myglobe.computePointFromPosition(this.position.add(upvec));
        gl.glVertex3d(pointA.x, pointA.y, pointA.z);
        gl.glColor4d(0.0, 0.0, 0.0, 1.0);
        gl.glVertex3d(pointB.x, pointB.y, pointB.z);
        gl.glLineWidth(1.0f);
        gl.glEnd();
        gl.glPopAttrib();
    }

    public void render(DrawContext dc) {
        this.drawPrimitives(dc);
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }
}

