/*
 * Decompiled with CFR 0.152.
 */
package gw.renderables;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gw.renderables.ComplexPolygonTesselationCallback;
import java.awt.Color;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;

public class ComplexPolygon
implements Renderable {
    private Position[] vertices;
    private Color color;
    int displayList = -1;

    public ComplexPolygon(Position[] vertices, Color color) {
        this.vertices = vertices;
        this.color = color;
    }

    private double[] makeVertex(Vec4 vec, Color c) {
        return new double[]{vec.x, vec.y, vec.z, (double)c.getRed() / 255.0, (double)c.getGreen() / 255.0, (double)c.getBlue() / 255.0, (double)c.getAlpha() / 255.0};
    }

    public void render(DrawContext dc) {
        int i;
        GL gl = dc.getGL();
        GLU glu = dc.getGLU();
        Globe myglobe = dc.getGlobe();
        GLUtessellator tess = glu.gluNewTess();
        ComplexPolygonTesselationCallback cb = new ComplexPolygonTesselationCallback(gl, glu);
        glu.gluTessCallback(tess, 100101, (GLUtessellatorCallback)cb);
        glu.gluTessCallback(tess, 100100, (GLUtessellatorCallback)cb);
        glu.gluTessCallback(tess, 100102, (GLUtessellatorCallback)cb);
        glu.gluTessCallback(tess, 100103, (GLUtessellatorCallback)cb);
        double[][] polygon = new double[this.vertices.length][7];
        for (i = 0; i < this.vertices.length; ++i) {
            double elevation = myglobe.getElevation(this.vertices[i].getLatitude(), this.vertices[i].getLongitude());
            Position upvec = Position.fromDegrees((double)0.0, (double)0.0, (double)elevation);
            polygon[i] = this.makeVertex(myglobe.computePointFromPosition(this.vertices[i].add(upvec)), this.color);
        }
        if (this.displayList == -1) {
            this.displayList = gl.glGenLists(1);
            gl.glNewList(this.displayList, 4864);
            gl.glPushAttrib(1 | 0x2000);
            gl.glDisable(2884);
            gl.glDisable(3553);
            gl.glEnable(3042);
            gl.glBlendFunc(770, 771);
            glu.gluTessBeginPolygon(tess, null);
            glu.gluTessBeginContour(tess);
            for (i = 0; i < polygon.length; ++i) {
                glu.gluTessVertex(tess, polygon[i], 0, (Object)polygon[i]);
            }
            glu.gluTessEndContour(tess);
            glu.gluTessEndPolygon(tess);
            gl.glPopAttrib();
            gl.glEndList();
        }
        gl.glCallList(this.displayList);
    }
}

