/*
 * Decompiled with CFR 0.152.
 */
package gw.layers;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceImage;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class RasterLayer
extends RenderableLayer {
    Sector sector;

    public RasterLayer(String rasterFile) throws Exception {
        this.setName(rasterFile);
        RasterFile f = new RasterFile(rasterFile);
        this.sector = Sector.fromDegrees((double)f.getYllcorner(), (double)(f.getYllcorner() + f.getCellsize()), (double)f.getXllcorner(), (double)(f.getXllcorner() + f.getCellsize()));
        this.addRenderable((Renderable)new SurfaceImage((Object)f.getImage(new Color(0, 0, 0, 255), Color.RED), this.getSector()));
    }

    public Sector getSector() {
        return this.sector;
    }

    class RasterFile {
        private int ncols;
        private int nrows;
        private double nodatavalue;
        private double cellsize;
        private double xllcorner;
        private double yllcorner;
        private double[][] data;
        private double min;
        private double max;

        private double readDouble(String name, String line) throws Exception {
            StringTokenizer t = new StringTokenizer(line);
            if (t.countTokens() != 2) {
                throw new Exception("Illegal line: " + line);
            }
            if (!t.nextToken().equalsIgnoreCase(name)) {
                throw new Exception(name);
            }
            return Double.parseDouble(t.nextToken());
        }

        private Color interpolateColors(Color ca, Color cb, double percent) {
            int r = (int)((double)(cb.getRed() - ca.getRed()) * percent + (double)ca.getRed());
            int g = (int)((double)(cb.getGreen() - ca.getGreen()) * percent + (double)ca.getGreen());
            int b = (int)((double)(cb.getBlue() - ca.getBlue()) * percent + (double)ca.getBlue());
            int a = (int)((double)(cb.getAlpha() - ca.getAlpha()) * percent + (double)ca.getAlpha());
            return new Color(r, g, b, a);
        }

        public RasterFile(String filename) throws Exception {
            BufferedReader r = new BufferedReader(new FileReader(filename));
            this.ncols = (int)this.readDouble("ncols", r.readLine());
            this.nrows = (int)this.readDouble("nrows", r.readLine());
            this.xllcorner = this.readDouble("xllcorner", r.readLine());
            this.yllcorner = this.readDouble("yllcorner", r.readLine());
            this.cellsize = this.readDouble("cellsize", r.readLine());
            this.nodatavalue = (int)this.readDouble("nodata_value", r.readLine());
            this.data = new double[this.nrows][this.ncols];
            this.min = Double.MAX_VALUE;
            this.max = Double.MIN_VALUE;
            for (int y = 0; y < this.nrows; ++y) {
                StringTokenizer t = new StringTokenizer(r.readLine());
                for (int x = 0; x < this.ncols; ++x) {
                    this.data[y][x] = Double.parseDouble(t.nextToken());
                    if (this.data[y][x] < this.min && (double)((int)this.data[y][x]) != this.nodatavalue) {
                        this.min = this.data[y][x];
                    }
                    if (!(this.data[y][x] > this.max) || (double)((int)this.data[y][x]) == this.nodatavalue) continue;
                    this.max = this.data[y][x];
                }
            }
            r.close();
        }

        public BufferedImage getImage(Color minColor, Color maxColor) {
            BufferedImage image = new BufferedImage(this.getNrows(), this.getNcols(), 2);
            for (int y = 0; y < this.getNrows(); ++y) {
                for (int x = 0; x < this.getNcols(); ++x) {
                    Color c = this.data[y][x] == this.nodatavalue ? new Color(0, 0, 0, 0) : this.interpolateColors(minColor, maxColor, (this.data[y][x] - this.min) / (this.max - this.min));
                    image.setRGB(y, x, c.getRGB());
                }
            }
            return image;
        }

        public int getNcols() {
            return this.ncols;
        }

        public int getNrows() {
            return this.nrows;
        }

        public double getNodatavalue() {
            return this.nodatavalue;
        }

        public double getCellsize() {
            return this.cellsize;
        }

        public double getXllcorner() {
            return this.xllcorner;
        }

        public double getYllcorner() {
            return this.yllcorner;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double[][] getData() {
            return this.data;
        }
    }
}

